/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProjectCreationWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewTomcatProjectWizardPage
extends WizardPage
implements TomcatPluginResources {
    private Button updateXmlCheck;
    private Text webpathText;
    private Text rootDirText;
    private TomcatProjectCreationWizard wizard;
    private boolean displayedOnce = false;
    private static final int TEXT_FIELD_WIDTH = 200;

    public NewTomcatProjectWizardPage(TomcatProjectCreationWizard wizard, String pageName) {
        super(pageName);
        this.setPageComplete(true);
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createWebpathGroup(composite);
        this.createUpdateXmlGroup(composite);
        new Label(composite, 0);
        this.createRootDirGroup(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public void createWebpathGroup(Composite parent) {
        Composite webpathGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        webpathGroup.setLayout((Layout)layout);
        webpathGroup.setLayoutData((Object)new GridData(768));
        Label webpathLabel = new Label(webpathGroup, 0);
        webpathLabel.setText(TomcatPluginResources.WIZARD_PROJECT_WEBPATH_LABEL);
        webpathLabel.setEnabled(true);
        this.webpathText = new Text(webpathGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.webpathText.setLayoutData((Object)data);
        this.webpathText.setText("");
        this.webpathText.setEnabled(true);
    }

    public void createUpdateXmlGroup(Composite parent) {
        Composite updateXmlGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        updateXmlGroup.setLayout((Layout)layout);
        updateXmlGroup.setLayoutData((Object)new GridData(768));
        this.updateXmlCheck = new Button(updateXmlGroup, 16416);
        this.updateXmlCheck.setText(TomcatPluginResources.WIZARD_PROJECT_UPDATEXML_LABEL);
        this.updateXmlCheck.setEnabled(true);
        this.updateXmlCheck.setSelection(true);
    }

    public void createRootDirGroup(Composite parent) {
        Composite rootDirGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        rootDirGroup.setLayout((Layout)layout);
        rootDirGroup.setLayoutData((Object)new GridData(768));
        Label rootDirLabel = new Label(rootDirGroup, 0);
        rootDirLabel.setText(TomcatPluginResources.WIZARD_PROJECT_ROOTDIR_LABEL);
        rootDirLabel.setEnabled(true);
        this.rootDirText = new Text(rootDirGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.rootDirText.setLayoutData((Object)data);
        this.rootDirText.setText("/");
        this.rootDirText.setEnabled(true);
    }

    public String getWebpath() {
        return this.webpathText.getText();
    }

    public String getRootDir() {
        return this.rootDirText.getText();
    }

    public boolean getUpdateXml() {
        return this.updateXmlCheck.getSelection();
    }

    public void setWebpath(String path) {
        this.webpathText.setText(path);
    }

    public boolean canFlipToNextPage() {
        this.displayedOnce = true;
        return super.canFlipToNextPage();
    }

    public boolean wasDisplayedOnce() {
        return this.displayedOnce;
    }
}

