/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatBootstrap;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.VMLauncherUtility;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Tomcat4Bootstrap
extends TomcatBootstrap {
    public String[] getClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(String.valueOf(this.getTomcatDir()) + File.separator + "bin" + File.separator + "bootstrap.jar");
        String toolsJarLocation = VMLauncherUtility.getVMInstall().getInstallLocation() + File.separator + "lib" + File.separator + "tools.jar";
        if (new File(toolsJarLocation).exists()) {
            classpath.add(toolsJarLocation);
        }
        return classpath.toArray(new String[0]);
    }

    public String getMainClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public String getStartCommand() {
        return "start";
    }

    public String getStopCommand() {
        return "stop";
    }

    public String[] getPrgArgs(String command) {
        String[] prgArgs = new String[]{command, "-config", "\"" + TomcatLauncherPlugin.getDefault().getConfigFile() + "\""};
        return prgArgs;
    }

    public String[] getVmArgs() {
        String[] vmArgs = new String[3];
        vmArgs[0] = "-Dcatalina.home=\"" + this.getTomcatDir() + "\"";
        String binDir = String.valueOf(this.getTomcatDir()) + File.separator + "bin";
        String commonLibDir = String.valueOf(this.getTomcatDir()) + File.separator + "common" + File.separator + "lib";
        vmArgs[1] = "-Djava.endorsed.dirs=\"" + binDir + File.pathSeparator + commonLibDir + "\"";
        vmArgs[2] = this.getTomcatBase().length() != 0 ? "-Dcatalina.base=\"" + this.getTomcatBase() + "\"" : "-Dcatalina.base=\"" + this.getTomcatDir() + "\"";
        return vmArgs;
    }

    public String getXMLTagAfterContextDefinition() {
        return "</Host>";
    }

    public IPath getServletJarPath() {
        return new Path("common").append("lib").append("servlet.jar");
    }

    public IPath getJasperJarPath() {
        return new Path("lib").append("jasper-runtime.jar");
    }

    public IPath getJSPJarPath() {
        return null;
    }

    public String getLabel() {
        return "Tomcat 4.0.x";
    }

    public String getContextWorkDir(String workFolder) {
        StringBuffer workDir = new StringBuffer("workDir=");
        workDir.append('\"');
        workDir.append(workFolder);
        workDir.append(File.separator);
        workDir.append("org");
        workDir.append(File.separator);
        workDir.append("apache");
        workDir.append(File.separator);
        workDir.append("jsp");
        workDir.append('\"');
        return workDir.toString();
    }
}

