/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatBootstrap;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.VMLauncherUtility;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Tomcat5Bootstrap
extends TomcatBootstrap {
    public String[] getClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(String.valueOf(this.getTomcatDir()) + File.separator + "bin" + File.separator + "bootstrap.jar");
        String toolsJarLocation = VMLauncherUtility.getVMInstall().getInstallLocation() + File.separator + "lib" + File.separator + "tools.jar";
        if (new File(toolsJarLocation).exists()) {
            classpath.add(toolsJarLocation);
        }
        return classpath.toArray(new String[0]);
    }

    public String getMainClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public String getStartCommand() {
        return "start";
    }

    public String getStopCommand() {
        return "stop";
    }

    public String[] getPrgArgs(String command) {
        String[] prgArgs = new String[]{"-config", "\"" + TomcatLauncherPlugin.getDefault().getConfigFile() + "\"", command};
        return prgArgs;
    }

    public String[] getVmArgs() {
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.add("-Dcatalina.home=\"" + this.getTomcatDir() + "\"");
        String commonEndorsedDir = String.valueOf(this.getTomcatDir()) + File.separator + "common" + File.separator + "endorsed";
        vmArgs.add("-Djava.endorsed.dirs=\"" + commonEndorsedDir + "\"");
        String catalinaBase = this.getTomcatBase();
        if (catalinaBase.length() == 0) {
            catalinaBase = this.getTomcatDir();
        }
        vmArgs.add("-Dcatalina.base=\"" + catalinaBase + "\"");
        vmArgs.add("-Djava.io.tmpdir=\"" + catalinaBase + File.separator + "temp\"");
        if (TomcatLauncherPlugin.getDefault().isSecurityManagerEnabled()) {
            vmArgs.add("-Djava.security.manager");
            String securityPolicyFile = String.valueOf(catalinaBase) + File.separator + "conf" + File.separator + "catalina.policy";
            vmArgs.add("-Djava.security.policy=\"" + securityPolicyFile + "\"");
        }
        return vmArgs.toArray(new String[0]);
    }

    public String getXMLTagAfterContextDefinition() {
        return "</Host>";
    }

    public IPath getJasperJarPath() {
        return new Path("common").append("lib").append("jasper-runtime.jar");
    }

    public IPath getServletJarPath() {
        return new Path("common").append("lib").append("servlet-api.jar");
    }

    public IPath getJSPJarPath() {
        return new Path("common").append("lib").append("jsp-api.jar");
    }

    public String getLabel() {
        return "Tomcat 5.x";
    }

    public String getContextWorkDir(String workFolder) {
        StringBuffer workDir = new StringBuffer("workDir=");
        workDir.append('\"');
        workDir.append(workFolder);
        workDir.append('\"');
        return workDir.toString();
    }
}

