/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import com.sysdeo.eclipse.tomcat.TomcatProjectPropertyPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TomcatProjectGeneralPropertyPage
implements TomcatPluginResources {
    private Button isTomcatProjectCheck;
    private Button updateXmlCheck;
    private Button reloadableCheck;
    private Button redirectLoggerCheck;
    private Text webpathText;
    private Text rootDirText;
    private Text extraInfoText;
    private TomcatProjectPropertyPage page;
    private static final int TEXT_FIELD_WIDTH = 200;

    public TomcatProjectGeneralPropertyPage(TomcatProjectPropertyPage page) {
        this.page = page;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.createIsTomcatProjectGroup(composite);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        this.createWebpathGroup((Composite)group);
        this.createExtraInformationGroup((Composite)group);
        Label lab = new Label((Composite)group, 0);
        this.createRootDirGroup((Composite)group);
        return composite;
    }

    public void createIsTomcatProjectGroup(Composite parent) {
        Composite isTomcatProjectGroup = new Composite(parent, 0);
        isTomcatProjectGroup.setLayout((Layout)new GridLayout(3, false));
        isTomcatProjectGroup.setLayoutData((Object)new GridData(768));
        this.isTomcatProjectCheck = new Button(isTomcatProjectGroup, 16416);
        this.isTomcatProjectCheck.setText(TomcatPluginResources.PROPERTIES_PAGE_PROJECT_ISTOMCATPROJECT_LABEL);
        this.isTomcatProjectCheck.setEnabled(true);
        try {
            this.isTomcatProjectCheck.setSelection(this.page.getJavaProject().getProject().hasNature("com.sysdeo.eclipse.tomcat.tomcatnature"));
        }
        catch (CoreException ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
    }

    public void createWebpathGroup(Composite parent) {
        Composite webpathGroup = new Composite(parent, 0);
        webpathGroup.setLayout((Layout)new GridLayout(3, false));
        webpathGroup.setLayoutData((Object)new GridData(768));
        Label webpathLabel = new Label(webpathGroup, 0);
        webpathLabel.setText(TomcatPluginResources.WIZARD_PROJECT_WEBPATH_LABEL);
        webpathLabel.setEnabled(true);
        this.webpathText = new Text(webpathGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.webpathText.setLayoutData((Object)data);
        this.webpathText.setText(this.getWebPath());
        this.webpathText.setEnabled(true);
        this.updateXmlCheck = new Button(webpathGroup, 16416);
        this.updateXmlCheck.setText(TomcatPluginResources.WIZARD_PROJECT_UPDATEXML_LABEL);
        data = new GridData();
        data.horizontalSpan = 3;
        this.updateXmlCheck.setLayoutData((Object)data);
        this.updateXmlCheck.setEnabled(true);
        this.updateXmlCheck.setSelection(this.getUpdateXml());
        this.reloadableCheck = new Button(webpathGroup, 16416);
        this.reloadableCheck.setText(TomcatPluginResources.WIZARD_PROJECT_RELOADABLE_LABEL);
        data = new GridData();
        data.horizontalSpan = 3;
        this.reloadableCheck.setLayoutData((Object)data);
        this.reloadableCheck.setEnabled(true);
        this.reloadableCheck.setSelection(this.getReloadable());
        this.redirectLoggerCheck = new Button(webpathGroup, 16416);
        this.redirectLoggerCheck.setText(TomcatPluginResources.WIZARD_PROJECT_REDIRECTLOGGER_LABEL);
        data = new GridData();
        data.horizontalSpan = 3;
        this.redirectLoggerCheck.setLayoutData((Object)data);
        this.redirectLoggerCheck.setEnabled(true);
        this.redirectLoggerCheck.setSelection(this.getRedirectLogger());
    }

    public void createRootDirGroup(Composite parent) {
        Composite rootDirGroup = new Composite(parent, 0);
        rootDirGroup.setLayout((Layout)new GridLayout(2, false));
        rootDirGroup.setLayoutData((Object)new GridData(768));
        Label rootDirLabel = new Label(rootDirGroup, 0);
        rootDirLabel.setText(TomcatPluginResources.WIZARD_PROJECT_ROOTDIR_LABEL);
        rootDirLabel.setEnabled(true);
        this.rootDirText = new Text(rootDirGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 30;
        this.rootDirText.setLayoutData((Object)data);
        this.rootDirText.setText(this.getRootDir());
        this.rootDirText.setEnabled(true);
    }

    public void createExtraInformationGroup(Composite parent) {
        Composite contextGroup = new Composite(parent, 0);
        contextGroup.setLayout((Layout)new GridLayout(1, false));
        contextGroup.setLayoutData((Object)new GridData(768));
        Label rootDirLabel = new Label(contextGroup, 0);
        rootDirLabel.setText(TomcatPluginResources.PROPERTIES_PAGE_PROJECT_EXTRAINFO_LABEL);
        rootDirLabel.setEnabled(true);
        this.extraInfoText = new Text(contextGroup, 2816);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 500;
        data.heightHint = 100;
        this.extraInfoText.setLayoutData((Object)data);
        this.extraInfoText.setText(this.getExtraInfo());
        this.extraInfoText.setEnabled(true);
    }

    protected String getWebPath() {
        String result = "";
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getWebPath();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    protected String getRootDir() {
        String result = "/";
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getRootDir();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    protected String getExtraInfo() {
        String result = "";
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getExtraInfo();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    protected boolean getUpdateXml() {
        boolean result = true;
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getUpdateXml();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    protected boolean getReloadable() {
        boolean result = true;
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getReloadable();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    protected boolean getRedirectLogger() {
        boolean result = false;
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getRedirectLogger();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    public boolean performOk() {
        try {
            if (this.isTomcatProjectCheck.getSelection()) {
                TomcatProject.addTomcatNature(this.page.getJavaProject());
                TomcatProject prj = this.page.getTomcatProject();
                prj.updateWebPath(this.webpathText.getText());
                prj.setUpdateXml(this.updateXmlCheck.getSelection());
                prj.setReloadable(this.reloadableCheck.getSelection());
                prj.setRedirectLogger(this.redirectLoggerCheck.getSelection());
                prj.setExtraInfo(this.extraInfoText.getText());
                prj.setRootDir(this.rootDirText.getText());
                prj.saveProperties();
            } else {
                this.page.getTomcatProject().removeContext();
                TomcatProject.removeTomcatNature(this.page.getJavaProject());
            }
        }
        catch (Exception ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
        return true;
    }

    public boolean isTomcatProjectChecked() {
        return this.isTomcatProjectCheck.getSelection();
    }
}

