/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.debug.ui.JavaUISourceLocator;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class VMLauncherUtility {
    public static IVMInstall getVMInstall() {
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstall[] vms = vmTypes[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                if (vms[j].getId().equals(TomcatLauncherPlugin.getDefault().getTomcatJRE())) {
                    return vms[j];
                }
                ++j;
            }
            ++i;
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static void runVM(String label, String classToLaunch, String[] classpath, String[] bootClasspath, String vmArgs, String prgArgs, ISourceLocator sourceLocator, boolean debug, boolean showInDebugger, boolean saveConfig) throws CoreException {
        IVMInstall vmInstall = VMLauncherUtility.getVMInstall();
        String mode = "";
        mode = debug ? "debug" : "run";
        IVMRunner vmRunner = vmInstall.getVMRunner(mode);
        ILaunchConfigurationWorkingCopy config = VMLauncherUtility.createConfig(label, classToLaunch, classpath, bootClasspath, vmArgs, prgArgs, sourceLocator, debug, showInDebugger, saveConfig);
        Launch launch = new Launch((ILaunchConfiguration)config, mode, sourceLocator);
        if (vmRunner != null) {
            VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(classToLaunch, classpath);
            ExecutionArguments executionArguments = new ExecutionArguments(vmArgs, prgArgs);
            vmConfig.setVMArguments(executionArguments.getVMArgumentsArray());
            vmConfig.setProgramArguments(executionArguments.getProgramArgumentsArray());
            if (bootClasspath.length == 0) {
                vmConfig.setBootClassPath(null);
            } else {
                vmConfig.setBootClassPath(bootClasspath);
            }
            vmRunner.run(vmConfig, (ILaunch)launch, null);
        }
        if (showInDebugger) {
            DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        }
    }

    public static void log(String label, String classToLaunch, String[] classpath, String[] bootClasspath, String vmArgs, String prgArgs, ISourceLocator sourceLocator, boolean debug, boolean showInDebugger) {
        StringBuffer trace = new StringBuffer("\n-------- Launch Tomcat JVM Start --------");
        trace.append("\n-> Label : " + label);
        trace.append("\n-> ClassToLaunch : " + classToLaunch);
        trace.append("\n-> Classpath : ");
        int i = 0;
        while (i < classpath.length) {
            trace.append(" | " + classpath[i] + " | ");
            ++i;
        }
        trace.append("\n-> BootClasspath : ");
        i = 0;
        while (i < bootClasspath.length) {
            trace.append(" | " + bootClasspath[i] + " | ");
            ++i;
        }
        trace.append("\n-> Vmargs : " + vmArgs);
        trace.append("\n-> PrgArgs : " + prgArgs);
        trace.append("\n-> Debug : " + debug);
        trace.append("\n-------- Launch Tomcat JVM End--------");
        TomcatLauncherPlugin.log(trace.toString());
    }

    public static ILaunchConfigurationWorkingCopy createConfig(String label, String classToLaunch, String[] classpath, String[] bootClasspath, String vmArgs, String prgArgs, ISourceLocator sourceLocator, boolean debug, boolean showInDebugger, boolean saveConfig) throws CoreException {
        IRuntimeClasspathEntry cpEntry;
        IVMInstall vmInstall = VMLauncherUtility.getVMInstall();
        ILaunchConfigurationType launchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.jdt.launching.localJavaApplication");
        ILaunchConfigurationWorkingCopy config = launchType.newInstance(null, label);
        config.setAttribute(IDebugUIConstants.ATTR_PRIVATE, !saveConfig);
        config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, JavaUISourceLocator.ID_PROMPTING_JAVA_SOURCE_LOCATOR);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, classToLaunch);
        ArrayList<String> classpathMementos = new ArrayList<String>();
        int i = 0;
        while (i < classpath.length) {
            cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(classpath[i]));
            cpEntry.setClasspathProperty(3);
            classpathMementos.add(cpEntry.getMemento());
            ++i;
        }
        if (bootClasspath.length == 0) {
            LibraryLocation[] librairies = vmInstall.getVMInstallType().getDefaultLibraryLocations(vmInstall.getInstallLocation());
            int i2 = 0;
            while (i2 < librairies.length) {
                IRuntimeClasspathEntry cpEntry2 = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)librairies[i2].getSystemLibraryPath());
                cpEntry2.setClasspathProperty(2);
                classpathMementos.add(cpEntry2.getMemento());
                ++i2;
            }
        } else {
            i = 0;
            while (i < bootClasspath.length) {
                cpEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(bootClasspath[i]));
                cpEntry.setClasspathProperty(2);
                classpathMementos.add(cpEntry.getMemento());
                ++i;
            }
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, classpathMementos);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, prgArgs);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        if (saveConfig) {
            config.doSave();
        }
        return config;
    }
}

