/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat.editors;

import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.editors.ListFieldEditor;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Widget;

public class ClasspathFieldEditor
extends ListFieldEditor
implements TomcatPluginResources {
    protected Button addJarZipButton;
    protected Button addDirButton;
    private String lastPath;

    protected ClasspathFieldEditor() {
    }

    public ClasspathFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected String[] getNewJarZip() {
        FileDialog dialog = new FileDialog(this.addJarZipButton.getShell(), 2);
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        String file = dialog.open();
        if (dialog.getFileNames().length != 0) {
            this.lastPath = dialog.getFilterPath();
            String[] result = dialog.getFileNames();
            int i = 0;
            while (i < result.length) {
                result[i] = String.valueOf(this.lastPath) + File.separator + result[i];
                ++i;
            }
            return result;
        }
        return new String[0];
    }

    protected String getNewDir() {
        String dir;
        DirectoryDialog dialog = new DirectoryDialog(this.addDirButton.getShell());
        if (this.lastPath != null && new File(this.lastPath).exists()) {
            dialog.setFilterPath(this.lastPath);
        }
        if ((dir = dialog.open()) != null) {
            if ((dir = dir.trim()).length() == 0) {
                return null;
            }
            this.lastPath = dir;
        }
        return dir;
    }

    protected void createButtons(Composite buttonBox) {
        this.addJarZipButton = this.createPushButton(buttonBox, TomcatPluginResources.PREF_PAGE_ADDJARZIPBUTTON_LABEL);
        this.addDirButton = this.createPushButton(buttonBox, TomcatPluginResources.PREF_PAGE_ADDDIRBUTTON_LABEL);
        this.removeButton = this.createPushButton(buttonBox, TomcatPluginResources.PREF_PAGE_REMOVEBUTTON_LABEL);
        this.upButton = this.createPushButton(buttonBox, TomcatPluginResources.PREF_PAGE_UPBUTTON_LABEL);
        this.downButton = this.createPushButton(buttonBox, TomcatPluginResources.PREF_PAGE_DOWNBUTTON_LABEL);
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ClasspathFieldEditor.this.addJarZipButton) {
                    ClasspathFieldEditor.this.addJarZipPressed();
                } else if (widget == ClasspathFieldEditor.this.addDirButton) {
                    ClasspathFieldEditor.this.addDirPressed();
                } else if (widget == ClasspathFieldEditor.this.removeButton) {
                    ClasspathFieldEditor.this.removePressed();
                } else if (widget == ClasspathFieldEditor.this.upButton) {
                    ClasspathFieldEditor.this.upPressed();
                } else if (widget == ClasspathFieldEditor.this.downButton) {
                    ClasspathFieldEditor.this.downPressed();
                } else if (widget == ClasspathFieldEditor.this.list) {
                    ClasspathFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void addJarZipPressed() {
        this.setPresentsDefaultValue(false);
        String[] input = this.getNewJarZip();
        int i = 0;
        while (i < input.length) {
            if (input != null) {
                int index = this.list.getSelectionIndex();
                if (index >= 0) {
                    this.list.add(input[i], index + 1);
                } else {
                    this.list.add(input[i], 0);
                }
                this.selectionChanged();
            }
            ++i;
        }
    }

    protected void addDirPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewDir();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
            } else {
                this.list.add(input, 0);
            }
            this.selectionChanged();
        }
    }
}

