/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.examples.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.examples.ui.ExamplesUIPlugin;
import org.eclipse.uml2.examples.ui.actions.UML2CommandAction;
import org.eclipse.uml2.util.UML2Util;
import org.osgi.framework.Bundle;

public class DiagnosticAction
extends UML2CommandAction {
    protected static final String URI_SCHEME_PLATFORM = "platform";
    protected static final String URI_SEGMENT_RESOURCE = "resource";
    protected final Bundle resourcesBundle = Platform.getBundle((String)"org.eclipse.core.resources");
    protected final ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = this.resourcesBundle == null ? null : new ValidateAction.EclipseResourcesUtil();
    protected final EValidator.SubstitutionLabelProvider substitutionLabelProvider = new EValidator.SubstitutionLabelProvider(){

        public String getObjectLabel(EObject eObject) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eObject);
        }

        public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eStructuralFeature);
        }

        public String getValueLabel(EDataType eDataType, Object value) {
            return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
        }
    };
    protected final UML2Util.QualifiedTextProvider qualifiedTextProvider = new UML2Util.QualifiedTextProvider(){

        public String getFeatureText(EStructuralFeature eStructuralFeature) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eStructuralFeature);
        }

        public String getClassText(EObject eObject) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eObject.eClass());
        }
    };
    protected final Map resourceToFileMap = new HashMap();

    protected DiagnosticAction() {
    }

    protected void handleDiagnostic(Diagnostic diagnostic, String dialogTitle) {
        switch (diagnostic.getSeverity()) {
            case 0: {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)ExamplesUIPlugin.INSTANCE.getString("_UI_DiagnosticOK_message"));
                break;
            }
            case 1: {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)ExamplesUIPlugin.INSTANCE.getString("_UI_DiagnosticOK_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
                break;
            }
            default: {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)ExamplesUIPlugin.INSTANCE.getString("_UI_DiagnosticProblems_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
            }
        }
        if (this.resourcesBundle != null) {
            List diagnostics;
            IFile file;
            HashMap fileToDiagnosticMap = new HashMap();
            Iterator children = diagnostic.getChildren().iterator();
            while (children.hasNext()) {
                Diagnostic child = (Diagnostic)children.next();
                file = this.getFile(child);
                if (file == null) continue;
                diagnostics = (List)fileToDiagnosticMap.get(file);
                if (diagnostics == null) {
                    try {
                        file.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 0);
                    }
                    catch (CoreException exception) {
                        ExamplesUIPlugin.INSTANCE.log((Object)exception);
                    }
                    diagnostics = new ArrayList();
                    fileToDiagnosticMap.put(file, diagnostics);
                }
                diagnostics.add(child);
            }
            if (1 < diagnostic.getSeverity()) {
                List data;
                Iterator entries = fileToDiagnosticMap.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    file = (IFile)entry.getKey();
                    diagnostics = ((List)entry.getValue()).iterator();
                    while (diagnostics.hasNext()) {
                        this.createMarkers(file, (Diagnostic)diagnostics.next());
                    }
                }
                if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                    Viewer viewer;
                    if (this.workbenchPart instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)this.workbenchPart).selectReveal((ISelection)new StructuredSelection(data.get(0)));
                    } else if (this.workbenchPart instanceof IViewerProvider && (viewer = ((IViewerProvider)this.workbenchPart).getViewer()) != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                    }
                }
            }
        }
    }

    protected Resource getResource(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        return !data.isEmpty() && data.get(0) instanceof EObject ? ((EObject)data.get(0)).eResource() : (Resource)this.editingDomain.getResourceSet().getResources().get(0);
    }

    protected void createMarkers(IFile file, Diagnostic diagnostic) {
        if (1 < diagnostic.getSeverity()) {
            this.eclipseResourcesUtil.createMarkers(file, diagnostic);
        }
    }

    protected IFile getFile(Diagnostic diagnostic) {
        Resource resource = this.getResource(diagnostic);
        if (resource != null) {
            URI uri;
            ResourceSet resourceSet;
            IFile file = (IFile)this.resourceToFileMap.get(resource);
            if (file == null && (resourceSet = resource.getResourceSet()) != null && URI_SCHEME_PLATFORM.equals((uri = resourceSet.getURIConverter().normalize(resource.getURI())).scheme()) && uri.segmentCount() > 1 && URI_SEGMENT_RESOURCE.equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int i = 1;
                int size = uri.segmentCount();
                while (i < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(i));
                    ++i;
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
                this.resourceToFileMap.put(resource, file);
            }
            return file;
        }
        return null;
    }
}

