/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.examples.ui.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.examples.ui.actions.UML2CommandAction;

public abstract class PropertiesAction
extends UML2CommandAction {
    protected static final String PROPERTIES_SEPARATOR = " = ";

    protected static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected static String format(String name, String separator, String prefix, boolean includePrefix) {
        List parsedName = new ArrayList();
        if (prefix != null) {
            if (name.startsWith(prefix)) {
                name = name.substring(prefix.length());
            }
            if (includePrefix) {
                parsedName = PropertiesAction.parseName(prefix, '_');
            }
        }
        if (name.length() != 0) {
            parsedName.addAll(PropertiesAction.parseName(name, '_'));
        }
        StringBuffer result = new StringBuffer();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(result.length() == 0 ? nameComponent : PropertiesAction.capName(nameComponent));
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        return result.length() == 0 && prefix != null ? prefix : result.toString();
    }

    protected static List parseName(String sourceName, char sourceSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        int length = sourceName.length();
        boolean lastIsLower = false;
        int index = 0;
        while (index < length) {
            char curChar = sourceName.charAt(index);
            if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == sourceSeparator) {
                if (lastIsLower || curChar == sourceSeparator) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                lastIsLower = false;
            } else {
                int currentWordLength;
                if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                    char lastChar = currentWord.charAt(--currentWordLength);
                    currentWord.setLength(currentWordLength);
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                    currentWord.append(lastChar);
                }
                lastIsLower = true;
            }
            if (curChar != sourceSeparator) {
                currentWord.append(curChar);
            }
            ++index;
        }
        result.add(currentWord.toString());
        return result;
    }

    protected static String capName(String name) {
        return name.length() == 0 ? name : String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    protected static StringBuffer appendValidIdentifier(StringBuffer validIdentifier, String name) {
        if (!PropertiesAction.isEmpty(name)) {
            char char_0 = name.charAt(0);
            if (Character.isJavaIdentifierStart(char_0)) {
                validIdentifier.append(char_0);
            } else {
                validIdentifier.append('_');
                if (Character.isJavaIdentifierPart(char_0)) {
                    validIdentifier.append(char_0);
                }
            }
            int i = 1;
            while (i < name.length()) {
                char char_i = name.charAt(i);
                if (Character.isJavaIdentifierPart(char_i)) {
                    validIdentifier.append(char_i);
                }
                ++i;
            }
        }
        return validIdentifier;
    }

    protected static String getValidIdentifier(String name) {
        return PropertiesAction.appendValidIdentifier(new StringBuffer(), name).toString();
    }

    protected static String getPropertiesKey(String prefix, String string) {
        return String.valueOf(prefix) + PropertiesAction.getValidIdentifier(string.replace(':', '_'));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static PrintWriter getPropertiesWriter(Package package_) {
        Resource resource = package_.eResource();
        ResourceSet resourceSet = resource.getResourceSet();
        URI uri = resource.getURI().trimFileExtension().appendFileExtension("properties");
        ArrayList<String> properties = new ArrayList<String>();
        BufferedReader lineNumberReader = null;
        try {
            try {
                lineNumberReader = new LineNumberReader(new InputStreamReader(resourceSet.getURIConverter().createInputStream(uri)));
                String line = ((LineNumberReader)lineNumberReader).readLine();
                while (line != null) {
                    properties.add(line);
                    line = ((LineNumberReader)lineNumberReader).readLine();
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (lineNumberReader == null) throw throwable;
                lineNumberReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (lineNumberReader != null) {
            lineNumberReader.close();
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(resourceSet.getURIConverter().createOutputStream(uri), true);
            if (properties.isEmpty()) return printWriter;
            Iterator i = properties.iterator();
            while (true) {
                if (!i.hasNext()) {
                    printWriter.println();
                    return printWriter;
                }
                printWriter.println((String)i.next());
            }
        }
        catch (IOException iOException) {}
        return printWriter;
    }
}

