/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.edit.command;

import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.impl.FeatureChangeImpl;
import org.eclipse.emf.ecore.change.impl.ListChangeImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ChangeCommand
extends AbstractCommand {
    private static final ChangeRecorder CHANGE_RECORDER = new ChangeRecorder(){
        private boolean featureIsUnique = false;

        protected ListChange createListChange(EList changesList, ChangeKind kind, int index) {
            if (this.featureIsUnique) {
                UniqueListChangeImpl listChange = new UniqueListChangeImpl();
                listChange.setKind(kind);
                listChange.setIndex(index);
                changesList.add((Object)listChange);
                return listChange;
            }
            return super.createListChange(changesList, kind, index);
        }

        protected void createRemoveListChange(EList oldList, EList changesList, Object newObject, int index) {
            if (this.featureIsUnique) {
                ListChange listChange = this.createListChange(changesList, ChangeKind.REMOVE_LITERAL, index);
                listChange.getValues().add(oldList.remove(index));
            } else {
                super.createRemoveListChange(oldList, changesList, newObject, index);
            }
        }

        protected void finalizeChange(FeatureChange change, EObject eObject) {
            this.featureIsUnique = change.getFeature().isUnique();
            super.finalizeChange(change, eObject);
        }

        protected FeatureChange createFeatureChange(EObject eObject, EStructuralFeature eStructuralFeature, Object value, boolean isSet) {
            return new UniqueFeatureChangeImpl(eStructuralFeature, value, isSet);
        }
    };
    private final EditingDomain editingDomain;
    private final Runnable runnable;
    private ChangeDescription changeDescription = null;

    public ChangeCommand(EditingDomain editingDomain, Runnable runnable) {
        this(editingDomain, runnable, null);
    }

    public ChangeCommand(EditingDomain editingDomain, Runnable runnable, String label) {
        this(editingDomain, runnable, label, null);
    }

    public ChangeCommand(EditingDomain editingDomain, Runnable runnable, String label, String description) {
        super(label, description);
        if (editingDomain == null) {
            throw new IllegalArgumentException(String.valueOf(editingDomain));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.valueOf(runnable));
        }
        this.editingDomain = editingDomain;
        this.runnable = runnable;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected Runnable getRunnable() {
        return this.runnable;
    }

    protected ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    protected void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    protected boolean prepare() {
        return this.getChangeDescription() == null;
    }

    public boolean canUndo() {
        return this.getChangeDescription() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        ChangeRecorder changeRecorder = CHANGE_RECORDER;
        synchronized (changeRecorder) {
            CHANGE_RECORDER.beginRecording(Collections.singleton(this.getEditingDomain().getResourceSet()));
            try {
                this.getRunnable().run();
                Object var2_4 = null;
                this.setChangeDescription(CHANGE_RECORDER.endRecording());
                return;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.setChangeDescription(CHANGE_RECORDER.endRecording());
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        ChangeRecorder changeRecorder = CHANGE_RECORDER;
        synchronized (changeRecorder) {
            this.getChangeDescription().applyAndReverse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        ChangeRecorder changeRecorder = CHANGE_RECORDER;
        synchronized (changeRecorder) {
            this.getChangeDescription().applyAndReverse();
        }
    }

    private static class UniqueListChangeImpl
    extends ListChangeImpl {
        UniqueListChangeImpl() {
        }

        public void apply(EList originalList) {
            switch (this.getKind().getValue()) {
                case 0: {
                    if (-1 == this.index) {
                        Iterator values = this.getValues().iterator();
                        while (values.hasNext()) {
                            Object value = values.next();
                            if (originalList.contains(value)) continue;
                            originalList.add(value);
                        }
                    } else {
                        ListIterator values = this.getValues().listIterator(this.getValues().size());
                        while (values.hasPrevious()) {
                            Object value = values.previous();
                            if (originalList.contains(value)) continue;
                            originalList.add(this.index, value);
                        }
                    }
                    break;
                }
                case 1: {
                    Iterator values = this.getValues().iterator();
                    while (values.hasNext()) {
                        originalList.remove(values.next());
                    }
                    break;
                }
                default: {
                    super.apply(originalList);
                }
            }
        }

        public void applyAndReverse(EList originalList) {
            switch (this.getKind().getValue()) {
                case 0: {
                    if (-1 == this.index) {
                        this.index = originalList.size();
                        Iterator values = this.getValues().iterator();
                        while (values.hasNext()) {
                            Object value = values.next();
                            if (originalList.contains(value)) continue;
                            originalList.add(value);
                        }
                    } else {
                        ListIterator values = this.getValues().listIterator(this.getValues().size());
                        while (values.hasPrevious()) {
                            Object value = values.previous();
                            if (originalList.contains(value)) continue;
                            originalList.add(this.index, value);
                        }
                    }
                    this.setKind(ChangeKind.REMOVE_LITERAL);
                    break;
                }
                case 1: {
                    Iterator values = this.getValues().iterator();
                    while (values.hasNext()) {
                        originalList.remove(values.next());
                    }
                    this.setKind(ChangeKind.ADD_LITERAL);
                    break;
                }
                default: {
                    super.applyAndReverse(originalList);
                }
            }
        }
    }

    private static final class UniqueFeatureChangeImpl
    extends FeatureChangeImpl {
        protected UniqueFeatureChangeImpl(EStructuralFeature feature, Object value, boolean isSet) {
            super(feature, value, isSet);
        }

        protected ListChange createListChange(EList changesList, ChangeKind kind, int index) {
            if (this.getFeature().isUnique()) {
                UniqueListChangeImpl listChange = new UniqueListChangeImpl();
                listChange.setKind(kind);
                listChange.setIndex(index);
                changesList.add((Object)listChange);
                return listChange;
            }
            return super.createListChange(changesList, kind, index);
        }
    }
}

