/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.search.SearchFactory;
import com.mbartl.viimplementation.util.Region;

public class MatchBrace
extends Command {
    private static final char[] BRACETYPES = new char[]{'{', '}', '[', ']', '(', ')', '<', '>'};
    private Search _search = SearchFactory.getRegExpSearch();
    private String _searchString = "[{}\\(\\)\\[\\]<>]";
    private String _nString = "";
    private String _fString = "";
    private boolean _forward = false;

    public void execute() {
        if (this._search == null) {
            return;
        }
        this.setSearchParameters(this._document.getCharAt(this._editor.getCaretPosition()));
        Region result = null;
        result = this._fString.length() == 0 ? this._search.search(this._document.get(), this._searchString, 0, this._editor.getCaretPosition()) : (this._forward ? this.getNextBrace() : this.getPreviousBrace());
        if (result != null) {
            this._editor.setCaretPosition(result.getOffset());
        }
    }

    private Region getNextBrace() {
        int stack = 1;
        boolean found = false;
        int startPos = this._editor.getCaretPosition();
        Region result = new Region(startPos, 0);
        while (!found) {
            result = this._search.search(this._document.get(), this._searchString, 0, 1, result.getOffset());
            if (startPos == result.getOffset()) {
                return null;
            }
            String selection = this._document.getText(result.getOffset(), result.getLength());
            if (selection.equals(this._nString)) {
                ++stack;
                continue;
            }
            if (!selection.equals(this._fString.substring(1)) || --stack != 0) continue;
            found = true;
        }
        return result;
    }

    private Region getPreviousBrace() {
        int stack = 1;
        boolean found = false;
        int startPos = this._editor.getCaretPosition();
        Region result = new Region(startPos, 0);
        while (!found) {
            result = this._search.search(this._document.get(), this._searchString, 1, 1, result.getOffset());
            if (startPos == result.getOffset()) {
                return null;
            }
            String selection = this._document.getText(result.getOffset(), result.getLength());
            if (selection.equals(this._nString)) {
                ++stack;
                continue;
            }
            if (!selection.equals(this._fString.substring(1)) || --stack != 0) continue;
            found = true;
        }
        return result;
    }

    private void setSearchParameters(char ch) {
        if (!this.isBrace(ch)) {
            this._searchString = "[\\[\\]{}\\(\\)<>]";
            this._forward = true;
            return;
        }
        switch (ch) {
            case '{': {
                this._searchString = "[{}]";
                this._forward = true;
                this._fString = "\\}";
                this._nString = "{";
                break;
            }
            case '}': {
                this._searchString = "[{}]";
                this._forward = false;
                this._fString = "\\{";
                this._nString = "}";
                break;
            }
            case '(': {
                this._searchString = "[\\)\\(]";
                this._forward = true;
                this._fString = "\\)";
                this._nString = "(";
                break;
            }
            case ')': {
                this._searchString = "[\\)\\(]";
                this._forward = false;
                this._fString = "\\(";
                this._nString = ")";
                break;
            }
            case '[': {
                this._searchString = "[\\[\\]]";
                this._forward = true;
                this._fString = "\\]";
                this._nString = "[";
                break;
            }
            case ']': {
                this._searchString = "[\\[\\]]";
                this._forward = false;
                this._fString = "\\[";
                this._nString = "]";
                break;
            }
            case '<': {
                this._searchString = "[<>]";
                this._forward = true;
                this._fString = "\\>";
                this._nString = "<";
                break;
            }
            case '>': {
                this._searchString = "[<>]";
                this._forward = false;
                this._fString = "\\<";
                this._nString = ">";
                break;
            }
            default: {
                this._searchString = "[{}()\\[\\]<>]";
                this._forward = true;
            }
        }
    }

    private boolean isBrace(char ch) {
        int i = 0;
        while (i < BRACETYPES.length) {
            if (ch == BRACETYPES[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

