/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.change;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.registers.TextBuffer;
import com.mbartl.viimplementation.registers.YankBufferHandler;
import com.mbartl.viimplementation.util.Line;
import com.mbartl.viimplementation.util.TextUtils;

public class PasteAbove
extends Command {
    private final TextBuffer _buffer;
    private final int _counter;

    public PasteAbove(int counter, String register) {
        this._counter = counter;
        this._buffer = YankBufferHandler.getInstance().getBuffer(register);
    }

    public void execute() {
        String text = TextUtils.multiplyString(this._buffer.getText(), this._counter);
        if (!this._buffer.getFullLines()) {
            this._document.replace(this._editor.getCaretPosition(), 0, text);
        } else {
            if (!TextUtils.endsWithDelimiter(text)) {
                text = String.valueOf(text) + this._analyzer.getStandardDelimiter();
            }
            if (this._analyzer.isEmptyDocument()) {
                this._document.replace(0, 0, String.valueOf(text) + "\n");
                this._editor.setCaretPosition(0);
                return;
            }
            Line line = this._analyzer.getLineOfOffset(this._editor.getCaretPosition());
            String delim = line.getDelimiter();
            if (text.endsWith(delim)) {
                delim = "";
            }
            int pos = line.getOffset();
            text = String.valueOf(delim) + text;
            this._document.replace(pos, 0, text);
            this._viLayer.updateDocument();
            Line newLine = this._analyzer.getLineOfOffset(pos);
            this._editor.setCaretPosition(newLine.getOffsetEndWithoutDelimiter());
        }
    }
}

