/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.change;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.registers.TextBuffer;
import com.mbartl.viimplementation.registers.YankBufferHandler;
import com.mbartl.viimplementation.util.Line;
import com.mbartl.viimplementation.util.TextUtils;

public class PasteBelow
extends Command {
    private final TextBuffer _buffer;
    private final int _counter;

    public PasteBelow(int counter, String register) {
        this._counter = counter;
        this._buffer = YankBufferHandler.getInstance().getBuffer(register);
    }

    public void execute() {
        String text = TextUtils.multiplyString(this._buffer.getText(), this._counter);
        if (this._analyzer.isEmptyDocument()) {
            if (!this._buffer.getFullLines()) {
                this._document.replace(this._editor.getCaretPosition(), 0, text);
            } else {
                this._document.replace(0, 0, "\n" + text);
                this._editor.setCaretPosition(0);
            }
            return;
        }
        int pos = this._editor.getCaretPosition();
        Line line = this._analyzer.getLineOfOffset(pos);
        if (!this._buffer.getFullLines()) {
            if (line.getLengthWithoutDelimiter() != 0) {
                ++pos;
            }
            pos = Math.min(pos, this._document.getLength() - 1);
            this._document.replace(pos, 0, text);
            this._editor.setCaretPosition(pos + text.length() - 1);
        } else {
            if (this._analyzer.getLinePosOfOffset(pos) == this._analyzer.getNumberOfLines() - 1) {
                text = String.valueOf(TextUtils.DELIMITER_ON_THIS_PLATFORM) + text;
            }
            this._document.replace(line.getOffsetEnd(), 0, text);
            this._editor.setCaretPosition(line.getOffsetEnd());
        }
    }
}

