/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.motion;

import com.mbartl.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viimplementation.util.Line;

public class MoveLeft
extends MotionCommand {
    private final boolean _jump;

    public MoveLeft(int counter, boolean jump) {
        super(counter);
        this._jump = jump;
    }

    public void execute() {
        if (this._analyzer.isEmptyDocument()) {
            return;
        }
        int cursorPos = this._editor.getCaretPosition();
        Line startLine = this._analyzer.getLineOfOffset(cursorPos);
        int startLineOffset = startLine.getOffset();
        int newPos = Math.max(0, cursorPos - this._counter);
        if (this._jump) {
            int endLinePos = this._analyzer.getLinePosOfOffset(newPos);
            Line endLine = this._analyzer.getLine(endLinePos);
            int delimiterPos = endLine.getOffsetEndWithoutDelimiter();
            int delimiterLength = endLine.getDelimiter().length();
            if (newPos >= delimiterPos && newPos < delimiterPos + delimiterLength) {
                newPos = endLine.getOffsetEndWithoutDelimiter() - 1;
                if (endLine.getLengthWithoutDelimiter() == 0) {
                    ++newPos;
                }
            }
        } else {
            newPos = Math.max(newPos, startLineOffset);
        }
        this._editor.setCaretPosition(newPos);
        this._viLayer.getCursorInLinePosition().setCurrentCursorInLinePosition();
    }
}

