/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.select;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.util.Line;

public class SelectLines
extends Command {
    private int _lines;
    private boolean _includeDelimiter;
    private int _direction;
    public static final int UP = 0;
    public static final int DOWN = 1;

    public SelectLines(int lines, int direction, boolean includeDelimiter) {
        this._lines = lines;
        this._includeDelimiter = includeDelimiter;
        this._direction = direction;
    }

    public SelectLines(int direction, boolean includeDelimiter) {
        this._lines = this._analyzer.getNumberOfLines();
        this._includeDelimiter = includeDelimiter;
        this._direction = direction;
    }

    public void execute() {
        Line endLine;
        Line startLine;
        if (this._analyzer.isEmptyDocument()) {
            return;
        }
        int cursorPos = this._editor.getCaretPosition();
        if (this._direction == 1) {
            startLine = this._analyzer.getLineOfOffset(cursorPos);
            int startLinePos = this._analyzer.getLinePosOfOffset(cursorPos);
            int endLinePos = startLinePos + this._lines - 1;
            endLinePos = Math.min(endLinePos, this._analyzer.getNumberOfLines() - 1);
            endLine = this._analyzer.getLine(endLinePos);
        } else {
            int endLinePos = this._analyzer.getLinePosOfOffset(cursorPos);
            endLine = this._analyzer.getLine(endLinePos);
            int startLinePos = endLinePos - this._lines;
            if (startLinePos < 0) {
                startLinePos = 0;
            }
            startLine = this._analyzer.getLine(startLinePos);
        }
        int start = startLine.getOffset();
        int length = endLine.getOffset() + endLine.getLength() - start;
        if (!this._includeDelimiter) {
            length -= endLine.getDelimiter().length();
        }
        this._selectionManager.setInternalSelection(start, length);
    }
}

