/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.select;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.util.Line;

public class SelectWord
extends Command {
    private final int _counter;
    private final boolean _forward;
    private final boolean _fullWord;

    public SelectWord(int counter, boolean forward, boolean fullWord) {
        this._counter = counter;
        this._forward = forward;
        this._fullWord = fullWord;
    }

    public void execute() {
        int length;
        int start = this._editor.getCaretPosition();
        if (this._forward) {
            length = this.selectWordForward(start, this._fullWord);
        } else {
            length = this.selectWordBackward(start, this._fullWord);
            start -= length;
        }
        this._selectionManager.setInternalSelection(start, length);
    }

    private int selectWordForward(int start, boolean fullWord) {
        int end = start;
        String text = this._document.get();
        int i = 0;
        while (i < this._counter) {
            end = fullWord ? this._viLayer.getWordSeparatorUtils().getNextWORD(text, end) : this._viLayer.getWordSeparatorUtils().getNextWord(text, end);
            ++i;
        }
        if (this._counter == 1) {
            Line line = this._analyzer.getLineOfOffset(start);
            end = Math.min(end, line.getOffset() + line.getLengthWithoutDelimiter());
        }
        return end - start;
    }

    private int selectWordBackward(int start, boolean fullWord) {
        String text = this._document.get();
        int end = start;
        int i = 0;
        while (i < this._counter) {
            end = fullWord ? this._viLayer.getWordSeparatorUtils().getPreviousWORD(text, end) : this._viLayer.getWordSeparatorUtils().getPreviousWord(text, end);
            if (end == -1) {
                end = 0;
            }
            ++i;
        }
        return start - end;
    }
}

