/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.layer;

import com.mbartl.viimplementation.interfaces.AbstractDocumentAdapter;
import com.mbartl.viimplementation.interfaces.IBookmark;
import com.mbartl.viimplementation.interfaces.ICaret;
import com.mbartl.viimplementation.interfaces.IEditor;
import com.mbartl.viimplementation.interfaces.IKeyListener;
import com.mbartl.viimplementation.interfaces.IUndoManager;
import com.mbartl.viimplementation.layer.Buffer;
import com.mbartl.viimplementation.layer.BufferEvaluator;
import com.mbartl.viimplementation.layer.CursorInLinePosition;
import com.mbartl.viimplementation.layer.KeyVerifier;
import com.mbartl.viimplementation.layer.LayerInformation;
import com.mbartl.viimplementation.layer.SelectionManager;
import com.mbartl.viimplementation.layer.ViLayerManager;
import com.mbartl.viimplementation.preferences.Preferences;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.util.DocumentAnalyzer;
import com.mbartl.viimplementation.util.ViKeyEvent;
import com.mbartl.viimplementation.util.ViMode;
import com.mbartl.viimplementation.util.WordSeparatorUtils;

public class ViLayer {
    private Buffer _buffer;
    private BufferEvaluator _bufferEvaluator;
    private StringBuffer _insertBuffer = new StringBuffer();
    private ViMode _mode;
    private KeyVerifier _keyVerifier;
    private IKeyListener _keyListener = null;
    private ICaret _caret;
    private LayerInformation _layerInformation;
    private SelectionManager _selectionManager;
    private IUndoManager _undoManager;
    private static long _lastPopupTime = System.currentTimeMillis();
    private DocumentAnalyzer _analyzer;
    private CursorInLinePosition _cursorInLinePosition;
    private WordSeparatorUtils _wordSeparatorUtils;
    private boolean _suppressNextStatusLineMessage;

    public ViLayer(LayerInformation info) {
        this._layerInformation = info;
        this._mode = ViMode.COMMAND_MODE;
        this._selectionManager = new SelectionManager(this);
        this._undoManager = info.getUndoManager();
        this._caret = info.getCaret();
        this._keyVerifier = new KeyVerifier(this);
        this._buffer = new Buffer();
        this._bufferEvaluator = new BufferEvaluator(this);
        this._analyzer = new DocumentAnalyzer(this._layerInformation.getDocument().get());
        this._cursorInLinePosition = new CursorInLinePosition(this.getEditor(), this._analyzer);
        Preferences preferences = ViPreferenceService.getInstance().getPreferences();
        String separators = preferences.getString("wordseparators");
        this._wordSeparatorUtils = new WordSeparatorUtils(separators);
        this.switchToCommandMode();
    }

    public void setStatusLine() {
        if (this._suppressNextStatusLineMessage) {
            this._suppressNextStatusLineMessage = false;
            return;
        }
        String message = this._mode == ViMode.COMMAND_MODE ? "CommandMode: CommandBuffer = " + this._buffer.getStatusLineCommand() : (this._mode == ViMode.INSERT_MODE ? "InsertMode" : (this._mode == ViMode.VISUAL_MODE ? "VisualMode: CommandBuffer = " + this._buffer.getStatusLineCommand() : (this._mode == ViMode.VISUAL_LINE_MODE ? "VisualLineMode: CommandBuffer = " + this._buffer.getStatusLineCommand() : (this._mode == ViMode.REPLACE_MODE ? "ReplaceMode" : "Something unexpected happened. Please report error!"))));
        this._layerInformation.getStatusLineManager().setMessage(message);
    }

    public void setStatusLine(String message) {
        this._layerInformation.getStatusLineManager().setMessage(message);
        this._suppressNextStatusLineMessage = true;
    }

    public void switchToCommandMode() {
        this._mode = ViMode.COMMAND_MODE;
        this._undoManager.endCompoundChange();
        this._bufferEvaluator.clear();
        if (ViPreferenceService.getInstance().getBoolean("vimcursor")) {
            this._caret.setCaretThick();
        }
        this._selectionManager.resetSelection();
        this.updateDocument();
    }

    public void switchToInsertMode() {
        this.getEditor().resetHighlighting(true);
        this._mode = ViMode.INSERT_MODE;
        this._bufferEvaluator._buffer.setCommand("");
        this._undoManager.beginCompoundChange();
        if (ViPreferenceService.getInstance().getBoolean("vimcursor")) {
            this._caret.setCaretThin();
        }
        this._insertBuffer = new StringBuffer(100);
    }

    public void switchToReplaceMode() {
        this.getEditor().resetHighlighting(true);
        this._mode = ViMode.REPLACE_MODE;
        this._bufferEvaluator._buffer.setCommand("");
        this._undoManager.beginCompoundChange();
        if (ViPreferenceService.getInstance().getBoolean("vimcursor")) {
            this._caret.setCaretThin();
        }
        this._insertBuffer = new StringBuffer(100);
    }

    public void switchToVisualMode(ViMode mode) {
        this._mode = mode;
        this._selectionManager.activateVisualMode(this._mode);
        this._bufferEvaluator._buffer.setCommand("");
        this._undoManager.beginCompoundChange();
        if (ViPreferenceService.getInstance().getBoolean("vimcursor")) {
            this._caret.setCaretThick();
        }
    }

    public void unLoad() {
        if (ViPreferenceService.getInstance().getBoolean("vimcursor")) {
            this._caret.restoreOriginalCaret();
        }
        this._keyListener.unregister();
        this._layerInformation.getDocument().unregister();
    }

    public boolean isInInsertMode() {
        return this._mode == ViMode.INSERT_MODE;
    }

    public boolean isInVisualOrVisualLineMode() {
        return this._mode == ViMode.VISUAL_MODE || this._mode == ViMode.VISUAL_LINE_MODE;
    }

    public boolean isInVisualCharacterMode() {
        return this._mode == ViMode.VISUAL_MODE;
    }

    public boolean isInVisualLineMode() {
        return this._mode == ViMode.VISUAL_LINE_MODE;
    }

    public boolean isInCommandMode() {
        return this._mode == ViMode.COMMAND_MODE;
    }

    public boolean isInReplaceMode() {
        return this._mode == ViMode.REPLACE_MODE;
    }

    public void toggleVisualMode() {
        if (this.isInVisualOrVisualLineMode()) {
            this.switchToCommandMode();
        } else {
            this.switchToVisualMode(ViMode.VISUAL_MODE);
        }
    }

    public void toggleVisualLineMode() {
        if (this.isInVisualLineMode()) {
            this.switchToCommandMode();
        } else {
            this.switchToVisualMode(ViMode.VISUAL_LINE_MODE);
        }
    }

    public StringBuffer getInsertBuffer() {
        return this._insertBuffer;
    }

    public void setInsertBuffer(StringBuffer buffer) {
        this._insertBuffer = buffer;
    }

    public IEditor getEditor() {
        return this._layerInformation.getEditor();
    }

    public BufferEvaluator getBufferEvaluator() {
        return this._bufferEvaluator;
    }

    public SelectionManager getSelectionManager() {
        return this._selectionManager;
    }

    public AbstractDocumentAdapter getDocument() {
        return this._layerInformation.getDocument();
    }

    public boolean verifyKeyEvent(ViKeyEvent e) {
        long time;
        if (!ViLayerManager.getInstance().isFullVersion() && (time = System.currentTimeMillis()) - _lastPopupTime > 180000L) {
            _lastPopupTime = time;
            this.showDialog("Trial Version", "To remove this message buy a full version!\nhttp://www.satokar.com/viplugin/index.php");
        }
        return this._keyVerifier.verifyKey(e);
    }

    public void setKeyListener(IKeyListener keyListener) {
        this._keyListener = keyListener;
        this._keyListener.register();
    }

    public IBookmark getBookmarkImplementation() {
        return this._layerInformation.getBookmark();
    }

    public IUndoManager getUndoManager() {
        return this._undoManager;
    }

    public DocumentAnalyzer getDocumentAnalyzer() {
        return this._analyzer;
    }

    public void updateDocument() {
        if (!this.isInInsertMode() && !this.isInReplaceMode()) {
            this._analyzer.updateAnalyzer(this.getDocument().get());
        }
    }

    public void showDialog(String title, String message) {
        this._layerInformation.getMessageDialog().showDialog(title, message);
    }

    public CursorInLinePosition getCursorInLinePosition() {
        return this._cursorInLinePosition;
    }

    public WordSeparatorUtils getWordSeparatorUtils() {
        return this._wordSeparatorUtils;
    }

    public Buffer getBuffer() {
        return this._buffer;
    }
}

