/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.util;

import com.mbartl.viimplementation.util.Line;
import com.mbartl.viimplementation.util.Region;
import com.mbartl.viimplementation.util.TextUtils;
import java.util.ArrayList;

public final class DocumentAnalyzer {
    private String _text;
    private ArrayList _lines;

    public DocumentAnalyzer(String text) {
        this.updateAnalyzer(text);
    }

    public void updateAnalyzer(String text) {
        this._text = text;
        this._lines = this.createLines(text);
    }

    private ArrayList createLines(String text) {
        ArrayList<Line> lines = new ArrayList<Line>(10000);
        int offset = 0;
        String delimiter = "";
        int idx = 0;
        int idx1 = text.indexOf(10, offset);
        int idx2 = text.indexOf(13, offset);
        while (true) {
            if (idx1 != -1 && idx1 < offset) {
                idx1 = text.indexOf(10, offset);
            }
            if (idx2 != -1 && idx2 < offset) {
                idx2 = text.indexOf(13, offset);
            }
            if (idx1 != -1 && idx2 != -1 && idx2 == idx1 - 1) {
                idx = idx2;
                delimiter = "\r\n";
            } else if (idx1 != -1 && (idx1 < idx2 || idx2 == -1)) {
                idx = idx1;
                delimiter = "\n";
            } else if (idx2 != -1 && (idx1 > idx2 || idx1 == -1)) {
                idx = idx2;
                delimiter = "\r";
            } else {
                if (offset <= text.length()) {
                    lines.add(new Line(offset, text.length() - offset, ""));
                }
                return lines;
            }
            int l = delimiter.length();
            lines.add(new Line(offset, idx + l - offset, delimiter));
            offset = idx + l;
        }
    }

    public int getNumberOfLines() {
        return this._lines.size();
    }

    public int getNumberofLines(Region region) {
        int endLine = this.getLinePosOfOffset(region.getOffsetEnd());
        int startLine = this.getLinePosOfOffset(region.getOffset());
        return endLine - startLine + 1;
    }

    public Line getLine(int linePos) {
        return (Line)this._lines.get(linePos);
    }

    public Line getLineOfOffset(int offset) {
        int linePos = this.getLinePosOfOffset(offset);
        if (linePos != -1) {
            return (Line)this._lines.get(linePos);
        }
        return null;
    }

    public int getLinePosOfOffset(int offset) {
        offset = Math.min(this._text.length(), offset);
        if (offset == this._text.length()) {
            return this._lines.size() - 1;
        }
        int i = 0;
        while (i < this._lines.size()) {
            Line line = (Line)this._lines.get(i);
            if (line.getOffsetEnd() > offset) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmptyDocument() {
        return this._lines.size() == 0 || this._lines.size() == 1 && this.getLine(0).getLength() == 0;
    }

    public String getStandardDelimiter() {
        if (this._lines.size() > 0) {
            Line line = (Line)this._lines.get(0);
            return line.getDelimiter();
        }
        return TextUtils.DELIMITER_ON_THIS_PLATFORM;
    }
}

