/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkConversionValue;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.OrmEclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkObjectTypeConverter
extends OrmEclipseLinkConverter<XmlObjectTypeConverter>
implements EclipseLinkObjectTypeConverter {
    private String dataType;
    private String objectType;
    private final List<OrmEclipseLinkConversionValue> conversionValues = new ArrayList<OrmEclipseLinkConversionValue>();
    private String defaultObjectValue;

    public OrmEclipseLinkObjectTypeConverter(XmlContextNode parent) {
        super(parent);
    }

    @Override
    public String getType() {
        return "objectTypeConverter";
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void setDataType(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        ((XmlObjectTypeConverter)((Object)this.getXmlResource())).setDataType(newDataType);
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    protected void setDataType_(String newDataType) {
        String oldDataType = this.dataType;
        this.dataType = newDataType;
        this.firePropertyChanged("dataType", oldDataType, newDataType);
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        ((XmlObjectTypeConverter)((Object)this.getXmlResource())).setObjectType(newObjectType);
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    protected void setObjectType_(String newObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = newObjectType;
        this.firePropertyChanged("objectType", oldObjectType, newObjectType);
    }

    public ListIterator<OrmEclipseLinkConversionValue> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public OrmEclipseLinkConversionValue addConversionValue(int index) {
        XmlConversionValue resourceConversionValue = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValue();
        OrmEclipseLinkConversionValue contextConversionValue = this.buildConversionValue(resourceConversionValue);
        this.conversionValues.add(index, contextConversionValue);
        ((XmlObjectTypeConverter)((Object)this.getXmlResource())).getConversionValues().add(index, (Object)resourceConversionValue);
        this.fireItemAdded("conversionValues", index, contextConversionValue);
        return contextConversionValue;
    }

    @Override
    public OrmEclipseLinkConversionValue addConversionValue() {
        return this.addConversionValue(this.conversionValues.size());
    }

    protected void addConversionValue(int index, OrmEclipseLinkConversionValue conversionValue) {
        this.addItemToList(index, conversionValue, this.conversionValues, "conversionValues");
    }

    protected void addConversionValue(OrmEclipseLinkConversionValue conversionValue) {
        this.addConversionValue(this.conversionValues.size(), conversionValue);
    }

    @Override
    public void removeConversionValue(int index) {
        OrmEclipseLinkConversionValue removedJoinColumn = this.conversionValues.remove(index);
        ((XmlObjectTypeConverter)((Object)this.getXmlResource())).getConversionValues().remove(index);
        this.fireItemRemoved("conversionValues", index, removedJoinColumn);
    }

    @Override
    public void removeConversionValue(EclipseLinkConversionValue conversionValue) {
        this.removeConversionValue(this.conversionValues.indexOf(conversionValue));
    }

    protected void removeConversionValue_(EclipseLinkConversionValue conversionValue) {
        this.removeItemFromList(conversionValue, this.conversionValues, "conversionValues");
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex);
        ((XmlObjectTypeConverter)((Object)this.getXmlResource())).getConversionValues().move(targetIndex, sourceIndex);
        this.fireItemMoved("conversionValues", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<String> dataValues() {
        return new TransformationListIterator<OrmEclipseLinkConversionValue, String>(this.conversionValues()){

            protected String transform(OrmEclipseLinkConversionValue next) {
                return next.getDataValue();
            }
        };
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        ((XmlObjectTypeConverter)((Object)this.getXmlResource())).setDefaultObjectValue(newDefaultObjectValue);
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    protected void setDefaultObjectValue_(String newDefaultObjectValue) {
        String oldDefaultObjectValue = this.defaultObjectValue;
        this.defaultObjectValue = newDefaultObjectValue;
        this.firePropertyChanged("defaultObjectValue", oldDefaultObjectValue, newDefaultObjectValue);
    }

    @Override
    protected void initialize(XmlObjectTypeConverter xmlResource) {
        super.initialize(xmlResource);
        this.dataType = this.getResourceDataType();
        this.objectType = this.getResourceObjectType();
        this.defaultObjectValue = this.getResourceDefaultObjectValue();
        this.initializeConversionValues();
    }

    protected void initializeConversionValues() {
        for (XmlConversionValue resourceConversionValue : ((XmlObjectTypeConverter)((Object)this.getXmlResource())).getConversionValues()) {
            this.conversionValues.add(this.buildConversionValue(resourceConversionValue));
        }
    }

    @Override
    public void update() {
        super.update();
        this.setDataType_(this.getResourceDataType());
        this.setObjectType_(this.getResourceObjectType());
        this.setDefaultObjectValue_(this.getResourceDefaultObjectValue());
        this.updateConversionValues();
    }

    protected void updateConversionValues() {
        CloneIterator xmlConversionValues = new CloneIterator(((XmlObjectTypeConverter)((Object)this.getXmlResource())).getConversionValues());
        ListIterator<OrmEclipseLinkConversionValue> contextConversionValues = this.conversionValues();
        while (contextConversionValues.hasNext()) {
            OrmEclipseLinkConversionValue contextConversionValue = (OrmEclipseLinkConversionValue)contextConversionValues.next();
            if (xmlConversionValues.hasNext()) {
                contextConversionValue.update((XmlConversionValue)((Object)xmlConversionValues.next()));
                continue;
            }
            this.removeConversionValue_(contextConversionValue);
        }
        while (xmlConversionValues.hasNext()) {
            this.addConversionValue(this.buildConversionValue((XmlConversionValue)((Object)xmlConversionValues.next())));
        }
    }

    protected OrmEclipseLinkConversionValue buildConversionValue(XmlConversionValue resourceConversionValue) {
        OrmEclipseLinkConversionValue conversionValue = new OrmEclipseLinkConversionValue(this);
        conversionValue.initialize(resourceConversionValue);
        return conversionValue;
    }

    protected String getResourceDataType() {
        return ((XmlObjectTypeConverter)this.resourceConverter).getDataType();
    }

    protected String getResourceObjectType() {
        return ((XmlObjectTypeConverter)this.resourceConverter).getObjectType();
    }

    protected String getResourceDefaultObjectValue() {
        return ((XmlObjectTypeConverter)this.resourceConverter).getDefaultObjectValue();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        ListIterator<OrmEclipseLinkConversionValue> stream = this.conversionValues();
        while (stream.hasNext()) {
            ((OrmEclipseLinkConversionValue)stream.next()).validate(messages, reporter);
        }
    }
}

