/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationArrayCellEditor;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsView;
import org.eclipse.jst.ws.internal.jaxws.ui.views.ClassDialogCellEditor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsValuesEditingSupport
extends EditingSupport {
    private AnnotationsView annotationsView;
    private TreeViewer treeViewer;
    private TextCellEditor textCellEditor;
    private CheckboxCellEditor checkboxCellEditor;
    private ComboBoxCellEditor comboBoxCellEditor;
    private ClassDialogCellEditor classDialogCellEditor;
    private AnnotationArrayCellEditor annotationArrayCellEditor;

    public AnnotationsValuesEditingSupport(AnnotationsView annotationsView, TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.treeViewer = treeViewer;
        this.annotationsView = annotationsView;
        this.textCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        this.checkboxCellEditor = new CheckboxCellEditor((Composite)treeViewer.getTree());
        this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)treeViewer.getTree(), new String[0]);
        this.classDialogCellEditor = new ClassDialogCellEditor((Composite)treeViewer.getTree());
        this.annotationArrayCellEditor = new AnnotationArrayCellEditor((Composite)treeViewer.getTree(), new Object[0]);
    }

    protected boolean canEdit(Object element) {
        if (element instanceof Method) {
            Method method = (Method)element;
            return (Boolean)this.getValue(method.getDeclaringClass());
        }
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof Class) {
            return this.checkboxCellEditor;
        }
        if (element instanceof Method) {
            Method method = (Method)element;
            final Class<?> returnType = method.getReturnType();
            if (returnType.isEnum()) {
                ?[] enumConstants = returnType.getEnumConstants();
                String[] values = new String[enumConstants.length];
                int i = 0;
                while (i < enumConstants.length) {
                    values[i] = enumConstants[i].toString();
                    ++i;
                }
                this.comboBoxCellEditor.setItems(values);
                return this.comboBoxCellEditor;
            }
            if (returnType.equals(Boolean.TYPE)) {
                return this.checkboxCellEditor;
            }
            if (returnType.equals(Class.class)) {
                return this.classDialogCellEditor;
            }
            if (returnType.isArray()) {
                this.annotationArrayCellEditor.setMethod(method);
                return this.annotationArrayCellEditor;
            }
            if (returnType.isPrimitive()) {
                this.textCellEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        try {
                            if (returnType.equals(Byte.TYPE)) {
                                Byte.parseByte((String)value);
                            }
                            if (returnType.equals(Short.TYPE)) {
                                Short.parseShort((String)value);
                            }
                            if (returnType.equals(Integer.TYPE)) {
                                Integer.parseInt((String)value);
                            }
                            if (returnType.equals(Long.TYPE)) {
                                Long.parseLong((String)value);
                            }
                            if (returnType.equals(Float.TYPE)) {
                                Float.parseFloat((String)value);
                            }
                            if (returnType.equals(Double.TYPE)) {
                                Double.parseDouble((String)value);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            return String.valueOf(JAXWSUIMessages.ANNOTATION_EDITING_SUPPORT_NOT_VALID_MESSAGE_PREFIX) + returnType.getSimpleName();
                        }
                        return null;
                    }
                });
                return this.textCellEditor;
            }
            return this.textCellEditor;
        }
        return this.checkboxCellEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof Class) {
            return this.getValueForClass((Class)element);
        }
        if (element instanceof Method) {
            return this.getValueForMethod((Method)element);
        }
        return null;
    }

    private Object getValueForClass(Class<?> aClass) {
        if (this.treeViewer.getInput() instanceof IAnnotatable) {
            return this.getValueForClass(aClass, (IAnnotatable)this.treeViewer.getInput());
        }
        return Boolean.FALSE;
    }

    private Object getValueForClass(Class<?> aClass, IAnnotatable annotatedElement) {
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                String annotationName = annotation.getElementName();
                if (AnnotationUtils.isAnnotationPresent((IJavaElement)((IJavaElement)annotatedElement), (String)annotationName) && (annotationName.equals(aClass.getSimpleName()) || annotationName.equals(aClass.getCanonicalName()))) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return Boolean.FALSE;
    }

    private Object getValueForMethod(Method method) {
        Object value = null;
        try {
            if (this.treeViewer.getInput() instanceof IAnnotatable) {
                value = this.getValueForMethod(method, (IAnnotatable)this.treeViewer.getInput());
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return value;
    }

    private Object getValueForMethod(Method method, IAnnotatable annotatedElement) throws JavaModelException {
        IAnnotation[] annotations;
        Class<?> returnType = method.getReturnType();
        IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            Class<?> declaringClass = method.getDeclaringClass();
            String annotationName = annotation.getElementName();
            if (annotationName.equals(declaringClass.getSimpleName()) || annotationName.equals(declaringClass.getCanonicalName())) {
                IMemberValuePair[] memberValuePairs;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                    if (memberValuePair.getMemberName().equals(method.getName())) {
                        if (returnType.equals(String.class)) {
                            return memberValuePair.getValue();
                        }
                        if (returnType.isEnum()) {
                            String enumValue = memberValuePair.getValue().toString();
                            String literal = enumValue.substring(enumValue.lastIndexOf(".") + 1);
                            ?[] enumConstants = method.getReturnType().getEnumConstants();
                            int i = 0;
                            while (i < enumConstants.length) {
                                if (enumConstants[i].toString().equals(literal)) {
                                    return i;
                                }
                                ++i;
                            }
                        }
                        if (returnType.equals(Class.class)) {
                            return memberValuePair.getValue();
                        }
                        if (returnType.equals(Boolean.TYPE)) {
                            return memberValuePair.getValue();
                        }
                        if (returnType.isPrimitive()) {
                            return "";
                        }
                        if (returnType.isArray()) {
                            if (memberValuePair.getValueKind() == 11) {
                                Object[] arrayValues = (Object[])memberValuePair.getValue();
                                int i = 0;
                                while (i < arrayValues.length) {
                                    String value = arrayValues[i].toString();
                                    arrayValues[i] = String.valueOf(value) + ".class";
                                    ++i;
                                }
                                return arrayValues;
                            }
                            return memberValuePair.getValue();
                        }
                    }
                    ++n4;
                }
                return this.getDefaultValueForMethod(returnType);
            }
            ++n2;
        }
        return null;
    }

    private Object getDefaultValueForMethod(Class<?> returnType) {
        if (returnType.equals(String.class)) {
            return "";
        }
        if (returnType.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        if (returnType.isEnum()) {
            return -1;
        }
        if (returnType.isPrimitive()) {
            return "";
        }
        if (returnType.isArray()) {
            return new Object[0];
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (element instanceof Class && ((Class)element).isAnnotation()) {
                Class annotationClass = (Class)element;
                this.setValueForClass(annotationClass, (Boolean)value);
            }
            if (element instanceof Method) {
                this.setValueForMethod((Method)element, value);
            }
        }
        catch (CoreException ce) {
            JAXWSUIPlugin.log(ce.getStatus());
        }
    }

    private void setValueForClass(Class<? extends Annotation> annotationClass, Boolean annotate) throws CoreException {
        Object viewerInput = this.treeViewer.getInput();
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationDefinitionForClass(annotationClass).getAnnotationAttributeInitializer();
        if (viewerInput instanceof IJavaElement) {
            this.setValueForClass(annotationClass, annotate, (IJavaElement)viewerInput, annotationAttributeInitializer);
        }
    }

    private org.eclipse.jdt.core.dom.Annotation getAnnotation(AST ast, Class<? extends Annotation> annotationClass, List<MemberValuePair> memberValuePairs) {
        Object annotation = null;
        int numberOfDeclaredMethods = annotationClass.getDeclaredMethods().length;
        if (numberOfDeclaredMethods == 0) {
            annotation = AnnotationsCore.createMarkerAnnotation((AST)ast, (String)annotationClass.getSimpleName());
        } else if (numberOfDeclaredMethods == 1) {
            MemberValuePair memberValuePair;
            Expression value = null;
            if (memberValuePairs != null && memberValuePairs.size() == 1 && (memberValuePair = memberValuePairs.get(0)) != null) {
                value = memberValuePair.getValue();
            }
            annotation = value != null ? AnnotationsCore.createSingleMemberAnnotation((AST)ast, (String)annotationClass.getSimpleName(), value) : AnnotationsCore.createNormalAnnotation((AST)ast, (String)annotationClass.getSimpleName(), memberValuePairs);
        } else if (numberOfDeclaredMethods > 1) {
            annotation = AnnotationsCore.createNormalAnnotation((AST)ast, (String)annotationClass.getSimpleName(), memberValuePairs);
        }
        return annotation;
    }

    private void setValueForClass(Class<? extends Annotation> annotationClass, Boolean annotate, IJavaElement javaElement, IAnnotationAttributeInitializer annotationAttributeInitializer) throws CoreException {
        ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement((IJavaElement)javaElement);
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        AST ast = compilationUnit.getAST();
        List<MemberValuePair> memberValuePairs = this.getMemberValuePairs(annotationAttributeInitializer, javaElement, ast, annotationClass);
        org.eclipse.jdt.core.dom.Annotation annotation = this.getAnnotation(ast, annotationClass, memberValuePairs);
        TextFileChange change = new TextFileChange("Add/Remove Annotation", (IFile)source.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        if (annotate.booleanValue()) {
            if (javaElement.getElementType() == 11 || javaElement.getElementType() == 7 || javaElement.getElementType() == 8 || javaElement.getElementType() == 9 || javaElement.getElementType() == 14) {
                change.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)javaElement, (org.eclipse.jdt.core.dom.Annotation)annotation));
                change.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)javaElement, (String)annotationClass.getCanonicalName()));
            }
        } else if (javaElement.getElementType() == 11 || javaElement.getElementType() == 7 || javaElement.getElementType() == 8 || javaElement.getElementType() == 9 || javaElement.getElementType() == 14) {
            change.addEdit(AnnotationUtils.createRemoveAnnotationTextEdit((IJavaElement)javaElement, (org.eclipse.jdt.core.dom.Annotation)annotation));
            change.addEdit(AnnotationUtils.createRemoveImportTextEdit((IJavaElement)javaElement, (String)annotationClass.getCanonicalName()));
        }
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)change);
    }

    private List<MemberValuePair> getMemberValuePairs(IAnnotationAttributeInitializer annotationAttributeInitializer, IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        if (annotationAttributeInitializer != null) {
            return annotationAttributeInitializer.getMemberValuePairs(javaElement, ast, annotationClass);
        }
        return Collections.emptyList();
    }

    private void setValueForMethod(Method method, Object value) throws CoreException {
        Object viewerInput;
        if (((Boolean)this.getValue(method.getDeclaringClass())).booleanValue() && (viewerInput = this.treeViewer.getInput()) instanceof IAnnotatable) {
            this.setValueForMethod(method, value, (IJavaElement)viewerInput);
        }
    }

    private void setValueForMethod(Method method, Object value, IJavaElement javaElement) throws CoreException {
        ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement((IJavaElement)javaElement);
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        AST ast = compilationUnit.getAST();
        TextFileChange change = new TextFileChange("Add/Update Annotation Value", (IFile)source.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)javaElement);
        for (org.eclipse.jdt.core.dom.Annotation annotation : annotations) {
            MemberValuePair memberValuePair;
            String annotationName;
            Class<?> declaringClass;
            if (annotation instanceof NormalAnnotation) {
                MemberValuePair memberValuePair22;
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
                declaringClass = method.getDeclaringClass();
                annotationName = normalAnnotation.getTypeName().getFullyQualifiedName();
                if (!annotationName.equals(declaringClass.getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName())) continue;
                List memberValuePairs = normalAnnotation.values();
                boolean hasMemberValuePair = false;
                for (MemberValuePair memberValuePair22 : memberValuePairs) {
                    ASTNode memberValue;
                    if (!memberValuePair22.getName().getIdentifier().equals(method.getName()) || (memberValue = this.getMemberValuePairValue(ast, method, value)) == null) continue;
                    change.addEdit(AnnotationUtils.createUpdateMemberValuePairTextEdit((MemberValuePair)memberValuePair22, (ASTNode)memberValue));
                    hasMemberValuePair = true;
                    break;
                }
                if (hasMemberValuePair || (memberValuePair22 = this.getMemberValuePair(ast, method, value)) == null) continue;
                change.addEdit(AnnotationUtils.createAddMemberValuePairTextEdit((NormalAnnotation)normalAnnotation, (MemberValuePair)memberValuePair22));
                break;
            }
            if (!(annotation instanceof SingleMemberAnnotation)) continue;
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            declaringClass = method.getDeclaringClass();
            annotationName = singleMemberAnnotation.getTypeName().getFullyQualifiedName();
            if (!annotationName.equals(declaringClass.getSimpleName()) && !annotationName.equals(declaringClass.getCanonicalName()) || (memberValuePair = this.getMemberValuePair(ast, method, value)) == null) continue;
            change.addEdit(AnnotationUtils.createUpdateSingleMemberAnnotationTextEdit((SingleMemberAnnotation)singleMemberAnnotation, (ASTNode)memberValuePair.getValue()));
            break;
        }
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)change);
    }

    private ASTNode getMemberValuePairValue(AST ast, Method method, Object value) {
        int selected;
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(String.class)) {
            return AnnotationsCore.createStringLiteral((AST)ast, (String)value.toString());
        }
        if (returnType.equals(Boolean.TYPE)) {
            return AnnotationsCore.createBooleanLiteral((AST)ast, (boolean)((Boolean)value));
        }
        if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
            return AnnotationsCore.createNumberLiteral((AST)ast, (String)value.toString());
        }
        if (returnType.isArray()) {
            if (method.getReturnType().getComponentType().isAnnotation()) {
                return this.createArrayValueLiteral(ast, method, (Object[])value);
            }
            return AnnotationsCore.createArrayValueLiteral((AST)ast, (Object[])((Object[])value));
        }
        if (returnType.equals(Class.class)) {
            return AnnotationsCore.createTypeLiteral((AST)ast, (String)value.toString());
        }
        if (returnType.isEnum() && (selected = ((Integer)value).intValue()) != -1) {
            return AnnotationsCore.createEnumLiteral((AST)ast, (String)method.getDeclaringClass().getCanonicalName(), method.getReturnType().getEnumConstants()[selected]);
        }
        return null;
    }

    private MemberValuePair getMemberValuePair(AST ast, Method method, Object value) {
        int selected;
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(String.class)) {
            return AnnotationsCore.createStringMemberValuePair((AST)ast, (String)method.getName(), (String)((String)value));
        }
        if (returnType.equals(Boolean.TYPE)) {
            return AnnotationsCore.createBooleanMemberValuePair((AST)ast, (String)method.getName(), (Boolean)((Boolean)value));
        }
        if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
            return AnnotationsCore.createNumberMemberValuePair((AST)ast, (String)method.getName(), (String)value.toString());
        }
        if (returnType.isArray()) {
            if (method.getReturnType().getComponentType().isAnnotation()) {
                return this.createArrayMemberValuePair(ast, method, (Object[])value);
            }
            return AnnotationsCore.createArrayMemberValuePair((AST)ast, (String)method.getName(), (Object[])((Object[])value));
        }
        if (returnType.equals(Class.class)) {
            return AnnotationsCore.createTypeMemberValuePair((AST)ast, (String)method.getName(), (Object)value.toString());
        }
        if (returnType.isEnum() && (selected = ((Integer)value).intValue()) != -1) {
            return AnnotationsCore.createEnumMemberValuePair((AST)ast, (String)method.getDeclaringClass().getCanonicalName(), (String)method.getName(), method.getReturnType().getEnumConstants()[selected]);
        }
        return null;
    }

    private void executeChange(IProgressMonitor monitor, Change change) {
        Change undoChange;
        IUndoManager manager;
        block8: {
            if (change == null) {
                return;
            }
            manager = RefactoringCore.getUndoManager();
            boolean successful = false;
            undoChange = null;
            try {
                try {
                    change.initializeValidationData(monitor);
                    RefactoringStatus valid = change.isValid(monitor);
                    if (valid.isOK()) {
                        manager.aboutToPerformChange(change);
                        undoChange = change.perform(monitor);
                        successful = true;
                    }
                }
                catch (CoreException ce) {
                    JAXWSUIPlugin.log(ce.getStatus());
                    manager.changePerformed(change, successful);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                manager.changePerformed(change, successful);
                throw throwable;
            }
            manager.changePerformed(change, successful);
        }
        if (undoChange != null) {
            undoChange.initializeValidationData(monitor);
            manager.addUndo(undoChange.getName(), undoChange);
        }
        this.annotationsView.refreshLabels();
    }

    private MemberValuePair createArrayMemberValuePair(AST ast, Method method, Object[] values) {
        return AnnotationsCore.createMemberValuePair((AST)ast, (String)method.getName(), (Expression)this.createArrayValueLiteral(ast, method, values));
    }

    private ArrayInitializer createArrayValueLiteral(AST ast, Method method, Object[] values) {
        ArrayInitializer arrayInitializer = ast.newArrayInitializer();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof List) {
                Class<?> annotationClass = method.getReturnType().getComponentType();
                ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
                List valuesList = (List)value;
                for (Map annotationMap : valuesList) {
                    Set entrySet = annotationMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String memberName = (String)entry.getKey();
                        try {
                            Method annotationMethod = annotationClass.getMethod(memberName, new Class[0]);
                            if (annotationMethod == null) continue;
                            Object memberValue = entry.getValue();
                            Class<?> returnType = annotationMethod.getReturnType();
                            if (returnType.equals(String.class)) {
                                memberValuePairs.add(AnnotationsCore.createStringMemberValuePair((AST)ast, (String)memberName, (String)memberValue.toString()));
                            }
                            if (returnType.equals(Boolean.TYPE)) {
                                memberValuePairs.add(AnnotationsCore.createBooleanMemberValuePair((AST)ast, (String)memberName, (Boolean)((Boolean)memberValue)));
                            }
                            if (!returnType.equals(Class.class)) continue;
                            String className = memberValue.toString();
                            if (className.endsWith(".class")) {
                                className = className.substring(0, className.lastIndexOf("."));
                            }
                            memberValuePairs.add(AnnotationsCore.createMemberValuePair((AST)ast, (String)memberName, (Expression)AnnotationsCore.createTypeLiteral((AST)ast, (String)className)));
                        }
                        catch (SecurityException se) {
                            AnnotationsCorePlugin.log((Throwable)se);
                        }
                        catch (NoSuchMethodException nsme) {
                            AnnotationsCorePlugin.log((Throwable)nsme);
                        }
                    }
                }
                arrayInitializer.expressions().add(AnnotationsCore.createNormalAnnotation((AST)ast, (String)annotationClass.getCanonicalName(), memberValuePairs));
            }
            ++n2;
        }
        return arrayInitializer;
    }
}

