/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsView;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsViewCategoryFilter
extends ViewerFilter {
    private static final String TAG_CATEGORY = "AnnotationCategoryFilterInfo";
    private static final String TAG_CATEGORY_NAME = "categoryName";
    private AnnotationsView annotationsView;
    private final StructuredViewer viewer;
    private List<Object> categories;

    public AnnotationsViewCategoryFilter(AnnotationsView annotationsView, StructuredViewer viewer) {
        this.annotationsView = annotationsView;
        this.viewer = viewer;
        this.categories = new ArrayList<Object>();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AnnotationDefinition annotationDefinition;
        if (element instanceof Class && ((Class)element).isAnnotation() && (annotationDefinition = AnnotationsManager.getAnnotationDefinitionForClass((Class)((Class)element))) != null) {
            return !this.categories.contains(annotationDefinition.getCategory());
        }
        return true;
    }

    public void filterAnnotations(List<Object> categories) {
        this.categories = categories;
        if (categories.size() > 0) {
            this.viewer.addFilter((ViewerFilter)this);
        } else {
            this.viewer.removeFilter((ViewerFilter)this);
        }
        this.annotationsView.refresh();
    }

    public List<Object> getCategories() {
        return this.categories;
    }

    public void init(IMemento memento) {
        IMemento catMemento = memento.getChild(TAG_CATEGORY);
        if (catMemento == null) {
            return;
        }
        int i = 0;
        while (i < AnnotationsManager.getAnnotationCategories().size()) {
            String category = catMemento.getString(TAG_CATEGORY_NAME + i);
            if (category != null) {
                this.categories.add(category);
            }
            ++i;
        }
        this.filterAnnotations(this.categories);
    }

    public void saveState(IMemento memento) {
        if (this.categories == null || this.categories.size() == 0) {
            return;
        }
        IMemento catMemento = memento.createChild(TAG_CATEGORY);
        int i = 0;
        for (Object category : this.categories) {
            catMemento.putString(TAG_CATEGORY_NAME + i, category.toString());
            ++i;
        }
    }
}

