/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.xml.core.internal.validation.XMLValidator;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsd.core.internal.validation.XSDValidationConfiguration;

public class XSDValidator {
    protected URIResolver uriresolver = null;

    public ValidationReport validate(String uri) {
        return this.validate(uri, null);
    }

    public ValidationReport validate(String uri, InputStream inputStream) {
        return this.validate(uri, null, null);
    }

    public ValidationReport validate(String uri, InputStream inputStream, XSDValidationConfiguration configuration) {
        if (configuration == null) {
            configuration = new XSDValidationConfiguration();
        }
        ValidationInfo valinfo = new ValidationInfo(uri);
        XSDErrorHandler errorHandler = new XSDErrorHandler(valinfo);
        try {
            XMLGrammarPreparser grammarPreparser = new XMLGrammarPreparser();
            grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
            grammarPreparser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", (Object)new XMLGrammarPoolImpl());
            grammarPreparser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespaces", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespace-prefixes", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/schema", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-general-entities", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-parameter-entities", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            if (configuration.getFeature(XSDValidationConfiguration.HONOUR_ALL_SCHEMA_LOCATIONS)) {
                try {
                    grammarPreparser.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
                }
                catch (Exception exception) {}
            }
            if (configuration.getFeature(XSDValidationConfiguration.FULL_SCHEMA_CONFORMANCE)) {
                try {
                    grammarPreparser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                }
                catch (Exception exception) {}
            }
            grammarPreparser.setErrorHandler((XMLErrorHandler)errorHandler);
            if (this.uriresolver != null) {
                XSDEntityResolver resolver = new XSDEntityResolver(this.uriresolver, uri);
                grammarPreparser.setEntityResolver((XMLEntityResolver)resolver);
            }
            try {
                XMLInputSource is = new XMLInputSource(null, uri, uri, inputStream, null);
                grammarPreparser.getLoader("http://www.w3.org/2001/XMLSchema");
                grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {}
        return valinfo;
    }

    public void setURIResolver(URIResolver uriresolver) {
        this.uriresolver = uriresolver;
    }

    protected class XSDEntityResolver
    implements XMLEntityResolver {
        private URIResolver uriresolver = null;

        public XSDEntityResolver(URIResolver uriresolver, String baselocation) {
            this.uriresolver = uriresolver;
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
            String literalSystemId = resourceIdentifier.getLiteralSystemId();
            if (literalSystemId != null) {
                resourceIdentifier.setLiteralSystemId(literalSystemId.replace('\\', '/'));
            }
            return XMLValidator._internalResolveEntity((URIResolver)this.uriresolver, (XMLResourceIdentifier)resourceIdentifier);
        }
    }

    protected class XSDErrorHandler
    implements XMLErrorHandler {
        private final ValidationInfo valinfo;

        public XSDErrorHandler(ValidationInfo valinfo) {
            this.valinfo = valinfo;
        }

        protected void addValidationMessage(String errorKey, XMLParseException exception, int severity) {
            String systemId = exception.getExpandedSystemId();
            if (systemId != null) {
                if (severity == 1) {
                    this.valinfo.addWarning(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), systemId);
                } else {
                    this.valinfo.addError(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), systemId, errorKey, null);
                }
            }
        }

        public void warning(String domain, String key, XMLParseException exception) throws XNIException {
            this.addValidationMessage(key, exception, 1);
        }

        public void error(String domain, String key, XMLParseException exception) throws XNIException {
            this.addValidationMessage(key, exception, 2);
        }

        public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
            this.addValidationMessage(key, exception, 3);
        }
    }
}

