/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ClassesGeneratorWizard
extends Wizard {
    private final IJavaProject javaProject;
    private final String xmlSchemaName;
    private String destinationFolder;
    private String targetPackage;
    private String catalog;
    private boolean useMoxy;
    private String[] bindingsFileNames;
    private ClassesGeneratorWizardPage generatorSettingsPage;

    public ClassesGeneratorWizard(IJavaProject javaProject, String xmlSchemaName) {
        this.javaProject = javaProject;
        this.xmlSchemaName = xmlSchemaName;
        this.setWindowTitle(JptJaxbUiMessages.ClassesGeneratorWizard_title);
        this.setDefaultPageImageDescriptor(JptJaxbUiPlugin.getImageDescriptor("full/wizban/newclass_wiz"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.generatorSettingsPage = this.buildClassesGeneratorPage();
        this.addPage((IWizardPage)this.generatorSettingsPage);
    }

    public boolean performFinish() {
        this.destinationFolder = this.generatorSettingsPage.getTargetFolder();
        this.targetPackage = this.generatorSettingsPage.getTargetPackage();
        this.catalog = this.generatorSettingsPage.getCatalog();
        this.useMoxy = this.generatorSettingsPage.usesMoxy();
        this.bindingsFileNames = this.generatorSettingsPage.getBindingsFileNames();
        IFolder folder = this.javaProject.getProject().getFolder(this.destinationFolder);
        this.createFolderIfNotExist(folder);
        return true;
    }

    public boolean canFinish() {
        return this.generatorSettingsPage.isPageComplete();
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public boolean getUseMoxy() {
        return this.useMoxy;
    }

    public String[] getBindingsFileNames() {
        return this.bindingsFileNames;
    }

    private ClassesGeneratorWizardPage buildClassesGeneratorPage() {
        return new ClassesGeneratorWizardPage(this.javaProject, this.xmlSchemaName);
    }

    private void createFolderIfNotExist(IFolder folder) {
        if (folder.exists()) {
            return;
        }
        try {
            folder.create(true, true, null);
        }
        catch (CoreException coreException) {
            this.logError(NLS.bind((String)JptJaxbUiMessages.ClassesGeneratorWizard_couldNotCreate, (Object)folder.getProjectRelativePath().toOSString()));
        }
    }

    protected void logError(String message) {
        this.displayError(message);
    }

    private void displayError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)JptJaxbUiMessages.ClassesGeneratorWizard_errorDialogTitle, (String)message);
    }
}

