/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.IMimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebAppDocument;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Connector;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Listener;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Service;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.ServerPort;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Tomcat70Configuration
extends TomcatConfiguration {
    protected static final String DEFAULT_SERVICE = "Catalina";
    protected static final String EOL = System.getProperty("line.separator");
    protected Server server;
    protected ServerInstance serverInstance;
    protected Factory serverFactory;
    protected boolean isServerDirty;
    protected WebAppDocument webAppDocument;
    protected Document contextDocument;
    protected Document tomcatUsersDocument;
    protected String policyFile;
    protected String propertiesFile;
    protected static final Map protocolHandlerMap = new HashMap();

    static {
        protocolHandlerMap.put("org.apache.coyote.http11.Http11Protocol", "HTTP/1.1");
        protocolHandlerMap.put("org.apache.coyote.http11.Http11NioProtocol", "HTTP/1.1");
        protocolHandlerMap.put("org.apache.coyote.http11.Http11AprProtocol", "HTTP/1.1");
        protocolHandlerMap.put("org.apache.coyote.ajp.AjpAprProtocol", "AJP/1.3");
        protocolHandlerMap.put("org.apache.jk.server.JkCoyoteHandler", "AJP/1.3");
    }

    public Tomcat70Configuration(IFolder path) {
        super(path);
    }

    public ServerPort getMainPort() {
        for (ServerPort port : this.getServerPorts()) {
            if (!port.getProtocol().toLowerCase().equals("http") || port.getId().indexOf(47) >= 0) continue;
            return port;
        }
        return null;
    }

    public List getMimeMappings() {
        return this.webAppDocument.getMimeMappings();
    }

    public List getServerPorts() {
        ArrayList<ServerPort> ports = new ArrayList<ServerPort>();
        try {
            int port = Integer.parseInt(this.server.getPort());
            ports.add(new ServerPort("server", Messages.portServer, port, "TCPIP"));
        }
        catch (Exception exception) {}
        try {
            String instanceServiceName = this.serverInstance.getService().getName();
            int size = this.server.getServiceCount();
            int i = 0;
            while (i < size) {
                Service service = this.server.getService(i);
                int size2 = service.getConnectorCount();
                int j = 0;
                while (j < size2) {
                    String secure;
                    Connector connector = service.getConnector(j);
                    String name = "HTTP/1.1";
                    String protocol2 = "HTTP";
                    boolean advanced = true;
                    String[] contentTypes = null;
                    int port = -1;
                    try {
                        port = Integer.parseInt(connector.getPort());
                    }
                    catch (Exception exception) {}
                    String protocol = connector.getProtocol();
                    if (protocol != null && protocol.length() > 0) {
                        if (protocol.startsWith("HTTP")) {
                            name = protocol;
                        } else if (protocol.startsWith("AJP")) {
                            name = protocol;
                            protocol2 = "AJP";
                        } else {
                            name = (String)protocolHandlerMap.get(protocol);
                            if (name != null) {
                                int index = name.indexOf(47);
                                protocol2 = index > 0 ? name.substring(0, index) : name;
                            } else {
                                name = protocol;
                                protocol2 = protocol;
                            }
                        }
                    }
                    if (protocol2.toLowerCase().equals("http")) {
                        contentTypes = new String[]{"web", "webservices"};
                    }
                    if ((secure = connector.getSecure()) != null && secure.length() > 0) {
                        name = "SSL";
                        protocol2 = "SSL";
                    } else {
                        advanced = false;
                    }
                    String portId = instanceServiceName != null && instanceServiceName.equals(service.getName()) ? Integer.toString(j) : String.valueOf(i) + "/" + j;
                    ports.add(new ServerPort(portId, name, port, protocol2, contentTypes, advanced));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting server ports", e);
        }
        return ports;
    }

    public List getWebModules() {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        try {
            Context[] contexts = this.serverInstance.getContexts();
            if (contexts != null) {
                int i = 0;
                while (i < contexts.length) {
                    Context context = contexts[i];
                    String reload = context.getReloadable();
                    if (reload == null) {
                        reload = "false";
                    }
                    WebModule module = new WebModule(context.getPath(), context.getDocBase(), context.getSource(), reload.equalsIgnoreCase("true"));
                    list.add(module);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting project refs", e);
        }
        return list;
    }

    public IPath getServerWorkDirectory(IPath basePath) {
        return this.serverInstance.getHostWorkDirectory(basePath);
    }

    public IPath getContextWorkDirectory(IPath basePath, ITomcatWebModule module) {
        Context context = this.serverInstance.getContext(module.getPath());
        if (context != null) {
            return this.serverInstance.getContextWorkDirectory(basePath, context);
        }
        return null;
    }

    public void load(IPath path, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 7);
            FileInputStream in = new FileInputStream(path.append("catalina.policy").toFile());
            ((InputStream)in).read();
            ((InputStream)in).close();
            monitor.worked(1);
            this.serverFactory = new Factory();
            this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
            this.server = (Server)this.serverFactory.loadDocument(new FileInputStream(path.append("server.xml").toFile()));
            this.serverInstance = new ServerInstance(this.server, null, null);
            monitor.worked(1);
            this.webAppDocument = new WebAppDocument(path.append("web.xml"));
            monitor.worked(1);
            File file = path.append("context.xml").toFile();
            if (file.exists()) {
                this.contextDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(new FileInputStream(file)));
            }
            monitor.worked(1);
            this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(new FileInputStream(path.append("tomcat-users.xml").toFile())));
            monitor.worked(1);
            this.policyFile = TomcatVersionHelper.getFileContents(new FileInputStream(path.append("catalina.policy").toFile()));
            monitor.worked(1);
            file = path.append("catalina.properties").toFile();
            this.propertiesFile = file.exists() ? TomcatVersionHelper.getFileContents(new FileInputStream(file)) : null;
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not load Tomcat v5.5 configuration from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    public void importFromPath(IPath path, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, monitor);
        if (isTestEnv) {
            while (this.serverInstance.removeContext(0)) {
            }
        }
    }

    public void load(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 1200);
            IFile file = folder.getFile("catalina.policy");
            if (!file.exists()) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), null));
            }
            file = folder.getFile("server.xml");
            InputStream in = file.getContents();
            this.serverFactory = new Factory();
            this.serverFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
            this.server = (Server)this.serverFactory.loadDocument(in);
            this.serverInstance = new ServerInstance(this.server, null, null);
            monitor.worked(200);
            file = folder.getFile("web.xml");
            this.webAppDocument = new WebAppDocument(file);
            monitor.worked(200);
            file = folder.getFile("context.xml");
            if (file.exists()) {
                in = file.getContents();
                this.contextDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            } else {
                this.contextDocument = null;
            }
            monitor.worked(200);
            file = folder.getFile("tomcat-users.xml");
            in = file.getContents();
            this.tomcatUsersDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(in));
            monitor.worked(200);
            file = folder.getFile("catalina.policy");
            in = file.getContents();
            this.policyFile = TomcatVersionHelper.getFileContents(in);
            monitor.worked(200);
            file = folder.getFile("catalina.properties");
            if (file.exists()) {
                in = file.getContents();
                this.propertiesFile = TomcatVersionHelper.getFileContents(in);
            } else {
                this.propertiesFile = null;
            }
            monitor.worked(200);
            if (monitor.isCanceled()) {
                throw new Exception("Cancelled");
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not reload Tomcat v5.5 configuration from: " + folder.getFullPath() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), (Throwable)e));
        }
    }

    protected void save(IPath path, boolean forceDirty, IProgressMonitor monitor) throws CoreException {
        try {
            BufferedWriter bw;
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 5);
            if (!path.toFile().exists()) {
                forceDirty = true;
                path.toFile().mkdir();
            }
            monitor.worked(1);
            if (forceDirty || this.isServerDirty) {
                this.serverFactory.save(path.append("server.xml").toOSString());
                this.isServerDirty = false;
            }
            monitor.worked(1);
            this.webAppDocument.save(path.append("web.xml").toOSString(), forceDirty);
            monitor.worked(1);
            if (forceDirty && this.contextDocument != null) {
                XMLUtil.save(path.append("context.xml").toOSString(), this.contextDocument);
            }
            monitor.worked(1);
            if (forceDirty) {
                XMLUtil.save(path.append("tomcat-users.xml").toOSString(), this.tomcatUsersDocument);
            }
            monitor.worked(1);
            if (forceDirty) {
                bw = new BufferedWriter(new FileWriter(path.append("catalina.policy").toFile()));
                bw.write(this.policyFile);
                bw.close();
            }
            monitor.worked(1);
            if (this.propertiesFile != null && forceDirty) {
                bw = new BufferedWriter(new FileWriter(path.append("catalina.properties").toFile()));
                bw.write(this.propertiesFile);
                bw.close();
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not save Tomcat v5.5 configuration to " + path, e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    public void save(IPath path, IProgressMonitor monitor) throws CoreException {
        this.save(path, true, monitor);
    }

    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.savingTask, 1200);
            byte[] data = this.serverFactory.getContents();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            IFile file = folder.getFile("server.xml");
            if (file.exists()) {
                if (this.isServerDirty) {
                    file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                } else {
                    monitor.worked(200);
                }
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            this.isServerDirty = false;
            this.webAppDocument.save(folder.getFile("web.xml"), ProgressUtil.getSubMonitorFor(monitor, 200));
            if (this.contextDocument != null) {
                data = XMLUtil.getContents(this.contextDocument);
                in = new ByteArrayInputStream(data);
                file = folder.getFile("context.xml");
                if (file.exists()) {
                    monitor.worked(200);
                } else {
                    file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                }
            }
            data = XMLUtil.getContents(this.tomcatUsersDocument);
            in = new ByteArrayInputStream(data);
            file = folder.getFile("tomcat-users.xml");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            in = new ByteArrayInputStream(this.policyFile.getBytes());
            file = folder.getFile("catalina.policy");
            if (file.exists()) {
                monitor.worked(200);
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
            }
            if (this.propertiesFile != null) {
                in = new ByteArrayInputStream(this.propertiesFile.getBytes());
                file = folder.getFile("catalina.properties");
                if (file.exists()) {
                    monitor.worked(200);
                } else {
                    file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                }
            } else {
                monitor.worked(200);
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not save Tomcat v5.5 configuration to " + folder.toString(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    protected static boolean hasMDBListener(Server server) {
        if (server == null) {
            return false;
        }
        int count = server.getListenerCount();
        if (count == 0) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Listener listener = server.getListener(i);
            if (listener != null && listener.getClassName() != null && listener.getClassName().indexOf("mbean") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.addMimeMapping(index, map);
        this.firePropertyChangeEvent("addMapping", new Integer(index), map);
    }

    public void addWebModule(int index, ITomcatWebModule module) {
        try {
            Context context = this.serverInstance.createContext(index);
            if (context != null) {
                context.setDocBase(module.getDocumentBase());
                context.setPath(module.getPath());
                context.setReloadable(module.isReloadable() ? "true" : "false");
                if (module.getMemento() != null && module.getMemento().length() > 0) {
                    context.setSource(module.getMemento());
                }
                this.isServerDirty = true;
                this.firePropertyChangeEvent("addWebModule", null, module);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error adding web module " + module.getPath(), e);
        }
    }

    public void modifyMimeMapping(int index, IMimeMapping map) {
        this.webAppDocument.modifyMimeMapping(index, map);
        this.firePropertyChangeEvent("modifyMapping", new Integer(index), map);
    }

    public void modifyServerPort(String id, int port) {
        try {
            if ("server".equals(id)) {
                this.server.setPort(String.valueOf(port));
                this.isServerDirty = true;
                this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
                return;
            }
            int i = id.indexOf("/");
            if (i < 0) {
                int connNum = Integer.parseInt(id);
                Connector connector = this.serverInstance.getConnector(connNum);
                if (connector != null) {
                    connector.setPort(String.valueOf(port));
                    this.isServerDirty = true;
                    this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
                }
            } else {
                int servNum = Integer.parseInt(id.substring(0, i));
                int connNum = Integer.parseInt(id.substring(i + 1));
                Service service = this.server.getService(servNum);
                Connector connector = service.getConnector(connNum);
                connector.setPort(String.valueOf(port));
                this.isServerDirty = true;
                this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error modifying server port " + id, e);
        }
    }

    public void modifyWebModule(int index, String docBase, String path, boolean reloadable) {
        try {
            Context context = this.serverInstance.getContext(index);
            if (context != null) {
                context.setPath(path);
                context.setDocBase(docBase);
                context.setReloadable(reloadable ? "true" : "false");
                this.isServerDirty = true;
                WebModule module = new WebModule(path, docBase, null, reloadable);
                this.firePropertyChangeEvent("modifyWebModule", new Integer(index), module);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error modifying web module " + index, e);
        }
    }

    public void removeMimeMapping(int index) {
        this.webAppDocument.removeMimeMapping(index);
        this.firePropertyChangeEvent("removeMapping", null, new Integer(index));
    }

    public void removeWebModule(int index) {
        try {
            this.serverInstance.removeContext(index);
            this.isServerDirty = true;
            this.firePropertyChangeEvent("removeWebModule", null, new Integer(index));
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error removing module ref " + index, e);
        }
    }

    protected IStatus publishContextConfig(IPath baseDir, IPath deployDir, IProgressMonitor monitor) {
        return TomcatVersionHelper.publishCatalinaContextConfig(baseDir, deployDir, monitor);
    }

    protected IStatus updateContextsToServeDirectly(IPath baseDir, String tomcatVersion, String loader, IProgressMonitor monitor) {
        return TomcatVersionHelper.updateContextsToServeDirectly(baseDir, tomcatVersion, loader, true, monitor);
    }

    protected IStatus cleanupServer(IPath baseDir, IPath installDir, boolean removeKeptContextFiles, IProgressMonitor monitor) {
        List modules = this.getWebModules();
        return TomcatVersionHelper.cleanupCatalinaServer(baseDir, installDir, removeKeptContextFiles, modules, monitor);
    }

    public IStatus localizeConfiguration(IPath baseDir, IPath deployDir, TomcatServer tomcatServer, IProgressMonitor monitor) {
        return TomcatVersionHelper.localizeConfiguration(baseDir, deployDir, tomcatServer, monitor);
    }
}

