/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonNullBooleanTransformer
implements Transformer<Boolean, Boolean> {
    private final Boolean nullValue;
    public static final Transformer<Boolean, Boolean> TRUE = new NonNullBooleanTransformer(Boolean.TRUE);
    public static final Transformer<Boolean, Boolean> FALSE = new NonNullBooleanTransformer(Boolean.FALSE);

    public Transformer<Boolean, Boolean> valueOf(Boolean b) {
        return this.valueOf((boolean)b);
    }

    public Transformer<Boolean, Boolean> valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    private NonNullBooleanTransformer(Boolean nullValue) {
        if (nullValue == null) {
            throw new NullPointerException();
        }
        this.nullValue = nullValue;
    }

    @Override
    public Boolean transform(Boolean b) {
        return b != null ? b : this.nullValue;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.nullValue);
    }
}

