/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticListValueModel<E>
extends AbstractModel
implements ListValueModel<E> {
    protected final Object[] elements;
    private static final long serialVersionUID = 1L;

    public StaticListValueModel(E ... elements) {
        this.elements = (Object[])elements.clone();
    }

    public StaticListValueModel(Iterable<? extends E> elements) {
        this.elements = ArrayTools.array(elements);
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<Object>(this.elements);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ArrayListIterator<Object>(this.elements);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public E get(int index) {
        return (E)this.elements[index];
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.elements.clone();
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(Arrays.toString(this.elements));
    }
}

