/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCollectionAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] collectionNames;
    protected final CollectionChangeListener valueCollectionListener;

    public ValueCollectionAdapter(WritablePropertyValueModel<V> valueHolder, String ... collectionNames) {
        super(valueHolder);
        this.collectionNames = collectionNames;
        this.valueCollectionListener = this.buildValueCollectionListener();
    }

    protected CollectionChangeListener buildValueCollectionListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                ValueCollectionAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                ValueCollectionAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                ValueCollectionAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                ValueCollectionAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "value collection listener: " + Arrays.asList(ValueCollectionAdapter.this.collectionNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.value).addCollectionChangeListener(collectionName, this.valueCollectionListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.value).removeCollectionChangeListener(collectionName, this.valueCollectionListener);
            ++n2;
        }
    }

    protected void itemsAdded(CollectionAddEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.valueAspectChanged();
    }

    protected void collectionCleared(CollectionClearEvent event) {
        this.valueAspectChanged();
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.valueAspectChanged();
    }
}

