/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.model.event;

import java.util.Collection;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionRemoveEvent
extends CollectionEvent {
    private final Object[] items;
    private static final long serialVersionUID = 1L;

    public CollectionRemoveEvent(Model source, String collectionName, Object item) {
        this(source, collectionName, new Object[]{item});
    }

    public CollectionRemoveEvent(Model source, String collectionName, Collection<?> items) {
        this(source, collectionName, items.toArray());
    }

    private CollectionRemoveEvent(Model source, String collectionName, Object[] items) {
        super(source, collectionName);
        this.items = items;
    }

    public Iterable<?> getItems() {
        return new ArrayIterable<Object>(this.items);
    }

    public int getItemsSize() {
        return this.items.length;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        StringTools.append(sb, this.items);
    }

    public CollectionRemoveEvent clone(Model newSource) {
        return this.clone(newSource, this.collectionName);
    }

    public CollectionRemoveEvent clone(Model newSource, String newCollectionName) {
        return new CollectionRemoveEvent(newSource, newCollectionName, this.items);
    }
}

