/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.ITrinidadConstants;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.Messages;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.model.SelectItem;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectItemModel {
    private static final List<SelectItem> SAMPLE_MODEL = new ArrayList<SelectItem>();

    static {
        SAMPLE_MODEL.add(new SelectItem(Messages.SelectItemModel_SampleItem1Label, Messages.SelectItemModel_SampleItem1Value));
        SAMPLE_MODEL.add(new SelectItem(Messages.SelectItemModel_SampleItem2Label, Messages.SelectItemModel_SampleItem2Value));
        SAMPLE_MODEL.add(new SelectItem(Messages.SelectItemModel_SampleItem3Label, Messages.SelectItemModel_SampleItem3Value));
    }

    public static final List<SelectItem> getModel(Element parentElement) {
        return SelectItemModel.getModel(parentElement, true);
    }

    public static final List<SelectItem> getModel(Element parentElement, boolean fallbackOnSampleModel) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        if (parentElement != null) {
            NodeList childNodes = parentElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (childNodes.item(i) instanceof Element) {
                    Element childElement = (Element)childNodes.item(i);
                    TagIdentifier tagID = TagIdentifierFactory.createDocumentTagWrapper((Element)childElement);
                    if (tagID.isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_SELECTITEM)) {
                        String label = childElement.getAttribute("label");
                        if (label == null || label.length() < 1) {
                            label = childElement.getAttribute("value");
                        }
                        selectItems.add(new SelectItem(label, childElement.getAttribute("value")));
                    } else if (tagID.isSameTagType(IJSFConstants.TAG_IDENTIFIER_SELECTITEM)) {
                        String label;
                        String value = childElement.getAttribute("value");
                        if (value == null || value.length() < 1) {
                            value = childElement.getAttribute("itemValue");
                        }
                        if ((label = childElement.getAttribute("itemLabel")) == null || label.length() < 1) {
                            label = value;
                        }
                        selectItems.add(new SelectItem(label, value));
                    }
                }
                ++i;
            }
        }
        if (selectItems.size() > 0 || !fallbackOnSampleModel) {
            return selectItems;
        }
        return SelectItemModel.getSampleModel();
    }

    public static final List<SelectItem> getSampleModel() {
        return SAMPLE_MODEL;
    }
}

