/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.libval;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public class JaxbLibValUtil {
    static IProjectFacetVersion getJavaVersion(JaxbLibraryProviderInstallOperationConfig config) {
        return config.getFacetedProject().getProjectFacetVersion(JavaFacet.FACET);
    }

    static IProjectFacetVersion findJavaJaxbVersion(JaxbLibraryProviderInstallOperationConfig config) {
        IProjectFacetVersion javaVersion = JaxbLibValUtil.getJavaVersion(config);
        if (javaVersion == JavaFacet.VERSION_1_6) {
            return JaxbFacet.VERSION_2_1;
        }
        if (javaVersion == JavaFacet.VERSION_1_7) {
            return JaxbFacet.VERSION_2_2;
        }
        return null;
    }

    static IProjectFacetVersion findJreJaxbVersion(JaxbLibraryProviderInstallOperationConfig config) {
        IRuntime runtime = config.getFacetedProject().getPrimaryRuntime();
        if (runtime != null) {
            for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                IVMInstall vm = JaxbLibValUtil.findVMInstall(rc);
                if (vm == null) continue;
                return JaxbLibValUtil.findJreJaxbVersion(vm);
            }
        }
        IVMInstall vm = JavaRuntime.getDefaultVMInstall();
        IJavaProject javaProject = JavaCore.create((IProject)config.getFacetedProject().getProject());
        if (javaProject != null) {
            try {
                vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            }
            catch (CoreException coreException) {}
        }
        if (vm != null) {
            return JaxbLibValUtil.findJreJaxbVersion(vm);
        }
        return null;
    }

    private static IVMInstall findVMInstall(IRuntimeComponent rc) {
        String vmInstallTypeId = rc.getProperty("vm-install-type");
        String vmInstallId = rc.getProperty("vm-install-id");
        if (vmInstallTypeId == null || vmInstallId == null) {
            return null;
        }
        IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)vmInstallTypeId);
        if (vmInstallType == null) {
            return null;
        }
        return vmInstallType.findVMInstall(vmInstallId);
    }

    /*
     * Loose catch block
     */
    private static IProjectFacetVersion findJreJaxbVersion(IVMInstall vm) {
        String javaVersion;
        if (vm instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vm).getJavaVersion()) != null) {
            if (javaVersion.startsWith("1.7")) {
                return JaxbFacet.VERSION_2_2;
            }
            if (!javaVersion.startsWith("1.6")) {
                return null;
            }
        }
        TransformationIterable<LibraryLocation, IPath> vmLibPaths = new TransformationIterable<LibraryLocation, IPath>((Iterable)new ArrayIterable((Object[])JavaRuntime.getLibraryLocations((IVMInstall)vm))){

            protected IPath transform(LibraryLocation o) {
                return o.getSystemLibraryPath();
            }
        };
        boolean foundXmlSeeAlso = false;
        boolean foundJAXBPermission = false;
        for (IPath vmLibPath : vmLibPaths) {
            ZipFile zip;
            block18: {
                IProjectFacetVersion iProjectFacetVersion;
                block19: {
                    File file = vmLibPath.toFile();
                    if (!file.exists()) continue;
                    zip = null;
                    zip = new ZipFile(file);
                    foundXmlSeeAlso |= zip.getEntry("javax/xml/bind/annotation/XmlSeeAlso.class") != null;
                    if (!(foundJAXBPermission |= zip.getEntry("javax/xml/bind/JAXBPermission.class") != null)) break block18;
                    iProjectFacetVersion = JaxbFacet.VERSION_2_2;
                    if (zip == null) break block19;
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                return iProjectFacetVersion;
                catch (IOException iOException) {
                    try {
                        if (zip == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        throw throwable;
                    }
                    try {
                        zip.close();
                    }
                    catch (IOException iOException3) {}
                    continue;
                }
            }
            if (zip == null) continue;
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
        if (foundXmlSeeAlso) {
            return JaxbFacet.VERSION_2_1;
        }
        return null;
    }
}

