/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkNamedConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaEclipseLinkConverter<A extends EclipseLinkNamedConverterAnnotation>
extends AbstractJavaJpaContextNode
implements EclipseLinkConverter {
    protected final A converterAnnotation;
    protected String name;

    protected JavaEclipseLinkConverter(JavaJpaContextNode parent, A converterAnnotation) {
        super((JpaContextNode)parent);
        this.converterAnnotation = converterAnnotation;
        this.name = converterAnnotation.getName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.converterAnnotation.getName());
    }

    public void update() {
        super.update();
        this.getPersistenceUnit().addConverter(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.converterAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public A getConverterAnnotation() {
        return this.converterAnnotation;
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    @Override
    public char getEnclosingTypeSeparator() {
        return '.';
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public boolean overrides(EclipseLinkConverter converter) {
        return false;
    }

    @Override
    public boolean duplicates(EclipseLinkConverter converter) {
        return this != converter && !StringTools.stringIsEmpty((String)this.name) && this.name.equals(converter.getName()) && !this.overrides(converter) && !converter.overrides(this);
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.converterAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getConverterAnnotation().getNameTextRange(astRoot), astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConverterNames(messages, astRoot);
    }

    protected void validateConverterNames(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange(astRoot)));
        } else {
            ArrayList<String> reportedNames = new ArrayList<String>();
            ListIterator<EclipseLinkConverter> globalConverters = this.getPersistenceUnit().allConverters();
            while (globalConverters.hasNext()) {
                if (!this.duplicates(globalConverters.next()) || reportedNames.contains(this.name)) continue;
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_DUPLICATE_NAME", new String[]{this.name}, this, this.getNameTextRange(astRoot)));
                reportedNames.add(this.name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractAdapter
    implements Adapter {
        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(JavaResourcePersistentMember member, JavaJpaContextNode parent) {
            EclipseLinkNamedConverterAnnotation annotation = this.getConverterAnnotation(member);
            return annotation == null ? null : this.buildConverter(annotation, parent);
        }

        @Override
        public EclipseLinkNamedConverterAnnotation getConverterAnnotation(JavaResourcePersistentMember member) {
            return (EclipseLinkNamedConverterAnnotation)member.getAnnotation(this.getAnnotationName());
        }

        protected abstract String getAnnotationName();

        @Override
        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildNewConverter(JavaResourcePersistentMember member, JavaJpaContextNode parent) {
            return this.buildConverter(this.buildConverterAnnotationIfNecessary(member), parent);
        }

        protected EclipseLinkNamedConverterAnnotation buildConverterAnnotationIfNecessary(JavaResourcePersistentMember member) {
            EclipseLinkNamedConverterAnnotation annotation = this.getConverterAnnotation(member);
            return annotation != null ? annotation : this.buildConverterAnnotation(member);
        }

        protected EclipseLinkNamedConverterAnnotation buildConverterAnnotation(JavaResourcePersistentMember member) {
            return (EclipseLinkNamedConverterAnnotation)member.addAnnotation(this.getAnnotationName());
        }

        @Override
        public void removeConverterAnnotation(JavaResourcePersistentMember member) {
            member.removeAnnotation(this.getAnnotationName());
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)ClassName.getSimpleName((String)this.getAnnotationName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Adapter {
        public Class<? extends EclipseLinkConverter> getConverterType();

        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(JavaResourcePersistentMember var1, JavaJpaContextNode var2);

        public EclipseLinkNamedConverterAnnotation getConverterAnnotation(JavaResourcePersistentMember var1);

        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildConverter(EclipseLinkNamedConverterAnnotation var1, JavaJpaContextNode var2);

        public JavaEclipseLinkConverter<? extends EclipseLinkNamedConverterAnnotation> buildNewConverter(JavaResourcePersistentMember var1, JavaJpaContextNode var2);

        public void removeConverterAnnotation(JavaResourcePersistentMember var1);
    }
}

