/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.entity;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.wizards.SelectJpaOrmMappingFileDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class EntityClassWizardPage
extends NewJavaClassWizardPage {
    private static final String EMPTY = "";
    private static final String SINGLE_TABLE = "SINGLE_TABLE";
    private static final String TABLE_PER_CLASS = "TABLE_PER_CLASS";
    private static final String JOINED = "JOINED";
    private static final String[] INHERITANCE_STRATEGIES = new String[]{"", "SINGLE_TABLE", "TABLE_PER_CLASS", "JOINED"};
    private Combo inheritanceStrategyCombo;
    private Button entityButton;
    private Button mapedAsSuperclassButton;
    private Button inheritanceButton;
    private Label displayNameLabel;
    private Button xmlSupportButton;
    private boolean isFirstCheck = true;
    private Text ormXmlName;
    private Button browseButton;

    public EntityClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle) {
        super(model, pageName, pageDesc, pageTitle, null);
    }

    protected String[] getValidationPropertyNames() {
        return (String[])ArrayTools.addAll((Object[])super.getValidationPropertyNames(), (Object[])new String[]{"IEntityDataModelProperties.XML_NAME", "IEntityDataModelProperties.XML_SUPPORT"});
    }

    private IProject getProject() {
        return (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.jpa.ui.dialog_entityClassPage");
        this.createInheritanceControl(composite);
        this.inheritanceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = EntityClassWizardPage.this.inheritanceButton.getSelection();
                if (isChecked) {
                    EntityClassWizardPage.this.entityButton.setSelection(true);
                    EntityClassWizardPage.this.mapedAsSuperclassButton.setSelection(false);
                }
                EntityClassWizardPage.this.inheritanceStrategyCombo.setEnabled(isChecked);
                EntityClassWizardPage.this.model.setBooleanProperty("IEntityDataModelProperties.ENTITY", true);
                EntityClassWizardPage.this.model.setBooleanProperty("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS", false);
                EntityClassWizardPage.this.entityButton.setEnabled(!isChecked);
                EntityClassWizardPage.this.mapedAsSuperclassButton.setEnabled(!isChecked);
            }
        });
        this.createXMLstorageControl(composite);
        this.xmlSupportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = EntityClassWizardPage.this.xmlSupportButton.getSelection();
                EntityClassWizardPage.this.enableMappingXMLChooseGroup(isChecked);
                if (EntityClassWizardPage.this.isFirstCheck) {
                    EntityClassWizardPage.this.ormXmlName.setText(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
                    EntityClassWizardPage.this.isFirstCheck = false;
                }
            }
        });
        return composite;
    }

    protected JpaProject getTargetJpaProject() {
        IProject project = this.getProject();
        return project != null ? JptJpaCorePlugin.getJpaProject((IProject)project) : null;
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection[0] != null) {
                    if (selection[0] instanceof IProject) {
                        IProject project = (IProject)selection[0];
                        IJavaProject javaProject = JavaCore.create((IProject)project);
                        for (IPackageFragmentRoot root : JDTTools.getJavaSourceFolders((IJavaProject)javaProject)) {
                            if (!project.equals((Object)root.getResource())) continue;
                            return WTPCommonPlugin.OK_STATUS;
                        }
                    } else {
                        return WTPCommonPlugin.OK_STATUS;
                    }
                }
                return WTPCommonPlugin.createErrorStatus((String)J2EEUIMessages.CONTAINER_SELECTION_DIALOG_VALIDATOR_MESG);
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                String projectName = (String)EntityClassWizardPage.this.model.getProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(projectName);
                }
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    IProject project = ProjectUtilities.getProject((String)projectName);
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    for (IPackageFragmentRoot root : JDTTools.getJavaSourceFolders((IJavaProject)javaProject)) {
                        if (!folder.equals((Object)root.getResource())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private void createInheritanceControl(Composite parent) {
        Group group = this.createGroup(parent, EntityWizardMsg.INHERITANCE_GROUP);
        this.entityButton = this.createRadioButton((Composite)group, EntityWizardMsg.ENTITY, "IEntityDataModelProperties.ENTITY");
        this.mapedAsSuperclassButton = this.createRadioButton((Composite)group, EntityWizardMsg.MAPPED_AS_SUPERCLASS, "IEntityDataModelProperties.MAPPED_AS_SUPERCLASS");
        this.inheritanceButton = this.createCheckButton((Composite)group, 256, 1, EntityWizardMsg.INHERITANCE_CHECK_BOX, "IEntityDataModelProperties.INHERITANCE");
        this.createComboBox((Composite)group, "IEntityDataModelProperties.INHERITANCE_STRATEGY");
    }

    private void createXMLstorageControl(Composite parent) {
        Group group = this.createGroup(parent, EntityWizardMsg.XML_STORAGE_GROUP);
        this.xmlSupportButton = this.createCheckButton((Composite)group, 768, 3, EntityWizardMsg.XML_SUPPORT, "IEntityDataModelProperties.XML_SUPPORT");
        this.createBrowseGroup((Composite)group, EntityWizardMsg.CHOOSE_XML, "IEntityDataModelProperties.XML_NAME");
        this.ormXmlName.setEnabled(false);
        this.browseButton.setEnabled(false);
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(text);
        return group;
    }

    private Button createRadioButton(Composite parent, String text, String property) {
        Button button = new Button(parent, 16);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        this.synchHelper.synchRadio(button, property, null);
        return button;
    }

    private Button createCheckButton(Composite parent, int fillStrategy, int horizontalSpan, String text, String property) {
        Button button = new Button(parent, 32);
        GridData groupGridData = new GridData(fillStrategy);
        groupGridData.horizontalSpan = horizontalSpan;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        this.synchHelper.synchCheckbox(button, property, null);
        return button;
    }

    private Combo createComboBox(Composite parent, String property) {
        this.inheritanceStrategyCombo = new Combo(parent, 2056);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 2;
        this.inheritanceStrategyCombo.setLayoutData((Object)groupGridData);
        this.inheritanceStrategyCombo.setItems(INHERITANCE_STRATEGIES);
        this.synchHelper.synchCombo(this.inheritanceStrategyCombo, property, null);
        this.inheritanceStrategyCombo.setEnabled(false);
        return this.inheritanceStrategyCombo;
    }

    private void createBrowseGroup(Composite parent, String label, String property) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.displayNameLabel = new Label(composite, 16384);
        this.displayNameLabel.setText(label);
        this.displayNameLabel.setLayoutData((Object)new GridData(32));
        this.ormXmlName = new Text(composite, 2052);
        this.ormXmlName.setLayoutData((Object)new GridData(768));
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(EntityWizardMsg.BROWSE_BUTTON_LABEL);
        GridData browseButtonData = new GridData(256);
        browseButtonData.horizontalSpan = 1;
        this.browseButton.setLayoutData((Object)browseButtonData);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntityClassWizardPage.this.handleChooseXmlButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.synchHelper.synchText(this.ormXmlName, property, null);
        this.enableMappingXMLChooseGroup(false);
    }

    protected String getMappingFileName() {
        String mappingFileLocation = this.model.getStringProperty("IEntityDataModelProperties.XML_NAME");
        return new File(mappingFileLocation).getName();
    }

    private void handleChooseXmlButtonPressed() {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        JpaProject jpaProject = JptJpaCorePlugin.getJpaProject((IProject)project);
        ViewerFilter filter = this.getDialogViewerFilter(jpaProject);
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        SelectJpaOrmMappingFileDialog dialog = new SelectJpaOrmMappingFileDialog(this.getShell(), project, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(EntityWizardMsg.MAPPING_XML_TITLE);
        dialog.setMessage(EntityWizardMsg.CHOOSE_MAPPING_XML_MESSAGE);
        dialog.addFilter(filter);
        String ormFileName = this.ormXmlName.getText();
        JpaXmlResource resource = jpaProject.getMappingFileXmlResource((IPath)new Path(ormFileName));
        IFile initialSelection = resource != null ? resource.getFile() : null;
        dialog.setInput(project);
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        if (dialog.open() == 0) {
            boolean noNameChange = false;
            if (StringTools.stringsAreEqual((String)this.model.getStringProperty("IEntityDataModelProperties.XML_NAME"), (String)dialog.getChosenName())) {
                noNameChange = true;
            }
            this.model.setProperty("IEntityDataModelProperties.XML_NAME", (Object)dialog.getChosenName());
            if (noNameChange) {
                this.validatePage();
            }
        }
    }

    protected ViewerFilter getDialogViewerFilter(JpaProject jpaProject) {
        return new XmlMappingFileViewerFilter(jpaProject);
    }

    private void enableMappingXMLChooseGroup(boolean enabled) {
        this.displayNameLabel.setEnabled(enabled);
        this.ormXmlName.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    protected boolean isProjectValid(IProject project) {
        return project.isAccessible() && JpaFacet.isInstalled((IProject)project);
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }
}

