/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class TableGenPanel {
    WizardPage wizardPage;
    private Text classNameField;
    private Combo idGeneratorCombo;
    private Text sequenceNameField;
    private Button entityAccessField;
    private Button entityAccessProperty;
    private Button associationFetchDefault;
    private Button associationFetchEager;
    private Button associationFetchLazy;
    private Button collectionTypeSet;
    private Button collectionTypeList;
    private Button generateOptionalAnnotations;
    private Label sequenceNameNoteLabel;
    private boolean isUpdatingControls;
    private ORMGenTable mTable;
    private boolean isDefaultTable = false;

    public TableGenPanel(Composite parent, int columns, boolean isDefaultTable, WizardPage wizardPage) {
        this.wizardPage = wizardPage;
        this.isDefaultTable = isDefaultTable;
        this.createTableMappingPropertiesGroup(parent, columns);
        SWTUtil.createLabel(parent, 4, "");
    }

    protected void createTableMappingPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_tableMapping);
        parent.setLayout((Layout)new GridLayout(columns, false));
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        parent.setLayoutData((Object)layoutData);
        this.createClassNameControl((Composite)parent, columns);
        this.createIdGeneratorControls((Composite)parent, columns);
        this.createEntityAccessControls((Composite)parent, columns);
        if (this.isDefaultTable) {
            this.createAssociationFetchControls((Composite)parent, columns);
            this.createCollectionTypeControls((Composite)parent, columns);
            this.createGenerateOptionalAnnotationControls(parent, columns);
        }
    }

    private void createGenerateOptionalAnnotationControls(Group parent, int columns) {
        this.generateOptionalAnnotations = new Button((Composite)parent, 32);
        this.generateOptionalAnnotations.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_genOptionalAnnotations);
        this.generateOptionalAnnotations.setToolTipText(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_genOptionalAnnotations_desc);
        GridData gd = new GridData();
        gd.horizontalSpan = columns;
        this.generateOptionalAnnotations.setLayoutData((Object)gd);
        this.generateOptionalAnnotations.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selected = TableGenPanel.this.generateOptionalAnnotations.getSelection();
                TableGenPanel.this.mTable.setGenerateDDLAnnotations(selected);
            }
        });
    }

    private void createClassNameControl(Composite parent, int columns) {
        if (!this.isDefaultTable) {
            SWTUtil.createLabel(parent, 1, JptUiEntityGenMessages.GenerateEntitiesWizard_tablePanel_className);
            this.classNameField = new Text(parent, 2052);
            SWTUtil.fillColumns((Control)this.classNameField, 3);
            this.classNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (e.getSource() == null || !TableGenPanel.this.isUpdatingControls) {
                        String className = TableGenPanel.this.classNameField.getText();
                        IStatus status = JavaConventions.validateJavaTypeName((String)className);
                        if (!status.matches(4)) {
                            TableGenPanel.this.mTable.setClassName(className);
                            TableGenPanel.this.wizardPage.setErrorMessage(null);
                        } else {
                            TableGenPanel.this.wizardPage.setErrorMessage(status.getMessage());
                        }
                    }
                }
            });
        }
    }

    private void createAssociationFetchControls(Composite composite, int columns) {
        SWTUtil.createLabel(composite, 1, JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_fetch);
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new RowLayout());
        SWTUtil.fillColumns((Control)parent, 3);
        this.associationFetchDefault = new Button(parent, 16);
        this.associationFetchDefault.setText("Default");
        this.associationFetchDefault.setData((Object)"defaultFetch");
        this.associationFetchEager = new Button(parent, 16);
        this.associationFetchEager.setText("&Eager");
        this.associationFetchEager.setData((Object)"eager");
        this.associationFetchLazy = new Button(parent, 16);
        this.associationFetchLazy.setText("La&zy");
        this.associationFetchLazy.setData((Object)"lazy");
        AssociationFetchListener associationFetchListener = new AssociationFetchListener();
        this.associationFetchDefault.addSelectionListener((SelectionListener)associationFetchListener);
        this.associationFetchLazy.addSelectionListener((SelectionListener)associationFetchListener);
        this.associationFetchEager.addSelectionListener((SelectionListener)associationFetchListener);
    }

    private void createCollectionTypeControls(Composite composite, int columns) {
        SWTUtil.createLabel(composite, 1, JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_collType);
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new RowLayout());
        SWTUtil.fillColumns((Control)parent, 3);
        this.collectionTypeSet = new Button(parent, 16);
        this.collectionTypeSet.setText("java.util.Se&t");
        this.collectionTypeSet.setData((Object)"java.util.Set");
        this.collectionTypeList = new Button(parent, 16);
        this.collectionTypeList.setText("java.util.&List");
        this.collectionTypeList.setData((Object)"java.util.List");
        CollectionTypeListener collectionTypeListener = new CollectionTypeListener();
        this.collectionTypeList.addSelectionListener((SelectionListener)collectionTypeListener);
        this.collectionTypeSet.addSelectionListener((SelectionListener)collectionTypeListener);
    }

    public void setORMGenTable(ORMGenTable table) {
        this.mTable = table;
        this.isUpdatingControls = true;
        try {
            if (this.classNameField != null) {
                this.classNameField.setText(this.mTable.getClassName());
            }
            List schemes = this.mTable.getCustomizer().getAllIdGenerators();
            String[] values = new String[schemes.size()];
            schemes.toArray(values);
            this.idGeneratorCombo.setItems(values);
            String idGenerator = this.mTable.getIdGenerator();
            this.idGeneratorCombo.setText(idGenerator);
            boolean isSequence = this.mTable.getCustomizer().getSequenceIdGenerators().contains(idGenerator);
            String sequenceName = this.mTable.isDefaultsTable() ? this.mTable.getSequence() : this.mTable.getFormattedSequence();
            sequenceName = sequenceName == null ? "" : sequenceName;
            this.sequenceNameField.setText(sequenceName);
            if (isSequence) {
                this.sequenceNameField.setEnabled(true);
                this.sequenceNameNoteLabel.setEnabled(true);
            } else {
                this.sequenceNameField.setEnabled(false);
                this.sequenceNameNoteLabel.setEnabled(false);
            }
            String access = this.mTable.getAccess();
            if ("field".equals(access)) {
                this.entityAccessField.setSelection(true);
                this.entityAccessProperty.setSelection(false);
            } else {
                this.entityAccessProperty.setSelection(true);
                this.entityAccessField.setSelection(false);
            }
            if (this.associationFetchLazy != null && this.associationFetchEager != null) {
                String defaultFetch = this.mTable.getDefaultFetch();
                this.associationFetchDefault.setSelection(false);
                this.associationFetchEager.setSelection(false);
                this.associationFetchLazy.setSelection(false);
                if ("defaultFetch".equals(defaultFetch)) {
                    this.associationFetchDefault.setSelection(true);
                } else if ("eager".equals(defaultFetch)) {
                    this.associationFetchEager.setSelection(true);
                } else {
                    this.associationFetchLazy.setSelection(true);
                }
            }
            if (this.collectionTypeList != null) {
                String cType = this.mTable.getDefaultCollectionType();
                if ("java.util.List".equals(cType)) {
                    this.collectionTypeList.setSelection(true);
                    this.collectionTypeSet.setSelection(false);
                } else {
                    this.collectionTypeSet.setSelection(true);
                    this.collectionTypeList.setSelection(false);
                }
                this.generateOptionalAnnotations.setSelection(this.mTable.isGenerateDDLAnnotations());
            }
        }
        catch (Exception e) {
            JptJpaUiPlugin.log(e);
        }
        this.isUpdatingControls = false;
    }

    private void createIdGeneratorControls(Composite parent, int columns) {
        SWTUtil.createLabel(parent, 1, JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_keyGen);
        this.idGeneratorCombo = new Combo(parent, 12);
        SWTUtil.fillColumns((Control)this.idGeneratorCombo, 3);
        this.idGeneratorCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (TableGenPanel.this.isUpdatingControls) {
                    return;
                }
                TableGenPanel.this.idGenChanged();
            }
        });
        SWTUtil.createLabel(parent, 1, JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_sequence);
        this.sequenceNameField = new Text(parent, 2052);
        SWTUtil.fillColumns((Control)this.sequenceNameField, 3);
        this.sequenceNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ((e.getSource() == null || !TableGenPanel.this.isUpdatingControls) && TableGenPanel.this.idGeneratorCombo.getText().equals("sequence")) {
                    String sequenceName = TableGenPanel.this.sequenceNameField.getText();
                    if (sequenceName.toLowerCase().indexOf("$table") >= 0 || sequenceName.toLowerCase().indexOf("$pk") >= 0) {
                        sequenceName = this.convertVarToLowerCase("$table", sequenceName);
                        sequenceName = this.convertVarToLowerCase("$pk", sequenceName);
                    }
                    if (sequenceName.trim().length() != 0) {
                        TableGenPanel.this.mTable.setSequence(sequenceName);
                    } else {
                        TableGenPanel.this.mTable.setSequence("");
                    }
                }
            }

            private String convertVarToLowerCase(String var, String sequenceName) {
                int n = sequenceName.toLowerCase().indexOf(var);
                if (n == 0) {
                    return String.valueOf(var) + sequenceName.substring(var.length());
                }
                if (n > 0) {
                    return String.valueOf(sequenceName.substring(0, n)) + var + sequenceName.substring(n + var.length());
                }
                return sequenceName;
            }
        });
        SWTUtil.newLabel(parent, "");
        this.sequenceNameNoteLabel = new Label(parent, 0);
        String text = String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_sequenceNote, "$table", "$pk");
        this.sequenceNameNoteLabel.setText(text);
        this.sequenceNameNoteLabel.setEnabled(false);
        SWTUtil.fillColumns((Control)this.sequenceNameNoteLabel, 3);
    }

    private void idGenChanged() {
        String scheme = this.idGeneratorCombo.getText();
        this.mTable.setIdGenerator(scheme);
        boolean isSequence = this.mTable.getCustomizer().getSequenceIdGenerators().contains(scheme);
        if (!isSequence) {
            this.sequenceNameField.setText("");
            this.sequenceNameField.setEnabled(false);
            this.mTable.setSequence(null);
            this.sequenceNameNoteLabel.setEnabled(false);
        } else {
            this.sequenceNameField.setEnabled(true);
            Color NOTE_LABEL_COLOR = new Color((Device)Display.getDefault(), 102, 102, 102);
            this.sequenceNameNoteLabel.setForeground(NOTE_LABEL_COLOR);
            NOTE_LABEL_COLOR.dispose();
            this.sequenceNameNoteLabel.setEnabled(true);
            if (this.sequenceNameField.getText().length() == 0) {
                String newMessage = "Please specify a sequence name";
                this.wizardPage.setMessage(newMessage);
                this.wizardPage.setPageComplete(true);
            } else {
                this.wizardPage.setErrorMessage(null);
                this.wizardPage.setPageComplete(true);
            }
        }
    }

    private void createEntityAccessControls(Composite composite, int columns) {
        SWTUtil.createLabel(composite, 1, JptUiEntityGenMessages.GenerateEntitiesWizard_defaultTablePage_access);
        Composite parent = new Composite(composite, 0);
        SWTUtil.fillColumns((Control)parent, 3);
        parent.setLayout((Layout)new RowLayout());
        this.entityAccessField = new Button(parent, 16);
        this.entityAccessField.setText("&Field");
        this.entityAccessField.setData((Object)"field");
        this.entityAccessProperty = new Button(parent, 16);
        this.entityAccessProperty.setText("&Property");
        this.entityAccessProperty.setData((Object)"property");
        EntityAccessFetchListener entityAccessFetchListener = new EntityAccessFetchListener();
        this.entityAccessField.addSelectionListener((SelectionListener)entityAccessFetchListener);
        this.entityAccessProperty.addSelectionListener((SelectionListener)entityAccessFetchListener);
    }

    class AssociationFetchListener
    implements SelectionListener {
        AssociationFetchListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!TableGenPanel.this.isUpdatingControls) {
                Button radioBtn = (Button)e.getSource();
                TableGenPanel.this.mTable.setDefaultFetch(radioBtn.getData().toString());
            }
        }
    }

    class CollectionTypeListener
    implements SelectionListener {
        CollectionTypeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!TableGenPanel.this.isUpdatingControls) {
                Button radioBtn = (Button)e.getSource();
                TableGenPanel.this.mTable.setDefaultCollectionType(radioBtn.getData().toString());
            }
        }
    }

    class EntityAccessFetchListener
    implements SelectionListener {
        EntityAccessFetchListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!TableGenPanel.this.isUpdatingControls) {
                Button radioBtn = (Button)e.getSource();
                TableGenPanel.this.mTable.setAccess(radioBtn.getData().toString());
            }
        }
    }
}

