/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.SimpleJavaResourceLocator;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PluginResourceLocator
extends SimpleJavaResourceLocator {
    public IContainer getDefaultResourceLocation(IProject project) {
        try {
            IContainer root = this.getBundleRoot(project);
            return root.getFolder(META_INF_PATH);
        }
        catch (CoreException ce) {
            JptCommonCorePlugin.log(ce);
            return super.getDefaultResourceLocation(project);
        }
    }

    public IPath getResourcePath(IProject project, IPath runtimePath) {
        try {
            IContainer root = this.getBundleRoot(project);
            IPath resourcePath = root.getFullPath().append(runtimePath);
            if (project.getWorkspace().getRoot().getFile(resourcePath).exists()) {
                return resourcePath;
            }
        }
        catch (CoreException ce) {
            JptCommonCorePlugin.log(ce);
        }
        return super.getResourcePath(project, runtimePath);
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IFile file = PlatformTools.getFile(resourcePath);
        try {
            IContainer root = this.getBundleRoot(project);
            if (root.contains((ISchedulingRule)file)) {
                return resourcePath.makeRelativeTo(root.getFullPath());
            }
        }
        catch (CoreException ce) {
            JptCommonCorePlugin.log(ce);
        }
        return super.getRuntimePath(project, resourcePath);
    }

    protected IContainer getBundleRoot(IProject project) throws CoreException {
        IBundleProjectService service = this.getBundleProjectService();
        IBundleProjectDescription description = service.getDescription(project);
        IPath path = description.getBundleRoot();
        return path == null ? project : project.getFolder(path);
    }

    protected IBundleProjectService getBundleProjectService() {
        BundleContext context = JptCommonCorePlugin.instance().getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(IBundleProjectService.class);
        if (reference == null) {
            return null;
        }
        IBundleProjectService service = (IBundleProjectService)context.getService(reference);
        if (service != null) {
            context.ungetService(reference);
        }
        return service;
    }
}

