/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Types;

public final class JDBCType
implements Cloneable,
Serializable {
    private final String name;
    private final int code;
    private static final long serialVersionUID = 1L;
    private static JDBCType[] TYPES;

    private JDBCType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public String name() {
        return this.name;
    }

    public int code() {
        return this.code;
    }

    public void appendTo(StringBuilder sb) {
        sb.append(this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        this.appendTo(sb);
        sb.append(')');
        return sb.toString();
    }

    public JDBCType clone() {
        try {
            return (JDBCType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static synchronized JDBCType[] types() {
        if (TYPES == null) {
            TYPES = JDBCType.buildTypes();
        }
        return TYPES;
    }

    public static JDBCType type(int code) {
        JDBCType[] types = JDBCType.types();
        int i = types.length;
        while (i-- > 0) {
            if (types[i].code() != code) continue;
            return types[i];
        }
        throw new IllegalArgumentException("invalid JDBC type code: " + code);
    }

    public static JDBCType type(String name) {
        JDBCType[] types = JDBCType.types();
        int i = types.length;
        while (i-- > 0) {
            if (!types[i].name().equals(name)) continue;
            return types[i];
        }
        throw new IllegalArgumentException("invalid JDBC type name: " + name);
    }

    private static JDBCType[] buildTypes() {
        Field[] fields = Types.class.getDeclaredFields();
        int len = fields.length;
        JDBCType[] types = new JDBCType[len];
        int i = len;
        while (i-- > 0) {
            int code;
            String name = fields[i].getName();
            try {
                code = (Integer)fields[i].get(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            types[i] = new JDBCType(name, code);
        }
        return types;
    }
}

