/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;

public final class AWTStateChangeListenerWrapper
implements StateChangeListener {
    private final StateChangeListener listener;

    public AWTStateChangeListenerWrapper(StateChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void stateChanged(StateChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.stateChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildStateChangedRunnable(event));
        }
    }

    private Runnable buildStateChangedRunnable(final StateChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTStateChangeListenerWrapper.this.stateChanged_(event);
            }

            public String toString() {
                return "state changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void stateChanged_(StateChangeEvent event) {
        this.listener.stateChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }
}

