/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.utility.swt;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListWidgetModelBinding<E> {
    private final ListValueModel<E> listModel;
    private final ListChangeListener listChangeListener;
    private final StringConverter<E> stringConverter;
    private final ListWidget listWidget;
    private final DisposeListener listWidgetDisposeListener;
    private final SelectionBinding selectionBinding;

    ListWidgetModelBinding(ListValueModel<E> listModel, ListWidget listWidget, StringConverter<E> stringConverter, SelectionBinding selectionBinding) {
        if (listModel == null || listWidget == null || stringConverter == null || selectionBinding == null) {
            throw new NullPointerException();
        }
        this.listModel = listModel;
        this.listWidget = listWidget;
        this.stringConverter = stringConverter;
        this.selectionBinding = selectionBinding;
        this.listChangeListener = this.buildListChangeListener();
        this.listModel.addListChangeListener("list values", this.listChangeListener);
        this.listWidgetDisposeListener = this.buildListWidgetDisposeListener();
        this.listWidget.addDisposeListener(this.listWidgetDisposeListener);
        this.synchronizeListWidget();
    }

    private ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    private ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ListWidgetModelBinding.this.listItemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ListWidgetModelBinding.this.listItemsRemoved(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ListWidgetModelBinding.this.listItemsMoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ListWidgetModelBinding.this.listItemsReplaced(event);
            }

            public void listCleared(ListClearEvent event) {
                ListWidgetModelBinding.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListWidgetModelBinding.this.listChanged(event);
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    private DisposeListener buildListWidgetDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ListWidgetModelBinding.this.listWidgetDisposed(event);
            }

            public String toString() {
                return "list widget dispose listener";
            }
        };
    }

    private void synchronizeListWidget() {
        if (!this.listWidget.isDisposed()) {
            this.synchronizeListWidget_();
        }
    }

    private void synchronizeListWidget_() {
        ArrayList<String> items = new ArrayList<String>(this.listModel.size());
        for (Object item : this.listModel) {
            items.add(this.convert(item));
        }
        this.listWidget.setItems(items.toArray(new String[items.size()]));
        this.selectionBinding.synchronizeListWidgetSelection();
    }

    void listItemsAdded(ListAddEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsAdded_(event);
        }
    }

    private void listItemsAdded_(ListAddEvent event) {
        int i = event.getIndex();
        for (E item : this.getItems(event)) {
            this.listWidget.add(this.convert(item), i++);
        }
        this.selectionBinding.synchronizeListWidgetSelection();
    }

    private Iterable<E> getItems(ListAddEvent event) {
        return event.getItems();
    }

    void listItemsRemoved(ListRemoveEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsRemoved_(event);
        }
    }

    private void listItemsRemoved_(ListRemoveEvent event) {
        this.listWidget.remove(event.getIndex(), event.getIndex() + event.getItemsSize() - 1);
        this.selectionBinding.synchronizeListWidgetSelection();
    }

    void listItemsMoved(ListMoveEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsMoved_(event);
        }
    }

    private void listItemsMoved_(ListMoveEvent event) {
        int target = event.getTargetIndex();
        int source = event.getSourceIndex();
        int len = event.getLength();
        int loStart = Math.min(target, source);
        int hiStart = Math.max(target, source);
        Object[] subArray = (String[])ArrayTools.subArray((Object[])this.listWidget.getItems(), (int)loStart, (int)(hiStart + len));
        subArray = (String[])ArrayTools.move((Object[])subArray, (int)(target - loStart), (int)(source - loStart), (int)len);
        int i = loStart;
        Object[] objectArray = subArray;
        int n = subArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.listWidget.setItem(i++, (String)item);
            ++n2;
        }
        this.selectionBinding.synchronizeListWidgetSelection();
    }

    void listItemsReplaced(ListReplaceEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listItemsReplaced_(event);
        }
    }

    private void listItemsReplaced_(ListReplaceEvent event) {
        int i = event.getIndex();
        for (E item : this.getNewItems(event)) {
            this.listWidget.setItem(i++, this.convert(item));
        }
        this.selectionBinding.synchronizeListWidgetSelection();
    }

    private Iterable<E> getNewItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    void listCleared(ListClearEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listCleared_(event);
        }
    }

    private void listCleared_(ListClearEvent event) {
        this.listWidget.removeAll();
    }

    void listChanged(ListChangeEvent event) {
        if (!this.listWidget.isDisposed()) {
            this.listChanged_(event);
        }
    }

    private void listChanged_(ListChangeEvent event) {
        this.synchronizeListWidget_();
    }

    private String convert(E item) {
        return this.stringConverter.convertToString(item);
    }

    void listWidgetDisposed(DisposeEvent event) {
        this.listWidget.removeDisposeListener(this.listWidgetDisposeListener);
        this.listModel.removeListChangeListener("list values", this.listChangeListener);
        this.selectionBinding.dispose();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.listModel);
    }

    static interface ListWidget {
        public boolean isDisposed();

        public void addDisposeListener(DisposeListener var1);

        public void removeDisposeListener(DisposeListener var1);

        public String[] getItems();

        public void setItem(int var1, String var2);

        public void setItems(String[] var1);

        public void add(String var1, int var2);

        public void remove(int var1, int var2);

        public void removeAll();
    }

    static interface SelectionBinding {
        public void synchronizeListWidgetSelection();

        public void dispose();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Null
        implements SelectionBinding {
            public static final SelectionBinding INSTANCE = new Null();

            public static SelectionBinding instance() {
                return INSTANCE;
            }

            private Null() {
            }

            @Override
            public void synchronizeListWidgetSelection() {
            }

            @Override
            public void dispose() {
            }

            public String toString() {
                return "SelectionBinding.Null";
            }
        }
    }
}

