<?php

/**
* Form printing and checking functions
*  
* This file includes function for printing an HTML for and checking field integrity.
* @package efront
* @todo Must change everything, in order to be more practical, currently it's much too complicated...
*/


/**
* Prints an HTML form
*
* @todo Must become smaller, it's huge
* @todo Can't tell how it works :(
* @version 1.0
*/
function eF_printForm( $table, 
                       $fields, 
                       $action, 
                       $hidden              = "", 
                       $foreign_table       = "", 
                       $foreign_desc        = "", 
                       $foreign_constraints = "", 
                       $submit              = false, 
                       $more_html           = false, 
                       $values              = false, 
                       $editor              = false, 
                       $all_rows            = false, 
                       $size_editor         = false,
                       $compatibility       = 0
                     )
{

    global $TRANSLATION;
    
    $text = '<form action = "'.$action.'" method = "post">';
    $text .= '<table align = "center" border = "0" width = "100%">';
     
    /*     $table      ,         .
            array   $field_char*/
    $res = eF_execute("desc $table");
    while (list($name, $type, $allow_null, $primary, $def_value, $auto_inc) = mysql_fetch_row($res)) {
        if (!isset($def_value)) {
            $def_value = "";          //$def_value = "&nbsp;";
        }
        if (!($primary)) {
            $primary = "No";
        }
        if (!($allow_null)) {
            $allow_null = "No";
        }
        if (!($auto_inc)) {
            $auto_inc = "No";
        } else {
            $auto_inc = "Yes";
        }

        $field_char[$name]['type']       = $type;
        $field_char[$name]['def_value']  = $def_value;
        $field_char[$name]['allow_null'] = $allow_null;
        
        preg_match("/.*\((\d*)\).*/", $type, $matches);     //    , .. varchar(255)  int(11),  ,       .
        isset($matches[1])? $field_char[$name]['size'] = $matches[1] : $field_char[$name]['size'] = '';
    }    

    foreach ($fields as $key => $value) {
        $type       = $field_char[$key]['type'];
        $size       = $field_char[$key]['size'];
        $allow_null = $field_char[$key]['allow_null'];
        //            
        if ($all_rows) {
            if ($allow_null == "No") {
                $text .= '<tr><td class="description">'.$value.'&nbsp;&nbsp;<b>*</b></td></tr><tr><td>';
            } else { 
                $text .= '<tr><td class="description">'.$value.'</td></tr><tr><td>';    
            }                           
        } else {
            if ($allow_null == "No") {
                $text .= '<tr><td>'.$value.'<b>*</b></td><td><span style = "white-space:nowrap">';  
            }else{
                $text .= '<tr><td>'.$value.'</td><td><span style = "white-space:nowrap">';  
            }
            
        }
        
        if (!$field_char[$key]['type']) {
            eF_printMessage(_FIELDNOTEXISTS.$key);
            exit;
        }   
        if (isset($values[$key])) {
            $def_value = $values[$key];
        } else {
            $def_value = $field_char[$key]['def_value'];
        }
        
        if ($foreign_table != "") {
            $is_foreign = eF_checkForeignKey($key, $foreign_table);
        } else {
            $is_foreign = false;
        }
        
        if ($is_foreign) {
            $table       = $foreign_table[$key];
            $desc        = $foreign_desc[$key];
            $constraints = $foreign_constraints[$key];
            
            $tempkey = $key;
            while ($tempkey) {
                $field = $tempkey;
                list($data, $tempkey) = split("_", $tempkey, 2);
            }
            
            $field = strtolower($field);
            
            $text .= '<select name='.$key.'><option value=0>'.$value.'</option><option value=0>--------------------</option>\n';
            
            if ($field != $desc) {            
                //      content_ID
                if ($table == "content") {
                    $tree = eF_getContentTree($nouse, $hidden['lessons_ID'], 0, false, true);
                    for ($i = 0; $i < sizeof($tree); $i++) {
                        if ($tree[$i]['id'] != $foreign_constraints[$key]) {
                            $name  = eF_printContentPrestring($tree[$i]).$tree[$i]['name'];
                            $text .= '<option value="'.$tree[$i]['id'].'"';
                            if ($def_value == $tree[$i]['id'])
                                $text .= ' selected';
                            $text .= '>'.$name.'</option>';
                        }
                    }
                } else {
                    $res = eF_execute("select $field, $desc from $table $constraints");
                    while (list($data, $name) = mysql_fetch_row($res)) {
                        $text .= "<option value=$data";
                        if ($def_value == $data) {
                            $text .= " selected";
                        }
                        $text .= ">$name</option>\n";
                    }
                }
            } else {
                $res = eF_execute("select $field from $table $constraints");
                while (list($data) = mysql_fetch_row($res)) {
                    $text .= "<option value=$data";
                    if ($def_value == $data) {
                        $text .= " selected";
                    }
                    $text .= ">$data</option>\n";
                }
            }
            $text .= "</select>\n";
        } else {
            // Diakrinoume periptoseis analoga me ton  typo toy pediou
            if (c("int", $type) || mb_ereg("float", $type) || mb_ereg("double", $type)) {
                if ($size != 1) {
                    $text .= "<input type=text size=5 name=$key value=\"$def_value\">";
                } else {
                    $text .= "<input type=checkbox name=$key";
                    if ($def_value == 1) {
                        $text .= " checked";
                    }
                    $text .= " value=1>";
                }
            } elseif (mb_ereg("char", $type)) {
                if ($key == "password") {
                    $text .= "<input type=password size=35 name=$key value=\"$def_value\">";
                } else {
                    $text .= "<input type=text size=35 name=$key value=\"$def_value\">";
                }
            } elseif (mb_ereg("enum", $type)) {
                list($nothing, $options) = split("\('", $type, 2);
                list($options, $nothing) = split("'\)", $options, 2);
                $text .= '<select name="'.$key.'"><option value=0>'.$value.'</option><option value=0>--------------------</option>\n';
                while (list($data, $options) = split("','", $options, 2)) {
                    if (!$data) {
                        break;
                    }
                    if ($data != "tests" AND ($key != "ctg_type" OR ($key == "ctg_type" AND isset($_SESSION['s_lesson_options'][$data])))) {
                        $text .= "<option value=$data";
                        if ($data == $def_value) {
                            $text .= " selected";
                        }
                        $text .= ">";
                        if (isset($TRANSLATION[$data])) {
                            $text .= $TRANSLATION[$data];
                        } else {
                            $text .= $data;
                        }
                        $text .= "</option>\n";
                    }
                }
                $text .= "</select>\n";
            } elseif (mb_ereg("text", $type)) {
             $height = '';
                if ($editor AND in_array($key, $editor)) {

                   if (isset($size_editor[$key])) {
                    //echo $key;
                        $height = $size_editor[$key];
                        //$height = 40;
    //echo $height;   
                        $cols   = 80;
                    } else {
                        $height = 30;
                        $cols   = 80;
                    }
                    if ($key == "options" || $key == "answer"){ // .... eidika gia ta questions
                        $text .= '<textarea name="'.$key.'" id="'.$key.'" style="width:100%" rows="'.$height.'" cols="'.$cols.'">'.$def_value.'</textarea>';    
                    }else {
                        if( $table == "questions") {
                            $text .= '<textarea name="'.$key.'" id="data" style="width:100%" rows="'.$height.'" cols="'.$cols.'" class=\"intermediateEditor\">'.$def_value.'</textarea>';
                        }else{           
                            $text .= '<textarea name="'.$key.'" id="data" style="width:100%" rows="'.$height.'" cols="'.$cols.'" class=\"mceEditor\">'.$def_value.'</textarea>';
                        }
                   }
                  
                } else {
                    if (isset($size_editor[$key])) {
                        $height = $size_editor[$key];
                        $cols   = 120;
                    } else {
                        $height = 7;
                        $cols   = 70;
                    }
                    if ($key == "options" || $key == "answer"){
                        $text .= '<textarea name="'.$key.'" id="'.$key.'" style="width:100%" rows="'.$height.'" cols="'.$cols.'">'.$def_value.'</textarea>';    
                    }else {
                        //$text .= "<textarea name=$key id=".$key." rows=".$height." cols=".$cols." class=\"simpleEditor\">$def_value</textarea>";//ebala edo id
                        $text .= '<textarea name="'.$key.'" id="'.$key.'" rows="'.$height.'" cols="'.$cols.'" class="simpleEditor">'.$def_value.'</textarea>';
                    }
                }
            } else {
                $text .= "Unidentified field type!";
            }
        }

        $text .= "</span></td></tr>\n";
    }   

    $text .= '<tr><td colspan=2 align="center">';
    if (isset($more_html['left']) && $more_html['left'] != "") {
        $text .= $more_html['left']."\n";
    }
    if ($submit != "") {
        $text .= '<input class = "flatButton" type="submit" value="'.$submit['value'].'" name="'.$submit['name'].'">';
    }
    if (isset($more_html['right']) && $more_html['right'] != "") {
        $text .= $more_html['right']."\n";
    }
    $text .= "</td></tr></table>\n";
        
    if ($hidden) {
        foreach ($hidden as $key => $value) {
            $text .= '<input type="hidden" name="'.$key.'" value="'.$value.'">'."\n";
        }
    }
    $text .= "</form>";
    return $text;
}

/**
*
*/
function eF_printForm2($table, $fields) {
//  form    ,           
    print '<table>';

    foreach ($fields as $key => $field) {
        $field_description = eF_describeTable($table, array($key));
        $field_properties  = eF_getFieldProperties($field_description[0]);
        
        switch ($field_properties['type']) {
//            case 'text':
//                print '<tr><td>'.current($fields).':</td><td><textarea></textarea>'.$asterisk.'</td></tr>';
//                break;
//            case 'enum':
//                $options = explode(',', $matches[1]);
//                print '<tr><td>'.current($fields).':</td><td><select>';
//                foreach ($options as $option) print '<option value = "">'.$option.'</option>';
//                print '</select>'.$asterisk.'</td></tr>';
//                break;
//            default:
//                print '<tr><td>'.current($fields).':</td><td><input type = "text" maxlength = '.$maxlength.'>'.$asterisk.'</td></tr>';
//                break;
        }

    }

    print '</table>';
}

function eF_getFieldProperties($field_info) {
    
    $properties['name']   = $field_info['Field'];
    $properties['type']   = false;
    $properties['size']   = false;
    $properties['values'] = false;
    
    if (preg_match("/enum\((.*)\)/", $field_info['Type'], $matches)) {                                          //Check if it is an enum field and get its values to the matches array. So, if, for example, the field has type "enum('yes','no')" then $matches[1] will contain "'yes','no'"  (without the double quotes).
        $properties['type']   = 'enum';
        $properties['values'] = explode(',', str_replace('\'', '', $matches[1]));                               //The enum values are surrounded by quotes (') so we use str_replace to filter them out
    } elseif (preg_match("/(.*)\((\d*)\).*/", $field_info['Type'], $matches)) {                                       //Get the field type and size. It applies to fields of type varchar, int etc. that their size accompanies their type. For example, if the field has type "varchar(128)", then $matches[1] will contain "varchar" and $matches[2] "128".
        $properties['type'] = $matches[1];
        $properties['size'] = $matches[2];
    } elseif(preg_match("/(.*)/", $field_info['Type'], $matches)) {
        $properties['type'] = $matches[1];        
    }
    
    $field_info['Null']    ? $properties['null']    = true                   : $properties['null']    = false;
    $field_info['Key']     ? $properties['key']     = true                   : $properties['key']     = false;
    $field_info['Default'] ? $properties['default'] = $field_info['Default'] : $properties['default'] = false;
    $field_info['Extra']   ? $properties['extra']   = $field_info['extra']   : $properties['extra']   = false;
    
    //print_r($properties);
    return $properties;
}


/**
* Checks field integrity
*
* This function is used exclusively from eF_printForm() to make sure that the foreign_table array
* is structured in the right way.
*
* @param array $foreign_table
* @param string $field
* @return int
* @see eF_printForm()
* @version 1.0
*/
function eF_checkForeignKey($field, $foreign_table)
{
    foreach ($foreign_table as $key => $value ) {
        if ($field == $key) {
            return 1;
        }
    }
    return 0;
}

/**
* Checks if the form data are consistent with the table
*
* This function checks if the data passed from an HTML form are consistent with the table structure.
* Specifically, if a table field cannot be null, then the function issues a suitable message if the 
* corresponding form field was left blank. Additionally, if a primary key field has the same value
* with the one passed, then another warning message is issued
*
* @todo Documentation
* @param string $table
* @param array $fields
* @param array $values
* @version 1.0
*/
function eF_checkForm($table, $fields, $values)
{
    $error = '';
    $res   = eF_execute("desc $table");
    while (list($name, $type, $allow_null, $primary, $def_value, $auto_inc) = mysql_fetch_row($res)) {
        if (!$allow_null) {
            $allow_null = "No";
        }
        
        preg_match("/.*\((\d*)\).*/", $type, $matches);     //    , .. varchar(255)  int(11),  ,       .        
        isset($matches[1]) ? $size = $matches[1] : $size = '';

        $field_char[$name]['type']       = $type;
        $field_char[$name]['allow_null'] = $allow_null;
        $field_char[$name]['primary']    = $primary;
        $field_char[$name]['size']       = $size;
    }
    foreach ($fields as $key => $name) {
        $value = $values[$key];
        if ($field_char[$key]['allow_null'] == "No" AND ($value === false OR ( $value == "" AND $field_char[$key]['size'] != 1 ) OR $value == "0" )) { 
            $error .= _FIELDLEFTBLANK.' "'.$name.'"<BR>';
        } else {
            if ($field_char[$key]['primary']) {
                $res2 = eF_getTableData($table, $key, "$key='$value'");
                if ($res2[0][$key] == $value) {
                    $error .= _THEFIELD.' "'.$name.'" '._CANNOTHAVEVALUE.' "'.$value.'" '._BECAUSEITALREADYEXISTS.'<BR>';
                }
            }
        }
    }
    return $error;
}

/*
if (time() < mktime(0,0,0,11,1,2007)) {
    $message      = "Trial Period is over. Thank you for evaluating eFront.";
    $message_type = 'success';
    if (basename($_SERVER['PHP_SELF']) != 'index.php') {
        header("location:index.php?message=$message&message_type=message_type");
        exit;
    } else {
        $_GET['message'] = $message;
    }
}
*/
?>
