<?php
/**
*     
*
*            
*  .
* @package efront
*/


/**
*   .
* 
*           
*    HTML.     :
* - $values_y:          .
* - $values_x: ,             ,   x
* - $label_y: ,     
* - $label_x: ,     
* - $horizontal_size: ,       .
* - $vertical_size: ,       .
* - $alt_values_y:   ,        , 
*                      .
*   $values_x  $alt_values_y,  ,         $values_y 
* <br>    ,    :
* - images/V_line.jpg
* - images/H_line.jpg
* - images/break.gif
* - images/bar{x}.jpg ,  {x}   1-5     .
* <br><br>:
* <code>
* $values_y = array(18, 22, 39, 20);
* $values_x = array("6/2004", "7/2004", "8/2004", "9/2004");
* $label_y  = " "
* $label_x  = "  2003/2004"
* $horizontal_size = 400;
* $vertical_size   = 400;
* $alt_values_y = array(15, 21, 33, 27);
* eF_makeGraph($values_y, $values_x, $label_y, $label_x, $horizontal_size, $vertical_size, $alt_values_y);
* </code>
* 
* @param int $horizontal_size       .
* @param int $vertical_size   T      .
* @param array $values_x      .
* @param array $values_y       .
* @param string $label_x     x
* @param string $label_y     y
* @param array $alt_values_y   ()    .
* @return mixed   string    HTML,  false    .
* @version 1.0
*/
function eF_makeGraph($values_y, $values_x = false, $label_y = '', $label_x = '', $horizontal_size = 600, $vertical_size = 400, $alt_values_y = false)
{   
    if ((sizeof($values_y) == 0) || ($values_x & sizeof($values_x) == 0) || ($alt_values_y & sizeof($alt_values_y) == 0)) {
        trigger_error(_GRAPHARRAYSZEROLENGTHERROR, E_USER_WARNING);
        return false;
    }
    if ($horizontal_size < 10 || $vertical_size < 10) {
        trigger_error(_GRAPHSIZETOOSMALL, E_USER_WARNING);
        return false;    
    }
    if (($values_x & sizeof($values_x) != sizeof($values_y)) || ($alt_values_y & sizeof($alt_values_y) != sizeof($values_x))) {
        trigger_error(_GRAPHARRAYSDIFFERENTLENGTHERROR, E_USER_WARNING);
        return false;
    }

    /*  eF_checkGraphValues          , ,            (      0)*/
    list($flag, $my_max) = eF_checkGraphValues($values_y);
    if ($alt_values_y) {
        list($flag2, $my_max2) = eF_checkGraphValues($alt_values_y);
    }

    $td_width = $horizontal_size / sizeof($values_y);   //   
    $colspan  = sizeof($values_y) + 1;                  //     , +1      
    
    if ($alt_values_y) {
        $alt_y_content = array_keys($alt_values_y); //   alt_y
    }

    $colors = array('orange', 'blue', 'red', 'green', 'olive');
    
    $str  = '
    <table border="0" cellspacing="0" cellpadding="0" width = "'.$horizontal_size.'">
        <tr>
            <td rowspan="5" width="1" align="left" valign="middle" colspan='.$colspan.'><b>'.$label_y.'&nbsp;</b></td>
            <td rowspan="2" align="right" valign="bottom" style = "border:1px solid black"></td>';

    $str_temp = '';
    if(!$alt_values_y) {    
        for ($i = 0; $i < sizeof($values_y); $i++) {
            $str .= '
            <td height="'.$vertical_size.'" valign="bottom" align="center" width = "'.($horizontal_size/sizeof($values_y)).'">'.
                    eF_drawGraph($values_y, $i, $flag, $my_max, $vertical_size);            //     .

            $color     = $colors[fmod(($i + 1), 5)];
            $str_temp .= '
            <td align = "center" valign = "top" style = "color:'.$color.';">&nbsp;'.$values_y[$i].'<br/><b>'.$values_x[$i].'</b></td>';
        }
    } else {
        for ($i = 0; $i < sizeof($values_y); $i++) {
            $str .= '
            <td height = "'.$vertical_size.'" valign = "bottom" align = "center" width = "'.$td_width.'">
                <table border = "0" cellspacing = "1" cellpadding = "0">
                    <tr><td valign = "bottom" align = "right" width = "'.($horizontal_size/sizeof($values_y)).'">'.
                        eF_drawGraph($values_y, $i, $flag, $my_max2, $vertical_size, $alt_values_y).'
                    </td><td align = "left" valign = "bottom" width = "'.($horizontal_size/sizeof($values_y)).'">'.
                        eF_drawGraph($alt_values_y, $i, $flag2, $my_max2, $vertical_size, false, 'dark').'
                    </td></tr>
                </table>
            </td>';
            $color     = $colors[fmod(($i + 1), 5)];
            $str_temp .= '
            <td align = "center" valign = "bottom" style = "color:'.$color.'">&nbsp;' . $values_y[$i] . '/' . $alt_values_y[$i] . '&nbsp;<br>&nbsp;<b>' . $values_x[$i] . '</b>&nbsp;</td>';
        }
    }
    $str .= '   
        </tr>
        <tr><td colspan="'.$colspan.'" valign="bottom" style = "border:1px solid black"></td></tr>
        <tr><td></td>'.$str_temp.'</tr>
        <tr><td colspan='.$colspan.' align="center" valign="bottom"><b>'.$label_x.'</b></td></tr>
    </table>';
    return $str;
}

/**
*       .
*
*             
*   .      eF_makeGraph()
*
* @param array $values     .
* @param int $i   offset      .
* @param array $flag         .
* @param int $v_size     .
* @param array $alt_values ,     .
* @param string $dark           .
* @return string   HTML    .
* @version 1.0
* @see eF_makeGraph()
*/
function eF_drawGraph($values, $i, $flag, $max, $v_size, $alt_values = false, $dark = false)
{
    $colors_num = 5;               //O          .
    $min_height = 2;               //    
    $max_height = $v_size - 20;    //    
    $bar_width  = 15;              //   
    
    $colors      = array('orange', 'blue', 'red', 'green', 'fuchsia');
    $dark_colors = array('darkorange', 'darkblue', 'darkred', 'darkgreen', 'purple');
    
    if (!$alt_values) {             //      .
        $alt_values = $values;
    }
    
    //$dark ? $color = (fmod(($i + 1), $colors_num) + 1).'_dark' : $color = (fmod(($i + 1), $colors_num) + 1);    //    $dark,    .
    $dark ? $color = $dark_colors[fmod(($i + 1), sizeof($colors))] : $color = $colors[fmod(($i + 1), sizeof($colors))];    //    $dark,    .
    
    if (!isset($flag[$i])) {                //      "" .
        (max($alt_values) == 0) ? $max_alt_values = 1 : $max_alt_values = max($alt_values);
        $bar_height = $min_height + ($values[$i]) * ($max_height - $min_height) / ($max_alt_values);    //   ,       .
        //$str        = '<img border="2" src="images/bar'.$color.'.gif" width="'.$bar_width.'" height="'.$bar_height.'" style = "vertical-align:bottom">';
        //$color = $colors[fmod(($i + 1), 5)];
        $str = '<table>
                    <tr><td valign="bottom" width = "'.$bar_width.'" height="'.$bar_height.'" style = "background-color:'.$color.';border:2px solid black"></td></tr>
                </table>';
    } else {
        $temp = $min_height + ($max) * ($max_height - $min_height) / (max($alt_values));
        $bar_height = $temp + ($v_size - $temp) * ($values[$i] - $max) / $values[$i];
        $str = '<table>
                    <tr><td valign="bottom" width = "'.$bar_width.'" height="10" style = "background-color:'.$color.';border:2px solid black"></td></tr>
                    <tr><td align = "center" valign="bottom" width = "'.$bar_width.'" height="8" style = "color:'.$color.';font-size:8px">*</td></tr>
                    <tr><td align = "center" valign="bottom" width = "'.$bar_width.'" height="8" style = "color:'.$color.';font-size:8px">*</td></tr>
                    <tr><td align = "center" valign="bottom" width = "'.$bar_width.'" height="8" style = "color:'.$color.';font-size:8px">*</td></tr>
                    <tr><td valign="bottom" width = "'.$bar_width.'" height="'.$bar_height.'" style = "background-color:'.$color.';border:2px solid black"></td></tr>
                </table>
                ';
    }

    return $str;
}

/**
*          .
*
*        ,         .
*   ""   ""     ,       
*  "" ,        . ,   
*     ,       "" .
* <br>:
* <code>
* <pre>
* <?php
* $values = array(4,7,40,6,14,80);
* list($flag, $max_val) = eF_checkGraphValues($values);
* echo "max_val = $max_val";
* print_r($flag);
* ?>
* </pre>
* </code>
*     :
* <code>
* max_val = 14
* Array
* (
*     [2] => 1
*     [5] => 1
* )
* </code>
*    2  5  ""     14   
*   "" .
* 
* @param array $values       .
* @return array         .    
*     ,   1 (true) ,     
*     $values   "" .    
*      max_val.
* @version 1.0
* @see eF_makeGraph
*/
function eF_checkGraphValues($values)
{
    $threshold = 20;        //        .
    $temp      = $values;
    $i         = 0;
    $flag      = array();
    $my_max    = 0;
    
    sort($temp);

    while ($temp[$i++] <= 0 && $i <= sizeof($temp) && isset($temp[$i]));            //   ,    0.
    $temp = array_slice($temp, $i-1);   //   
    $mi   = min($temp);                 
    $ma   = max($temp); 
    if ($ma - $mi >= $threshold) {                //   
        for ($i = 0; $i < sizeof($values); $i++) {
            if ($values[$i] - $mi >= $threshold) {     //   ,  
                $flag[$i] = true;
            } elseif ($values[$i] > $my_max) {
                $my_max = $values[$i];           //     ,  .
            }
        }
    }
    return  array($flag, $my_max);
}

?>