<?php
/**
* Download file
* 
* This file offers the user the ability to download a file.
*
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

error_reporting(E_ERROR);
//echo "<pre>";print_r($_POST);print_r($_GET);

$user = eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']);
if (!$user) {                                                                                       //User must be logged in and valid
    header("location:index.php");
    exit;
}

if ( isset($_GET['filename']) && eF_checkParameter($_GET['filename'], 'filename') && isset($_GET['action'])) {         //Make sure parameters are valid
    $filename = $_GET['filename'];

    if (isset($_GET['zip'])) {
        $zip      = new ZipArchive();
        $temp_dir = eF_sys_get_temp_dir();
        $zip_file = $temp_dir.pathinfo($filename, PATHINFO_FILENAME).'.zip';
        if ($zip -> open($zip_file, ZIPARCHIVE::CREATE) !== TRUE) {
            eF_printMessage(_CANNOTCREATEZIPFILE);
            exit;
        }
    }
    switch ($_GET['action']) {
        case 'lesson_export':                                                                             //download a content file
            
            if (realpath(G_LESSONSPATH.$_GET['offset'].'/') === false || strpos(realpath(G_LESSONSPATH), realpath(G_LESSONSPATH.$_GET['offset'].'/')) !== false) {                                  //Check of the specified offset is valid
                echo "A";eF_printMessage(_ILLEGALOFFSET);
                exit;
            }
                header('Content-type: application/'.pathinfo($filename, PATHINFO_EXTENSION));
                header('Content-Disposition: attachment; filename="'.$_GET['lesson_name'].'"');
                readfile(getcwd()."/content/lessons/".$_GET['offset']."/".$filename);
            break;
        case 'link':
            if (realpath(G_LESSONSPATH.$_GET['offset'].'/') === false || strpos(realpath(G_LESSONSPATH), realpath(G_LESSONSPATH.$_GET['offset'].'/')) !== false) {                                  //Check of the specified offset is valid
                eF_printMessage(_ILLEGALOFFSET);
                exit;
            }
            $mime_types = eF_getMimeTypes();
            $mime_types[pathinfo($filename, PATHINFO_EXTENSION)] ? $mime_type = $mime_types[pathinfo($filename, PATHINFO_EXTENSION)] : $mime_type = 'application/'.pathinfo($filename, PATHINFO_EXTENSION);
            header('Content-type: '.$mime_type);
            //header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile(getcwd()."/content/lessons/".$_GET['offset']."/".$filename);
            break;
        case 'content':                                                                             //download a content file
            //echo realpath(G_LESSONSPATH)."<BR>".realpath(G_LESSONSPATH.$_GET['offset'].'/')."!";exit;
            
            if (realpath(G_LESSONSPATH.$_GET['offset'].'/') === false || strpos(realpath(G_LESSONSPATH), realpath(G_LESSONSPATH.$_GET['offset'].'/')) !== false) {                                  //Check of the specified offset is valid
                eF_printMessage(_ILLEGALOFFSET);
                exit;
            }
            if (isset($_GET['zip'])) {
                $zip -> addFile(G_LESSONSPATH.$_GET['offset']."/".$filename, $filename);
                $zip -> close();        
                header('Content-type: application/zip');
                header('Content-Disposition: attachment; filename="'.basename($zip_file).'"');
                readfile($zip_file);
                unlink($zip_file);
                exit;
            } else {
                header('Content-type: application/'.pathinfo($filename, PATHINFO_EXTENSION));
                header('Content-Disposition: attachment; filename="'.basename($filename).'"');
                readfile(getcwd()."/content/lessons/".$_GET['offset']."/".$filename);
            }
            break;
        case 'backup':                                                                              //Download a backup file
            if ($user != 'administrator') {                                                         //User must be an administrator to download backup files
                exit;
            }
            header('Content-type: application/tgz');
            header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile(G_BACKUPPATH.$filename);    
            break;
        case 'language':                                                                            //download a language file
            if ($user != 'administrator') {                                                         //User must be an administrator to download backup files
                exit;
            }
            header('Content-type: application/text');
            header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile($path.'/language/'.$filename);    
            break;
        case 'css':
            if ($user != 'administrator') {                                                         //User must be an administrator to download backup files
                exit;
            }
            header('Content-type: application/text');
            header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile('css/custom_css/'.$filename);    
            break;          
        case 'c_css':
            if ($user != 'administrator') {                                                         //User must be an administrator to download backup files
                exit;
            }
            header('Content-type: application/text');
            header('Content-Disposition: attachment; filename="css_global.css"');
            readfile('css/'.'css_global.css');    
            break;        
        case 'message_attach':                                                                      //download a private message attachment. 
            if (eF_checkParameter($_GET['folder'], 'id')) {
                $attach_filename = preg_replace('/[0-9]{10}_prefix_(.*)/', "$1", basename($filename));
                $folder = eF_getTableData("f_folders", "name", "users_LOGIN='".$_SESSION['s_login']."' and id=".$_GET['folder']);
                header('Content-type: application/text');
                header('Content-Disposition: attachment; filename="'.$attach_filename.'"');
                readfile(G_UPLOADPATH.$_SESSION['s_login'].'/message_attachments/'.$folder[0]['name'].'/'.$filename);
            } 
            break;
        case 'project':
            $type = '';
            $extension = substr($filename,strlen($filename)-3);
            switch($extension) {
                case 'zip':
                    $type = 'application/zip';
                    break;
                case 'rar';
                    $type = 'application/rar';
                    break;
                case 'pdf':
                    $type = 'application/pdf';
                    break;
                case 'txt':
                    $type = 'application/text';
                    break;
                case 'txt':
                    $type = 'text/plain';
                    break;
                case 'doc':
                    $type = 'application/ms-word';
                    break;
                case 'ppt':
                case 'pps':
                    $type = 'application/ms-powerpoint';
                    break;
                case 'xls';
                    $type = 'application/ms-excel';
                default:
                    eF_printMessage(_UNDEFINEDFILETYPE);
                    break;
                
            }
            
            header('Content-type: '.$type);
            header('Content-Disposition: attachment; filename="'.$filename.'"');
            readfile(G_UPLOADPATH.$_GET['student'].'/projects/'.$filename);
            break;
            
        case 'digital_library':                                                                     //download a digital library file
            header('Content-type: application/text');
            header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile(getcwd()."/content/lessons/".$_SESSION['s_lessons_ID']."/Digital Library/".$filename);
            break;

        case 'tests':
            header('Content-type: application/text');
            header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile(G_UPLOADPATH.$_GET['student'].'/tests/'.$_GET['offset'].'/'.basename($filename));
            break;
        case 'users_export':
            header('Content-type: application/text');
            header('Content-Disposition: attachment; filename="'.basename($filename).'"');
            readfile($filename);
            break;
        default:
            eF_printMessage(_UNDEFINEDACTION);
            exit;
            break;
    }
} 


//Here, we reproduce the view_file.php functionality, by changing the content-disposition parameter only, so that the file always downloads.
if (isset($_GET['file']) && eF_checkParameter($_GET['file'], 'id')) {         //Make sure parameters are valid
    $file          = new eF_File($_GET['file']);
    $file_info     = $file -> getInfo();

    header("content-type:".$file_info['mime_type']);
    header('content-disposition: attachment; filename= "'.$file_info['original_name'].'"');
    readfile($file -> getFullPath());
}

/*
if (isset($_GET['filename']) && !preg_match("/.*((\.\.)|(\/)|(\\\)).* /", $filename)) {
    if (!isset($_GET['backup'])) {
        header('Content-type: application/text');
        header('Content-Disposition: attachment; filename="'.basename($filename).'"');
        readfile(getcwd()."/content/lessons/".$offset."/".$filename);
    } else {
        if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "administrator") {                               //User must have administrative rights
            header("location:index.php");
            exit;
        }

        header('Content-type: application/tgz');
        header('Content-Disposition: attachment; filename="'.basename($filename).'"');
        readfile(G_BACKUPPATH.$filename);    
    }
} else {
    echo "Error in filename!";
}*/
?>
