<?php
/**
*
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

//error_reporting(E_ALL);


try {
    if ($_SESSION['s_type'] == 'administrator') {
        $rootDir = new eF_Directory(G_ADMINPATH);
    } else {
        $rootDir = new eF_Directory(G_LESSONSPATH.$_SESSION['s_lessons_ID'].'/');
    }

    if (isset($_GET['directory']) && eF_checkParameter($_GET['directory'], 'id')) {
        $directory = new eF_Directory($_GET['directory']);
        if (strpos($directory -> getFullPath(), $rootDir -> getFullPath()) === false) {
            $directory = $rootDir;
        } else {
            $directory -> getDirectory() == $rootDir -> getFullPath() ? $smarty -> assign("T_PARENT_DIR", '') : $smarty -> assign("T_PARENT_DIR", $directory -> getDirectory());
        }
    } else {
        $directory = $rootDir;
    }
    $offset = G_RELATIVELESSONSLINK.str_replace(G_LESSONSPATH, '', $directory -> getFullPath());
    
    switch ($_GET['for_type']) {
        case 'image': $filter = array_keys(EfrontFileSystem :: getFileTypes('image')); break;
        case 'java' : $filter = array_keys(EfrontFileSystem :: getFileTypes('java'));  break;
        case 'media': $filter = array_keys(EfrontFileSystem :: getFileTypes('media')); break;
        default     : $filter = false; break;        
    }

    $dirFiles = $directory -> getContents(false, true, $filter);

    if ($filter) {                                                            //If $filter is false, directories are included in $dirFiles
        $subDirs  = $directory -> getContents(false, true, 'directory');
        if (sizeof($subDirs) > 0) {
            $dirFiles = array_merge($subDirs, $dirFiles);
        }
    }

    foreach ($dirFiles as &$dirFile) {
        if ($dirFile['type'] == 'directory') {
            $dirFile['image'] = 'folder.png';
        } elseif (is_file(G_IMAGESPATH.'file_types/'.mb_strtolower($dirFile['extension']).'.png')) {
            $dirFile['image'] = mb_strtolower($dirFile['extension']).'.png';
        } else {
            $dirFile['image'] = 'unknown.png';
        }
    }

    $smarty -> assign("T_FILES", $dirFiles);

} catch (Exception $e) {
    $message      = $e -> getMessage();
    $message_type = 'failure';
}

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);
$smarty -> assign("T_OFFSET", $offset);

$smarty -> display("browse.tpl");
?>