<?php
/**
* Import / export data
* 
* This page is used to import and export content from the platform
*
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

//eF_printHeader(); 
//error_reporting(E_ALL);
//$db->debug=true;
//echo "<pre>";print_r($_POST);print_r($_GET);print_r($_FILES);echo "</pre>";

if (isset($_GET['close'])) {                                                                                    //must this window close?
    print '<SCRIPT LANGUAGE="JavaScript">self.opener.location.reload(); window.close();</script>';
}

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "professor") {                           //Only a professor may access this page
    header("location:index.php");
    exit;
}


if (isset($_GET['op']) && $_GET['op'] == "export") {
    if (!isset($_GET['lessons_ID']) || !($lessons_ID = eF_checkParameter($_GET['lessons_ID'], 'id'))) {
        eF_printMessage(_LESSONNOTSET);
        exit;
    }

  if (isset($_POST['submit_export_settings'])) {

    $lesson  = eF_getTableData("lessons", "options,info,metadata,name", "id=$lessons_ID");
    $data['lessons'] = $lesson;  //added in v3 to export lessons parameters too....
    $smarty -> assign("T_LESSON_NAME", $lesson[0]['name']);
    $content = eF_getTableData("content", "*", "lessons_ID=$lessons_ID");
    if (sizeof($content) > 0) {
        for ($i = 0; $i < sizeof($content); $i++) {
            $content[$i]['data'] = str_replace(G_SERVERNAME, "##SERVERNAME##", $content[$i]['data']);
            $content[$i]['data'] = str_replace("content/lessons/".$lessons_ID, "##LESSONSLINK##", $content[$i]['data']);
        }
        $content_list    = eF_makeListIDs($content);
        $data['content'] = $content;

        $questions = eF_getTableData("questions", "*", "content_ID IN ($content_list)");
        if (sizeof($questions) > 0) {
            for ($i = 0; $i < sizeof($questions); $i++) {
                $questions[$i]['text'] = str_replace(G_SERVERNAME, "##SERVERNAME##", $questions[$i]['text']);
                $questions[$i]['text'] = str_replace("content/lessons/".$lessons_ID, "##LESSONSLINK##", $questions[$i]['text']);
            }
            $data['questions'] = $questions;
        }
        
        
        $tests = eF_getTableData("tests", "*", "content_ID IN ($content_list)");
        if (sizeof($tests)) {
            $tests_list         = eF_makeListIDs($tests);
            $tests_to_questions = eF_getTableData("tests_to_questions", "*", "tests_ID IN ($tests_list)");
            for ($i = 0; $i < sizeof($tests); $i++) {
                $tests[$i]['description'] = str_replace(G_SERVERNAME, "##SERVERNAME##", $tests[$i]['description']);
                $tests[$i]['description'] = str_replace("content/lessons/".$lessons_ID, "##LESSONSLINK##", $tests[$i]['description']);
            }
            
            $data['tests']      = $tests;
            $data['tests_to_questions'] = $tests_to_questions;
        }
        if (isset($_POST['export_rules'])) {
            $rules = eF_getTableData("rules", "*", "content_ID IN ($content_list)");
            if (sizeof($rules) > 0) {
                $data['rules'] = $rules;    
            }
        }
        if (isset($_POST['export_comments'])) {
            $comments = eF_getTableData("comments", "*", "content_ID IN ($content_list)");
            if (sizeof($comments) > 0) {
                $data['comments'] = $comments;  
            }
        }       
    
    }
    if (isset($_POST['export_periods'])) {
        $periods = eF_getTableData("periods", "*", "lessons_ID=$lessons_ID");
        if (sizeof($periods) > 0) {
            $periods_list    = eF_makeListIDs($periods);
            $current_content = eF_getTableData("current_content", "*", "periods_ID IN ($periods_list)");
            $data['periods'] = $periods;
            $data['current_content'] = $current_content;
        }
    }
    if (isset($_POST['export_calendar'])) {
        $calendar = eF_getTableData("calendar", "*", "lessons_ID=$lessons_ID");
        if (sizeof($calendar) > 0) {
            $data['calendar'] = $calendar;
        }
    }   
    
    if (isset($_POST['export_glossary'])) {
        $glossary_words = eF_getTableData("glossary_words", "*", "lessons_ID=$lessons_ID");
        if (sizeof($glossary_words) > 0) {
            $data['glossary_words'] = $glossary_words;  
        }
    }

    if (isset($_POST['export_announcements'])) {
        $news = eF_getTableData("news", "*", "lessons_ID=$lessons_ID");
        if (sizeof($news) > 0) {
            $data['news'] = $news;  
        }
    }
    
    if (isset($_POST['export_surveys'])) {
        $surveys = eF_getTableData("surveys", "*", "lessons_ID=$lessons_ID");   //prepei na ginei to   lesson_ID -> lessons_ID sti basi (ayto isos to parampsoyme eykola)
        if (sizeof($surveys) > 0) {
            $data['surveys'] = $surveys; 
            $surveys_list    = eF_makeListIDs($surveys);

            $questions_to_surveys = eF_getTableData("questions_to_surveys", "*", "surveys_ID IN ($surveys_list)");  // oposipote omos to survey_ID -> surveys_ID sti basi
            if (sizeof($questions_to_surveys) > 0) {
                $data['questions_to_surveys'] = $questions_to_surveys;  
            }
        }
    }    

    $lesson_conditions = eF_getTableData("lesson_conditions", "*", "lessons_ID=$lessons_ID");
    if (sizeof($lesson_conditions) > 0) {
        $data['lesson_conditions'] = $lesson_conditions;  
    }
    
    $projects = eF_getTableData("projects", "*", "lessons_ID=$lessons_ID");
    if (sizeof($projects) > 0) {
        $data['projects'] = $projects;  
    }

    
//print_r($data['periods']);   
//print_r($data['rules']); exit; 

    // file to store tha database data
    $filedata = serialize($data);
    $filename = G_LESSONSPATH.$lessons_ID.'/'."data.dat";
    $fp       = fopen($filename, "w");
    fwrite($fp, $filedata);
    fclose($fp);

    // tar to be downloaded
    $dir = G_LESSONSPATH.$lessons_ID.'/';
    if (is_file($dir."data.tar.gz")) {
        unlink($dir."data.tar.gz");
    }
    $filelist = eF_getDirContents($dir);
    $tarname  = G_LESSONSPATH.$lessons_ID."/data.tar.gz";
    $tar      = new Archive_Tar($tarname, true);
    $tar -> createModify($filelist, "", G_LESSONSPATH.$_SESSION['s_lessons_ID']);
    unlink($filename);
  }
    $smarty -> assign("T_LESSONS_ID", $lessons_ID);
    
} elseif(isset($_GET['op']) && $_GET['op'] == "import") {

    if (isset($_POST['submit'])) {
//print_r($_POST);exit;
        if (!isset($_POST['lessons_ID']) || !($lessons_ID = eF_checkParameter($_POST['lessons_ID'], 'id'))) {
            eF_printMessage(_LESSONNOTSET);
            exit;
        }

        if (!($lessons_ID = eF_checkParameter($_POST['lessons_ID'], 'id'))) {
            eF_printMessage(_INVALIDID);
            eF_printBackButton();
            exit;
        }

        if (isset($_POST['delete_files'])) {  //added in v3. professor can choose to delete previous files of lesson during import
             eF_deleteFolder(G_LESSONSPATH.$lessons_ID."/");
             mkdir(G_LESSONSPATH.$lessons_ID,0755,true);                      
        }


        list($ok, $upload_messages, $upload_messages_type, $filename) = eF_handleUploads('fileupload', G_LESSONSPATH.$lessons_ID);      
        
        if (isset($ok) && $ok) {
            if (G_ENABLE_CACHE && sizeof(eF_getTableData("cache", "*", "name='".$_SESSION['s_lessons_ID']."_contentTree'"))) {
                eF_updateTableData("cache", array('expired' => 1), "name='".$_SESSION['s_lessons_ID']."_contentTree'");
            } 
         
            $content = eF_getTableData("content", "*", "lessons_ID=$lessons_ID");
            if (sizeof($content) > 0) {
                $content_list    = eF_makeListIDs($content);
                if (isset($_POST['delete_comments'])) {          
                    eF_deleteTableData("comments","content_ID IN ($content_list)");
                }
                if (isset($_POST['delete_rules'])) {
                    eF_deleteTableData("rules","content_ID IN ($content_list)");
                    eF_deleteTableData("lesson_conditions","lessons_ID=$lessons_ID");
                }
                if (isset($_POST['delete_content'])) {
                    foreach ($content as $value) {
                        eF_deleteUnit($value['id']);

/*
                        eF_deleteTableData("questions", "content_ID IN ($content_list)");


                        $tests = eF_getTableData("tests", "*", "content_ID IN ($content_list)");
                        if (sizeof($tests)) {
                            $tests_list         = eF_makeListIDs($tests);
                            eF_deleteTableData("tests_to_questions","tests_ID IN ($tests_list)");
                            eF_deleteTableData("tests", "content_ID IN ($content_list)");

                        }
*/
                    }                
                }           
            }
            eF_deleteTableData("content", "lessons_ID=$lessons_ID");                                    //Just make sure everything is deleted

            if (isset($_POST['delete_calendar'])) {
                 eF_deleteTableData("calendar","lessons_ID=$lessons_ID");
            }
            
            if (isset($_POST['delete_periods'])) {
                 eF_deleteTableData("periods","lessons_ID=$lessons_ID");
            }       
            if (isset($_POST['delete_announcements'])) {
                 eF_deleteTableData("news","lessons_ID=$lessons_ID");
            }               
            if (isset($_POST['delete_glossary'])) {
                 eF_deleteTableData("glossary_words","lessons_ID=$lessons_ID");
            }   
            if (isset($_POST['delete_surveys'])) {
                $surveys = eF_getTableData("surveys", "id", "lessons_ID=$lessons_ID");
                for ($i = 0; $i < sizeof($surveys); $i++) {
                    eF_deleteTableData("questions_to_surveys",  "surveys_ID=".$surveys[$i]['id']);
                    eF_deleteTableData("survey_questions_done", "surveys_ID=".$surveys[$i]['id']);
                    eF_deleteTableData("users_to_surveys",      "surveys_ID=".$surveys[$i]['id']);
                    eF_deleteTableData("users_to_done_surveys", "surveys_ID=".$surveys[$i]['id']);
                }
                eF_deleteTableData("surveys", "lessons_ID=".$lessons_ID);
            }   
         
            $tar      = new Archive_Tar($filename[0], true);
            $tar -> extract(G_LESSONSPATH.$lessons_ID.'/');
            $tarContents = $tar -> listContent();
            foreach ($tarContents as $entry) {
                $filesList[] = G_LESSONSPATH.$lessons_ID.'/'.$entry['filename'];
            }
            EfrontFileSystem :: convert($filesList);
            unlink($filename[0]);

            $filename = G_LESSONSPATH.$lessons_ID."/data.dat";
            $filedata = file_get_contents($filename);
            unlink($filename);

            $data = unserialize($filedata);
            $data['content'] = eF_local_fixTree($data['content'], $last_current_node);

            $last_current_node = 0;
            $existing_tree     = eF_getContentTree($nouse, $lessons_ID, 0, false, false);
            if (sizeof($existing_tree) > 0) {
                $last_current_node = $existing_tree[sizeof($existing_tree) - 1]['id'];
                $first_node        = eF_local_getTreeFirstChild($data['content']);
                
                $data['content'][$first_node]['previous_content_ID'] = $last_current_node;
            }
//echo "<pre>"; 
//echo $last_current_node;
//exit;

            foreach ($data as $table => $tabledata) {
                if ($table == "lessons") { //from v3 lessons parameters also imported
                     eF_updateTableData("lessons", array(   'info'      => $data['lessons'][0]['info'],
                                                            'metadata'  => $data['lessons'][0]['metadata'],
                                                            'options'   => $data['lessons'][0]['options'],
                                                              ), "id=$lessons_ID"); 
                } else {
                    for ($i = 0; $i < sizeof($tabledata); $i++) {
                        $sql = "INSERT INTO ".$table." SET ";
                        $connector = "";
                        foreach ($tabledata[$i] as $key => $value) {
                            if ($key == "id") {
                                $old_id = $value;
                            } else {
                                if (($table == "content" AND $key == "data") || ($table == "questions" AND $key == "text") || ($table == "tests" AND $key == "description")) {
                                    $value = str_replace("##SERVERNAME##", G_SERVERNAME, $value);
                                    $value = str_replace("##LESSONSLINK##", "content/lessons/".$lessons_ID, $value);
                                    $content_data = $value;
                                }
                                elseif ($key == "lessons_ID") {
                                    $value = $lessons_ID;    
                                }elseif ($table == "lesson_conditions" AND $key == "options") {
                                    if (mb_strpos($data['lesson_conditions'][$i]['type'], "specific") === false){
                                        
                                    }else{
                                        $options = unserialize($data['lesson_conditions'][$i]['options']);
                                        $options[0] = $map['content'][$options[0]];
                                        $value = serialize($options);
                                            
                                    }
                            
                                } 
                                elseif ($table != "content" AND mb_substr($key, -3) == "_ID") {
                                    $from_table = mb_substr($key, 0, -3);
                                    if (isset($map[$from_table][$value])) {
                                        $value = $map[$from_table][$value];
                                    }
                                }
                                // Gia na einai simvato me palia DB
                                if (!($table == "content" AND $key == "format")) {
                                    $sql .= $connector.$key."='".str_replace("'","''",$value)."'";
                                    $connector = ", ";
                                }
                                if ($table == "content" AND $key == "name") {
                                    $content_name = $value;
                                }
                            }
                        }
                        //echo $sql."<br>";
                        eF_execute($sql);
                        $new_id = mysql_insert_id();
                        if ($table == "content") {
							EfrontSearch :: insertText($content_name, $new_id, "content", "title");
							EfrontSearch :: insertText(strip_tags($content_data), $new_id, "content", "data");

                        }
                        $map[$table][$old_id] = $new_id;
                    }
                }
            }

            if ($data['content']) {
                foreach($map['content'] as $old_id => $new_id) {
                    //eF_execute("UPDATE content SET parent_content_ID=$new_id WHERE parent_content_ID=$old_id AND lessons_ID=$lessons_ID");
                    eF_updateTableData("content", array('parent_content_ID' => $new_id), "parent_content_ID=$old_id AND lessons_ID=$lessons_ID");
                    //eF_execute("UPDATE content SET previous_content_ID=$new_id WHERE previous_content_ID=$old_id AND lessons_ID=$lessons_ID");
                    eF_updateTableData("content", array('previous_content_ID' => $new_id), "previous_content_ID=$old_id AND lessons_ID=$lessons_ID");
                }
            }
            if ($data['rules']) {
                foreach($map['content'] as $old_id => $new_id) {
                    eF_updateTableData("rules", array('rule_content_ID' => $new_id), "rule_content_ID=$old_id");
                }
            }

            if ($data['questions']) {
                foreach($map['questions'] as $old_id => $new_id) {
                    eF_updateTableData("tests_to_questions", array('previous_question_ID' => $new_id), "previous_question_ID=$old_id");
                }
            }
            
        /*  if ($data['questions_to_surveys']) {
                foreach($map['questions_to_surveys'] as $old_id => $new_id) {
                    eF_updateTableData("questions_to_surveys", array('father_ID' => $new_id), "father_ID=$old_id");
                }
            } NO */
            
            
            foreach($map['content'] as $old_id => $new_id){  //needs debugging
                $content_new_IDs[] = $new_id;
            }
            $content_new_IDs_list = implode(",",$content_new_IDs);
           
            $content_data  = eF_getTableData("content", "data,id", "id IN ($content_new_IDs_list) AND lessons_ID=$lessons_ID AND data like '%##EFRONTINNERLINK##%'");
            for($i =0; $i < sizeof($content_data); $i++) {
            
                $ok = ereg ("[##EFRONTINNERLINK##.php?ctg=content&amp;view_unit=]([0-9]+)", $content_data[$i]['data'], $regs);
                $replaced   = str_replace("##EFRONTINNERLINK##.php?ctg=content&amp;view_unit=".$regs[1],"##EFRONTINNERLINK##.php?ctg=content&amp;view_unit=".$map["content"][$regs[1]], $content_data[$i]['data']);
                eF_updateTableData("content", array('data' => $replaced), "id=".$content_data[$i]['id']);
            
            }
           
            $message      = _SUCCESFULLYINSERTEDDATACLOSE5SECONDS;
            $message_type = 'success';
            $smarty -> assign("T_FINISH", true);
        
        }
        
    } else {
        if (!isset($_GET['lessons_ID']) || !($lessons_ID = eF_checkParameter($_GET['lessons_ID'], 'id'))) {
            eF_printMessage(_LESSONNOTSET."<br>(Check ini settings)");
            exit;
        }

        $smarty -> assign("T_LESSONS_ID", $lessons_ID);
    }
}

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display('import_export.tpl');


/**
Problem: There may be multiple units with previous_content_ID = 0. This was allowed by the data scheme of efront 1, but is not allowed by 
efront 2.
Solution: Repair content order such there is only a single unit with previous content 0.
Algorithm: 
1. Find all the units, which have parent and previous content 0. (only top units, with parent_content_ID = 0, may have previous_content_ID 0 as well.)
2. For these units, get the last node of their subtrees. For example, for a unit structure like:
    3
     3.1
     3.2
      3.2.1
      3.2.2
     3.3
      3.3.1
   the last unit is 3.3.1
3. Get the creation timestamps of these units
4. Sort these units by their timestamps. This way, units that all have previous unit 0, will be put in order according to their creation timestamp.
5. For each of these units, starting with the second oldest, set its previous unit to be the last unit of the older one.

* @version 1.0
* 31/10/2005
*/
function eF_local_fixTree($tree, $last_current_node = 0)
{
    for ($i = 0; $i < sizeof($tree); $i++) {
        if ($tree[$i]['parent_content_ID'] == 0) {
            $roots[$i] = $tree[$i];
            $roots[$i]['idx'] = $i;
        }
    }
    
    foreach ($roots as $key => $node) {
        $roots[$key]['last_child'] = eF_local_getLastChild($tree, $key);
        if ($node['previous_content_ID'] == 0 && $node['parent_content_ID'] == 0) {
            $eligible[] = $roots[$key];
        }
    }

    foreach ($eligible as $key => $node) {
        $timestamps[] = $node['timestamp'];
        $found = true;
        $temp = $roots;

        $eligible[$key]['final_child'] = $node['last_child'];
        while (sizeof($temp) > 0 && $found) {
            $found = false;
            foreach ($temp as $temp_key => $temp_node) {
                if ($eligible[$key]['final_child'] == $temp_node['previous_content_ID']) {
                    $eligible[$key]['final_child'] = $temp_node['last_child'];
                    unset($temp[$temp_key]);

                    $found = true;
                }
            }
        }
    }

    array_multisort($timestamps, SORT_ASC, $eligible);

    for ($i = 0; $i < sizeof($eligible); $i++) {
        if ($i < sizeof($eligible) - 1) {
            $eligible[$i + 1]['previous_content_ID'] = $eligible[$i]['final_child'];
        }
        unset($eligible[$i]['last_child']);
        unset($eligible[$i]['final_child']);
        $idx = $eligible[$i]['idx'];
        unset($eligible[$i]['idx']);
        $tree[$idx] = $eligible[$i];
    }
    
    return $tree;
}

/**
*
*/
function eF_local_getLastChild($tree, $idx) {
    $original_tree = $tree;

    $count = 0;
    $children[$idx] = $tree[$idx]['id'];
    $found = true;
    while (sizeof($tree) > 0 && $count++ < 1000 && $found) {
        $found = false;
        foreach ($tree as $key => $node) {
            if (in_array($node['parent_content_ID'], $children)) {
                $children[$key] = $node['id'];
                unset($tree[$key]);
                $found = true;
            }
        }
    }

    foreach ($children as $key => $child) {
        $previous[] = $original_tree[$key]['previous_content_ID'];
    }

    $last = (array_diff($children, $previous));
    $last = array_values($last);

    return $last[0];
}

/**
*
*/
function eF_local_getTreeLastChild($tree)
{
    for ($i = 0; $i < sizeof($tree); $i++) {
        $previous[] = $tree[$i]['previous_content_ID'];
        $id[] = $tree[$i]['id'];
    }
    
    $last_node = array_values(array_diff($id, $previous));
    return $last_node[0];
}

function eF_local_getTreeFirstChild($tree)
{
    $count = 0;
    while ($tree[$count]['parent_content_ID'] != 0 || $tree[$count]['previous_content_ID'] != 0)
    {
        $count++;
    }
    
    $first_node = $count;
    return $first_node;    
}

?>


