<?php
/**
* Professor main page
*
* This page performs all professor functions
* @package efront
* @version 1.0
*/
$debug_TimeStart = microtime(true);     //Debugging timer - initialization

session_cache_limiter('none');          //Initialize session
session_start();

$path = "../libraries/";                //Define default path

/** The configuration file.*/
require_once $path."configuration.php";
$debug_InitTime = microtime(true) - $debug_TimeStart;       //Debugging timer - time spent on file inclusion
//error_reporting(E_ALL);
//Set headers in order to eliminate browser cache (especially IE's)
header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past

//If the page is shown as a popup, make sure it remains in such mode
if (isset($_GET['popup']) || isset($_POST['popup']) || (strpos(strtolower($_SERVER['HTTP_REFERER']), 'popup') != false && !strpos(strtolower($_SERVER['HTTP_REFERER']), 'evaluation'))) {
    output_add_rewrite_var('popup', 1);
    $smarty -> assign("T_POPUP_MODE", true);
    $popup = 1;
}


$message = '';$message_type = '';                            //Initialize messages, because if register_globals is turned on, some messages will be displayed twice
$loadScripts = array('EfrontScripts', 'scriptaculous/prototype');

/*Check the user type. If the user is not valid or not an administrator, he cannot access this page, so exit*/
if (isset($_SESSION['s_login']) && $_SESSION['s_password']) {
    try {
        $currentUser = EfrontUserFactory :: factory($_SESSION['s_login']);
/*
        if ($currentUser -> user['user_type'] != 'professor') {
            header("location:index.php?message=".urlencode(_YOUCANNOTACCESSTHISPAGE)."&message_type=failure");
            exit;
        }
*/
    } catch (EfrontException $e) {
        $message = $e -> getMessage().' ('.$e -> getCode().')';
        header("location:index.php?message=".urlencode($message)."&message_type=failure");
        exit;
    }
} else {
    header("location:index.php?message=".urlencode(_YOUCANNOTACCESSTHISPAGE)."&message_type=failure");
    exit;
}

/*This is the first time the professor enters this lesson, so register the lesson id to the session*/
if (isset($_GET['lessons_ID']) && eF_checkParameter($_GET['lessons_ID'], 'id') && (!isset($_SESSION['s_lessons_ID']) || $_GET['lessons_ID'] != $_SESSION['s_lessons_ID'])) {
    $userLessons = $currentUser -> getLessons();
    if (in_array($_GET['lessons_ID'], array_keys($userLessons))) {
        $_SESSION['s_lessons_ID'] = $_GET['lessons_ID'];
        $_SESSION['s_type']       = $userLessons[$_GET['lessons_ID']];

        $smarty -> assign("T_CHANGE_LESSON", "true");
        $smarty -> assign("T_REFRESH_SIDE", "true");
        //eF_setLessonParameters();    //@todo remove
        //eF_setRoleParameters();      //@todo remove

    } else {
        unset($_GET['lessons_ID']);
        $message      = _YOUCANNOTACCESSTHISLESSONORITDOESNOTEXIST;
        $message_type = 'failure';
        $ctg          = 'personal';
    }
}

if (isset($_SESSION['s_lessons_ID']) && $_SESSION['s_lessons_ID'] && in_array($_SESSION['s_lessons_ID'], array_keys($currentUser -> getLessons()))) {    //Check validity of current lesson
    try {
        $currentLesson  = new EfrontLesson($_SESSION['s_lessons_ID']);                //Initialize lesson
        $smarty -> assign("T_TITLE_BAR", $currentLesson -> lesson['name']);

    } catch (Exception $e) {
        unset($_SESSION['s_lessons_ID']);
        $message = $e -> getMessage().' ('.$e -> getCode().')';
        header("location:".$_SERVER['PHP_SELF']."?message=".urlencode($message)."&message_type=failure");    //redirect to user lessons page
    }
    try {
        $currentContent = new EfrontContentTree($_SESSION['s_lessons_ID']);           //Initialize content
        $currentUser    -> applyRoleOptions($_SESSION['s_lessons_ID']);                //Initialize user's role options for this lesson
    } catch (Exception $e) {
        $message = _ERRORLOADINGCONTENT.": ".$_SESSION['s_lessons_ID'].": ".$e -> getMessage().' ('.$e -> getCode().')';
    }
}
/*Check current unit*/
if (isset($_GET['view_unit']) && eF_checkParameter($_GET['view_unit'], 'id')) {
    try {
        $currentUnit = $currentContent -> seekNode($_GET['view_unit']);              //Initialize current unit
        $currentUnit['ctg_type'] == 'tests' ? $_GET['ctg'] = 'tests' : $_GET['ctg'] = 'content';
    } catch (Exception $e) {
        unset($_GET['view_unit']);
        $message      = $e -> getMessage().'( '.$e -> getCode().')';
        $message_type = 'failure';
    }
}

// Share the hcd value with smarty
$module_hcd_interface = MODULE_HCD_INTERFACE;
$smarty -> assign("T_MODULE_HCD_INTERFACE", $module_hcd_interface);

/*Added Session variable for search results*/
$_SESSION['referer'] = $_SERVER['REQUEST_URI'];

/*Derive installed modules*/
$modules     = eF_getTableData("modules", "*", "active=1");
$module_ctgs = array();
foreach ($modules as $key => $module) {
    $permissions = explode(",", $module['permissions']);
    if (!in_array('professor', $permissions)) {                         //Remove modules not applicable to this user type
        unset($modules[$key]);
    } else {
        $module_ctgs[$module['name']] = $module['title'];
    }
}
$smarty -> assign("T_MODULES", $module_ctgs);

/*These are the possible ctg we can have. - The three last added by HCD */
$possible_ctgs = array('control_panel', 'content', 'scheduling', 'tests', 'rules', 'calendar',
                       'statistics', 'survey', 'glossary', 'settings', 'lessons', 'personal',
                       'projects','module_hcd', 'users','emails','evaluations');
if (sizeof($module_ctgs) > 0) {
    $possible_ctgs = array_merge($possible_ctgs, array_keys($module_ctgs));
}
!isset($_GET['ctg']) || !in_array($_GET['ctg'], $possible_ctgs)  ? $ctg = "control_panel" : $ctg = $_GET['ctg'];    //The default ctg is 'control_panel'

if (!$_SESSION['s_lessons_ID'] && $ctg != 'personal' && $ctg != 'statistics' && ($ctg == 'control_panel' && $_GET['op'] != "search")) {       //If there is not a lesson in the session, then the user just logged into the system. Redirect him to lessons page, except for the case he is viewing his personal information 2007/07/27 added search control. It was a problem when user had not choose a lesson.
    $ctg = 'lessons';
}

$smarty -> assign("T_CTG", $ctg);       //As soon as we derive the current ctg, assign it to smarty.
$smarty -> assign("T_OP", $_GET['op']);

/*
Control panel is the first page that the professor sees, and contains links to most of the available functions
At the control panel main page, you will find 7 sections:
- A Settings list, with icons representing available functions
- Lesson announcements
- Recent forum messages
- Recent personal messages
- A list with test questions that need to be corrected
- Recent comments
- The calendar
*/
if ($ctg == 'control_panel') {
    $loadScripts[] = 'scriptaculous/scriptaculous';
    /*
    Insert a record into the logs table, if a lesson has been selected
    */
    if (isset($_SESSION['s_lessons_ID'])) {
        $fields_log = array ('users_LOGIN' => $_SESSION['s_login'],                                 //This is the log entry array
                             'timestamp'   => time(),
                             'action'      => 'lesson',
                             'comments'    => 0,
                             'session_ip'  => eF_encodeIP($_SERVER['REMOTE_ADDR']),
                             'lessons_ID'  => $_SESSION['s_lessons_ID']);
        eF_deleteTableData("logs", "users_LOGIN='".$_SESSION['s_login']."' AND action='lastmove'"); //Only one lastmove action interests us, so delete any other
        eF_insertTableData("logs", $fields_log);
    }


    /*
    SCORM related functions
    */
    if (isset($_GET['op']) && $_GET['op'] == 'scorm') {
        $loadScripts[] = 'drag-drop-folder-tree';
        
        $options = array(array('image' => !$_GET['scorm_review'] ? '16x16/document_text.png' : '16x16/document_text_gray.png', 'title' => _SCORMREVIEW, 'link' => !$_GET['scorm_review'] ? $_SERVER['PHP_SELF'].'?ctg=control_panel&op=scorm&scorm_review=1' : 'javascript:void(0)', 'class' => !$_GET['scorm_review'] ? null : 'inactiveLink'),
                         array('image' => !$_GET['scorm_import'] ? '16x16/import1.png'       : '16x16/import1_gray.png',       'title' => _SCORMIMPORT, 'link' => !$_GET['scorm_import'] ? $_SERVER['PHP_SELF'].'?ctg=control_panel&op=scorm&scorm_import=1' : 'javascript:void(0)', 'class' => !$_GET['scorm_import'] ? null : 'inactiveLink'),
                         //array('image' => !$_GET['scorm_export'] ? '16x16/export1.png'       : '16x16/export1_gray.png', 	   'title' => _SCORMEXPORT, 'link' => !$_GET['scorm_export'] ? $_SERVER['PHP_SELF'].'?ctg=control_panel&op=scorm&scorm_export=1' : 'javascript:void(0)', 'class' => !$_GET['scorm_export'] ? null : 'inactiveLink')
                         );
        $smarty -> assign("T_TABLE_OPTIONS", $options);

        if ($_GET['scorm_review']) {
            $iterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('ctg_type' => 'scorm'));
            foreach ($iterator as $key => $value) {
                $scormContentIds[] = $key;
            }
            $scormData = eF_getTableData("scorm_data, content", "scorm_data.*, content.name as content_name", "scorm_data.users_LOGIN != '' and scorm_data.content_ID IN (".implode(",", $scormContentIds).") and content_ID=content.id");
            $smarty -> assign("T_SCORM_DATA", $scormData);
        } else if ($_GET['scorm_import']) {
            $form = new HTML_QuickForm("upload_scorm_form", "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=scorm&scorm_import=1', "", null, true);
            $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter

            $form -> addElement('file', 'scorm_file', _SCORMFILEINZIPFORMAT);
            $form -> addElement('submit', 'submit_upload_scorm', _SUBMIT, 'class = "flatButton"');
            $smarty -> assign("T_MAX_UPLOAD_SIZE", EfrontFileSystem :: getUploadMaxSize());

            
            
            $timestamp       = time();
            $lessons_ID = $currentLesson -> lesson['id'];            
            if ($form -> isSubmitted() && $form -> validate()) {
                try {
                    //$directory  = $currentLesson -> getDirectory(true);
                    $filesystem = new FileSystemTree(G_SCORMPATH); 
                    $scormFile  = $filesystem -> uploadFile('scorm_file', G_SCORMPATH);
                    $fileList   = $scormFile -> uncompress();


                    $total_fields = array();
                    $resources    = array();
                    $tagArray     = @eF_local_parseManifest(G_SCORMPATH);
        
                    foreach($tagArray as $key => $value) {                                                                      //     imsmanifest
                        $fields = array();
                        switch ($value['tag']) {
                            case 'TITLE':
                                $cur = $value['parent_index'];
                                $total_fields[$cur]['name'] = $value['value'];
                                break;
        
                            case 'ITEM':
                                $total_fields[$key]['lessons_ID'] = $lessons_ID;
                                $total_fields[$key]['timestamp']  = time();
                                $total_fields[$key]['ctg_type']   = 'scorm';
                                $total_fields[$key]['active']     = 1;
                                $references[$key] = $value['attributes']['IDENTIFIERREF'];
                                break;
        
                            case 'RESOURCE':
                                $resources[$key] = $value['attributes']['IDENTIFIER'];
                                break;
        
                            case 'FILE':
                                $files[$key] = $value['attributes']['HREF'];
                                break;
        
                            case 'ADLCP:MAXTIMEALLOWED':
                                $maxtimeallowed[$key]  = $value['value'];
                                break;
                            case 'ADLCP:TIMELIMITACTION':
                                $timelimitaction[$key] = $value['value'];
                                break;
                            case 'ADLCP:MASTERYSCORE':
                                $masteryscore[$key]    = $value['value'];
                                break;
                            case 'ADLCP:DATAFROMLMS':
                                $datafromlms[$key]     = $value['value'];
                                break;
        
                            case 'ADLCP:PREREQUISITES':
                                $prerequisites[$key]   = $value['value'];
                                break;              
        
                            default:
                                break;
                        }
                    }
        
        
                    foreach ($references as $key => $value) {
                        $ref = array_search($value, $resources);
                        if ($ref) {
                            $data = file_get_contents(G_SCORMPATH."/".$tagArray[$ref]['attributes']['HREF']);
        
                            $primitive_hrefs[$ref] = $tagArray[$ref]['attributes']['HREF'];
                            $path_part[$ref]       = dirname($primitive_hrefs[$ref]);
        
                            foreach($tagArray[$ref]['children'] as $value2) {
                                if ($tagArray[$value2]['tag'] == 'DEPENDENCY') {
                                    $idx = array_search($tagArray[$value2]['attributes']['IDENTIFIERREF'], $resources);
        
                                    foreach ($tagArray[$idx]['children'] as $value3) {
                                        if ($tagArray[$value3]['tag'] == 'FILE')  {
                                            $data = preg_replace("#(\.\.\/(\w+\/)*)?".$tagArray[$value3]['attributes']['HREF']."#", G_LESSONSPATH.$lessons_ID."/".$path_part[$ref]."/$1".$tagArray[$value3]['attributes']['HREF'], $data);
                                        }
                                    }
                                }
                            }
                            //$total_fields[$key]['data'] = eF_postProcess(str_replace("'","&#039;",$data));      //               iframes ( 1  2)
                            $total_fields[$key]['data'] = '<iframe height = "100%"  width = "100%" frameborder = "no" name = "scormFrameName" id = "scormFrameID" src = "'.G_RELATIVELESSONSLINK.$lessons_ID."/".$primitive_hrefs[$ref].'" onload = "eF_js_setCorrectIframeSize()"></iframe><iframe name = "commitFrame" frameborder = "no" id = "commitFrame" width = "1" height = "1" style = "display:none"></iframe>';
                        }
                    }
        
                    //$tree = eF_getContentTree($nouse, $lessons_ID, 0, false, false);        //Get the content tree, so that we may append the imported content to the last unit.
                    $lastUnit = $currentContent -> getLastNode();
                    $this_id = $lastUnit['id'];
                    //$this_id = $tree[sizeof($tree) - 1]['id'];
                    foreach ($total_fields as $key => $value)  {
                        if (isset($value['ctg_type']))  {
                            $total_fields[$key]['previous_content_ID'] = $this_id;
        
                            if (!isset($total_fields[$key]['parent_content_ID'])) {
                                $total_fields[$key]['parent_content_ID'] = 0;
                            }
        
                            $this_id = eF_insertTableData("content", $total_fields[$key]);
        
                            $tagArray[$key]['this_id'] = $this_id;
                            foreach($tagArray[$key]['children'] as $key2 => $value2) {
                                if (isset($total_fields[$value2])) {
                                    $total_fields[$value2]['parent_content_ID'] = $this_id;
                                }
                            }
                        } else  {                                                                                       // ,      array (..  organizations     ...) 
                            unset($total_fields[$key]);
                        }
                    }
        
                    eF_local_buildDirectories(G_LESSONSPATH.$lessons_ID."/", G_SCORMPATH);
        
                    foreach ($files as $key => $value) {
                            $newhref = $tagArray[$tagArray[$key]['parent_index']]['attributes']['XML:BASE'];
                            copy(G_SCORMPATH."/".trim($newhref,"/")."/".trim($value,"/"), G_LESSONSPATH.$lessons_ID."/".trim($newhref,"/")."/".trim($value,"/"));
                    }
        
                    $cur_dir = getcwd();
                    chdir(G_SCORMPATH);
                    $filelist = eF_getDirContents();
                    foreach ($filelist as $value) {
                        copy($value, G_LESSONSPATH.$lessons_ID."/".$value);
                    }
                    chdir($cur_dir);
        
                    foreach ($timelimitaction as $key => $value) {
                        $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];
        
                        $fields_insert[$content_ID]['content_ID']      = $content_ID;
                        $fields_insert[$content_ID]['timelimitaction'] = $value;
                    }
                    foreach ($maxtimeallowed as $key => $value) {
                        $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];
        
                        $fields_insert[$content_ID]['content_ID']     = $content_ID;
                        $fields_insert[$content_ID]['maxtimeallowed'] = $value;
                    }
                    foreach ($masteryscore as $key => $value) {
                        $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];
        
                        $fields_insert[$content_ID]['content_ID']   = $content_ID;
                        $fields_insert[$content_ID]['masteryscore'] = $value;
                    }
                    foreach ($datafromlms as $key => $value) {
                        $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];
        
                        $fields_insert[$content_ID]['content_ID']  = $content_ID;
                        $fields_insert[$content_ID]['datafromlms'] = $value;
                    }
        
                    foreach ($fields_insert as $value) {
                        eF_insertTableData("scorm_data", $value);
                    }
        
        
                    foreach ($prerequisites as $key => $value) {
                        foreach ($tagArray as $key2 => $value2) {
                            if (isset($value2['attributes']['IDENTIFIER']) && $value2['attributes']['IDENTIFIER'] == $value) {
                                unset($fields_insert);
                                $fields_insert['users_LOGIN'] = "*";
                                $fields_insert['content_ID']  = $tagArray[$tagArray[$key]['parent_index']]['this_id'];
                                $fields_insert['rule_type']   = "hasnot_seen";
                                $fields_insert['rule_content_ID'] = $value2['this_id'];
                                $fields_insert['rule_option'] = 0;
                                eF_insertTableData("rules", $fields_insert);
                            }
                        }
                    }
        

                    
                    
                    
                    
                } catch (EfrontFileException $e) {
                    $message      = $e -> getMessage();
                    $message_type = failure;
                }
            }
            $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
            $form -> accept($renderer);
    
            $smarty -> assign('T_UPLOAD_SCORM_FORM', $renderer -> toArray());            
        } else if ($_GET['scorm_export']) {
            $form = new HTML_QuickForm("export_scorm_form", "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=scorm&scorm_export=1', "", null, true);
            $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter
            $form -> addElement('submit', 'submit_export_scorm', _EXPORT, 'class = "flatButton"');
            if ($form -> isSubmitted() && $form -> validate()) {
exit;//Doesn't work yet
                define ('SCORM_FOLDER', G_ROOTPATH."www/content/scorm_data");
                $scorm_filename = "scorm_lesson".$lessons_id.".zip";
                
                if (is_file(SCORM_FOLDER."/".$scorm_filename)) {
                    unlink(SCORM_FOLDER."/".$scorm_filename);
                }

                $lessons_id = $currentLesson -> lesson['id'];
                
                $lesson_entries = eF_getTableData("content", "id,name,data", "lessons_ID=" . $lessons_id . " and ctg_type!='tests' and active=1");
                for ($i = 0; $i < sizeof($lesson_entries); $i++) {
                    $lesson_entries[$i]['name'] = eF_makeGreeklish($lesson_entries[$i]['name']);
                }
                
                $cur_dir = getcwd();
                chdir(G_LESSONSPATH.$lessons_id.'/');
                $filelist = eF_getDirContents();
                chdir($cur_dir);
                
                create_manifest($lessons_id, $lesson_entries, $filelist);

                chdir(SCORM_FOLDER  ."/lesson/". $lessons_id);

                $d = dir("."); 
                $entries = array();
                while (false !== ($entry = $d->read())) { 
                    if ($entry != "." & $entry != "..")
                        array_push($entries, $entry); 
                } 
                $d->close(); 
                pr($entries);exit;
                $zip = new Archive_zip("../".$scorm_filename);
                $zip -> create( $entries );
                
                chdir($cur_dir);
                
                deldir(SCORM_FOLDER  ."/lesson". $lessons_id);
                
                
                
            }
            $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
            $form -> accept($renderer);
    
            $smarty -> assign('T_EXPORT_SCORM_FORM', $renderer -> toArray());            
            
        } else {
            $iterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('ctg_type' => 'scorm'));
            $smarty -> assign("T_SCORM_TREE", $currentContent -> toHTML($iterator, 'dhtmlContentTree', array('expand' => true)));
        }                

        $scormOptions[] = array('text' => _SCORMEXPORT,       'image' => "32x32/export1.png",         'href' => "scorm_export.php?lessons_ID=".$_SESSION['s_lessons_ID'], 'onClick' => "eF_js_showDivPopup('"._SCORMEXPORT."',     new Array('500px', '300px'))", 'target' => 'POPUP_FRAME');
        $scormOptions[] = array('text' => _SCORMIMPORT,       'image' => "32x32/import1.png",         'href' => "scorm_import.php?lessons_ID=".$_SESSION['s_lessons_ID'], 'onClick' => "eF_js_showDivPopup('"._SCORMIMPORT."',     new Array('500px', '300px'))", 'target' => 'POPUP_FRAME');
        $scormOptions[] = array('text' => _REVIEWSCORMDATA,   'image' => "32x32/document_text.png",   'href' => "scorm_review.php?lessons_ID=".$_SESSION['s_lessons_ID'], 'onClick' => "eF_js_showDivPopup('"._REVIEWSCORMDATA."', new Array('500px', '300px'))", 'target' => 'POPUP_FRAME');
        
    }
    /*
    Manage lesson information. There are 6 types of lesson information: General Description,
    Objectives, Assessement, Lesson Topics, Resources and Other Information. the professor may
    set whichever and as many as he wants
    */
    elseif (isset($_GET['op']) && $_GET['op'] == 'lesson_information') {
        $loadScripts[] = 'scriptaculous/scriptaculous';                            //Load effects to be used on ajax users assignment
        $loadScripts[] = 'scriptaculous/effects';
        $form = new HTML_QuickForm("empty_form", "post", null, null, null, true);
        try {
            $lessonInformation = unserialize($currentLesson -> lesson['info']);
            $information       = new LearningObjectInformation($lessonInformation);
            $smarty -> assign("T_LESSON_INFO_HTML", $information -> toHTML($form, false));

            $lessonMetadata = unserialize($currentLesson -> lesson['metadata']);
            $metadata       = new DublinCoreMetadata($lessonMetadata);
            $smarty -> assign("T_LESSON_METADATA_HTML", $metadata -> toHTML($form));
        } catch (Exception $e) {
            $message      = _SOMEPROBLEMEMERGED.': '.$e -> getMessage().' ('.$e -> getCode().')';
            $message_type = "failure";
        }

        if (isset($_GET['postAjaxRequest'])) {
            if (in_array($_GET['dc'], array_keys($information -> metadataAttributes))) {
                if ($_GET['value']) {
                    $lessonInformation[$_GET['dc']] = $_GET['value'];
                } else {
                    unset($lessonInformation[$_GET['dc']]);
                }
                $currentLesson -> lesson['info'] = serialize($lessonInformation);
            } elseif (in_array($_GET['dc'], array_keys($metadata -> metadataAttributes))) {
                if ($_GET['value']) {
                    $lessonMetadata[$_GET['dc']] = $_GET['value'];
                } else {
                    unset($lessonMetadata[$_GET['dc']]);
                }
                $currentLesson -> lesson['metadata'] = serialize($lessonMetadata);
            }

            $currentLesson -> persist();
            echo $_GET['value'];
            exit;
        }
    }

    /*Include the module that is used to perform the searches*/
    elseif (isset($_GET['op']) && $_GET['op'] == 'search') {
        /**Functions to perform searches*/
        require_once "module_search.php";
    }

    /*Show the announcements (news) full page*/
    elseif (isset($_GET['op']) && $_GET['op'] == 'news') {
        $news = eF_getTableData("news", "*", "lessons_ID=".$currentLesson -> lesson['id']);
        $smarty -> assign("T_NEWS", $news);
    }

    /*
    The progress section presents a list with the students that have completed the lesson
    Here the professor may set additional students' lesson status to completed and issue certificates.
    He also edits the certificate that is issued from the system.
    */
    elseif (isset($_GET['op']) && $_GET['op'] == 'progress') {
        $load_editor = true;
        if (isset($_GET['edit_user']) && eF_checkParameter($_GET['edit_user'], 'login')) {
            //$lessonUser  = EfrontUserFactory :: factory($_GET['edit_user']);

            $form = new HTML_QuickForm("edit_user_complete_lesson_form", "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=progress&edit_user='.$_GET['edit_user'], "", null, true);
            $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter

            $form -> addElement('advcheckbox', 'completed', _COMPLETED, null, 'class = "inputCheckbox"');            //Whether the user has completed the lesson
            $form -> addElement('text', 'score', _SCORE, 'class = "inputText"');                                                        //The user lesson score
            $form -> addRule('score', _THEFIELD.' "'._SCORE.'" '._MUSTBENUMERIC, 'numeric', null, 'client');                            //The score must be numeric
            $form -> addRule('score', _RATEMUSTBEBETWEEN0100, 'callback', create_function('&$a', 'return ($a >= 0 && $a <= 100);'));    //The score must be between 0 and 100

            $form -> addElement('textarea', 'comments', _COMMENTS, 'class = "inputContentTextarea simpleEditor" style = "width:100%;height:5em;"');      //Comments on student's performance
            $form -> addElement('submit', 'submit_lesson_complete', _SUBMIT, 'class = "flatButton"');       //The submit button

            $user_data = eF_getTableData("users_to_lessons", "*", "users_LOGIN='".$_GET['edit_user']."' and lessons_ID=".$_SESSION['s_lessons_ID']);
            $userStats   = EfrontStats::getStudentsLessonStatus($currentLesson, $_GET['edit_user']);

            $form -> setDefaults(array("completed" => $userStats[$_GET['edit_user']]['completed'],
                                       "score"     => $userStats[$_GET['edit_user']]['score'],
                                       "comments"  => $userStats[$_GET['edit_user']]['comments']));

            if ($form -> isSubmitted() && $form -> validate()) {
                if ($form -> exportValue('completed')) {
                    $lessonUser  = EfrontUserFactory :: factory($_GET['edit_user']);
                    $lessonUser -> completeLesson($currentLesson -> lesson['id'], $form -> exportValue('score'), $form -> exportValue('comments'));
                } else {
                    eF_updateTableData("users_to_lessons", array('completed' => 0, 'score' => 0, 'to_timestamp' => ''), "users_LOGIN = '".$_GET['edit_user']."' and lessons_ID=".$currentLesson -> lesson['id']);
                }

                header('location:'.$_SERVER['PHP_SELF'].'?ctg=control_panel&op=progress&message='.urlencode(_STUDENTSTATUSCHANGED).'&message_type=success');
            }

            $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

            $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
            $form -> setRequiredNote(_REQUIREDNOTE);
            $form -> accept($renderer);

            $smarty -> assign('T_COMPLETE_LESSON_FORM', $renderer -> toArray());

/**@todo This part that calulates statistics must be refactored*/
            $smarty -> assign("T_STATISTICS_USER", $_GET['edit_user']);
            $user_info = eF_getUserInfo($_GET['edit_user'], $_SESSION['s_lessons_ID']);

            $smarty -> assign("T_USER_GENERAL_INFO", $user_info['general_info']);
            $smarty -> assign("T_USER_COMMON_INFO", $user_info['common_info']);
            $smarty -> assign("T_USER_USERTYPE",$user_info['user_type']);
            if (isset($user_info['avatar']))
            $smarty -> assign("T_USER_AVATAR", $user_info['avatar']);
            $smarty -> assign("T_USER_COMMUNICATION", $user_info['communication']);
            $smarty -> assign("T_USER_USAGE", $user_info['usage']);

            $user_type = eF_getTableData("users", "user_type", "login='".$_GET['edit_user']."'");
            $smarty -> assign("T_USER_TYPE", $user_type[0]['user_type']);

            $i = 0;
            $scores = array();
            $tests_array = array();
            $projects_array = array();
            $tmp = eF_getStudentProgress($_GET['edit_user'], $_SESSION['s_lessons_ID']);
            $scores['percentage'] = $tmp[$_SESSION['s_lessons_ID']];
            foreach($user_info['lessons_info']['content_done'] as $key => $lesson_data){
                $counter_seen = $lesson_data['theory_seen'] + $lesson_data['examples_seen'] ;
                $counter_overall = $lesson_data['theory'] + $lesson_data['examples'] ;
                $tests_array[$i] = array('done' => $lesson_data['tests_done'],'tests' => $lesson_data['tests']);
                $projects_array[$i] =  array('done' => $lesson_data['projects_done'],'projects' => $lesson_data['projects']);
                $i ++;
            }
            $smarty -> assign("T_OVERALL_VIEWED",$scores);
            $smarty -> assign("T_TESTS_OVERALL",$tests_array);
            $smarty -> assign("T_PROJECTS_OVERALL",$projects_array);


            if ($user_type[0]['user_type'] == 'student') {
                foreach ($user_info['lessons_info']['content_done'] as $key => $lesson_data) {
                    $user_info['lessons_info']['content_done'][$key]['theory_seen_percentage']    = sprintf("%01.2f",round(100 * $lesson_data['theory_seen'] / ($lesson_data['theory'] + 0.00001), 1));
                    $user_info['lessons_info']['content_done'][$key]['examples_seen_percentage']  = sprintf("%01.2f",round(100 * $lesson_data['examples_seen'] / ($lesson_data['examples'] + 0.00001), 1));
                    $user_info['lessons_info']['content_done'][$key]['tests_done_percentage']     = sprintf("%01.2f",round(100 * $lesson_data['tests_done'] / ($lesson_data['tests'] + 0.00001), 1));
                }

                $array_scores_mean = array();
                $array_grades_mean = array();
                for ($i=0; $i < sizeof($user_info['lessons_info']['done_projects']); $i ++){
                    for($j = 0 ; $j < sizeof($user_info['lessons_info']['done_projects'][$i]['grade']) ; $j ++){
                        $user_info['lessons_info']['done_projects'][$i]['grade'][$j] = sprintf("%01.2f",$user_info['lessons_info']['done_projects'][$i]['grade'][$j]);
                        $tmp_g += floatval($user_info['lessons_info']['done_projects'][$i]['grade'][$j]);
                    }
                    $tmp_g_i = $tmp_g / sizeof($user_info['lessons_info']['done_projects'][$i]['grade']);
                    $array_grades_mean[$i] = array('avg_score' => sprintf("%01.2f",round($tmp_g_i,2)));
                }

                for($i = 0 ; $i < sizeof($user_info['lessons_info']['done_tests']) ; $i ++){
                    $tmp = 0.00;
                    for($j = 0 ; $j < sizeof($user_info['lessons_info']['done_tests'][$i]['score']) ; $j ++){
                        $tmp += floatval($user_info['lessons_info']['done_tests'][$i]['score'][$j]);
                    }
                    $tmp_i = $tmp / sizeof($user_info['lessons_info']['done_tests'][$i]['score']);
                    $array_scores_mean[$i] = array('avg_score' => sprintf("%01.2f",round($tmp_i,2)));
                }
                $smarty -> assign("T_USERAVGSCORE",$array_scores_mean);
                $smarty -> assign("T_PROJECTAVGSCORE",$array_grades_mean);
                for($i = 0 ; $i < sizeof($user_info['lessons_info']['done_tests']) ; $i ++){
                    for($j = 0 ; $j < sizeof($user_info['lessons_info']['done_tests'][$i]['score']) ; $j ++){
                        $user_info['lessons_info']['done_tests'][$i]['score'][$j] = sprintf("%01.2f",$user_info['lessons_info']['done_tests'][$i]['score'][$j]);
                    }
                }
                $smarty -> assign("T_USER_LESSONS_INFO", $user_info['lessons_info']);

            } elseif ($user_type[0]['user_type'] == 'professor') {
                foreach ($user_info['lessons_info']['id'] as $key => $lesson_id) {
                    $res = ef_getTableData("projects","count(*)","lessons_ID=$lesson_id");
                    $user_info['lessons_info']['projects_num'][$key] = $res[0]['count(*)'];
                    $res = ef_getTableData("users_to_lessons","count(*)","lessons_ID=$lesson_id");
                    $user_info['lessons_info']['students_num'][$key] = $res[0]['count(*)']-1;  //we dont consider the professor
                    $res = ef_getTableData("tests t, content c","count(*)","t.content_ID=c.id and c.lessons_ID=$lesson_id");
                    $user_info['lessons_info']['tests_num'][$key] = $res[0]['count(*)'];  //we dont consider the professor
                }
                $smarty -> assign("T_PROFESSOR_LESSONS", $user_info['lessons_info']);
            }
        } elseif (isset($_GET['auto_complete'])) {
            if ($_GET['auto_complete']) {
                $currentLesson -> lesson['auto_complete'] = 1;
            } else {
                $currentLesson -> lesson['auto_complete']    = 0;
                $currentLesson -> lesson['auto_certificate'] = 0;
            }
            $currentLesson -> persist();
        }

        //Get users list through ajax
        if (isset($_GET['ajax']) && $_GET['ajax'] == 'usersTable') {

            $users = EfrontStats::getStudentsLessonStatus($currentLesson);
            foreach ($users as $key => $user) {
                if ($user['user_type'] != 'student') {
                    unset($users[$key]);
                }
            }

            isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;

            if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                $sort = $_GET['sort'];
                isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
            } else {
                $sort = 'login';
            }
            $users = eF_multiSort($users, $sort, $order);
            $smarty -> assign("T_USERS_SIZE", sizeof($users));
            if (isset($_GET['filter'])) {
                $users = eF_filterData($users, $_GET['filter']);
            }
            if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                $users = array_slice($users, $offset, $limit);
            }
			foreach ($users as $key => &$value) {
				$value['issued_certificate'] = unserialize($value['issued_certificate']);
			}
            $smarty -> assign("T_USERS_PROGRESS", $users);
            $smarty -> display('professor.tpl');
            exit;
        }

        $smarty -> assign("AUTO_COMPLETE", $currentLesson -> lesson['auto_complete']);
    }
    /*
    Users is the operation that enables user handling. In this section, the professor may assign users to
    the lesson, as well as change their type.
    */
    elseif (isset($_GET['op']) && $_GET['op'] == 'users') {

        try {
            $lessonUsers    = $currentLesson -> getUsers();                    //Get all users that have this lesson
            unset($lessonUsers[$currentUser -> login]);                        //Remove the current user from the list, he can't set parameters for his self!
            $nonLessonUsers = $currentLesson -> getNonUsers();                 //Get all the users that can, but don't, have this lesson
            $users          = array_merge($lessonUsers, $nonLessonUsers);      //Merge users to a single array, which will be useful for displaying them

            $roles = eF_getTableDataFlat("user_types","user_type","active=1 AND basic_user_type!='administrator'");    //Get available roles
            if (sizeof($roles) > 0) {
                $roles = array_combine($roles['user_type'], $roles['user_type']);                                          //Match keys with values, it's more practical this way
            }
            $roles = array_merge(array('student' => _STUDENT, 'professor' => _PROFESSOR), $roles);                     //Append basic user types to the beginning of the array

            if (isset($_GET['ajax']) && $_GET['ajax'] == 'usersTable') {
                isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;

                if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                    $sort = $_GET['sort'];
                    isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
                } else {
                    $sort = 'login';
                }
                $users = eF_multiSort($users, $sort, $order);
                $smarty -> assign("T_USERS_SIZE", sizeof($users));
                if (isset($_GET['filter'])) {
                    $users = eF_filterData($users, $_GET['filter']);
                }
                if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                    isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                    $users = array_slice($users, $offset, $limit);
                }

                $smarty -> assign("T_ROLES", $roles);
                $smarty -> assign("T_ALL_USERS", $users);
                $smarty -> assign("T_LESSON_USERS", array_keys($lessonUsers));                                             //We assign separately the lesson's users, to know when to display the checkboxes as "checked"
                $smarty -> display('professor.tpl');
                exit;
            }

        } catch (Exception $e) {
            $message      = $e -> getMessage().' ('.$e -> getCode().')';
            $message_type = 'failure';
        }

        if (isset($_GET['postAjaxRequest'])) {

            try {
                if (isset($_GET['login']) && eF_checkParameter($_GET['login'], 'login')) {
                    isset($_GET['user_type']) && in_array($_GET['user_type'], array_keys($roles)) ? $userType = $_GET['user_type'] : $userType = 'student';
                    if (in_array($_GET['login'], array_keys($nonLessonUsers))) {
                        $currentLesson -> addUsers($_GET['login'], $userType);
                    }
                    if (in_array($_GET['login'], array_keys($lessonUsers))) {
                        $userType != $lessonUsers[$_GET['login']]['role'] ? $currentLesson -> setRoles($_GET['login'], $userType) : $currentLesson -> removeUsers($_GET['login']);
                    }
                } else if (isset($_GET['addAll'])) {
                    $currentLesson -> addUsers(array_keys($nonLessonUsers));
                } else if (isset($_GET['removeAll'])) {
                    $currentLesson -> removeUsers(array_keys($lessonUsers));
                }
                exit;
            } catch (Exception $e) {
                echo $e -> getMessage().' ('.$e -> getCode().')';
            }

        }

    }

    /*
    Module inclusion. If there are any modules that need to be displayed as ops in the control panel, they are included here
    */
    else if (isset($_GET['op']) && in_array($_GET['op'], array_keys($module_ctgs))) {
        $module_mandatory = eF_getTableData("modules", "mandatory", "name = '".$_GET['op']."'");
        if ($module_mandatory[0]['mandatory'] != 'false' || isset($currentLesson -> options[$_GET['op']])) {
            include(G_MODULESPATH.$_GET['op'].'/module.php');
            $smarty -> assign("T_OP_MODULE", $module_ctgs[$_GET['op']]);
        }
    }

    /*
    These are the default procedures that take place when the professor is accessing the control panel, and
    no operation is set.
    */
    else {
        /*Calculate element positions, so they can be rearreanged accordingly to the user selection*/
        $elementPositions = eF_getTableData("users_to_lessons", "positions", "lessons_ID=".$_SESSION['s_lessons_ID']." AND users_LOGIN='".$_SESSION['s_login']."'");
        if (sizeof($elementPositions) > 0) {
            if ($elementPositions = unserialize($elementPositions[0]['positions'])) {
                $smarty -> assign("T_POSITIONS_FIRST", $elementPositions['first']);
                $smarty -> assign("T_POSITIONS_SECOND", $elementPositions['second']);
                $smarty -> assign("T_POSITIONS", array_merge($elementPositions['first'], $elementPositions['second']));
            }
        } else {
            $smarty -> assign("T_POSITIONS", array());
        }

        if ($currentUser -> roleOptions['content']) {
//            $lessonOptions[4]  = array('text' => _LINEARCONTENT,            'image' => "32x32/replace2.png",        'href' => "professor.php?ctg=content&op=unit_order");
            $lessonOptions[5]  = array('text' => _CONTENTTREEMANAGEMENT,    'image' => "32x32/trafficlight_on.png", 'href' => "professor.php?ctg=content&op=unit_order");
//            $lessonOptions[6]  = array('text' => _DELETECONTENT,            'image' => "32x32/delete.png",          'href' => "professor.php?ctg=content&op=delete_content");
            $lessonOptions[7]  = array('text' => _COPYFROMANOTHERLESSON,    'image' => "32x32/folder_into.png",     'href' => "professor.php?ctg=content&op=copy_content");
        }

        $lessonOptions[0]  = array('text' => _LESSONINFORMATION, 'image' => "32x32/about.png",       'href' => $_SERVER['PHP_SELF']."?ctg=control_panel&op=lesson_information");
        $lessonOptions[1]  = array('text' => _CONTENTMANAGEMENT, 'image' => "32x32/pencil.png",      'href' => "professor.php?ctg=content");
        $lessonOptions[9]  = array('text' => _STATISTICS,        'image' => "32x32/chart.png",       'href' => "professor.php?ctg=statistics");
        //$lessonOptions[12] = array('text' => _SCHEDULING,        'image' => "32x32/calendar.png",    'href' => "professor.php?ctg=scheduling");
        $lessonOptions[15] = array('text' => _USERSMANAGEMENT,   'image' => "32x32/user1.png",       'href' => "professor.php?ctg=control_panel&op=users");
        //$lessonOptions[17] = array('text' => _FILEMANAGER.' (old)',       'image' => "32x32/folder_view.png", 'href' => "professor.php?ctg=content&op=file_manager2");
        $lessonOptions[17] = array('text' => _FILEMANAGER,       'image' => "32x32/folder_view.png", 'href' => "professor.php?ctg=content&op=file_manager");
        $lessonOptions[19] = array('text' => _LESSONSETTINGS,    'image' => "32x32/gear.png",        'href' => "professor.php?ctg=settings");

        isset($currentLesson -> options['tests'])     ? $lessonOptions[3]  = array('text' => _TESTS,       'image' => "32x32/document_edit.png", 'href' => "professor.php?ctg=tests")     : null;
        isset($currentLesson -> options['survey'])    ? $lessonOptions[8]  = array('text' => _SURVEY,      'image' => "32x32/form_green.png",    'href' => "professor.php?ctg=survey")    : null;
        isset($currentLesson -> options['rules'])     ? $lessonOptions[10] = array('text' => _ACCESSRULES, 'image' => "32x32/recycle.png",       'href' => "professor.php?ctg=rules")      : null;
        isset($currentLesson -> options['projects'])  ? $lessonOptions[2]  = array('text' => _PROJECTS,    'image' => "32x32/exercises.png",     'href' => "professor.php?ctg=projects")  : null;
/*
        $lesson_users           = eF_getStudentsLessonStatus($_SESSION['s_lessons_ID']);
        $users_completed_lesson = 0;
        for ($i = 0; $i < sizeof($lesson_users['completed']); $i++) {
            if ($lesson_users['total_conditions'][$i] && ($lesson_users['completed'][$i] != $lesson_users['lesson_passed'][$i])) {
                $users_completed_lesson++;
            }
        }
        $users_completed_lesson                     == 0    ? $lessonOptions[11] = array('text' => _CERTIFICATES, 'image' => "32x32/certificate.png", 'href' => "professor.php?ctg=control_panel&op=certificates") : $lessonOptions[11] = array('text' => _CERTIFICATES." ($users_completed_lesson "._PENDING.")",          'image' => "32x32/certificate_information.png",     'href' => "professor.php?ctg=control_panel&op=certificates");
*/
        $lessonOptions[11] = array('text' => _PROGRESS, 'image' => "32x32/stethoscope.png", 'href' => "professor.php?ctg=control_panel&op=progress");
        $currentLesson -> options['scorm']          == true ? $lessonOptions[18] = array('text' => _SCORM,        'image' => "32x32/book_red.png",   'href'  => "professor.php?ctg=control_panel&op=scorm")        : null;

        foreach ($modules as $module) {
            if ($module['mandatory'] != 'false' || isset($currentLesson -> options[$module['name']])) {
                if ($module['position'] != 'left') {
                    $lessonOptions[] = array('text' => $module['title'],  'image' => "32x32/component_green.png", 'href' => $_SERVER['PHP_SELF']."?ctg=control_panel&op=".$module['name']);
                }
                if ($module['menu'] == 'inner_table') {
                    /**Include the inner table code*/
                    include(G_MODULESPATH.$module['name'].'/module_innerTable.php');
                    $innertable_modules[] = $module['name'];
                }
            }
        }
        ksort($lessonOptions);
        $smarty -> assign("T_INNERTABLE_MODULES", $innertable_modules);
        $smarty -> assign("T_LESSON_OPTIONS", $lessonOptions);

        /*Lesson announcements list*/
        $announcements = eF_getNews();
        if ($currentUser -> roleOptions['news'] == 1) {
            $announcements_options = array(
                    array('text' => _ANNOUNCEMENTGO,  'image' => "16x16/redo.png", 'href' => $_SERVER['PHP_SELF']."?ctg=control_panel&op=news"),
                    array('text' => _ANNOUNCEMENTADD, 'image' => "16x16/add2.png", 'href' => "news.php?op=insert", 'onClick' => "eF_js_showDivPopup('"._ANNOUNCEMENTADD."', 1)", 'target' => 'POPUP_FRAME')
                    );
        } else {
            $announcements_options = array(
                    array('text' => _UNPRIVILEGEDATTEMPT, 'image' => "16x16/add2_gray.png", 'href' => "#")
                    );
        }
        $smarty -> assign("T_NEWS", $announcements);
        $smarty -> assign("T_NEWS_OPTIONS", $announcements_options);
        $smarty -> assign("T_NEWS_LINK", "professor.php?ctg=control_panel&op=news");

        /*Forum messages list*/
        $forum_messages   = eF_getForumMessages($_SESSION['s_lessons_ID'], $f_messages_limit);
        $forum_lessons_ID = eF_getTableData("f_categories", "id", "lessons_ID=".$_SESSION['s_lessons_ID']);
        $smarty -> assign("T_FORUM_MESSAGES", $forum_messages);
        $smarty -> assign("T_FORUM_LESSONS_ID", $forum_lessons_ID[0]['id']);

        if ($forum_lessons_ID[0]['id']) {
            if ($currentUser -> roleOptions['forum'] == 1){
                $forum_options = array(
                    array('text' => _GOTOFORUM, 'image' => "16x16/redo.png", 'href' => "forum/forum_index.php?category=".$forum_lessons_ID[0]['id']),
                    array('text' => _SENDMESSAGEATFORUM, 'image' => "16x16/add2.png", 'href' => "forum/forum_add.php?type=topic&category=".$forum_lessons_ID[0]['id'], 'onClick' => "eF_js_showDivPopup('"._NEWMESSAGE."', new Array('650px', '450px'))", 'target' => 'POPUP_FRAME')
                    );
            } else {
                $forum_options = array(
                    array('text' => _GOTOFORUM, 'image' => "16x16/redo.png", 'href' => "forum/forum_index.php?category=".$forum_lessons_ID[0]['id']),
                    array('text' => _UNPRIVILEGEDATTEMPT, 'image' => "16x16/add2_gray.png", 'href' => "#")
                    );
            }
        } else {
            $forum_options = array(
                    array('text' => _GOTOFORUM, 'image' => "16x16/redo.png", 'href' => "forum/forum_index.php  ")
                    );
        }
        $smarty -> assign("T_FORUM_OPTIONS", $forum_options);
        $smarty -> assign("T_FORUM_LINK", "forum/forum_index.php?category=".$forum_lessons_ID[0]['id']);

        /*Personal messages list*/
        $personal_messages = eF_getPersonalMessages(false, 10);
        $smarty -> assign("T_PERSONAL_MESSAGES", $personal_messages);

        if ($currentUser -> roleOptions['personal_messages'] == 1) {
            $personal_message_options = array(
                    array('text' => _GOTOINBOX,   'image' => "16x16/redo.png", 'href' => "forum/messages_index.php"),
                    array('text' => _SENDMESSAGE, 'image' => "16x16/add2.png", 'href' => "forum/new_message.php", 'onClick' => "eF_js_showDivPopup('"._NEWMESSAGE."', new Array('650px', '450px'))", 'target' => 'POPUP_FRAME')
            );
        } else {
            $personal_message_options = array(
                    array('text' => _GOTOINBOX, 'image' => "16x16/redo.png", 'href' => "forum/messages_index.php"),
                    array('text' => _UNPRIVILEGEDATTEMPT, 'image' => "16x16/add2_gray.png", 'href' => "#")
            );
        }
        $smarty -> assign("T_PERSONAL_MESSAGES_OPTIONS", $personal_message_options);
        $smarty -> assign("T_PERSONAL_MESSAGES_LINK",    "forum/messages_index.php");
        /*Comments list*/
        $comments = eF_getComments(false, false, false, 10);
        $smarty -> assign("T_COMMENTS", $comments);

        //$done_questions = eF_getTabledata("done_questions AS d_q, questions AS q, done_tests AS d_t, tests AS t, content AS c", "d_q.*, d_t.users_LOGIN, q.text", "c.lessons_ID=".$_SESSION['s_lessons_ID']." AND c.id=t.content_ID AND t.id=d_t.tests_ID AND d_q.done_tests_ID=d_t.id AND q.type='raw_text' AND d_q.questions_ID=q.id AND d_q.score=0", "d_t.timestamp ASC");
        $num_done_questions = eF_getTableData("done_tests AS d_t, done_questions AS d_q, content AS c, tests, questions as q", "count(*)", "c.lessons_ID=".$_SESSION['s_lessons_ID']." AND d_q.done_tests_ID=d_t.id AND d_t.tests_ID=tests.id AND c.id=tests.content_ID AND q.id = d_q.questions_ID AND d_q.score=-1 AND q.type='raw_text'", "d_t.timestamp ASC");
        $smarty -> assign("T_DONE_QUESTIONS", $num_done_questions[0]['count(*)']);
        $smarty -> assign("T_DONE_QUESTIONS_OPTIONS", array(array("text" => _GOTOCORRECTQUESTIONS, "image" => "16x16/redo.png", "href" => $_SERVER['PHP_SELF']."?ctg=tests&tab=correct_question")));
        $smarty -> assign("T_DONE_QUESTIONS_LINK", "professor.php?ctg=tests&tab=correct_question");


        $today = getdate(time());                                                                     //Get current time in an array
        $today = mktime(0, 0, 0, $today['mon'], $today['mday'], $today['year']);                      //Create a timestamp that is today, 00:00. this will be used in calendar for displaying today
        (eF_checkParameter($_GET['view_calendar'], 'timestamp')) ? $view_calendar = $_GET['view_calendar']: $view_calendar = $today;    //If a specific calendar date is not defined in the GET, set as the current day to be today

        //if (MODULE_HCD_INTERFACE) {
            $events     = eF_getCalendar(0, 2);                                                         //Get all events for this type
            $smarty -> assign("T_CALENDAR_TYPE", "&type=2");
            $type_of_events = "&type=2";
        //} else {
        //    $events     = eF_getCalendar();                                                                 //Get all events
        //}


        //$events = eF_getCalendar();                                                                         //Get events for the specified day
        $smarty -> assign("T_CALENDAR_EVENTS", $events);                                                    //Assign events and specific day timestamp to smarty, to be used from calendar
        $smarty -> assign("T_VIEW_CALENDAR", $view_calendar);

        $calendar_options = array(                                                                          //Create calendar options and assign them to smarty, to be displayed at the calendar inner table
                    array('text' => _GOTOCALENDAR, 'image' => "16x16/redo.png", 'href' => "professor.php?ctg=calendar"),
                    array('text' => _ADDCALENDAR,  'image' => "16x16/add2.png", 'href' => "professor.php?ctg=calendar&add_calendar=1&view_calendar=".$view_calendar.$type_of_events, "onClick" => "eF_js_showDivPopup('"._ADDCALENDAR."', new Array('650px', '350px'))", "target" => "POPUP_FRAME", "id" => "add_new_event_link")
        );
        $smarty -> assign("T_CALENDAR_OPTIONS", $calendar_options);
        $smarty -> assign("T_CALENDAR_LINK", "professor.php?ctg=calendar");
        if (isset($_GET['add_another'])) {
            $smarty -> assign('T_ADD_ANOTHER', "1");
        }
    }
}
/*
Content is the page where the professor views manages the lesson content. Here, he may, add and edit units,
as well as perform content-specific operation, such as:
- Change the units order
- Upload files
- Copy content from one unit to another
- Activate, deactivate and delete units
*/
elseif ($ctg == 'content') {
    try {
        $iterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST));
        foreach ($iterator as $key => $value) {
            $contentUnits[] = $key;
        }
    } catch (Exception $e) {
        $message      = _SOMEPROBLEMOCCURED.': '.$e -> getMessage().' ('.$e -> getCode().')';
        $message_type = 'failure';
    }

    /*
    The system file manager
    */
    if (isset($_GET['op']) && $_GET['op'] == 'file_manager2') {
        $main_directory = $currentLesson -> getDirectory();
        include("module_filemanager.php");
    }
    else if (isset($_GET['op']) && $_GET['op'] == 'file_manager') {
        $loadScripts[] = 'drag-drop-folder-tree';
        $loadScripts[] = 'scriptaculous/effects';
//$db->debug=true;        
        $basedir    = $currentLesson -> getDirectory();
        try {
            $filesystem = new FileSystemTree($basedir);
            $filesystem -> handleAjaxActions($currentUser);
            
            $url        = $_SERVER['PHP_SELF'].'?ctg=content&op=file_manager';
            $options    = array('db_files_only' => true, 'root_name' => _FILESFOR.' &quot;'.$currentLesson -> lesson['name'].'&quot;', 'lessons_ID' => $currentLesson -> lesson['id']);
            if (isset($_GET['ajax'])) {
                isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;
    
                if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                    $sort = $_GET['sort'];
                    isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
                } else {
                    $sort = 'login';
                }
    
                if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                    isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                }
                isset($_GET['filter']) ? $filter = $_GET['filter'] : $filter = false;
                isset($_GET['other'])  ? $other  = $_GET['other']  : $other  = '';
                $ajaxOptions = array('sort' => $sort, 'order' => $order, 'limit' => $limit, 'offset' => $offset, 'filter' => $filter);
                echo $filesystem -> toHTML($url, $other, $ajaxOptions, $options);
                exit;
            } 
            $smarty -> assign("T_FILE_MANAGER", $filesystem -> toHTML($url, false, false, $options));
        } catch (Exception $e) {
            $message      = $e -> getMessage().' ('.$e -> getCode().')';
            $message_type = 'failure';
        }
    }
    /*
    This section is used to change the order of the units, as well as delete and (de)activate units
    */
    elseif (isset($_GET['op']) && $_GET['op'] == 'unit_order') {
        $loadScripts[] = 'drag-drop-folder-tree';
        $loadScripts[] = 'scriptaculous/scriptaculous';                            //Load effects to be used on ajax users assignment
        $loadScripts[] = 'scriptaculous/effects';

        //$loadScripts[] = 'context-menu';
        if ($currentUser -> roleOptions['content']) {
            try {
                $iterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST));
                $smarty -> assign("T_UNIT_ORDER_TREE", $currentContent -> toHTML($iterator, 'dhtmlContentTree', array('delete' => true, 'noclick' => true, 'activate' => true, 'drag' => true, 'expand' => true)));
                $options = array(array('image' => '16x16/undo.png', 'text' => _REPAIRTREE, 'href' => 'javascript:void(0)', 'onClick' => 'if (confirm (\''._ORDERWILLPERMANENTLYCHANGE.'\')) repairTree();'));
                $smarty -> assign("T_TABLE_OPTIONS", $options);
            } catch (Exception $e) {
                $message      = _ERRORLOADINGCONTENT." ".$_SESSION['s_lessons_ID'].": ".$e -> getMessage();
                $message_type = 'failure';
            }
            if (isset($_GET['ajax'])) {
                if (isset($_GET['delete_nodes']) && $_GET['delete_nodes']) {      //Delete nodes through AJAX call
                    $deleteNodes = explode(",", $_GET['delete_nodes']);
                    foreach ($deleteNodes as $value) {
                        if (eF_checkParameter($value, 'id')) {
                            try {                                                //Putting the try/catch block here, makes the process to continue even if it fails for some units
                                $currentContent -> removeNode($value);
                            } catch (Exception $e) {
                                $message      .= _ERRORDELETINGUNIT." ".$value.": ".$e -> getMessage().'<br/>';
                                $message_type = 'failure';
                            }
                        }
                    }
                }
                if (isset($_GET['activate_nodes']) && $_GET['activate_nodes']) {      //Delete nodes through AJAX call
                    $activateNodes = explode(",", $_GET['activate_nodes']);
                    foreach ($activateNodes as $value) {
                        if (eF_checkParameter($value, 'id') && in_array($value, $contentUnits)) {
                            try {                                                //Putting the try/catch block here, makes the process to continue even if it fails for some units
                                $currentContent -> seekNode($value) -> activate();
                            } catch (Exception $e) {
                                $message      .= _ERRORACTIVATINGUNIT." ".$value.": ".$e -> getMessage().'<br/>';
                                $message_type = 'failure';
                            }
                            //echo "activating node $value";
                        }
                    }
                }
                if (isset($_GET['deactivate_nodes']) && $_GET['deactivate_nodes']) {      //Delete nodes through AJAX call
                    $deactivateNodes = explode(",", $_GET['deactivate_nodes']);
                    foreach ($deactivateNodes as $value) {
                        if (eF_checkParameter($value, 'id') && in_array($value, $contentUnits)) {
                            try {                                                //Putting the try/catch block here, makes the process to continue even if it fails for some units
                                $currentContent -> seekNode($value) -> deactivate();
                            } catch (Exception $e) {
                                $message      .= _ERRORDEACTIVATINGUNIT." ".$value.": ".$e -> getMessage().'<br/>';
                                $message_type = 'failure';
                            }
                            //echo "deactivating node $value";
                        }
                    }
                }
                if (isset($_GET['node_orders']) && $_GET['node_orders']) {
                    $nodeOrders        = explode(",", $_GET['node_orders']);
                    $previousContentId = 0;
                    foreach ($nodeOrders as $value) {
                        list($id, $parentContentId) = explode("-", $value);
                        $contentUnits[] = 0;                                        //Add 0 to possible content units, since both parent and previous units may be 0
                        if (eF_checkParameter($id, 'id') !== false && in_array($id, $contentUnits) && eF_checkParameter($parentContentId, 'id') !== false  && in_array($parentContentId, $contentUnits)) {
                            try {                                                //Putting the try/catch block here, makes the process to continue even if it fails for some units
                                $unit = $currentContent -> seekNode($id);
                                $unit -> offsetSet('previous_content_ID', $previousContentId);
                                $unit -> offsetSet('parent_content_ID', $parentContentId);
                                $unit -> persist();
                                $previousContentId = $id;
                            } catch (Exception $e) {
                                $message      .= _ERRORDEPOSITIONINGUNIT." ".$id.": ".$e -> getMessage().'<br/>';
                                $message_type = 'failure';
                            }
                        }
                    }
                }
                if (isset($_GET['repair_tree'])) {
                    try {
                        $currentContent -> repairTree();
                    } catch (Exception $e) {
                        $message      .= _ERRORREPAIRINGTREE.": ".$e -> getMessage().'<br/>';
                        $message_type = 'failure';
                    }
                }
                echo _TREESAVEDSUCCESSFULLY;
                exit;
            }
        } else {
            $message = _UNPRIVILEGEDATTEMPT;
        }
    }

    /*
    This section is used to copy units from one lesson to another
    */
    elseif (isset($_GET['op']) && $_GET['op'] == 'copy_content') {
        $loadScripts[] = 'drag-drop-folder-tree';
        if ($currentUser -> roleOptions['content']) {
            $userLessons = $currentUser -> getLessons();
            if (isset($_GET['lesson']) && eF_checkParameter($_GET['lesson'], 'id') && isset($userLessons[$_GET['lesson']])) {    //@todo: Must be professor also, so we need a way to get the basic user type for each lesson, apart from role
                $iterator       = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST));
                if (sizeof($currentContent -> tree) == 0) {
                    $smarty -> assign("T_CONTENT_TREE", $currentContent -> toHTML($iterator,       'dhtmlTargetTree', array('noclick' => true, 'drag' => false, 'tree_root' => true)));
                } else {
                    $smarty -> assign("T_CONTENT_TREE", $currentContent -> toHTML($iterator,       'dhtmlTargetTree', array('noclick' => true, 'drag' => false)));
                }                
                
                $sourceContent  = new EfrontContentTree($_GET['lesson']);
                $sourceIterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($sourceContent  -> tree), RecursiveIteratorIterator :: SELF_FIRST));
                $smarty -> assign("T_SOURCE_TREE",  $sourceContent  -> toHTML($sourceIterator, 'dhtmlSourceTree',  array('noclick' => true, 'drag' => true)));


                foreach ($iterator as $key => $value) {
                    $currentIds[] = $value['id'];
                }
                foreach ($sourceIterator as $key => $value) {
                    $sourceIds[] = $value['id'];
                }
                
                if (sizeof($currentIds) == 0){
                    $currentIds[] = 0; //root node    
                }
                
                if (isset($_GET['node_orders'])) {                                    //Save new order through AJAX call
                    $nodeOrders        = explode(",", $_GET['node_orders']);
                    $previousContentId = 0;
                    foreach ($nodeOrders as $value) {
                        list($id, $parentContentId) = explode("-", $value);
                        if (eF_checkParameter($id, 'id') !== false && eF_checkParameter($parentContentId, 'id') !== false
                                && in_array($id, $sourceIds) && in_array($parentContentId, $currentIds)) {
                            //echo "Copying $id to parent $parentContentId with previous $previousContentId\n";
                            try {
                                $currentContent -> copyUnit($id, $parentContentId);
                            } catch (Exception $e) {
                                $errorMessages[] = $e -> getMessage();
                            }
                        }
                        $previousContentId = $id;
                    }
                    if ($errorMessages) {
                        echo _ERRORSAVINGTREE."\n".implode("\n", $errorMessages);
                    } else {
                        echo _TREESAVEDSUCCESSFULLY;
                    }
                    exit;
                }
            }
            $lessons = eF_getUserLessons($_SESSION['s_login']);
           
            $smarty -> assign("T_USER_LESSONS", $lessons);
        } else {
            $message = _UNPRIVILEGEDATTEMPT;
        }
    }

    /*
     * Here we either view or edit a unit
     */
    else {
        try {
            $iterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('active' => 1));
            !isset($currentUnit) ? $currentUnit = $currentContent -> getFirstNode($iterator) : null;                                               //If a unit is not specified, then consider the first content unit by default
            $smarty  -> assign("T_CONTENT_TREE", $currentContent -> toHTML($iterator, 'dhtmlContentTree', array('truncateNames' => 20, 'edit' => true, 'selectedNode' => $currentUnit['id'])));

        } catch (Exception $e) {
            $message      = _SOMEPROBLEMOCCURED.': '.$e -> getMessage().' ('.$e -> getCode().')';
            $message_type = 'failure';
        }

        /*The professor asked to add or update a unit*/
        if (isset($_GET['add_unit']) || (isset($_GET['edit_unit']) && eF_checkParameter($_GET['edit_unit'], 'id')) && $currentUser -> roleOptions['content']) {
            $load_editor = true;
            try {

                $optionsArray = $currentContent -> toHTMLSelectOptions();    //Get the units as an array of formated strings, that can be used to form an HTML select list

    //            $lesson_periods = eF_getTableData("periods", "*", "lessons_ID=".$_SESSION['s_lessons_ID']); //Get the lesson periods
    //            foreach ($lesson_periods as $lesson_period) {
    //                $periods[$lesson_period['id']] = $lesson_period['name'];                                //Get period and lesson names in 1 array, to use them in the form select box
    //            }

                if (isset($_GET['add_unit'])) {
                    $post_target = 'add_unit=1';
                } else {
                    $post_target = 'edit_unit='.$_GET['edit_unit'];
                    $currentUnit = $currentContent -> seekNode($_GET['edit_unit']);
                }
                if ($currentUnit) {
                    $smarty -> assign("T_PARENT_LIST", $currentContent -> getNodeAncestors($currentUnit));
                }

                $form = new HTML_QuickForm("update_content_form", "post", $_SERVER['PHP_SELF'].'?ctg=content&'.$post_target, "", null, true);
                $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter

                $form -> addElement('text', 'name', _UNITNAME, 'class = "inputText"');                      //The Unit name
                $form -> addRule('name', _THEFIELD.' "'._UNITNAME.'" '._ISMANDATORY, 'required', null, 'client');           //The name is mandatory
                $form -> addRule('name', _INVALIDFIELDDATA, 'checkParameter', 'text');                      //The unit name must be 'text'

                if (isset($_GET['add_unit']) || $currentUnit['ctg_type'] != 'scorm') {                                          //SCORM units should not be edited neither its content nor its type
                    $form -> addElement('select', 'ctg_type', _CONTENTTYPE, array('theory' => _THEORY, 'examples'=> _EXAMPLES), 'class = "inputSelect"');     //A select drop down for content type.... Exercises went away in version 3 (2007/07/10) makriria
                    $form -> addRule('ctg_type', _THEFIELD.' '._CONTENTTYPE.' '._ISMANDATORY, 'required', null, 'client');       //The content type is mandatry
                    $form -> addRule('ctg_type', _INVALIDFIELDDATA, 'checkParameter', 'string');                //The content type can only be string

                    $form -> addElement('textarea', 'data', _CONTENT, 'class = "inputContentTextarea mceEditor" style = "width:100%;height:50em;"');      //The unit content itself
                }
                $form -> addElement('submit', 'submit_insert_content', _SAVECHANGES, 'class = "flatButton"');       //The submit content button

                if (isset($_GET['edit_unit'])) {
                    $form -> setDefaults(array('name' => $currentUnit['name']));
                    if ($currentUnit['ctg_type'] != 'scorm') {                                          //SCORM units should not be edited neither its content nor its type
                        $form -> setDefaults(array('ctg_type' => $currentUnit['ctg_type'],
                                                   'data'     => $currentUnit['data']));
                    } else {
                        $smarty -> assign("T_SCORM", true);
                    }
                } else {
                    $select_units = & HTML_QuickForm :: createElement('select', 'parent_content_ID', _UNITPARENT, null, 'class = "inputSelect"');
                    $select_units -> addOption(_UNITPARENT, 0);
                    $select_units -> addOption('-------------', 0);
                    $select_units -> loadArray($optionsArray);

                    $form -> addElement($select_units);
                    $form -> addRule('parent_content_ID', _THEFIELD.' '._UNITPARENT.' '._ISMANDATORY, 'required', null, 'client');
                    $form -> addRule('parent_content_ID', _INVALIDID, 'numeric');
                    if (isset($_GET['view_unit'])) {
                        $form -> setDefaults(array('parent_content_ID' => $_GET['view_unit']));                                //Set the current content to be the selected in the list
                    }
/*
                    $result = eF_getTableData("periods", "count(*) as total_periods", "lessons_ID=".$_SESSION['s_lessons_ID']);
                    if ($result[0]['total_periods'] > 0) {
                        $select_period = & HTML_QuickForm :: createElement('select', 'period', _PERIODOFINTEREST, null, 'class = "inputSelect"');
                        $select_period -> addOption(_SELECTPERIOD, 0);
                        $select_period -> addOption('-------------', 0);
                        $select_period -> loadArray($periods);
                        $form -> addElement($select_period);                                                            //A select drop down for periods. The first two values are a label and a separator options
                        $form -> addRule('type', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
                        $form -> addRule('type', _INVALIDFIELDDATA, 'checkParameter', 'text');
                    }
*/
                }

                if ($form -> isSubmitted() && $form -> validate()) {
                    if (isset($_GET['add_unit'])) {
                        $newUnit = array('name'              => $form -> exportValue('name'),
                                         'data'              => $form -> exportValue('data'),
                                         'parent_content_ID' => $form -> exportValue('parent_content_ID'),
                                         'lessons_ID'        => $_SESSION['s_lessons_ID'],
                                         'ctg_type'          => $form -> exportValue('ctg_type'),
                                         'active'            => 1);

                        $currentUnit = $currentContent -> insertNode($newUnit);
                        $message     = _SUCCESFULLYINSERTEDNEWUNIT;
                        /*
                         if ($form -> elementExists('period') && $form -> exportValue('period')) {                                            //If the user specified a period, insert this information also.
                         eF_insertTableData("current_content", array("content_ID" => $new_content_ID, "periods_ID" => $form -> exportValue('period')));
                         }
                         */
                    } else {
                        $values = $form -> exportValues();
                        $currentUnit['data'] = addslashes(str_replace('/'.G_RELATIVELESSONSLINK, G_RELATIVELESSONSLINK, $values['data']));   //This is to replace a very annoying / that is added in front of the codebase, which causes the applet to fail load when in relative paths
                        $values['ctg_type'] ? $currentUnit['ctg_type'] = $values['ctg_type'] : null;
                        $values['name']     ? $currentUnit['name']     = $values['name']     : null;                       
                        $currentUnit -> persist();
                        $message = _SUCCESFULLYUPDATEDUNIT;
                        /*
                         if ($form -> elementExists('period') && $form -> exportValue('period')) {                                            //If the user specified a period, insert this information also.
                         eF_insertTableData("current_content", array("content_ID" => $new_content_ID, "periods_ID" => $form -> exportValue('period')));
                         }
                         */
                    }
                    header('location:'.$_SERVER['PHP_SELF'].'?ctg=content&view_unit='.$currentUnit['id'].'&message='.urlencode($message).'&message_type=success');
                }

                $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
                $renderer -> setRequiredTemplate (
                   '{if $required}
                        {$html}&nbsp;<span class = "formRequired">*</span>
                    {/if}');
                $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
                $form -> setRequiredNote(_REQUIREDNOTE);
                $form -> accept($renderer);

                $smarty -> assign('T_INSERT_CONTENT_FORM', $renderer -> toArray());

            } catch (Exception $e) {
                $message      = _SOMEPROBLEMOCCURED.': '.$e -> getMessage().' ('.$e -> getCode().')';
                $message_type = 'failure';
            }

        /*The professor asked to view a unit*/
        } else {
            $loadScripts[] = 'drag-drop-folder-tree';
            $loadScripts[] = 'ASCIIMathML';
            $loadScripts[] = 'scriptaculous/scriptaculous';
            $loadScripts[] = 'scriptaculous/sidebar_extra';

            if ($currentUnit) {
                try {
                    if ($currentLesson -> options['glossary']) {
                        $currentUnit['data'] = eF_applyGlossary($currentUnit['data']);        //If glossary is activated, transform content data accordingly
                    }
                    if ($currentUnit['ctg_type'] == 'scorm') {
                        $smarty -> assign("T_SCORM", true);
                    }
                    $currentUnit['data'] = str_replace("##EFRONTINNERLINK##", $_SESSION['s_type'], $currentUnit['data']);    //Replace inner links. Inner links are created when linking from one unit to another, so they must point either to professor.php or student.php, depending on the user viewing the content

                    $smarty -> assign("T_UNIT",          $currentUnit);
                    $smarty -> assign("T_NEXT_UNIT",     $currentContent -> getNextNode($currentUnit, $iterator));
                    $smarty -> assign("T_PREVIOUS_UNIT", $currentContent -> getPreviousNode($currentUnit, $iterator));        //Next and previous units are needed for navigation buttons
                    $smarty -> assign("T_PARENT_LIST",   $currentContent -> getNodeAncestors($currentUnit));       //Parents are needed for printing the title
                    $smarty -> assign("T_COMMENTS",      eF_getComments($_SESSION['s_lessons_ID'], false, $currentUnit['id']));        //Retrieve any comments regarding this unit
                    $smarty -> assign("T_SHOW_TOOLS",    true);                                                    //Tools is the right upper corner table box, that lists tools such as 'upload files', 'copy content' etc
                } catch (Exception $e) {
                    $message      = $e -> getMessage();
                    $message_type = 'failure';
                }
            }
//                if (eF_isLinked($content_data)) {
//                    $content_data = eF_getTableData("content", "data", "id=".mb_substr($content_data, 8));
//                    $content_data = $content_data[0]['data'];
//                }

            //$comments =  eF_getComments($_SESSION['s_lessons_ID'], false, $currentUnit['id']);
            //for ($l = 0; $l < sizeof($comments); $l++) {
            //    $comments[$l]['data'] = html_entity_decode($comments[$l]['data'], ENT_QUOTES);
            //}
            //$smarty -> assign("T_COMMENTS", $comments);

        }
    }

}
/*
Scheduling pages is used to add periods to the lesson. The professor may add, change
or delete periods, as well as assign units to them. Furthermore, he may change the lesson
start date, thus shifting all periods.
*/
elseif ($ctg == 'scheduling') {
    if (isset($_GET['delete_period']) && eF_checkParameter($_GET['delete_period'], 'id')) {
        if (eF_deleteTableData("periods", "id=".$_GET['delete_period']) && eF_deleteTableData("current_content", "periods_ID=".$_GET['delete_period'])) {
            $message      = _PERIODDELETED;
            $message_type = 'success';
        } else {
            $message      = _SOMEPROBLEMEMERGED;
            $message_type = "failure";
        }
        header("location:".$_SERVER['PHP_SELF']."?ctg=scheduling&message=".$message."&message_type=".$message_type);
    } elseif (isset($_GET['add_period']) || (isset($_GET['edit_period']) && eF_checkParameter($_GET['edit_period'], 'id'))) {
        isset($_GET['add_period']) ? $post_target = 'add_period=1' : $post_target = 'edit_period='.$_GET['edit_period'];

        $form = new HTML_QuickForm("add_period_form", "post", $_SERVER['PHP_SELF']."?ctg=scheduling&".$post_target, "", null, true);
        $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');

        $form -> addElement('text', 'name', _NAME, 'class = "inputText"');                      //A select drop down for period name
        $form -> addRule('name', _THEFIELD.' '._NAME.' '._ISMANDATORY, 'required', null, 'client');       //The period name is mandatry
        $form -> addRule('name', _INVALIDFIELDDATA, 'checkParameter', 'text');

        $form -> addElement('submit', 'submit_add_period', _SAVECHANGES, 'class = "flatButton"');           //The submit period button

        if (isset($_GET['edit_period'])) {
            $period = eF_getTableData("periods", "*", "id=".$_GET['edit_period']);
            $form -> setDefaults(array('name' => $period[0]['name']));

            $smarty -> assign('T_FROM_TIMESTAMP', $period[0]['from_timestamp']);
            $smarty -> assign('T_TO_TIMESTAMP',   $period[0]['to_timestamp']);
        } else {
            $smarty -> assign('T_FROM_TIMESTAMP', mktime(0, 0, 0, date("m") ,date("d"),   date("Y")));
            $smarty -> assign('T_TO_TIMESTAMP',   mktime(0, 0, 0, date("m") ,date("d")+1, date("Y")));
        }

        if ($form -> isSubmitted()) {
            if ($form -> validate()) {
                $from_timestamp = mktime($_POST['from_Hour'], $_POST['from_Minute'], 0, $_POST['from_Month'], $_POST['from_Day'], $_POST['from_Year']);
                $to_timestamp   = mktime($_POST['to_Hour'], $_POST['to_Minute'], 0, $_POST['to_Month'],   $_POST['to_Day'],   $_POST['to_Year']);

                if ($from_timestamp < $to_timestamp) {
                    $fields = array('name'           => $form -> exportValue('name'),
                                    'from_timestamp' => $from_timestamp,
                                    'to_timestamp'   => $to_timestamp,
                                    'lessons_ID'     => $_SESSION['s_lessons_ID']);

                    if (isset($_GET['add_period'])) {
                        if (eF_insertTableData("periods", $fields)) {
                            $message      = _SUCCESFULLYADDEDPERIOD;
                            $message_type = 'success';
                            header("location:".$_SERVER['PHP_SELF']."?ctg=scheduling&message=".$message."&message_type=".$message_type);
                        } else {
                            $message      = _SOMEPROBLEMEMERGED;
                            $message_type = 'failure';
                        }
                    } else {
                        if (eF_updateTableData("periods", $fields, "id=".$_GET['edit_period'])) {
                            $message      = _SUCCESFULLYUPDATEDPERIOD;
                            $message_type = 'success';
                            header("location:".$_SERVER['PHP_SELF']."?ctg=scheduling&message=".$message."&message_type=".$message_type);
                        } else {
                            $message      = _SOMEPROBLEMEMERGED;
                            $message_type = 'failure';
                        }
                    }
                } else {
                    $message      = _ENDDATEMUSTBEBEFORESTARTDATE;
                    $message_type = 'failure';
                }
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

        $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
        $form -> setRequiredNote(_REQUIREDNOTE);
        $form -> accept($renderer);

        $smarty -> assign('T_ADD_PERIOD_FORM', $renderer -> toArray());
    } else if (isset($_POST['submit_init_date']) && $currentUser -> roleOptions['content'] == 1) {
        $new_timestamp = mktime(0, 0, 0, $_POST['initMonth'], $_POST['initDay'], $_POST['initYear']);
        $periods       = eF_getTableData("periods", "id, name, from_timestamp, to_timestamp", "lessons_ID=".$_SESSION['s_lessons_ID'], "from_timestamp ASC");
        $old_timestamp = $periods[0]['from_timestamp'];
        $change        = $new_timestamp - $old_timestamp;

        foreach ($periods as $period) {
            $periods_update = array("from_timestamp" => $period['from_timestamp'] + $change,
                                    "to_timestamp"   => $period['to_timestamp']   + $change);

            eF_updateTableData("periods", $periods_update, "id=".$period['id']);
        }

        $message      = _SUCCESFULLYCHANGEDLESSONSTARTDATE;
        $message_type = 'success';
        header("location:".$_SERVER['PHP_SELF']."?ctg=scheduling&message=".$message."&message_type=".$message_type);
    } else {
        $tree = eF_getContentTree($nouse, $_SESSION['s_lessons_ID'], 0, false, true);

        $periods = eF_getTableDataFlat("periods", "id, name, from_timestamp, to_timestamp", "lessons_ID=".$_SESSION['s_lessons_ID'], "from_timestamp ASC");
        if (sizeof($periods) > 0) {
            isset($_GET['current_period']) && eF_checkParameter($_GET['current_period'], 'id') ? $current_period = $_GET['current_period'] : $current_period = $periods['id'][0] ;

            $form = new HTML_QuickForm("assign_period_form", "post", $_SERVER['PHP_SELF']."?ctg=scheduling&current_period=".$current_period, "", null, true);
            $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');

            $form -> addElement("select", "current_period", null, array_combine($periods['id'], $periods['name']), 'onchange = "document.location=\''.$_SERVER['PHP_SELF'].'?ctg=scheduling&current_period=\'+this.options[this.selectedIndex].value"');
            $form -> addRule('current_period', _INVALIDID, null, 'numeric');
            $form -> setDefaults(array('current_period' => $current_period));

            $in_period = eF_getTableDataFlat("content, current_content", "id, name", "current_content.content_ID=content.id AND content.lessons_ID=".$_SESSION['s_lessons_ID']." AND current_content.periods_ID=".$current_period);
            for ($i = 0; $i < sizeof($tree); $i++) {
                $form -> addElement('checkbox', 'content['.$tree[$i]['id'].']', null, null, 'onclick = "eF_js_selectAllChildren(this)" parent = "'.$tree[$i]['parent_id'].'" class = "inputCheckBox"');                      //A select drop down for unit checkboxes
                if (in_array($tree[$i]['id'], $in_period['id'])) {
                    $form -> setDefaults(array('content['.$tree[$i]['id'].']' => true));
                }
            }

            $form -> addElement('submit', 'submit_assign_period', _SAVECHANGES, 'class = "flatButton"');           //The submit period button

            if ($form -> isSubmitted()) {
                if ($form -> validate()) {
                    $values = $form -> exportValues();
                    $result = eF_deleteTableData("current_content", "periods_ID=".$values['current_period']);
                    foreach ($values['content'] as $key => $value) {
                        $fields_insert = array ('content_ID' => $key,
                                                'periods_ID' => $values['current_period']);
                        eF_insertTableData("current_content", $fields_insert);
                        eF_updateTableData("content", array('active' => 1), "id=".$values['current_period']);
                    }
                    $message      = _MATERIALUPDATEDSUCCESFULLY;
                    $message_type = 'success';
                }
            }

            $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

            $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
            $form -> setRequiredNote(_REQUIREDNOTE);
            $form -> accept($renderer);

            $smarty -> assign('T_ASSIGN_PERIOD_FORM', $renderer -> toArray());

            for ($i = 0; $i <sizeof($tree); $i++) {
                $tree[$i]['name'] = eF_printContentPrestring($tree[$i]).$tree[$i]['name'];
            }

            $smarty -> assign("T_PERIOD_TREE", $tree);
        }

        $smarty -> assign("T_PERIODS", $periods);
        $smarty -> assign("T_INIT_TIMESTAMP", $periods['from_timestamp'][0]);
    }
}
/*
Projects page is responsible for displaying and configuring projects.
The professor may assign students to tests as he wants. The code below
is responsible for displaying the current projects and add new ones.
*/
elseif ($ctg == 'projects') {
    try {
        $projects = $currentLesson -> getProjects(true);
    } catch (Exception $e) {
        $message      = _SOMEPROBLEMOCCURED.': '.$e -> getMessage().' ('.$e -> getCode().')';
        $message_type = 'failure';
    }
    if (isset($_GET['delete_project']) && eF_checkParameter($_GET['delete_project'], 'id') && in_array($_GET['delete_project'], array_keys($projects))) {
        $currentProject = $projects[$_GET['delete_project']];
        try {
            $currentProject -> delete();
            $message      = _PROJECTDELETEDSUCCESSFULLY;
            $message_type = 'success';
            header("location:".$_SERVER['PHP_SELF']."?ctg=projects");
        } catch (Exception $e) {
            $message      = _PROJECTCOULDNOTBEDELETED.': '.$e -> getMessage().' ('.$e -> getCode().')';
            $message_type = 'failure';
        }
    } else if (isset($_GET['compress_data']) && eF_checkParameter($_GET['compress_data'], 'id') && in_array($_GET['compress_data'], array_keys($projects))){         //download project data
        try {
            $currentProject = $projects[$_GET['compress_data']];
            $projectFiles   = $currentProject -> getFiles();

            $zipFileName = G_UPLOADPATH.$currentUser -> user['login'].'/projects/'.$currentProject -> project['title'].'.zip';
            $zip         = new ZipArchive();
            $zip        -> open($zipFileName, ZIPARCHIVE::CREATE);
            foreach ($projectFiles as $file) {
                $zip -> addFile($file['file'], $filename = $file['surname'].'_'.$file['name'].'_'.date("d.m.Y", $file['upload_timestamp']).'_'.$file['original_name']);

            }

            $zip -> close();

            $zipFile = new EF_file($zipFileName);
            header("location:downloadfile.php?file=".$zipFile -> getFileId());
        } catch (Exception $e) {
            $message      = _FILESCOULDNOTBEDOWNLOADED.': '.$e -> getMessage().' ('.$e -> getCode().')';
            $message_type = 'failure';
        }
    } else if (isset($_GET['add_project']) || (isset($_GET['edit_project']) && eF_checkParameter($_GET['edit_project'], 'id')) && in_array($_GET['edit_project'], array_keys($projects))) {
        $load_editor = true;
        $form = new HTML_QuickForm("create_project_form", "post", $_SERVER['PHP_SELF']."?ctg=projects".(isset($_GET['add_project']) ? '&add_project=1' : '&edit_project='.$_GET['edit_project']), "", null, true);
        $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');

        $form -> addElement('text', 'title', _PROJECTTITLE, 'class = "inputText"');
        $form -> addRule('title', _THEFIELD.' "'._TITLE.'" '._ISMANDATORY, 'required', null, 'client');
        $form -> addRule('title', _INVALIDFIELDDATA, 'checkParameter', 'text');

        $form -> addElement('checkbox', 'auto_assign', _AUTOASSIGNTONEWUSERS, null, 'class = "inputCheckBox"');
        $form -> addElement('textarea', 'data', _PROJECTDATA, 'class = "mceEditor" style = "width:100%;height30em;"');

        $form -> addElement('submit', 'submit_add_project', _SUBMIT, 'class=flatButton');
        if (isset($_GET['edit_project'])) {
            $loadScripts[] = 'scriptaculous/scriptaculous';                            //Load effects to be used on ajax users assignment
            $loadScripts[] = 'scriptaculous/effects';

            $currentProject = $projects[$_GET['edit_project']];
            $smarty -> assign("T_CURRENT_PROJECT", $currentProject);
            $form -> setDefaults(array('title'       => $currentProject -> project['title'],
                                       'auto_assign' => $currentProject -> project['auto_assign'],
                                       'data'        => $currentProject -> project['data']));
            $smarty -> assign('T_DEADLINE_TIMESTAMP', $currentProject -> project['deadline']);

        } else {
            $smarty -> assign('T_DEADLINE_TIMESTAMP', mktime(0, 0, 0, date("m") + 1 ,date("d"), date("Y")));
        }

        if ($form -> isSubmitted() && $form -> validate()) {
            $deadline = mktime($_POST['deadline_Hour'], $_POST['deadline_Minute'], 0, $_POST['deadline_Month'], $_POST['deadline_Day'], $_POST['deadline_Year']);
            $values   = $form -> exportValues();
            try {
                if (isset($_GET['add_project'])) {
                    $fields = array('title'         => $values['title'],
                                    'data'          => $values['data'],
                                    'deadline'      => $deadline,
                                    'creator_LOGIN' => $currentUser -> user['login'],
                                    'lessons_ID'    => $currentLesson -> lesson['id'],
                                    'auto_assign'   => $values['auto_assign'] ? 1 : 0);
                    $newProject = EfrontProject :: createProject($fields);

                    $message      = _PROJECTCREATEDSUCCESSFULLY;
                    $message_type = 'success';
                    header("location:".$_SERVER['PHP_SELF']."?ctg=projects&edit_project=".$newProject -> project['id']."&tab=project_users");
                } else {
                    $currentProject -> project['title']       = $values['title'];
                    $currentProject -> project['data']        = $values['data'];
                    $currentProject -> project['deadline']    = $deadline;
                    $currentProject -> project['auto_assign'] = $values['auto_assign'] ? 1 : 0;
                    $currentProject -> persist();

                    $message = _PROJECTUPDATEDSUCCESSFULLY;
                    header("location:".$_SERVER['PHP_SELF']."?ctg=projects&message=".urlencode($message)."&message_type=success");
                }
            } catch (Exception $e) {
                $message      = _SOMEPROBLEMOCCURED.': '.$e -> getMessage().' ('.$e -> getCode().')';
                $message_type = 'failure';
            }
        }
        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

        $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
        $form -> setRequiredNote(_REQUIREDNOTE);
        $form -> accept($renderer);

        $smarty -> assign('T_ADD_PROJECT_FORM', $renderer -> toArray());

        //Build the project users list
        if (isset($_GET['ajax']) && $_GET['ajax'] == 'usersTable') {
            $users        = $currentLesson  -> getUsers('student');
            $projectUsers = $currentProject -> getUsers();
            foreach ($users as $key => &$user) {
                in_array($key, array_keys($projectUsers)) ? $user['checked'] = 1 : $user['checked'] = 0;        //Set the checked status, depending on whether the user has this project
            }
            isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;

            if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                $sort = $_GET['sort'];
                isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
            } else {
                $sort = 'login';
            }
            $users = eF_multiSort($users, $sort, $order);
            $smarty -> assign("T_USERS_SIZE", sizeof($users));
            if (isset($_GET['filter'])) {
                $users = eF_filterData($users, $_GET['filter']);
            }
            if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                $users = array_slice($users, $offset, $limit);
            }

            $smarty -> assign("T_ALL_USERS", $users);
            $smarty -> display('professor.tpl');
            exit;
        }
        //ajax request to register users with project
        if (isset($_GET['postAjaxRequest'])) {
            try {
                $users        = $currentLesson  -> getUsers('student');
                $projectUsers = $currentProject -> getUsers();
                if (isset($_GET['login']) && eF_checkParameter($_GET['login'], 'login')) {
                    if (in_array($_GET['login'], array_keys($projectUsers))) {                    //The user has the project, so remove him
                        $currentProject -> removeUsers($_GET['login']);
                    } elseif (in_array($_GET['login'], array_keys($users))) {                     //The user doesn't have the project, so add him
                        $currentProject -> addUsers($_GET['login']);
                    }
                } else if (isset($_GET['addAll'])) {
                    $currentProject -> addUsers(array_keys($users));
                } else if (isset($_GET['removeAll'])) {
                    $currentProject -> removeUsers(array_keys($projectUsers));
                }
            } catch (Exception $e) {
                echo $e -> getMessage().' ('.$e -> getCode().')';
            }
            exit;
        }
    } else if (isset($_GET['project_results']) && eF_checkParameter($_GET['project_results'], 'id') && in_array($_GET['project_results'], array_keys($projects))) {
        $loadScripts[] = 'scriptaculous/scriptaculous';                            //Load effects to be used on ajax users assignment
        $loadScripts[] = 'scriptaculous/effects';

        $currentProject = $projects[$_GET['project_results']];
        $smarty -> assign("T_CURRENT_PROJECT", $currentProject);
        if (isset($_GET['ajax']) && $_GET['ajax'] == 'usersTable') {
            $users          = $currentProject -> getUsers();
            $files          = eF_getTableDataFlat("files", "id,original_name");
            sizeof($files) > 0 ? $files = array_combine($files['id'], $files['original_name']) : $files = array();
            foreach ($users as $key => &$user) {
                $user['filename'] ? $user['file'] = $files[$user['filename']] : null;
                in_array($key, array_keys($projectUsers)) ? $user['checked'] = 1 : $user['checked'] = 0;        //Set the checked status, depending on whether the user has this project
            }

            isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;

            if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                $sort = $_GET['sort'];
                isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
            } else {
                $sort = 'login';
            }
            $users = eF_multiSort($users, $sort, $order);
            $smarty -> assign("T_USERS_SIZE", sizeof($users));
            if (isset($_GET['filter'])) {
                $users = eF_filterData($users, $_GET['filter']);
            }
            if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                $users = array_slice($users, $offset, $limit);
            }

            $smarty -> assign("T_ALL_USERS", $users);
            $smarty -> display('professor.tpl');
            exit;
        }
        //ajax request to register project grades and comments
        if (isset($_GET['postAjaxRequest'])) {
            try {
                $projectUsers = $currentProject -> getUsers();
                if (isset($_GET['login']) && eF_checkParameter($_GET['login'], 'login') && in_array($_GET['login'], array_keys($projectUsers))) {
                    $currentProject -> grade($_GET['login'], $_GET['grade'], $_GET['comments']);
                }
            } catch (Exception $e) {
                echo $e -> getMessage().' ('.$e -> getCode().')';
            }
            exit;
        }
    } else {
        $currentProjects = array();
        $passedProjects  = array();
        foreach ($projects as &$project) {
            $projectUsers = $project -> getUsers();                                            //getUsers() initializes user information for the specified projects
            $project -> timeRemaining ? $currentProjects[] = $project : $passedProjects[] = $project;
        }

        $smarty -> assign("T_CURRENT_PROJECTS", $currentProjects);
        $smarty -> assign("T_ACTIVE_COUNT", sizeof($currentProjects));

        $smarty -> assign("T_EXPIRED_PROJECTS", $passedProjects);
        $smarty -> assign("T_INACTIVE_COUNT", sizeof($passedProjects));
    }

}
/*
Tests page is responsible for displaying and configuring tests and questions
The professor may add, change and delete questions and tests
The code below is responsible for displaying tests and questions. The functions
used to configure them is included from module_addTest.php and module_addQuestion.php
*/
elseif ($ctg == 'tests') {
    $loadScripts[] = 'drag-drop-folder-tree';
    $loadScripts[] = 'ASCIIMathML';
    $loadScripts[] = 'scriptaculous/scriptaculous';
    $loadScripts[] = 'scriptaculous/sidebar_extra';

    /**The tests module file*/
    include_once ('module_tests.php');


}
/*
The rules page is used to configure lesson rules and conditions.
Conditions are used to set the prerequisites that must be met so that a student
is considered to have completed the lesson succesfully. Furthermore, the professor
here defines the certificate details.
Rules are used to define a "lesson path". The user may access or not specific content
based on these rules
*/
elseif ($ctg == 'rules') {
    $rules = $currentContent -> getRules();
    foreach ($iterator = new EfrontAttributeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree)), array('id', 'name')) as $key => $value) {
        $key == 'id' ? $ids[] = $value : $names[] = $value;
    }
    $smarty -> assign("T_TREE_NAMES", array_combine($ids, $names));
    $smarty -> assign("T_RULES", array_values($rules));                                        //We pass array_values, so that the leys are reindexed and we can use "section" in the template (in order not to change the template)

    $conditions      = $currentLesson -> getConditions();
    $condition_types = array('all_units'        => _PASSEDALLUNITS,
                             'percentage_units' => _PERCENTAGEUNITS,
                             'specific_unit'    => _SPECIFICUNIT,
                             'all_tests'        => _PASSEDALLTESTS,
                             'specific_test'    => _SPECIFICTEST);
    $smarty -> assign("T_LESSON_CONDITIONS", $conditions);
    $smarty -> assign("T_CONDITION_TYPES", $condition_types);

    if (isset($_GET['delete_rule']) && eF_checkParameter($_GET['delete_rule'], 'id')) {
        try {
            $currentContent -> deleteRules($_GET['delete_rule']);
            $message      = _RULEDELETED;
            $message_type = 'success';
        } catch (Exception $e) {
            $message      = _SOMEPROBLEMEMERGED.': '.$e -> getMessage().'('.$e -> getCode().')';
            $message_type = "failure";
        }
        header("location:".$_SERVER['PHP_SELF']."?ctg=rules&message=".$message."&message_type=".$message_type);
    } elseif (isset($_GET['add_rule']) || (isset($_GET['edit_rule']) && eF_checkParameter($_GET['edit_rule'], 'id'))) {
        isset($_GET['add_rule']) ? $post_target = 'add_rule=1' : $post_target = 'edit_rule='.$_GET['edit_rule'];

        $form = new HTML_QuickForm("add_rule_form", "post", $_SERVER['PHP_SELF']."?ctg=rules&".$post_target, "", null, true);
        $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');
        $form -> registerRule('in_array', 'callback', 'in_array');

        $users = $currentLesson -> getUsers('student');
        sizeof($users) > 0 ? $users = array('*' => _ALLOFTHEM) + array_combine(array_keys($users), array_keys($users)) : $users = array('*' => _ALLOFTHEM);

        $form -> addElement('select', 'scope', null, $users, 'class = "inputSelect"');
        $form -> addRule('scope', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
        $form -> addRule('scope', _INVALIDLOGIN, 'checkParameter', 'text');

        $testsIterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('ctg_type' => 'tests', 'active' => true));    //Get active test units
        $testUnits     = $currentContent -> toHTMLSelectOptions($testsIterator);

        $noTestsIterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('ctg_type' => 'tests', 'active' => false), false);    //Get active units that are anything but tests (false negates both rules)
        $noTestUnits     = $currentContent -> toHTMLSelectOptions($noTestsIterator);

        $form -> addElement('select', 'exclusion_unit', null, $currentContent -> toHTMLSelectOptions(), 'class = "inputSelect"');
        $form -> addRule('exclusion_unit', _INVALIDID, null, 'numeric');

        $rule_type = array('always' => _ALWAYS, 'hasnot_seen' => _HASNOTSEENTHEUNIT, 'hasnot_passed' => _HASNOTPASSEDTHETEST);
        $form -> addElement('select', 'rule_type', null, $rule_type, 'class = "inputSelect" onchange = "eF_js_selectRule(this)"');
        $form -> addRule('rule_type', _INVALIDRULE, 'in_array', array_keys($rule_type));

        $form -> addElement('select', 'rule_unit', null, $noTestUnits, 'class = "inputSelect"');
        $form -> addRule('rule_unit', _INVALIDID, 'numeric', null, 'client');

        $form -> addElement('select', 'test_unit', null, $testUnits, 'class = "inputSelect"');
        $form -> addRule('test_unit', _INVALIDID, 'numeric', null, 'client');

        $form -> addElement('text', 'score', null, 'style = "width:5em"');
        $form -> addRule('score', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
        $form -> addRule('score', _INVALIDSCORE, 'numeric');

        $form -> addElement('submit', 'submit_rule', _SUBMIT, 'class = "flatButton"');

        if ($_GET['edit_rule']) {
            $form -> setDefaults(array('scope'          => $rules[$_GET['edit_rule']]['users_LOGIN'],
                                       'exclusion_unit' => $rules[$_GET['edit_rule']]['content_ID'],
                                       'rule_type'      => $rules[$_GET['edit_rule']]['rule_type'],
                                       'rule_unit'      => $rules[$_GET['edit_rule']]['rule_content_ID'],
                                       'test_unit'      => $rules[$_GET['edit_rule']]['rule_content_ID'],
                                       'score'          => $rules[$_GET['edit_rule']]['rule_option'] * 100));
            $smarty -> assign("T_CURRENT_RULE", $rules[$_GET['edit_rule']]['rule_type']);
        } else {
            $form -> setDefaults(array('score' => 50));
        }

        if ($form -> isSubmitted()) {
            if ($form -> exportValue('rule_type') == 'hasnot_passed' && ($form -> exportValue('score') < 1 || $form -> exportValue('score') > 100)) {
                $message      = _RATEMUSTBEBETWEEN0100;
                $message_type = 'failure';
            } elseif ($form -> validate()) {
                $fields = array('users_LOGIN' => $form -> exportValue('scope'),
                                'content_ID'  => $form -> exportValue('exclusion_unit'));

                switch ($form -> exportValue('rule_type')) {
                    case 'always':
                        $fields['rule_type'] = 'always';
                        break;
                    case 'hasnot_seen':
                        $fields['rule_type']       = 'hasnot_seen';
                        $fields['rule_content_ID'] = $form -> exportValue('rule_unit');
                        break;
                    case 'hasnot_passed':
                        $fields['rule_type']       = 'hasnot_passed';
                        $fields['rule_content_ID'] = $form -> exportValue('test_unit');
                        $fields['rule_option']     = round($form -> exportValue('score') / 100, 2);
                        break;
                    default:
                        break;
                }

                if (isset($_GET['edit_rule'])) {
                    if (eF_updateTableData("rules", $fields, "id=".$_GET['edit_rule'])) {
                        $message      = _SUCCESFULLYUPDATEDRULE;
                        $message_type = 'success';
                        header("location:".$_SERVER['PHP_SELF']."?ctg=rules&message=".$message."&message_type=".$message_type);
                    } else {
                        $message      = _SOMEPROBLEMEMERGED;
                        $message_type = 'failure';
                    }
                } else {
                    if (eF_insertTableData("rules", $fields)) {
                        $message      = _SUCCESFULLYINSERTEDRULE;
                        $message_type = 'success';
                        header("location:".$_SERVER['PHP_SELF']."?ctg=rules&message=".$message."&message_type=".$message_type);
                    } else {
                        $message      = _SOMEPROBLEMEMERGED;
                        $message_type = 'failure';
                    }
                }
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

        $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
        $form -> setRequiredNote(_REQUIREDNOTE);
        $form -> accept($renderer);

        $smarty -> assign('T_ADD_RULE_FORM', $renderer -> toArray());

    } elseif (isset($_GET['delete_condition']) && eF_checkParameter($_GET['delete_condition'], 'id')) {
        try {
            $currentLesson -> deleteConditions($_GET['delete_condition']);
            $message      = _SUCCESFULLYDELETEDCONDITION;
            $message_type = 'success';
        } catch (Exception $e) {
            $message      = _SOMEPROBLEMEMERGED.': '.$e -> getMessage().'('.$e -> getCode().')';
            $message_type = "failure";
        }
        header("location:".$_SERVER['PHP_SELF']."?ctg=rules&tab=conditions&message=".$message."&message_type=".$message_type);
    } elseif (isset($_GET['add_condition']) || (isset($_GET['edit_condition']) && eF_checkParameter($_GET['edit_condition'], 'id'))) {
        isset($_GET['add_condition']) ? $post_target = 'add_condition=1' : $post_target = 'edit_condition='.$_GET['edit_condition'];

        $form = new HTML_QuickForm("complete_lesson_form", "post", $_SERVER['PHP_SELF'].'?ctg=rules&tab=conditions&'.$post_target, "", null, true);
        $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter
        $form -> registerRule('in_array', 'callback', 'in_array');

        $testsIterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('ctg_type' => 'tests', 'active' => true));    //Get active test units
        $testUnits     = $currentContent -> toHTMLSelectOptions($testsIterator);

        $noTestsIterator = new EfrontNodeFilterIterator(new RecursiveIteratorIterator(new RecursiveArrayIterator($currentContent -> tree), RecursiveIteratorIterator :: SELF_FIRST), array('ctg_type' => 'tests', 'active' => false), false);    //Get active units that are anything but tests (false negates both rules)
        $noTestUnits     = $currentContent -> toHTMLSelectOptions($noTestsIterator);

        $form -> addElement('select', 'condition_types', null, $condition_types, 'class = "inputSelect" onchange = "eF_js_selectCondition(this)"');
        $form -> addRule('condition_types', _INVALIDCONDITION, 'in_array', array_keys($condition_types));

        $form -> addElement('text', 'percentage_units', null, 'style = "width:2.5em"');
        $form -> setDefaults(array('percentage_units' => 50));
        $form -> addRule('percentage_units', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
        $form -> addRule('percentage_units', _INVALIDPERCENTAGE, 'numeric');

        $form -> addElement('select', 'specific_unit', null, $noTestUnits, 'class = "inputSelect"');
        $form -> addRule('specific_test', _INVALIDID, 'numeric', null, 'client');

        $form -> addElement('select', 'specific_test', null, $testUnits, 'class = "inputSelect"');
        $form -> addRule('test_unit', _INVALIDID, 'numeric', null, 'client');

        $form -> addElement('text', 'all_tests', null, 'style = "width:2.5em"');
        $form -> setDefaults(array('all_tests' => 50));
        $form -> addRule('all_tests', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
        $form -> addRule('all_tests', _INVALIDSCORE, 'numeric');

        $form -> addElement('text', 'specific_test_score', null, 'style = "width:2.5em"');
        $form -> setDefaults(array('specific_test_score' => 50));
        $form -> addRule('specific_test_score', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
        $form -> addRule('specific_test_score', _INVALIDSCORE, 'numeric');

        $form -> addElement('select', 'relation', null, array('and' => _AND, 'or' => _OR));

        $form -> addElement('submit', 'submit_complete_lesson_condition', _SUBMIT, 'class = "flatButton"');

        if (isset($_GET['edit_condition'])) {
            $smarty -> assign('T_CURRENT_CONDITION', $conditions[$_GET['edit_condition']]);
            $form -> setDefaults(array('condition_types' => $conditions[$_GET['edit_condition']]['type'], 'relation' => $conditions[$_GET['edit_condition']]['relation']));
            $form -> freeze('condition_types');

            $options = $conditions[$_GET['edit_condition']]['options'];
            switch ($conditions[$_GET['edit_condition']]['type']) {
                case 'percentage_units': $defaults = array('percentage_units' => $options[0]);                                                                                    break;
                case 'specific_unit':    $defaults = array('specific_unit'    => $options[0]);                                                                                    break;
                case 'all_tests':        $defaults = array('all_tests'        => $options[0]);                                                                                    break;
                case 'specific_test':    $defaults = array('specific_test'    => $options[0], 'specific_test_score' => $options[1]); break;
                default: break;
            }
            $form -> setDefaults($defaults);
        }

        if ($form -> isSubmitted()) {
            if ($form -> validate()) {
                $fields = array('lessons_ID' => $_SESSION['s_lessons_ID'],
                                'type'       => $form -> exportValue('condition_types'),
                                'relation'   => $form -> exportValue('relation'));

                switch ($form -> exportValue('condition_types')) {
                    case 'percentage_units': $fields['options'] = serialize(array(0 => $form -> exportValue('percentage_units')));    break;
                    case 'specific_unit':    $fields['options'] = serialize(array(0 => $form -> exportValue('specific_unit')));       break;
                    case 'all_tests':        $fields['options'] = serialize(array(0 => $form -> exportValue('all_tests')));           break;
                    case 'specific_test':    $fields['options'] = serialize(array(0 => $form -> exportValue('specific_test'),
                                                                                  1 => $form -> exportValue('specific_test_score'))); break;
                    default: break;
                }

                if (isset($_GET['add_condition'])) {
                    if (eF_insertTableData('lesson_conditions', $fields)) {
                        $message      = _SUCCESFULLYADDEDCONDITION;
                        $message_type = 'success';
                        header("location:".$_SERVER['PHP_SELF']."?ctg=rules&tab=conditions&message=".$message."&message_type=".$message_type);
                    } else {
                        $message      = _SOMEPROBLEMEMERGED;
                        $message_type = 'failure';
                    }
                } else {
                    if (eF_updateTableData('lesson_conditions', $fields, "id=".$_GET['edit_condition'])) {
                        $message      = _SUCCESFULLYUPDATEDCONDITION;
                        $message_type = 'success';
                        header("location:".$_SERVER['PHP_SELF']."?ctg=rules&tab=conditions&message=".$message."&message_type=".$message_type);
                    } else {
                        $message      = _SOMEPROBLEMEMERGED;
                        $message_type = 'failure';
                    }
                }
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

        $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
        $form -> setRequiredNote(_REQUIREDNOTE);
        $form -> accept($renderer);

        $smarty -> assign('T_COMPLETE_LESSON_FORM', $renderer -> toArray());
    }
}
/*
The statistics page displays all statistic information that concerns the professor.
This information is calculated and displayed through module_statistics.php
*/
elseif ($ctg == 'statistics') {
    if ($currentUser -> roleOptions['statistics'] == 1){
        /**This file does all the statistics job*/
        require_once "module_statistics.php";
    } else {
        $message        = _UNPRIVILEGEDATTEMPT;
        $message_type   = "failure";
    }
}
/**************/
/* MODULE HCD */
/**************/
elseif ($ctg == 'module_hcd' && MODULE_HCD_INTERFACE) {
   include "module_hcd.php";
}
/*
Emails is the page that is used to send email to system users.
*/
elseif ($ctg == "emails" && MODULE_HCD_INTERFACE) {
   include "emails.php";
}
/*
Users is the page that concerns EMPLOYEE administration for users with supervisor rights. It uses module_personal.php to perform most of the update functions,
since the same functions need to be performed from the professor and student as well (for themseleves)
There are 5 sub options in this page, denoted by an extra link part:
- &add_user=1                   When we are adding a new user
- &delete_user=<login>          When we want to delete user <login>
- &edit_user=<login>            When we want to edit user <login>
- &deactivate_user=<login>      When we deactivate user <login>
- &activate_user=<login>        When we activate user <login>
*/
elseif ($ctg == 'users' && MODULE_HCD_INTERFACE) {

    $unprivileged = false;                          //This variable is used to check whether the current user is elegible (based on his role) to access this area
    $currentEmployee = $currentUser -> aspects['hcd'];
    if ($_SESSION['s_type'] != "administrator" && $currentEmployee -> getType() != _SUPERVISOR && !($currentEmployee -> getType() == _EMPLOYEE && (isset($_GET['add_evaluation'])||isset($_GET['edit_evaluation']) || isset($_GET['delete_evaluation'])) && $_SESSION['s_type']=="professor" )) {
        $message      = _SORRYYOUDONOTHAVEPERMISSIONTOPERFORMTHISACTION;
        $message_type = "failure";
        header("location:".$_SERVER['HTTP_REFERER']."&message=".$message."&message_type=".$message_type);
        exit;
    } else {

        if (isset($_GET['delete_user']) && eF_checkParameter($_GET['delete_user'], 'login') && !$unprivileged) {    //The administrator asked to delete a user
            if (eF_deleteUser($_GET['delete_user'])) {

                /** MODULE HCD: Delete the employee relevant information **/
                if ($module_hcd_interface) {
                    eF_deleteTableData("module_hcd_employees", "users_login='".$_GET['delete_user']."'");
                    eF_deleteTableData("module_hcd_employee_has_skill", "users_login='".$_GET['delete_user']."'");
                    eF_deleteTableData("module_hcd_employee_has_job_description", "users_login='".$_GET['delete_user']."'");
                    eF_deleteTableData("module_hcd_employee_works_at_branch", "users_login='".$_GET['delete_user']."'");

                    // Register user's firing into the event log
                    eF_insertTableData("module_hcd_events", array("event_code"    => $MODULE_HCD_EVENTS['FIRED'],
                                                                  "users_login"   => $_GET['delete_user'],
                                                                  "specification" => _FIRED,
                                                                  "timestamp"     => time()));
                    $message      = _EMPLOYEEDELETED;
                } else {
                    $message      = _USERDELETED;
                }
                $message_type = 'success';
            } else {
                $message      = _SOMEORALLOFTHEUSERELEMENTSCOULDNOTBEDELETED;
                $message_type = "failure";
            }
            header("location:".$_SERVER['PHP_SELF']."?ctg=users&message=".$message."&message_type=".$message_type);
        } elseif (isset($_GET['deactivate_user']) && eF_checkParameter($_GET['deactivate_user'], 'login') && !$unprivileged) {      //The administrator asked to deactivate a user
            if (eF_updateTableData("users", array('active' => 0), "login='".$_GET['deactivate_user']."'")) {
                $message      = _USERDEACTIVATED;
                $message_type = 'success';
            } else {
                $message      = _SOMEPROBLEMEMERGED;
                $message_type = "failure";
            }
            header("location:".$_SERVER['PHP_SELF']."?ctg=users&message=".$message."&message_type=".$message_type);
        } elseif (isset($_GET['activate_user']) && eF_checkParameter($_GET['activate_user'], 'login') && !$unprivileged) {          //The administrator asked to activate a user
            if (eF_updateTableData("users", array('active' => 1, 'pending' => 0), "login='".$_GET['activate_user']."'")) {
                $message      = _USERACTIVATED;
                $message_type = 'success';
            } else {
                $message      = _SOMEPROBLEMEMERGED;
                $message_type = "failure";
            }
            header("location:".$_SERVER['PHP_SELF']."?ctg=users&message=".$message."&message_type=".$message_type);
        } elseif (isset($_GET['add_user']) || (isset($_GET['edit_user']) && $login = eF_checkParameter($_GET['edit_user'], 'login')) && !$unprivileged) {   //The administrator asked to add a new user or to edit a user
            $smarty -> assign("T_PERSONAL", true);
            /**Include the personal settings file*/
            include "module_personal.php";                      //User addition and manipulation is done through module_personal.

        } else {                                                //The professor just asked to view the users
    //dddddddddddddddddd

            if (!MODULE_HCD_INTERFACE) {
                $result_with_lessons    = eF_getTableData("users_to_lessons, users","count( * ) AS lessons_num, users.*", "users_LOGIN = login AND users_LOGIN IN ( SELECT login FROM users) GROUP BY login");
                $result_without_lessons = eF_getTableData("users","*", "login NOT IN ( SELECT DISTINCT (users_LOGIN) FROM users_to_lessons)");
                $result = array_merge($result_with_lessons, $result_without_lessons);  //right is this: SELECT name, login, count( lessons_ID )FROM usersLEFT OUTER JOIN users_to_lessons ON users.login = users_to_lessons.users_LOGIN GROUP BY login
                for ($i = 0; $i < sizeof($result); $i++) {
                    foreach ($result[$i] as $key => $value) {
                        if ($key == 'user_type') {
                            $result[$i][$key] = $TRANSLATION[$value];
                        }
                    }
                }
                $smarty -> assign("T_USERS", $result);

            } else {

                $_GET['op'] = "employees";
                include "module_hcd.php";
            }
        }
   }
}

/*
The surveys page handles the surveys section. All the corresponding code is
inside module_surveys.php
*/
elseif ($ctg == 'survey') {
    /**This file handles surveys*/
    require_once "module_surveys.php";
}
/*
The glossary page is responsible for viewing and manipulating glossary words
*/
elseif ($ctg == 'glossary') {
    $glossary_words = eF_getTableData("glossary_words", "id,name,info", "lessons_ID=".$_SESSION['s_lessons_ID']);

    $words = eF_getAllGlossaryWords($glossary_words);
    $smarty -> assign("T_GLOSSARY", $words);
}
/*
*/
elseif ($ctg == 'calendar') {
    include_once "calendar.php";
}
/*
Settings is the page where the professor may set configuration variables concerning the lesson and
perform actions related to the lesson, specifically:
- Set lesson information
- Set lesson which parts of the lesson will be made accessible. Possible parts are:
  Theory, Examples, Projects, Tests, Rules,
  Comments, Forum, Chat, Glossary,
  Online users, SCORM, Periods per student,
  Digital Library, Calendar, New Content (etc)
*/
elseif ($ctg == 'settings') {
    $options = array(array('image' => isset($_GET['op'])                              ? '16x16/gear.png'    : '16x16/gear_gray.png',    'title' => _LESSONOPTIONS, 'link' => isset($_GET['op'])                                    ? $_SERVER['PHP_SELF'].'?ctg=settings'                  : 'javascript:void(0)', 'class' => isset($_GET['op'])                                    ? null : 'inactiveLink'),
               array('image' => !isset($_GET['op']) || $_GET['op'] != 'reset_lesson'  ? '16x16/refresh.png' : '16x16/refresh_gray.png', 'title' => _RESTARTLESSON, 'link' => !isset($_GET['op']) || $_GET['op'] != 'reset_lesson'  ? $_SERVER['PHP_SELF'].'?ctg=settings&op=reset_lesson'  : 'javascript:void(0)', 'class' => !isset($_GET['op']) || $_GET['op'] != 'reset_lesson'  ? null : 'inactiveLink'),
               array('image' => !isset($_GET['op']) || $_GET['op'] != 'import_lesson' ? '16x16/import2.png' : '16x16/import2_gray.png', 'title' => _IMPORTLESSON,  'link' => !isset($_GET['op']) || $_GET['op'] != 'import_lesson' ? $_SERVER['PHP_SELF'].'?ctg=settings&op=import_lesson' : 'javascript:void(0)', 'class' => !isset($_GET['op']) || $_GET['op'] != 'import_lesson' ? null : 'inactiveLink'),
               array('image' => !isset($_GET['op']) || $_GET['op'] != 'export_lesson' ? '16x16/export1.png' : '16x16/export1_gray.png', 'title' => _EXPORTLESSON,  'link' => !isset($_GET['op']) || $_GET['op'] != 'export_lesson' ? $_SERVER['PHP_SELF'].'?ctg=settings&op=export_lesson' : 'javascript:void(0)', 'class' => !isset($_GET['op']) || $_GET['op'] != 'export_lesson' ? null : 'inactiveLink'));
    $smarty -> assign("T_TABLE_OPTIONS", $options);

    if ($_GET['op'] == 'reset_lesson') {
        /*Reset lesson part*/
        $form = new HTML_QuickForm("reset_lesson_form", "post", $_SERVER['PHP_SELF'].'?ctg=settings&op=reset_lesson', "", null, true);
        $form -> addElement('checkbox', 'users',    null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson students
        $form -> addElement('checkbox', 'news',     null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson announcements
        $form -> addElement('checkbox', 'comments', null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson comments
        $form -> addElement('checkbox', 'rules',    null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson rules
        $form -> addElement('checkbox', 'calendar', null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson calendar
        $form -> addElement('checkbox', 'glossary', null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson glossary
        $form -> addElement('checkbox', 'tracking', null, null, 'class = "inputCheckBox"');         //Whether to delete the lesson tracking information
        $form -> addElement('submit', 'submit_reset_lesson', _SUBMIT, 'class = "flatButton"');

        if ($form -> isSubmitted() && $form -> validate()) {
            $lesson = new EfrontLesson($_SESSION['s_lessons_ID']);
            $lesson -> initialize(array_keys($form -> exportValues()));

            $message      = _RESTARTLESSONCOMPLETED;
            $message_type = 'success';
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
        $form -> accept($renderer);
        $smarty -> assign('T_RESET_LESSON_FORM', $renderer -> toArray());
    } elseif ($_GET['op'] == 'import_lesson') {
        /* Import part */
        $form = new HTML_QuickForm("import_lesson_form", "post", $_SERVER['PHP_SELF'].'?ctg=settings&op=import_lesson', "", null, true);
        $form -> addElement('checkbox', 'content',  null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson content
        $form -> addElement('checkbox', 'periods',  null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson periods
        $form -> addElement('checkbox', 'files',    null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson files
        $form -> addElement('checkbox', 'users',    null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson students
        $form -> addElement('checkbox', 'news',     null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson announcements
        $form -> addElement('checkbox', 'comments', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson comments
        $form -> addElement('checkbox', 'rules',    null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson rules
        $form -> addElement('checkbox', 'calendar', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson calendar
        $form -> addElement('checkbox', 'glossary', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson glossary
        $form -> addElement('checkbox', 'tracking', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson tracking information
        $form -> addElement('checkbox', 'surveys',  null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson surveys
        $form -> addElement('file', 'file_upload', null, 'class = "inputText"');                    //Lesson file
        $form -> addElement('submit', 'submit_import_lesson', _SUBMIT, 'class = "flatButton"');

        if ($form -> isSubmitted() && $form -> validate()) {
            try {
                $lesson       = new EfrontLesson($_SESSION['s_lessons_ID']);
                $directory    = new eF_Directory($lesson -> getDirectory());                    //the directory to upload the file to.
                $lesson      -> initialize(array_keys($form -> exportValues()));
                $uploadedFile = EfrontFileSystem :: uploadFile('file_upload', $directory -> getFullPath());
                $lesson      -> import($uploadedFile);

                $message      = _LESSONIMPORTEDSUCCESFULLY;
                $message_type = 'success';
            } catch (Exception $e) {
                $message      = _PROBLEMIMPORTINGFILE.': '.$e -> getMessage().' ('.$e -> getCode().')';
                $message_type = 'failure';
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
        $form -> accept($renderer);
        $smarty -> assign('T_IMPORT_LESSON_FORM', $renderer -> toArray());
    } elseif ($_GET['op'] == 'export_lesson') {

        /* Export part */
        $form = new HTML_QuickForm("export_lesson_form", "post", $_SERVER['PHP_SELF'].'?ctg=settings&op=export_lesson', "", null, true);
        $form -> addElement('checkbox', 'periods',  null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson periods
        $form -> addElement('checkbox', 'news',     null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson announcements
        $form -> addElement('checkbox', 'comments', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson comments
        $form -> addElement('checkbox', 'rules',    null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson rules
        $form -> addElement('checkbox', 'calendar', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson calendar
        $form -> addElement('checkbox', 'glossary', null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson glossary
        $form -> addElement('checkbox', 'surveys',  null, null, 'class = "inputCheckBox" checked');         //Whether to delete the lesson surveys
        $form -> addElement('submit', 'submit_export_lesson', _SUBMIT, 'class = "flatButton"');

        if ($form -> isSubmitted() && $form -> validate()) {
            try {
                $lesson = new EfrontLesson($_SESSION['s_lessons_ID']);
                $file = $lesson -> export(array_keys($form -> exportValues()));
                $smarty -> assign("T_EXPORTED_FILE", $file -> getInfo());

                $message      = _LESSONEXPORTEDSUCCESFULLY;
                $message_type = 'success';
            } catch (Exception $e) {
                $message = $e -> getMessage().' ('.$e -> getCode().')';
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
        $form -> accept($renderer);
        $smarty -> assign('T_EXPORT_LESSON_FORM', $renderer -> toArray());

    } else {
        /*
         This is the default settings page. It consists of two parts. On the first one, a list with lesson options is
         displayed, where the professor may choose which aspects of the lesson are active. On the second one, there
         are links to other options related to the lesson.
         */
        $lesson_options = eF_getTableData("lessons", "options", "id=".$currentLesson -> lesson['id']);    //Get lesson options registered for the current lesson
        $lesson_options[0]['options'] ? $lesson_options = (unserialize($lesson_options[0]['options'])) : $lesson_options = $currentLesson -> options;

        $lessonSettings['theory']          = array('text' => _THEORY,            'image' => isset($lesson_options['theory'])          && $lesson_options['theory']          ? "32x32/book_blue.png"     : "32x32/book_blue_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'theory\')',          'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['examples']        = array('text' => _EXAMPLES,          'image' => isset($lesson_options['examples'])        && $lesson_options['examples']        ? "32x32/lightbulb_on.png"  : "32x32/lightbulb_on_gray.png",  'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'examples\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['projects']        = array('text' => _PROJECTS,          'image' => isset($lesson_options['projects'])        && $lesson_options['projects']        ? "32x32/exercises.png"     : "32x32/exercises_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'projects\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['tests']           = array('text' => _TESTS,             'image' => isset($lesson_options['tests'])           && $lesson_options['tests']           ? "32x32/document_edit.png" : "32x32/document_edit_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'tests\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['survey']          = array('text' => _SURVEY,            'image' => isset($lesson_options['survey'])          && $lesson_options['survey']          ? "32x32/form_green.png"    : "32x32/form_green_gray.png",    'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'survey\')',          'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['rules']           = array('text' => _ACCESSRULES,       'image' => isset($lesson_options['rules'])           && $lesson_options['rules']           ? "32x32/recycle.png"       : "32x32/recycle_gray.png",       'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'rules\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['forum']           = array('text' => _FORUM,             'image' => isset($lesson_options['forum'])           && $lesson_options['forum']           ? "32x32/messages.png"      : "32x32/messages_gray.png",      'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'forum\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['comments']        = array('text' => _COMMENTS,          'image' => isset($lesson_options['comments'])        && $lesson_options['comments']        ? "32x32/note.png"          : "32x32/note_gray.png",          'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'comments\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['online']          = array('text' => _USERSONLINE,       'image' => isset($lesson_options['online'])          && $lesson_options['online']          ? "32x32/users4.png"        : "32x32/users4_gray.png",        'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'online\')',          'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['chat']            = array('text' => _CHAT,              'image' => isset($lesson_options['chat'])            && $lesson_options['chat']            ? "32x32/user1_message.png" : "32x32/user1_message_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'chat\')',            'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['scorm']           = array('text' => _SCORM,             'image' => isset($lesson_options['scorm'])           && $lesson_options['scorm']           ? "32x32/book_red.png"      : "32x32/book_red_gray.png",      'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'scorm\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        //$lessonSettings['dynamic_periods'] = array('text' => _PERIODSPERSTUDENT, 'image' => isset($lesson_options['dynamic_periods']) && $lesson_options['dynamic_periods'] ? "32x32/user1_time.png"    : "32x32/user1_time_gray.png",    'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'dynamic_periods\')', 'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['digital_library'] = array('text' => _DIGITALLIBRARY,    'image' => isset($lesson_options['digital_library']) && $lesson_options['digital_library'] ? "32x32/disk_blue.png"     : "32x32/disk_blue_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'digital_library\')', 'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['calendar']        = array('text' => _CALENDAR,          'image' => isset($lesson_options['calendar'])        && $lesson_options['calendar']        ? "32x32/calendar.png"      : "32x32/calendar_gray.png",      'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'calendar\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['new_content']     = array('text' => _NEWCONTENT,        'image' => isset($lesson_options['new_content'])     && $lesson_options['new_content']     ? "32x32/book_blue_new.png" : "32x32/book_blue_new_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'new_content\')',     'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['glossary']        = array('text' => _GLOSSARY,          'image' => isset($lesson_options['glossary'])        && $lesson_options['glossary']        ? "32x32/book_open2.png"    : "32x32/book_open2_gray.png",    'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'glossary\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
        $lessonSettings['tracking']        = array('text' => _TRACKING,          'image' => isset($lesson_options['tracking'])        && $lesson_options['tracking']        ? "32x32/dot-chart.png"     : "32x32/dot-chart_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'tracking\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);

        foreach ($modules as $module) {
            if ($module['mandatory'] == 'false') {
                $lessonSettings[$module['name']] = array('text' => $module['title'], 'image' => isset($lesson_options[$module['name']]) ? "32x32/component_green.png"  : "32x32/component_green_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \''.$module['name'].'\')', 'style' => 'color:gray', 'title' => _CLICKTOTOGGLE);
            }
        }

        foreach ($lesson_options as $key => $value) {                                               //Remove activated elements from above list
            if ($value) {
                $lessonSettings[$key]['onClick'] = 'activate(this, \''.$key.'\')';
                $lessonSettings[$key]['style']   = 'color:inherit';
            }
        }


        $smarty -> assign("T_LESSON_SETTINGS", $lessonSettings);

        if (isset($_GET['ajax']) && isset($_GET['activate']) && in_array($_GET['activate'], array_keys($lessonSettings))) {
            $lesson_options[$_GET['activate']] = 1;
            eF_updateTableData("lessons", array('options' => serialize($lesson_options)), "id=".$_SESSION['s_lessons_ID']);
            $currentLesson -> options = $lesson_options;

            $smarty -> assign("T_REFRESH_SIDE", "true");

            if ($currentLesson -> options['digital_library'] == 1) {                        //If the professor set a digital library, create the corresponding if folder, if it does not exist
                if (!is_dir(G_LESSONSPATH.$currentLesson -> lesson['id']."/"."Digital Library"))
                @mkdir(G_LESSONSPATH.$currentLesson -> lesson['id']."/"."Digital Library");
            }
            echo "Option activated";
            exit;

        } elseif (isset($_GET['ajax']) && isset($_GET['deactivate']) && in_array($_GET['deactivate'], array_keys($lessonSettings))) {
            unset($lesson_options[$_GET['deactivate']]);
            eF_updateTableData("lessons", array('options' => serialize($lesson_options)), "id=".$_SESSION['s_lessons_ID']);
            $currentLesson -> options = $lesson_options;
            echo "Option deactivated";
            exit;
        }
    }
}
/*
The lessons page is the page where the user chooses which lesson
to view
*/
elseif ($ctg == 'lessons') {
    $userLessons = $currentUser -> getLessons();                //Get user lessons
    $userCourses = $currentUser -> getCourses();

    if (sizeof($userLessons) == 0) {                                //This user hasn't enrolled to any lessons
        header("location:professor.php?ctg=personal&tab=lessons");
    } elseif (sizeof($userLessons) == 1 && !$currentLesson) {                           //The user has enrolled to a single lesson
        header("location:".current($userLessons).".php?ctg=control_panel&lessons_ID=".key($userLessons)."&message=".$message."&message_type=".$message_type);    //Redirect to the lesson's first page
    }

    if (isset($_GET['op']) && isset($_GET['course']) && in_array($_GET['course'], array_keys($userCourses))) {
        $loadScripts[] = 'scriptaculous/scriptaculous';                            //Load effects to be used on ajax users assignment
        $loadScripts[] = 'scriptaculous/effects';

        $options = array(array('image' => $_GET['op'] != 'course_info'          ? '16x16/about.png'                   : '16x16/about_gray.png',                   'title' => _COURSEINFORMATION,  'link' => $_GET['op'] != 'course_info'        ? $_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_info'         : 'javascript:void(0)', 'class' => $_GET['op'] != 'course_info'         ? null : 'inactiveLink'),
                         array('image' => $_GET['op'] != 'course_certificates'  ? '16x16/certificate.png'             : '16x16/certificate_gray.png',             'title' => _COURSECERTIFICATES, 'link' => $_GET['op'] != 'course_certificate' ? $_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_certificates' : 'javascript:void(0)', 'class' => $_GET['op'] != 'course_certificates' ? null : 'inactiveLink'),
                         array('image' => $_GET['op'] != 'course_rules'         ? '16x16/recycle.png'                 : '16x16/recycle_gray.png',                 'title' => _COURSERULES,        'link' => $_GET['op'] != 'course_rules'       ? $_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_rules'        : 'javascript:void(0)', 'class' => $_GET['op'] != 'course_rules'        ? null : 'inactiveLink'),
                         array('image' => $_GET['op'] != 'course_order'         ? '16x16/replace2.png'                : '16x16/replace2_gray.png',                'title' => _COURSEORDER,        'link' => $_GET['op'] != 'course_order'       ? $_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_order'        : 'javascript:void(0)', 'class' => $_GET['op'] != 'course_order'        ? null : 'inactiveLink'));
        $smarty -> assign("T_TABLE_OPTIONS", $options);

        $currentCourse = new EfrontCourse($_GET['course']);
        $smarty -> assign("T_CURRENT_COURSE", $currentCourse);

        if ($_GET['op'] == 'course_info') {
            $form = new HTML_QuickForm("empty_form", "post", null, null, null, true);

            $courseInformation = unserialize($currentCourse -> course['info']);
            $information       = new LearningObjectInformation($courseInformation);
            $smarty -> assign("T_COURSE_INFO_HTML", $information -> toHTML($form, false));

            $courseMetadata = unserialize($currentCourse -> course['metadata']);
            $metadata       = new DublinCoreMetadata($courseMetadata);
            $smarty -> assign("T_COURSE_METADATA_HTML", $metadata -> toHTML($form));

            if (isset($_GET['postAjaxRequest'])) {
                if (in_array($_GET['dc'], array_keys($information -> metadataAttributes))) {
                    if ($_GET['value']) {
                        $courseInformation[$_GET['dc']] = $_GET['value'];
                    } else {
                        unset($courseInformation[$_GET['dc']]);
                    }
                    $currentCourse -> course['info'] = serialize($courseInformation);
                } elseif (in_array($_GET['dc'], array_keys($metadata -> metadataAttributes))) {
                    if ($_GET['value']) {
                        $courseMetadata[$_GET['dc']] = $_GET['value'];
                    } else {
                        unset($courseMetadata[$_GET['dc']]);
                    }
                    $currentCourse -> course['metadata'] = serialize($courseMetadata);
                }

                $currentCourse -> persist();
                echo $_GET['value'];
                exit;
            }

        } else if ($_GET['op'] == 'course_certificates') {

            $users = EfrontStats::getStudentsCourseStatus($currentCourse);
			
            if (isset($_GET['edit_user']) && in_array($_GET['edit_user'], array_keys($users))) {
                $userStats = $users[$_GET['edit_user']];
                $form = new HTML_QuickForm("edit_user_complete_course_form", "post", $_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_certificates&edit_user='.$_GET['edit_user'].'&popup=1', "", null, true);
                $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter

                $form -> addElement('advcheckbox', 'completed', _COMPLETED, null, 'class = "inputCheckbox"');            //Whether the user has completed the course
                $form -> addElement('text', 'score', _SCORE, 'class = "inputText" style = "width:40px;"');                                                        //The user course score
                $form -> addRule('score', _THEFIELD.' "'._SCORE.'" '._MUSTBENUMERIC, 'numeric', null, 'client');                            //The score must be numeric
                $form -> addRule('score', _RATEMUSTBEBETWEEN0100, 'callback', create_function('&$a', 'return ($a >= 0 && $a <= 100);'));    //The score must be between 0 and 100

                $form -> addElement('textarea', 'comments', _COMMENTS, 'class = "inputContentTextarea simpleEditor" style = "width:100%;height:5em;"');      //Comments on student's performance
                $form -> addElement('submit', 'submit_course_complete', _SUBMIT, 'class = "flatButton"');       //The submit button

                $totalScore = 0;
                foreach ($userStats['lessonsStatus'] as $stat) {
                    $totalScore += $stat['score'] / sizeof($userStats['lessonsStatus']);
                }

                $form -> setDefaults(array("completed" => $userStats['completed'],
                                           "score"     => $userStats['completed'] ? $userStats['score'] : round($totalScore),
                                           "comments"  => $userStats['comments']));

                if ($form -> isSubmitted() && $form -> validate()) {
                    $fields = array("completed" => $form -> exportValue('completed'),
                                    "score"     => $form -> exportValue('completed') ? $form -> exportValue('score')    : 0,
                                    "comments"  => $form -> exportValue('completed') ? $form -> exportValue('comments') : '');
                    eF_updateTableData("users_to_courses", $fields, "users_LOGIN = '".$_GET['edit_user']."' and courses_ID=".$currentCourse -> course['id']);
                    echo '<script>parent.location="'.$_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_certificates&message='.urlencode(_STUDENTSTATUSCHANGED).'&message_type=success"</script>';//header('location:'.$_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_certificates&message='.urlencode(_STUDENTSTATUSCHANGED).'&message_type=success');
                }

                $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

                $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
                $form -> setRequiredNote(_REQUIREDNOTE);
                $form -> accept($renderer);

                $smarty -> assign('T_COMPLETE_COURSE_FORM', $renderer -> toArray());
                $smarty -> assign("T_USER_PROGRESS", $userStats);
            } else if (isset($_GET['issue_certificate']) && in_array($_GET['issue_certificate'], array_keys($users))) {
                try {
                    $certificate = $currentCourse -> prepareCertificate($_GET['issue_certificate']);
                    $currentCourse -> issueCertificate($_GET['issue_certificate'], serialize($certificate));
					header('location:'.$_SERVER['PHP_SELF'].'?ctg=lessons&course='.$_GET['course'].'&op=course_certificates&message='.urlencode(_STUDENTSTATUSCHANGED).'&message_type=success');
                } catch (Exception $e) {
                    $message      = _PROBLEMISSUINGCERTIFICATE.': '.$e -> getMessage().' ('.$e -> getCode().')';
                    $message_type = 'failure';
                }
            } else if (isset($_GET['revoke_certificate']) && in_array($_GET['revoke_certificate'], array_keys($users))) {
                try {
                    $currentCourse -> revokeCertificate($_GET['revoke_certificate']);
                    header('location:'.$_SERVER['PHP_SELF'].'?ctg=lessons&course='.$currentCourse -> course['id'].'&op=course_certificates&message='.urlencode(_CERTIFICATEREVOKED).'&message_type=success');
                } catch (Exception $e) {
                    $message      = _PROBLEMREVOKINGCERTIFICATE;
                    $message_type = 'failure';
                }
            } else if (isset($_GET['auto_complete'])) {
                if ($currentCourse -> course['auto_complete']) {
                    $currentCourse -> course['auto_complete']    = 0;
                    $currentCourse -> course['auto_certificate'] = 0;
                } else {
                    $currentCourse -> course['auto_complete'] = 1;
                }
                $currentCourse -> persist();
            } else if (isset($_GET['auto_certificate'])) {
                if ($currentCourse -> course['auto_certificate']) {
                    $currentCourse -> course['auto_certificate'] = 0;
                } else {
                    $currentCourse -> course['auto_certificate'] = 1;
                }
                $currentCourse -> persist();
            }

            if (isset($_GET['ajax']) && $_GET['ajax'] == 'usersTable') {
                foreach ($users as $key => $user) {
                    if ($user['user_type'] != 'student') {
                        unset($users[$key]);
                    }
                }

                isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;

                if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                    $sort = $_GET['sort'];
                    isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
                } else {
                    $sort = 'login';
                }
                $users = eF_multiSort($users, $sort, $order);
                $smarty -> assign("T_USERS_SIZE", sizeof($users));
                if (isset($_GET['filter'])) {
                    $users = eF_filterData($users, $_GET['filter']);
                }
                if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                    isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                    $users = array_slice($users, $offset, $limit);
                }
				foreach ($users as $key => &$value) {
					$value['issued_certificate'] = unserialize($value['issued_certificate']);
				}
                $smarty -> assign("T_USERS_PROGRESS", $users);
                $smarty -> display('professor.tpl');
                exit;
            }
			if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
				$result = eF_getTableData("users_to_courses", "*", "users_LOGIN = '".$_GET['user']."' and courses_ID = '".$_GET['course']."' limit 1");
				$row	= unserialize($result['0']['issued_certificate']);
				if (sizeof($row) == 5) {
					$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true);
					$pdf->SetCreator(PDF_CREATOR);
					$pdf->SetAuthor(PDF_AUTHOR);
					$pdf->SetTitle($doc_title);
					$pdf->SetSubject($doc_subject);
					$pdf->SetKeywords($doc_keywords);

					
					//set margins
					$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
					//set auto page breaks
					$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
					$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor
					$pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
					$pdf->setPrintHeader(false);
					$pdf->setPrintFooter(false); 
					$pdf->setLanguageArray($l); //set language items
					//initialize document
					//$pdf->AliasNbPages();
					$pdf->AddPage();
					$pdf->SetFont("FreeSerif","B",30);

					$pdf->SetTextColor(0,0,0);
					$pdf->Image('images/certificate.jpg', '0', '0', '0', '0', '', '');
					$pdf->Cell(0, 20, _CERTIFICATE, 0, 1, C, 0);
					$pdf->SetFont("FreeSerif","B",18);
					$pdf->Cell(0, 20, _CERTIFICATEHEAD, 0, 1, C, 0);

					$pdf->SetTextColor(131,146,141);
					$pdf->SetFont("FreeSerif","B",22);
					$pdf->Cell(0, 20, $row['surname']." ".$row['name'], 0, 1, C, 0);

					$pdf->SetFont("FreeSerif","B",18);
					$pdf->SetTextColor(0,0,0);
					$pdf->Cell(0, 10, _CERTIFICATEHASCOMPLETED, 0, 1, C, 0);

					$pdf->SetTextColor(131,146,141);
					$pdf->SetFont("FreeSerif","B",18);
					$pdf->Cell(0, 10, $row['course'], 0, 1, C, 0);

					$pdf->SetFont("FreeSerif","B",18);
					$pdf->SetTextColor(0,0,0);
					$pdf->Cell(0, 10, _CERTIFICATEWITHGRADES, 0, 1, C, 0);
					$pdf->SetTextColor(131,146,141);
					$pdf->Cell(0, 10, $row['score'], 0, 1, C, 0);

					$pdf->SetTextColor(0,0,0);
					$pdf->SetFont("FreeSerif","B",12);
					$pdf->Cell(0, 55, date("M-d-Y",$row['time']), 0, 1, C, 0);

					try {
						$logoFile = new eF_File($configuration['logo']);
						$logo	  = 'logo/'.$logoFile -> getPhysicalName();
					} catch (EfrontFileException $e) {
						$logo	  = "logo.png";
					}

					$pdf->Image('images/'.$logo, '30', '150', '30', '30', '', '');

					$pdf->Output();
				}
				exit(0);
			}
        } else if ($_GET['op'] == 'format_certificate') {
            $load_editor = true;
            $certificate = $currentCourse -> getCertificate();

            $form = new HTML_QuickForm("edit_course_certificate_form", "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=certificates&edit_certificate=1', "", null, true);
            $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter
            $form -> addElement('textarea', 'certificate', _CERTIFICATE, 'class = "mceEditor" style = "width:100%;height:30em;"');      //The certificate textarea
            $form -> addElement('submit', 'submit_certificate', _SUBMIT, 'class = "flatButton"');
            $form -> setDefaults(array('certificate' => $certificate));

            if ($form -> isSubmitted() && $form -> validate()) {
                try {
                    $currentCourse -> setCertificate($form -> exportValue('certificate'));
                    header("location:".$_SERVER['PHP_SELF']."?ctg=lessons&course=".$currentCourse -> course['id']."&op=format_certificate&message=".urlencode(_SUCCESFULLYUPDATEDCERTIFICATE)."&message_type=success");
                } catch (Exception $e) {
                    $message      = _SOMEPROBLEMEMERGED;
                    $message_type = 'failure';
                }
            }

            $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

            $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
            $form -> setRequiredNote(_REQUIREDNOTE);
            $form -> accept($renderer);

            $smarty -> assign('T_CERTIFICATE_FORM', $renderer -> toArray());

        } else if ($_GET['op'] == 'course_rules') {
            $courseLessons = $currentCourse -> getLessons();

            $rules_form = new HTML_QuickForm("course_rules_form", "post", $_SERVER['PHP_SELF']."?ctg=lessons&course=".$currentCourse -> course['id']."&op=course_rules", "", null, true);
            $rules_form -> addElement('submit', 'submit_rule', _SUBMIT, 'class = "flatButton"');
            if ($rules_form -> isSubmitted() && $rules_form -> validate()) {
                foreach ($_POST['rules'] as $rule_lesson) {
                    if (sizeof(array_unique($rule_lesson['lesson'])) != sizeof($rule_lesson['lesson'])) {
                        $duplicate = true;
                    }
                }
                if (!isset($duplicate)) {
                    try {
                        $currentCourse -> rules = $_POST['rules'];
                        $currentCourse -> persist();
                        header("location:".$_SERVER['PHP_SELF']."?ctg=lessons&course=".$currentCourse -> course['id']."&op=course_rules&message=".urlencode(_SUCCESFULLYSETORDER)."&message_type=success");
                    } catch (Exception $e) {
                        $message      = _PROBLEMSETTINGORDER.': '.$e -> getMessage().' ('.$e -> getCode().')';
                        $message_type = 'failure';
                    }
                } else {
                    $message      = _DUPLICATESARENOTALLOWED;
                    $message_type = 'failure';
                }
            }
            $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

            $rules_form -> accept($renderer);
            $smarty -> assign('T_COURSE_RULES_FORM', $renderer -> toArray());
            $smarty -> assign("T_COURSE_RULES", $currentCourse -> rules);
            $smarty -> assign('T_COURSE_LESSONS', $courseLessons);

            $smarty -> assign('T_COURSE', $currentCourse -> course);
            $smarty -> assign('T_COURSE_LESSONS', $courseLessons);
        } else if ($_GET['op'] == 'course_order') {
            $loadScripts[] = 'drag-drop-folder-tree';
            $courseLessons = $currentCourse -> getLessons();

            $smarty -> assign('T_COURSE', $currentCourse -> course);
            $smarty -> assign('T_COURSE_LESSONS', $courseLessons);

            if (isset($_GET['ajax']) && isset($_GET['order'])) {
                $order    = explode(",", $_GET['order']);
                $previous = 0;
                foreach ($order as $value) {
                    $result = explode("-", $value);
                    if (in_array($value, array_keys($courseLessons))) {
                        eF_updateTableData("lessons_to_courses", array("previous_lessons_ID" => $previous), "courses_ID=".$currentCourse -> course['id']." and lessons_ID=".$result[0]);
                    }
                    $previous = $result[0];
                }
                echo _TREESAVEDSUCCESSFULLY;
                exit;
            }
        }
    } else {
        $directionsTree = new EfrontDirectionsTree();
        $userLessons = $currentUser -> getLessons(true);
        $userCourses = $currentUser -> getCourses(true);
        $smarty -> assign("T_DIRECTIONS_TREE", $directionsTree -> toHTML(false, $userLessons, $userCourses));
    }

    /*
    $directionsTree = new EfrontDirectionsTree();
    $userLessons = $currentUser -> getNonLessons(true);
    $userCourses = $currentUser -> getNonCourses(true);
    $smarty -> assign("T_DIRECTIONS_TREE2", $directionsTree -> toHTML(false, $userLessons, $userCourses));
*/
    //$directionsTree = new EfrontDirectionsTree();
    //echo $directionsTree -> toHTML();

}
/*
The personal page is used to display the professor's personal information
and provides the means to edit this information
*/
elseif ($ctg == 'evaluations' && MODULE_HCD_INTERFACE) {
    /**This part is used to display the evaluations that have been written for the employee*/

    // Administrators and supervisors will see all evaluations for the employee while employee-professors will see only their own
    if ($_SESSION['s_type'] == "administrator" || $_SESSION['employee_type'] == _SUPERVISOR) {
        $evaluations = eF_getTableData("module_hcd_events", "*", "users_login = '".$_GET['user']."' AND event_code >=10","timestamp");
        if(!empty($evaluations)) {
            $smarty -> assign("T_EVALUATION", $evaluations);
        }
    } else if ($_SESSION['s_type'] == "professor") {
        $evaluations = eF_getTableData("module_hcd_events", "*", "users_login = '".$_GET['user']."' AND author = '".$_SESSION['s_login']."' AND event_code >=10","timestamp");
        if(!empty($evaluations)) {
            $smarty -> assign("T_EVALUATION", $evaluations);
        }
    }

}
/*
The personal page is used to display the professor's personal information
and provides the means to edit this information
*/
elseif ($ctg == 'personal') {
    /**This part is used to display the user's personal information*/
    include "module_personal.php";
}
/*
At this point, we apply module functionality
*/
elseif (sizeof($modules) > 0 && in_array($ctg, array_keys($module_ctgs))) {
    $module_mandatory = eF_getTableData("modules", "mandatory", "name = '".$ctg."'");
    if ($module_mandatory[0]['mandatory'] != 'false' || isset($currentLesson -> options[$ctg])) {
        include(G_MODULESPATH.$ctg.'/module.php');
        $smarty -> assign("T_CTG_MODULE", $module_ctgs[$ctg]);
    }
}

$fields_log = array ('users_LOGIN' => $_SESSION['s_login'],                                 //This is the log entry array
                     'timestamp'   => time(),
                     'action'      => 'lastmove',
                     'comments'    => 0,
                     'session_ip'  => eF_encodeIP($_SERVER['REMOTE_ADDR']));

eF_deleteTableData("logs", "users_LOGIN='".$_SESSION['s_login']."' AND action='lastmove'"); //Only one lastmove action interests us, so delete any other
eF_insertTableData("logs", $fields_log);

$smarty -> assign("T_HEADER_EDITOR", $load_editor);                                         //Specify whether we need to load the editor

if (isset($_GET['refresh'])) {
    $smarty -> assign("T_REFRESH_SIDE","true");
}

$smarty -> assign("T_HEADER_LOAD_SCRIPTS", array_unique($loadScripts));                    //array_unique, so it doesn't send duplicate entries

$smarty -> assign("T_CURRENT_CTG", $ctg);
$smarty -> assign("T_MENUCTG", $ctg);
$smarty -> assign("T_MENU", eF_getMenu());

$smarty -> assign("T_QUERIES", $numberOfQueries);

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);
$smarty -> assign("T_SEARCH_MESSAGE", $search_message);

$smarty -> assign("T_CONFIGURATION", $configuration);       //Assign global configuration values to smarty
$smarty -> assign("T_CURRENT_USER", $currentUser);
$smarty -> assign("T_CURRENT_LESSON", $currentLesson);

$smarty -> load_filter('output', 'eF_template_formatTimestamp');
$smarty -> load_filter('output', 'eF_template_formatLogins');

$debug_timeBeforeSmarty = microtime(true) - $debug_TimeStart;
$smarty -> display('professor.tpl');
$debug_timeAfterSmarty = microtime(true) - $debug_TimeStart;

$debug_TotalTime = microtime(true) - $debug_TimeStart;

if (G_DEBUG) {
    echo "
    <div onclick = 'this.style.display=\"none\"' style = 'position:absolute;top:0px;right:0px;background-color:lightblue;border:1px solid black' >
    <table>
        <tr><th colspan = '100%'>Benchmarking info (click to remove)</th></tr>
        <tr><td>Initialization time: </td><td>".round($debug_InitTime, 5)." sec</td></tr>
        <tr><td>Time up to smarty: </td><td>".round($debug_timeBeforeSmarty, 5)." sec</td></tr>
        <tr><td>Database time: </td><td>".round($databaseTime, 5)." sec</td></tr>
        <tr><td>Smarty overhead: </td><td>".round($debug_timeAfterSmarty - $debug_timeBeforeSmarty, 5)." sec</td></tr>
        <tr><td colspan = \"2\" class = \"horizontalSeparator\"></td></tr>
        <tr><td>Total execution time: </td><td>".round($debug_TotalTime, 5)." sec</td></tr>
        <tr><td>Execution time for this script is: </td><td>".round($debug_TotalTime - $debug_InitTime - ($debug_timeAfterSmarty - $debug_timeBeforeSmarty), 5)." sec</td></tr>
    </table>
    </div>";
}



