<?php
/**
* Import SCORM data
* 
* This page is used to import a SCORM 1.2 compatible unit or lesson to the platform
*
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";


/** Configuration file.*/
include_once $path."configuration.php";


//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);
//error_reporting(E_ALL);$db->debug = true;
//if (isset($_GET['close'])) {                                                                                    //must this window close?
//    print '<SCRIPT LANGUAGE="JavaScript">self.opener.location.reload(); window.close();</script>';
//}

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "professor") {                           //Only a professor may access this page
    header("location:index.php");
    exit;
}

/***/
//define ('SCORM_CONTENT_DIR', "content/lessons/");

if (!eF_checkParameter($_GET['lessons_ID'], 'id')) {
    eF_printMessage(_LESSONNOTSET);
    exit;
}

$lessons_ID = $_GET['lessons_ID'];

//$uploaddir        = "scorm_uploaded_files/";   //:      /
//$scorm_dir        = $uploaddir;
//$new_dir          = G_LESSONSPATH.$lessons_ID."/";
//$new_absolute_dir = G_LESSONSPATH.$lessons_ID."/";

if (isset($_POST['SCOsubmit'])) {
    $tree     = eF_getContentTree($nouse, $_SESSION['s_lessons_ID'], 0, false, false);          //Get the content tree in order for this unit to be put in the end.
    $last_idx = end($tree);
    
    $SCOname       = $_POST['SCOdata'];
    $filename      = $_POST['filename'];
    $fields_insert = array('name'                => $_POST['SCOname'], 
                           'data'                => '<iframe height = "100%" width = "100%" frameborder = "no" name = "scormFrameName" id = "scormFrameID" src = "'.G_RELATIVELESSONSLINK.$lessons_ID."/SCO_".$_POST['timestamp']."/".$filename.'" ></iframe><iframe name = "commitFrame" frameborder = "no" id = "commitFrame" width = "1" height = "1" style = "display:none"></iframe>', 
                           'parent_content_id'   => 0, 
                           'lessons_ID'          => $_POST['lessons_ID'], 
                           'timestamp'           => time(), 
                           'ctg_type'            => 'scorm', 
                           'active'              => 1, 
                           'previous_content_id' => $last_idx['id']);
    eF_insertTableData('content', $fields_insert);
    
}


if (isset($_POST['submit_upload_scorm'])) {   

    if (file_exists(G_SCORMPATH)) {                                                                          //'       
        eF_deleteFolder(G_SCORMPATH);
    }
    
    if (@mkdir(G_SCORMPATH)) {
        list($ok, $upload_messages, $upload_messages_type, $filename) = eF_handleUploads("scorm_file", G_SCORMPATH);    //Upload the file
        $message      = $upload_messages[0];
        $message_type = $upload_messages_type[0];
        $scorm_file   = $filename[0];
    } else {
        $ok      = false;
        $message = _COULDNOTCREATESCORMDIRECTORY;
    }

    if ($ok) {
        $timestamp       = time();
        $zip             = new Archive_zip($scorm_file);                                                                    //   zip      directory

        if (isset($_POST['SCOonly'])) {                                                                             //      SCO,    .
            $extracted_files = $zip -> extract(array('add_path' => G_LESSONSPATH.$lessons_ID."/SCO_".$timestamp));
            foreach($extracted_files as $value) {
                $path_parts = pathinfo(basename($value['filename']));
                if (basename($value['filename']) == 'index.html') {
                    $selected = 'index.html';
                } else if ($path_parts['extension'] == 'html' || $path_parts['extension'] == 'htm') {
                    $suggested[] = basename($value['filename']); 
                }
                $filenames[] = basename($value['filename']);
            }
            
            if (!isset($selected)) {
                $selected = $suggested[0];
            }
            
            $smarty -> assign("T_FILENAMES", $filenames);
            $smarty -> assign("T_SUGGESTED_FILENAMES", $suggested);
            $smarty -> assign("T_SUGGESTED_FILE", $selected);
            $smarty -> assign("T_TIMESTAMP", $timestamp);
        } else {   
            $extracted_files = $zip -> extract(array('add_path' => G_SCORMPATH));

            $total_fields = array();
            $resources    = array();
            $tagArray     = @eF_local_parseManifest(G_SCORMPATH);

            foreach($tagArray as $key => $value) {                                                                      //     imsmanifest
                $fields = array();
                switch ($value['tag']) {
                    case 'TITLE':
                        $cur = $value['parent_index'];
                        $total_fields[$cur]['name'] = $value['value'];
                        break;

                    case 'ITEM':
                        $total_fields[$key]['lessons_ID'] = $lessons_ID;
                        $total_fields[$key]['timestamp']  = time();
                        $total_fields[$key]['ctg_type']   = 'scorm';
                        $total_fields[$key]['active']     = 1;
                        $references[$key] = $value['attributes']['IDENTIFIERREF'];
                        break;

                    case 'RESOURCE':
                        $resources[$key] = $value['attributes']['IDENTIFIER'];
                        break;

                    case 'FILE':
                        $files[$key] = $value['attributes']['HREF'];
                        break;

                    case 'ADLCP:MAXTIMEALLOWED':
                        $maxtimeallowed[$key]  = $value['value'];
                        break;
                    case 'ADLCP:TIMELIMITACTION':
                        $timelimitaction[$key] = $value['value'];
                        break;
                    case 'ADLCP:MASTERYSCORE':
                        $masteryscore[$key]    = $value['value'];
                        break;
                    case 'ADLCP:DATAFROMLMS':
                        $datafromlms[$key]     = $value['value'];
                        break;

                    case 'ADLCP:PREREQUISITES':
                        $prerequisites[$key]   = $value['value'];
                        break;              

                    default:
                        break;
                }
            }


            foreach ($references as $key => $value) {
                $ref = array_search($value, $resources);
                if ($ref) {
                    $data = file_get_contents(G_SCORMPATH."/".$tagArray[$ref]['attributes']['HREF']);

                    $primitive_hrefs[$ref] = $tagArray[$ref]['attributes']['HREF'];
                    $path_part[$ref]       = dirname($primitive_hrefs[$ref]);

                    foreach($tagArray[$ref]['children'] as $value2) {
                        if ($tagArray[$value2]['tag'] == 'DEPENDENCY') {
                            $idx = array_search($tagArray[$value2]['attributes']['IDENTIFIERREF'], $resources);

                            foreach ($tagArray[$idx]['children'] as $value3) {
                                if ($tagArray[$value3]['tag'] == 'FILE')  {
                                    $data = preg_replace("#(\.\.\/(\w+\/)*)?".$tagArray[$value3]['attributes']['HREF']."#", G_LESSONSPATH.$lessons_ID."/".$path_part[$ref]."/$1".$tagArray[$value3]['attributes']['HREF'], $data);
                                }
                            }
                        }
                    }
                    //$total_fields[$key]['data'] = eF_postProcess(str_replace("'","&#039;",$data));      //               iframes ( 1  2)
                    $total_fields[$key]['data'] = '<iframe height = "100%"  width = "100%" frameborder = "no" name = "scormFrameName" id = "scormFrameID" src = "'.G_RELATIVELESSONSLINK.$lessons_ID."/".$primitive_hrefs[$ref].'" onload = "eF_js_setCorrectIframeSize()"></iframe><iframe name = "commitFrame" frameborder = "no" id = "commitFrame" width = "1" height = "1" style = "display:none"></iframe>';
                }
            }

            $tree = eF_getContentTree($nouse, $lessons_ID, 0, false, false);        //Get the content tree, so that we may append the imported content to the last unit.

            $this_id = $tree[sizeof($tree) - 1]['id'];
            foreach ($total_fields as $key => $value)  {
                if (isset($value['ctg_type']))  {
                    $total_fields[$key]['previous_content_ID'] = $this_id;

                    if (!isset($total_fields[$key]['parent_content_ID'])) {
                        $total_fields[$key]['parent_content_ID'] = 0;
                    }

                    $this_id = eF_insertTableData("content", $total_fields[$key]);

                    $tagArray[$key]['this_id'] = $this_id;
                    foreach($tagArray[$key]['children'] as $key2 => $value2) {
                        if (isset($total_fields[$value2])) {
                            $total_fields[$value2]['parent_content_ID'] = $this_id;
                        }
                    }
                } else  {                                                                                       // ,      array (..  organizations     ...) 
                    unset($total_fields[$key]);
                }
            }

            eF_local_buildDirectories(G_LESSONSPATH.$lessons_ID."/", G_SCORMPATH);

            foreach ($files as $key => $value) {
                    $newhref = $tagArray[$tagArray[$key]['parent_index']]['attributes']['XML:BASE'];
                    copy(G_SCORMPATH."/".trim($newhref,"/")."/".trim($value,"/"), G_LESSONSPATH.$lessons_ID."/".trim($newhref,"/")."/".trim($value,"/"));
            }

            $cur_dir = getcwd();
            chdir(G_SCORMPATH);
            $filelist = eF_getDirContents();
            foreach ($filelist as $value) {
                copy($value, G_LESSONSPATH.$lessons_ID."/".$value);
            }
            chdir($cur_dir);

            foreach ($timelimitaction as $key => $value) {
                $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];

                $fields_insert[$content_ID]['content_ID']      = $content_ID;
                $fields_insert[$content_ID]['timelimitaction'] = $value;
            }
            foreach ($maxtimeallowed as $key => $value) {
                $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];

                $fields_insert[$content_ID]['content_ID']     = $content_ID;
                $fields_insert[$content_ID]['maxtimeallowed'] = $value;
            }
            foreach ($masteryscore as $key => $value) {
                $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];

                $fields_insert[$content_ID]['content_ID']   = $content_ID;
                $fields_insert[$content_ID]['masteryscore'] = $value;
            }
            foreach ($datafromlms as $key => $value) {
                $content_ID = $tagArray[$tagArray[$key]['parent_index']]['this_id'];

                $fields_insert[$content_ID]['content_ID']  = $content_ID;
                $fields_insert[$content_ID]['datafromlms'] = $value;
            }

            foreach ($fields_insert as $value) {
                eF_insertTableData("scorm_data", $value);
            }


            foreach ($prerequisites as $key => $value) {
                foreach ($tagArray as $key2 => $value2) {
                    if (isset($value2['attributes']['IDENTIFIER']) && $value2['attributes']['IDENTIFIER'] == $value) {
                        unset($fields_insert);
                        $fields_insert['users_LOGIN'] = "*";
                        $fields_insert['content_ID']  = $tagArray[$tagArray[$key]['parent_index']]['this_id'];
                        $fields_insert['rule_type']   = "hasnot_seen";
                        $fields_insert['rule_content_ID'] = $value2['this_id'];
                        $fields_insert['rule_option'] = 0;
                        eF_insertTableData("rules", $fields_insert);
                    }
                }
            }

        }
        //$str .= '<table align = "center"><tr><td><a href = "" onClick="javascript:void(0);window.close();">['._CLOSEWINDOW.']</a></td></tr></table>';
    }
} 

//echo $str;

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display("scorm_import.tpl");



//--------------------------------------------------------------------
////////////////////////FUNCTIONS LIST///////////////////////////////



function eF_local_buildDirectories1($new_absolute_dir, $scorm_dir)
{   
    $current_dir = getcwd();
    chdir($scorm_dir);
    $path_array = eF_local_readDirRecursive();

    chdir($new_absolute_dir);

    foreach ($path_array as $value) {
        $path_parts = explode("/", $value);
        $this_dir   = $new_absolute_dir;
        for ($i = 1; $i < sizeof($path_parts); $i++) {
            if (!file_exists($this_dir.$path_parts[$i]."/")) {
                chdir($this_dir);
                mkdir($path_parts[$i]);
            }
            $this_dir .= $path_parts[$i]."/";
        }
        chdir($current_dir);
    }
}

function eF_local_readDirRecursive1($path = '.')
{
    $count = 0;
    $path_array[0] = $path;
    while (isset($path_array[$count])) {
        $handle = opendir($path_array[$count]);
        while (false !== ($file = readdir($handle))) { 
            if ($file != '.' && $file != '..') {
                if (is_dir($path_array[$count]."/".$file)) {
                    array_push($path_array, $path_array[$count]."/".$file);
                }
            }
        } 
        closedir($handle);
        $count++;
    }
    return $path_array;
}

/**
*       www.php.net
*/
function deldir1($dir)
{
    if (isset($dir) & $dir != '' & $dir != G_LESSONSPATH) {
        $current_dir = opendir($dir);
        while($entryname = readdir($current_dir)) {
            if(is_dir("$dir/$entryname") and ($entryname != "." and $entryname!="..")) {
                deldir("${dir}/${entryname}");
            } elseif($entryname != "." and $entryname!="..") {
                unlink("${dir}/${entryname}");
            }
        }
        closedir($current_dir);
        rmdir(${dir});
    }
}


function eF_local_parseManifest1($path)
{
    $filename = $path."/imsmanifest.xml";
    $data     = iconv("ISO-8859-7", "UTF-8", implode("", file($filename))); 
    $parser   = xml_parser_create(); 

    xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1); 
    xml_parse_into_struct($parser, $data, $tagContents, $tags); 
    xml_parser_free($parser);   

    $currentParent = array(0 => 0);

    for ($i = 0; $i < sizeof($tagContents); $i++) {
        if ($tagContents[$i]['type'] != 'close') {
            $tagArray[$i] = array('parent_index' => end($currentParent), 
                                  'tag'          => $tagContents[$i]['tag'],
                                  'value'        => $tagContents[$i]['value'],
                                  'attributes'   => $tagContents[$i]['attributes'],
                                  'children'     => array()
                            );
            array_push($tagArray[end($currentParent)]['children'], $i);
        }
        if ($tagContents[$i]['type'] == 'open') {
            array_push($currentParent, $i);
        } else if ($tagContents[$i]['type'] == 'close') {
            array_pop($currentParent);
        }
        
    }
    
    return $tagArray;   
}


?>
