<?php
/**
*
*/
$time_start = microtime(true);


$path = "../../libraries/";

/**   .*/
include_once $path."configuration.php";
/**Functions to perform searches*/
include_once "module_search.php";


//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);echo "</pre>";

eF_printHeader();


if (isset($_POST['submit'])) {

    switch ($_POST['category']) {
        case 'function': 
            list($occurences_in_files, $into_files) = eF_local_searchFunction();
            $smarty -> assign("T_OCCURENCES_IN_FILES", $occurences_in_files);    
            $smarty -> assign("T_INTO_FILES", $into_files);
            break;
        case 'language': 
            list ($in_files, $unused_tags) = eF_local_searchLanguage();
            $smarty -> assign("T_IN_FILES", $in_files);
            $smarty -> assign("T_UNUSED_TAGS", $unused_tags);
            break;
        case 'file': 
            list ($in_files, $unused_files) = eF_local_searchFiles();
            $smarty -> assign("T_IN_FILES", $in_files);
            $smarty -> assign("T_UNUSED_FILES", $unused_files);
            break;
        case 'image': 
            list($unlisted_files, $in_files, $non_existent_files) = eF_local_searchImage();
            $smarty -> assign("T_IN_FILES", $in_files);
            $smarty -> assign("T_UNLISTED_FILES", $unlisted_files);
            $smarty -> assign("T_NONEXISTENT_FILES", $non_existent_files);
            break;
        case 'any': 
            $in_files = eF_local_searchAny();
            $smarty -> assign("T_IN_FILES", $in_files);
            break;
        default: 
            break;
    }

    

//    $smarty -> assign("T_TOTAL_TIME", $total_time);
    
}


echo "<br>Total Execution time: ".round(microtime(true) - $time_start,2)." sec<br>";

$smarty -> display("analyze_code.tpl");

//***********************************************************************************************************************************************

/**
*
*/
function eF_local_searchAny() {
    if ($_POST['file_types'] == 'all') {
        $file_extension = array('php', 'tpl', 'html', 'htm', 'js');
    } else {
        $file_extension = array($_POST['file_types']);
    }
    
    $_POST['folders']     ? $directories    = explode(",", $_POST['folders']) : $directories = array('www/', 'libraries/'); //If a directory is not specified, search in libraries and www

    chdir('../../');           //Not really important, just to display filenames without '../' at the beginning
    if ($_POST['search_term'] == '') {            //Look for a specific file
        eF_printMessage("You must set a search term!");
        exit;
    }
    
    $files = array();
    foreach ($directories as $dir) {
        $files = array_merge($files, eF_getDirContents($dir.'/'));
    }

    foreach ($files as $key => $file) {
        if (in_array(pathinfo($file, PATHINFO_EXTENSION), $file_extension)) {
            $filename            = pathinfo($file, PATHINFO_BASENAME);
            $file_contents       = file_get_contents($file);
            $num_of_matches = strpos($file_contents, $_POST['search_term']);  
            if ($num_of_matches) {
                $in_files[] = $file;
            }                    
            unset($matches);
        }        
    }
//echo "<pre>";
//print_r($in_files);echo "</pre>";
    chdir('www/tools/');

    return $in_files;

}


/**
*
*/
function eF_local_searchFiles() {
    if ($_POST['file_types'] == 'all') {
        $file_extension = array('php', 'tpl', 'html', 'htm', 'js');
    } else {
        $file_extension = array($_POST['file_types']);
    }
    $_POST['folders']     ? $directories    = explode(",", $_POST['folders']) : $directories = array('www/', 'libraries/'); //If a directory is not specified, search in libraries and www

    chdir('../../');           //Not really important, just to display filenames without '../' at the beginning
    if ($_POST['search_term']) {            //Look for a specific file
        $search_files = array($_POST['search_term']);
    } else {                                //Get a list of all the files in the system, and look for them
        $search_files = array_merge(eF_getDirContents('www/', false), eF_getDirContents('libraries/', false));
    }
    
    foreach ($search_files as $key => $value) {         //Exclude directories and svn files
        if (strpos($value, '.svn')) {
            unset($search_files[$key]);
        }    
        if (is_dir($value)) {
            unset($search_files[$key]);
        }
    }
    
    $files = array();
    foreach ($directories as $dir) {
        $files = array_merge($files, eF_getDirContents($dir.'/'));
    }

    $unused_files = array_flip($search_files);
    
    foreach ($search_files as $search_file) {
        foreach ($files as $key => $file) {
            if (in_array(pathinfo($file, PATHINFO_EXTENSION), $file_extension)) {
                $filename            = pathinfo($file, PATHINFO_BASENAME);
                $file_contents       = file_get_contents($file);
                $num_of_matches = strpos($file_contents, basename($search_file));  
                if ($num_of_matches) {
                    $in_files[$search_file][] = $file;
                    unset($unused_files[$search_file]);
                }                    
                unset($matches);
            }        
        }
    }

    chdir('www/tools/');

    return array($in_files, array_keys($unused_files));
}

/**
*
*/
function eF_local_searchLanguage() {
error_reporting(E_WARNING);
    if ($_POST['file_types'] == 'all') {
        $file_extension = array('php', 'tpl', 'html', 'js');
    } else {
        $file_extension = array($_POST['file_types']);
    }
    $_POST['folders']     ? $directories    = explode(",", $_POST['folders']) : $directories = array('www/', 'libraries/'); //If a directory is not specified, search in libraries and www
    
    if ($_POST['search_term']) {
        $tags = array($_POST['search_term']);
    } else {
        $file_contents = file_get_contents('../../libraries/language/lang-english.php');
        $num_of_matches = preg_match_all("/define\(\"(_.*)\"\s*,\s*\".*\"\);\s*/", $file_contents, $matches);
        $tags = $matches[1];
    }

    chdir('../../');           //Not really important, just to display filenames without '../' at the beginning

    $files = array();
    foreach ($directories as $dir) {
        $files = array_merge($files, eF_getDirContents($dir.'/'));
    }

    $unused_tags = array_flip($tags);

    $count = 0;
    foreach ($tags as $tag) {    
    $count++;
        echo "$count. Searching for: $tag ";
        foreach ($files as $key => $file) {
            if (!strpos($file, 'language/lang-') && in_array(pathinfo($file, PATHINFO_EXTENSION), $file_extension)) {
                $filename            = pathinfo($file, PATHINFO_BASENAME);
                $file_contents       = file_get_contents($file);
                $num_of_matches      = strpos($file_contents, $tag);  
                if ($num_of_matches) {
                    $in_files[$tag][] = $file;
                    unset($unused_tags[$tag]);
                }
                unset($matches);
            }
        }
        echo "Instances: ".sizeof($in_files[$tag])."<br>";flush();ob_flush();
    }

    chdir('www/tools/');

    file_put_contents('test.txt', implode("\n", array_keys($unused_tags)));
    return array($in_files, array_keys($unused_tags));
}


/**
*
*/
function eF_local_searchImage() {

    if ($_POST['file_types'] == 'all') {
        $file_extension = array('php', 'tpl', 'html', 'htm', 'js');
    } else {
        $file_extension = array($_POST['file_types']);
    }
    $_POST['folders']     ? $directories    = explode(",", $_POST['folders']) : $directories = array('www/', 'libraries/'); //If a directory is not specified, search in libraries and www

    $image_types_extensions = array('png', 'jpg', 'gif', 'bmp', 'jpeg', 'ico');
    
    if ($_POST['search_term']) {            //Look for a specific image in files
        $image_files = array($_POST['search_term']);
    } else {                                //Get a list of all the images in the system, and look for them
        $image_files = eF_getDirContents('images/', $image_types_extensions, false);    //Get all image files
    }
    
    chdir('../../');           //Not really important, just to display filenames without '../' at the beginning

    $files = array();
    foreach ($directories as $dir) {
        $files = array_merge($files, eF_getDirContents($dir.'/'));
    }

    $occurences          = array();
    $occurences_in_files = array();
    
    foreach ($files as $key => $file) {
        if (in_array(pathinfo($file, PATHINFO_EXTENSION), $file_extension)) {
            $filename            = pathinfo($file, PATHINFO_BASENAME);
            $file_contents       = file_get_contents($file);
            //$num_of_matches      = preg_match_all("/<img\s+src\s*=\s*\"(\S+\.(".implode("|", $image_types_extensions)."))\".*>/", $file_contents, $matches);  
            $num_of_matches      = preg_match_all("/(\w+-*\w+\.(".implode("|", $image_types_extensions)."))/", $file_contents, $matches);  
            if ($matches[1]) {
                $occurences_in_files = array_merge($occurences_in_files, array($file => $matches[1]));
                $occurences          = array_merge($occurences, $matches[1]);                
            }
            unset($matches);
        }
    }
    $non_existent_files = array_flip($occurences);
    $unlisted_files     = array_flip($image_files);


    foreach ($image_files as $image_file) {
        foreach ($occurences_in_files as $filename => $occurence_in_file) {
            if (($place = array_search($image_file, $occurence_in_file)) !== false) {
                if (!isset($in_files[$image_file]) || (isset($in_files[$image_file]) && !in_array($filename, $in_files[$image_file]))) {
                    $in_files[$image_file][] = $filename;
                }
                unset($non_existent_files[$image_file]);
                unset($unlisted_files[$image_file]);
            } 
        }        
    }
    
    $temp = array();
    foreach ($non_existent_files as $file => $value) {
        foreach ($occurences_in_files as $filename => $occurence_in_file) {
            if (in_array($file, $occurence_in_file)) {
                $temp[$file][] = $filename;
            } 
        }
    }
    $non_existent_files = $temp;
    $unlisted_files     = array_keys($unlisted_files);
    
    chdir ('www/');

    return array($unlisted_files, $in_files, $non_existent_files);
  
}

/**
*
*/
function eF_local_searchFunction() {

    $default_search_string = 'eF_.*';

    if ($_POST['file_types'] == 'all') {
        $file_extension = array('php', 'tpl', 'html', 'htm', 'js');
    } else {
        $file_extension = array($_POST['file_types']);
    }

    $_POST['folders']     ? $directories    = explode(",", $_POST['folders']) : $directories = array('www/', 'libraries/'); //If a directory is not specified, search in libraries and www
    $_POST['search_term'] ? $preg_string    = $_POST['search_term']           : $preg_string = $default_search_string;      //If a specific search term is specified, use it; otherwise use the default search string for this query type

    chdir('../../');           //Not really important, just to display filenames without '../' at the beginning

    $files = array();
    foreach ($directories as $dir) {
        $files = array_merge($files, eF_getDirContents($dir.'/'));
    }
    
    $occurences          = array();
    $occurences_in_files = array();
    
    foreach ($files as $key => $file) {                                 //First pass, get all function declarations
        if (in_array(pathinfo($file, PATHINFO_EXTENSION), $file_extension)) {
            $filename            = pathinfo($file, PATHINFO_BASENAME);
            $file_contents       = file_get_contents($file);
            $num_of_matches      = preg_match_all("/\s*function\s*(".$preg_string.")\s*\(/", $file_contents, $matches);  //Find function declarations. We need to look through the whole file, to get all declarrations, so we use preg_match_all
            $occurences_in_files = array_merge($occurences_in_files, array($file => $matches[1]));
            $occurences          = array_merge($occurences, $matches[1]);

            unset($matches);
        }
    }

    $into_files = array();

//echo "<br>Execution time before PREG: ".round(microtime(true) - $time_start,2)." sec<br>";
    foreach ($files as $key => $file) {
        if (pathinfo($file, PATHINFO_EXTENSION) == 'php') {            
            $filename       = pathinfo($file, PATHINFO_BASENAME);
            $file_contents  = file_get_contents($file);
            foreach ($occurences as $key => $occurence) {
//                $t1 = microtime(true);                                          //Benchmarking
                if (preg_match("/\s*[^function]\s+".$occurence."\(.*\)/", $file_contents, $matches)) {    //Find all function uses, excluding their declarations. We only need to find a function once, so we use preg_match instead of preg_match_all
                    $into_files[$occurence][] = $filename;
                }
//                isset($total_time[$occurence]) ? $total_time[$occurence] += round(microtime(true) - $t1, 2) : $total_time[$occurence] = round(microtime(true) - $t1, 2);   //Benchmarking
            }            
            unset($matches);
        }
    }
//echo "<br>Execution time after PREG: ".round(microtime(true) - $time_start,2)." sec<br>";
    chdir('www/tools/');

    return array($occurences_in_files, $into_files);
}

?>




