<?php
/**
*  .
* 
*      ,     .
* @package efront
* @version 1.0
*/

//   .
session_cache_limiter('none');
session_start();
$path = "../../libraries/";
error_reporting(E_ALL);
/**   .*/
include_once $path."configuration.php";
//eF_printHeader();

if ($_GET['message']) {
    $message = $_GET['message'];
    $message_type = $_GET['message_type'];
}

$form = new HTML_QuickForm("stress_form", "post", $_SERVER['PHP_SELF'], "", null, true);
$form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter

//Users part
$form -> addElement('text', 'num_users', null);    
$form -> addRule('num_users', _INVALIDFIELDDATA, 'numeric', null, 'client', null, 'client');

$form -> addElement('select', 'users_type', null, array('student' => 'student', 'professor' => 'professor', 'admin' => 'admin'));    

$languages = eF_getLanguages();//pr($languages);
$languages = array_combine($languages, $languages);
$form -> addElement('select', 'users_language', null, $languages);    

$form -> addElement('advcheckbox', 'activate_users', null);    
$form -> addElement('advcheckbox', 'insert_users_log', null);    

$lessons = eF_getTableDataFlat("lessons", "id,name");
$lessons = array_combine($lessons['id'], $lessons['name']);
$lessons = array(0 => 'None') + $lessons;
$form -> addElement('select', 'enroll_lesson', null, $lessons);    

//Directions part
$form -> addElement('text', 'num_directions', null);    
$form -> addRule('num_directions', _INVALIDFIELDDATA, 'numeric', null, 'client');

$directions = eF_getTableDataFlat("directions", "id,name");//pr(array_combine($directions['id'], $directions['name']));
$directions = array_combine($directions['id'], $directions['name']);
$directions = array(0 => 'None') + $directions;
$form -> addElement('select', 'parent_direction', null, $directions);    

$form -> addElement('text', 'prefix_users', null);    

$form -> addElement('text', 'prefix_directions', null);    

//Lessons part
$form -> addElement('text', 'num_lessons', null);    
$form -> addRule('num_lessons', _INVALIDFIELDDATA, 'numeric', null, 'client');

//$languages = eF_getLanguages();//pr($languages);
$form -> addElement('select', 'lesson_language', null, $languages);    

$form -> addElement('select', 'lesson_direction', null, array_slice($directions, 1, sizeof($directions), true));    //pr(array_slice($directions,1, sizeof($directions), true));

$form -> addElement('text', 'lesson_price', null);    
$form -> addRule('num_lessons', _INVALIDFIELDDATA, 'numeric', null, 'client');

$form -> addElement('advcheckbox', 'insert_lessons_log', null);    

$form -> addElement('text', 'prefix_lessons', null);    

//Units part
$form -> addElement('text', 'num_units', null);    
$form -> addRule('num_units', _INVALIDFIELDDATA, 'numeric', null, 'client');

$lessons = eF_getTableDataFlat("lessons", "id,name");
$lessons = array_combine($lessons['id'], $lessons['name']);
$form -> addElement('select', 'unit_lesson', null, $lessons);    

$form -> addElement('select', 'unit_type', null, array('theory' => 'theory', 'exercises' => 'exercises', 'examples' => 'examples', 'tests' => 'tests'));    

$units = eF_getTableDataFlat("content", "id,name");
$units = array_combine($units['id'], $units['name']);
$units = array(0 => 'None') + $units;
$form -> addElement('select', 'copy_unit', null, $units);    

$form -> addElement('text', 'prefix_units', null);    

//Logs part
$form -> addElement('text', 'num_logs', null);    
$form -> addRule('num_logs', _INVALIDFIELDDATA, 'numeric', null, 'client');

$users = eF_getTableDataFlat("users", "login");
$users = array_combine($users['login'], $users['login']);
$form -> addElement('select', 'logs_user', null, $users);    

$form -> addElement('text', 'log_entry', null);    

$form -> addElement('text', 'prefix_logs', null);

//forum part
$form -> addElement('text', 'num_topics', null);    
$form -> addRule('num_topics', _INVALIDFIELDDATA, 'numeric', null, 'client');

$form -> addElement('text', 'num_messages', null);    
$form -> addRule('num_messages', _INVALIDFIELDDATA, 'numeric', null, 'client');

$form -> addElement('text', 'message_title', null);    
$form -> addElement('text', 'message_body', null);    

$form -> addElement('text', 'prefix_forum', null);

$form -> setDefaults(array('prefix_users'      => 'stress_user_',
                           'prefix_directions' => 'stress_direction_',
                           'prefix_lessons'    => 'stress_lesson_',
                           'prefix_units'      => 'stress_unit_',
                           'prefix_logs'       => 'stress_',
                           'prefix_forum'      => 'stress_forum_',
                           'activate_users'    => true,
                           'lesson_price'      => 0,
                           'num_users'         => '',
                           'num_directions'    => '',
                           'num_units'         => '',
                           'num_logs'          => '',
                           'num_lessons'       => ''));

if ($form -> isSubmitted()) {
    if ($form -> validate()) {            
        //pr($form -> exportValues());
        $num_users      = $form -> exportValue('num_users');
        $num_directions = $form -> exportValue('num_directions');
        $num_lessons    = $form -> exportValue('num_lessons');
        $num_units      = $form -> exportValue('num_units');
        $num_logs       = $form -> exportValue('num_logs');
        $num_topics     = $form -> exportValue('num_topics');
        $num_messages   = $form -> exportValue('num_messages');
        
        if ($num_users) {
            for ($i = 0; $i < $num_users; $i++) {
                $user_data = array("login"          => $form -> exportValue('prefix_users').$i,
                                   "password"       => 1,
                                   "name"           => $form -> exportValue('prefix_users').'name_'.$i,
                                   "surname"        => $form -> exportValue('prefix_users').'surname_'.$i,
                                   "email"          => $form -> exportValue('prefix_users').'email_'.$i.'@stress.test',
                                   "comments"       => '',
                                   "languages_NAME" => $form -> exportValue('users_language'));
                
                eF_registerUser($user_data, $form -> exportValue('activate_users'), false, $form -> exportValue('users_type'));

                if ($form -> exportValue('enroll_lesson')) {
                    $lesson_registrations = array("users_LOGIN"    => $user_data['login'], 
                                                  "lessons_ID"     => $form -> exportValue('enroll_lesson'), 
                                                  "from_timestamp" => time(),
                                                  "active"         => 1);
                    eF_insertTableData("users_to_lessons", $lesson_registrations);
                }
                
                if ($form -> exportValue('insert_users_log')) {
                    $logs_data = array("users_LOGIN" => $form -> exportValue('prefix_users').$i,
                                       "timestamp"   => time(),
                                       "action"      => 'login',
                                       "comments"    => '0',
                                       "session_ip"  => $form -> exportValue('prefix_users'));
                    eF_insertTableData("logs", $logs_data);                
                    
                    for ($j = 0; $j < 10; $j++) {
                        $logs_data = array("users_LOGIN" => $form -> exportValue('prefix_users').$i,
                                           "timestamp"   => time(),
                                           "action"      => 'personal',
                                           "comments"    => 1,
                                           "session_ip"  => $form -> exportValue('prefix_users'));

                        eF_insertTableData("logs", $logs_data);                
                    }
                    
                    $logs_data = array("users_LOGIN" => $form -> exportValue('prefix_users').$i,
                                       "timestamp"   => time(),
                                       "action"      => 'logout',
                                       "comments"    => '0',
                                       "session_ip"  => $form -> exportValue('prefix_users'));
                    eF_insertTableData("logs", $logs_data);                
                }
            }
            
            $message      .= "Succesfully added ".$num_users." users";
            $message_type = 'success';
        }

        if ($num_directions) {
            for ($i = 0; $i < $num_directions; $i++) {
                $direction_data = array("name"                => $form -> exportValue('prefix_directions').$i,
                                        "active"              => 1,
                                        "parent_direction_ID" => $form -> exportValue('parent_direction'));
                
                eF_insertTableData("directions", $direction_data);
            }
            
            $message      .= "Succesfully added ".$num_directions." directions";
            $message_type = 'success';
        }

        if ($num_lessons) {
            for ($i = 0; $i < $num_lessons; $i++) {
                $fields_insert = array('name'           => $form -> exportValue('prefix_lessons').$i,
                                       'languages_NAME' => $form -> exportValue('lesson_language'),
                                       'directions_ID'  => $form -> exportValue('lesson_direction'),
                                       'active'         => 1,
                                       'price'          => $form -> exportValue('lesson_price'));
                
                eF_createLesson($fields_insert);

            }
            
            $message      .= "Succesfully added ".$num_lessons." lessons";
            $message_type = 'success';
        }        

        if ($num_units) {
            if ($form -> exportValue('copy_unit')) {
                $content = eF_getTableData("content", "data", "id=".$form -> exportValue('copy_unit'));
                $content = $content[0]['data'];
            } else {
                $content = 'random data';
            }
            
            for ($i = 0; $i < $num_units; $i++) {
                $tree = eF_getContentTree($nouse, $form -> exportValue('unit_lesson'), 0, false, false);
                $new_unit = array('name'              => $form -> exportValue('prefix_units').$i,
                                  'data'              => $content,
                                  'parent_content_ID' => 0,
                                  'lessons_ID'        => $form -> exportValue('unit_lesson'),
                                  'timestamp'         => time(),
                                  'ctg_type'          => $form -> exportValue('unit_type'),
                                  'active'            => 1);

                $content_ID = eF_insertUnit($new_unit, $tree);                                 //Insert the new unit   
            }

            if (G_ENABLE_CACHE && sizeof(eF_getTableData("cache", "*", "name='".$form -> exportValue('unit_lesson')."_contentTree'"))) {
                eF_updateTableData("cache", array('expired' => 1), "name='".$form -> exportValue('unit_lesson')."_contentTree'");
            } 
            
            $message      .= "Succesfully added ".$num_units." units";
            $message_type = 'success';
        }        

        if ($num_logs) {
            $logs_data = array("users_LOGIN" => $form -> exportValue('logs_user'),
                               "timestamp"   => time(),
                               "action"      => 'login',
                               "comments"    => '0',
                               "session_ip"  => $form -> exportValue('prefix_logs'));

            eF_insertTableData("logs", $logs_data);                
            
            for ($i = 1; $i < $num_logs-1; $i++) {
                if (fmod($i,10) == 0 && !fmod($i,20) == 0) {
                    $logs_data = array("users_LOGIN" => $form -> exportValue('logs_user'),
                                       "timestamp"   => time(),
                                       "action"      => 'login',
                                       "comments"    => '0',
                                       "session_ip"  => $form -> exportValue('prefix_logs'));

                    eF_insertTableData("logs", $logs_data);                
                }

                $logs_data = array("users_LOGIN" => $form -> exportValue('logs_user'),
                                   "timestamp"   => time(),
                                   "action"      => 'personal',
                                   "comments"    => 1,
                                   "session_ip"  => $form -> exportValue('prefix_logs'));
                
                eF_insertTableData("logs", $logs_data);                

                if (fmod($i,20) == 0) {
                    $logs_data = array("users_LOGIN" => $form -> exportValue('logs_user'),
                                       "timestamp"   => time(),
                                       "action"      => 'logout',
                                       "comments"    => '0',
                                       "session_ip"  => $form -> exportValue('prefix_logs'));

                    eF_insertTableData("logs", $logs_data);                
                }
            }

            $logs_data = array("users_LOGIN" => $form -> exportValue('logs_user'),
                               "timestamp"   => time(),
                               "action"      => 'logout',
                               "comments"    => '0',
                               "session_ip"  => $form -> exportValue('prefix_logs'));
            
            eF_insertTableData("logs", $logs_data);                

            $message      .= "Succesfully added ".$num_logs." logs";
            $message_type = 'success';
        }

        if ($num_forum) {
            for ($i = 0; $i < $num_forum; $i++) {
                
            }
            
            $message      .= "Succesfully added ".$num_forum." forum topics and ";
            $message_type = 'success';
        }
        
        header("location:".$_SERVER['PHP_SELF']."?message=$message&message_type=$message_type");

    }
}


$form -> addElement('submit', 'submit_stress', _SUBMIT, 'class=flatButton');

$renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

$form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
$form -> setRequiredNote(_REQUIREDNOTE);
$form -> accept($renderer);

$smarty -> assign('T_STRESS_FORM', $renderer -> toArray());        


$form2 = new HTML_QuickForm("delete_stress_form", "post", $_SERVER['PHP_SELF'], "", null, true);

$form2 -> addElement('select', 'delete_stress_data', null, array('users'      => 'users', 
                                                                 'directions' => 'directions', 
                                                                 'lessons'    => 'lessons', 
                                                                 'units'      => 'units', 
                                                                 'logs'       => 'logs',
                                                                 'forum'      => 'forum'));    

$form2 -> addElement('text', 'delete_stress_prefix', null);    
$form2 -> addElement('submit', 'submit_delete_stress', _DELETE, 'class=flatButton onclick = "return confirm(\'Are you sure?\')"');
$form2 -> setDefaults(array('delete_stress_prefix' => 'stress_'));

if ($form2 -> isSubmitted()) {
    if ($form2 -> validate()) {            
        //pr($form2 -> exportValues());
        switch ($form2 -> exportValue('delete_stress_data')) {
            case 'users':
                $users = eF_getTableDataFlat("users", "login", "login like '".($form2 -> exportValue('delete_stress_prefix'))."%'");
                foreach ($users['login'] as $login) {
                    eF_deleteUser($login);
                }
                break;
            case 'directions':
                eF_deleteTableData("directions", "name like '".($form2 -> exportValue('delete_stress_prefix'))."%'");
                break;
            case 'lessons':
                $lessons = eF_getTableDataFlat("lessons", "id", "name like '".($form2 -> exportValue('delete_stress_prefix'))."%'");
                foreach ($lessons['id'] as $id) {
                    eF_deleteLesson($id);
                }                
                break;
            case 'units':
                $lessons = eF_getTableDataFlat("content", "distinct lessons_ID", "name like '".($form2 -> exportValue('delete_stress_prefix'))."%'");
                foreach ($lessons['lessons_ID'] as $lessons_ID) {
                    $tree  = eF_getContentTree($nouse, $lessons_ID, 0, false, false);
                    $units = eF_getTableDataFlat("content", "id", "lessons_ID = $lessons_ID and name like '".($form2 -> exportValue('delete_stress_prefix'))."%'");
                    foreach ($units['id'] as $id) {
                        eF_deleteUnit($id, $tree);
                    }

                    if (G_ENABLE_CACHE && sizeof(eF_getTableData("cache", "*", "name='".$lessons_ID."_contentTree'"))) {
                        eF_updateTableData("cache", array('expired' => 1), "name='".$lessons_ID."_contentTree'");
                    } 
                }
                
                break;
            case 'logs':
                eF_deleteTableData("logs", "session_IP='".$form2 -> exportValue('delete_stress_prefix')."'");
                break;
            case 'forum':
                break;
            default:
                break;
        }

        $message      = 'Succesfully deleted '.$form2 -> exportValue('delete_stress_data');
        $message_type = 'success';
    }
}

$renderer2 =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

$form2 -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
$form2 -> setRequiredNote(_REQUIREDNOTE);
$form2 -> accept($renderer2);

$smarty -> assign('T_DELETE_STRESS_FORM', $renderer2 -> toArray());        

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);


$smarty -> display('stress_tool.tpl');



?>