<?php
	/*	Στο αρχείο αυτό περιλαμβάνονται οι συναρτήσεις για
	*	τη δημιουργία των php/swf γραφημάτων
	*
	*/
	$path = "../libraries/"; 
	require_once $path."configuration.php";
	include("charts.php");
	$chid = $_GET['chid'];
	
	switch ($chid){
		case 1: {
			$lesson_id = $_GET['lesson_id'];
			$test_id = $_GET['test_id'];
			$chart = swf_createBarScoreAllocation($lesson_id,$test_id);	
			SendChartData ( $chart );
			break;			
		}
		case 2:{
			$lesson_id = $_GET['lesson_id'];
			$test_id = $_GET['test_id'];
			$chart = swf_createPieQuestionsKind($lesson_id,$test_id);
			SendChartData ( $chart );
			break;
		}
		case 3:{
			$lesson_id = $_GET['lesson_id'];
			$test_id = $_GET['test_id'];
			$chart = swf_createPieQuestionsDifficulty($lesson_id,$test_id);
			SendChartData ( $chart );
			break;
		}
		case 4:{
			if (isset($_GET['lesson_id']))
				$lesson_id = $_GET['lesson_id'];
			else
				$lesson_id="";
				
			$chart = swf_createColumnUserTypes($lesson_id);		
			SendChartData ( $chart );
			break;
		}
		case 5:{	//most active users for a lesson in a specific period
			if (isset($_GET['lesson_id'])){
				$lesson_id = $_GET['lesson_id'];
				if (isset($_GET['from']))
					$from = $_GET['from'];
				else	
					$from = null;
				
				if (isset($_GET['to']))
					$to = $_GET['to'];
				else	
					$to = null;
					
				$chart = swf_createBarActiveUsers($lesson_id, $from, $to);
				SendChartData ($chart);
				break;	
			}
		}
		case 6:{
			$logins = explode(",",$_GET['logins']);
			$seconds = explode(",",$_GET['seconds']);
			$chart = swf_createBar20ActiveUsers($logins,$seconds);
			SendChartData ($chart);
			break;	
		}
		case 7:{
			$lessons = explode(",",$_GET['lessons']);
			$access = explode(",",$_GET['access']);
			$chart = swf_createBar20ActiveLessons($lessons,$access);
			SendChartData ($chart);
			break;	
		}
		case 8:{  //lesson access through time
            $lesson = $_GET['lesson'];
            $from = $_GET['from'];
            $to = $_GET['to'];
            $chart = swf_createLineAccessTime($lesson, $from, $to);
            SendChartData ($chart);
            break;
        }
        case 9:{  //system login through time
            $from = $_GET['from'];
            $to = $_GET['to'];
            $chart = swf_createLineLoginTime($from, $to);
            SendChartData ($chart);
            break;
        }
        case 10:{  //user access through a lesson
            $from = $_GET['from'];
            $to = $_GET['to'];
            $login = $_GET['login'];
            $lesson = $_GET['lesson'];
            $chart = swf_createLineAccessLesson($from, $to, $login, $lesson);
            SendChartData ($chart);
            break;
        }
        case 11:{  //user logins
            $from = $_GET['from'];
            $to = $_GET['to'];
            $login = $_GET['login'];            
            $chart = swf_createLineUserLogin($from, $to, $login);
            SendChartData ($chart);
            break;
        }
	}

	function swf_createBarScoreAllocation($lesson_id, $test_id){
		$done_tests = ef_getDoneTests($test_id);
		$cnt_20 = 0;
		$cnt_40 = 0;
		$cnt_60 = 0;
		$cnt_80 = 0;
		$cnt_100 = 0;
	
		foreach($done_tests as $test){
			$score = $test['score'];
			if ($score <= 0.2)
				$cnt_20++;
			else if ($score <= 0.4 && $score > 0.2)
				$cnt_40++;
			else if ($score <= 0.4 && $score > 0.2)
				$cnt_40++;
			else if ($score <= 0.6 && $score > 0.4)
				$cnt_60++;	
			else if ($score <= 0.8 && $score > 0.6)
				$cnt_80++;
			else if ($score <= 1 && $score > 0.8)
				$cnt_100++;			
		}
		
		$chart['chart_data'] = array(	array("","0-20","20-40","40-60","60-80","80-100"),
										array("",$cnt_20,$cnt_40,$cnt_60,$cnt_80,$cnt_100)
									);
		$chart['chart_type'] = "column";
		$chart['chart_rect'] = array ('width' => "400", 'height' => "250"); 
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart[ 'chart_value' ] = array ( 'color'=>"ffffff", 'alpha'=>90, 'font'=>"arial", 'bold'=>true, 'size'=>14, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"" );
		$chart['series_color'] = array ("ff6600");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		$chart['series_switch'] = "true";
		return $chart;										
	}
	
	
	function swf_createPieQuestionsKind($lesson_id, $test_id){
		$lesson_info = ef_getLessonInfo($lesson_id);
		$tests = $lesson_info['tests'];
		$total = 0;
		$raw = 0;
		$multiple_one = 0;
		$multiple_many = 0;
		$match = 0;
		$empty_spaces = 0;
		$true_false = 0;

		foreach ($tests['id'] as $key => $t_id){
			if ($t_id == $test_id){
				$total = $tests['total_questions'][$key];
				$raw = $tests['raw_text'][$key];
				$multiple_one = $tests['multiple_one'][$key];
				$multiple_many = $tests['multiple_many'][$key];
				$empty_spaces = $tests['empty_spaces'][$key];
				$true_false = $tests['true_false'][$key];				
			}	
		}

		
		
		$chart['chart_data'] = array(	array("",_DEVELOPMENT,_MULTIPLEONE,_MULTIPLEMANY,_EMPTYSPACES,_TRUEFALSE),
										array("",$raw,$multiple_one,$multiple_many,$empty_spaces,$true_false)
									);
		$chart[ 'chart_transition' ] = array ('type' => "scale"); 
		$chart[ 'chart_grid_h' ] = array ( 'alpha'=>20, 'color'=>"000000", 'thickness'=>1, 'type'=>"solid" );
		$chart[ 'chart_rect' ] = array ( 'width' => "600", 'height' => "220",'positive_color'=>"ffffff", 'positive_alpha'=>20, 'negative_color'=>"ff0000", 'negative_alpha'=>10 );
		$chart[ 'chart_type' ] = "pie";
		$chart[ 'chart_value' ] = array ( 'color'=>"ffffff", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>10, 'position'=>"inside", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'as_percentage'=>true );
		$chart[ 'legend_label' ] = array ( 'layout'=>"horizontal", 'bullet'=>"circle", 'font'=>"Times New Roman", 'bold'=>true, 'size'=>13, 'color'=>"000000", 'alpha'=>85 ); 
		$chart[ 'legend_rect' ] = array ( 'fill_color'=>"ffffff", 'fill_alpha'=>10, 'line_color'=>"000000", 'line_alpha'=>0, 'line_thickness'=>0, 'height' => 200 ); 
		$chart[ 'series_color' ] = array ( "ddaa41", "88dd11", "4e62dd", "ff8811", "4d4d4d"); 
		$chart[ 'series_explode' ] = array ( 20, 0, 50 );	
					
		return $chart;								
	}
	
	function swf_createPieQuestionsDifficulty($lesson_id, $test_id){
		$lesson_info = ef_getLessonInfo($lesson_id);
		$tests = $lesson_info['tests'];
		$low = 0;
		$medium = 0;
		$high = 0;
		
		foreach ($tests['id'] as $key => $t_id){
			if ($t_id == $test_id){
				$low = $tests['low'][$key];
				$medium = $tests['medium'][$key];
				$high = $tests['high'][$key];			
			}	
		}

		
		
		$chart['chart_data'] = array(	array("",_LOWDIFFICULTY,_MEDIUMDIFFICULTY,_HIGHDIFFICULTY),
										array("",$low, $medium, $high)
									);
		$chart[ 'chart_transition' ] = array ('type' => "scale"); 
		$chart[ 'chart_grid_h' ] = array ( 'alpha'=>20, 'color'=>"000000", 'thickness'=>1, 'type'=>"solid" );
		$chart[ 'chart_rect' ] = array ( 'width' => "500", 'height' => "220",'positive_color'=>"ffffff", 'positive_alpha'=>20, 'negative_color'=>"ff0000", 'negative_alpha'=>10 );
		$chart[ 'chart_type' ] = "pie";
		$chart[ 'chart_value' ] = array ( 'color'=>"ffffff", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>10, 'position'=>"inside", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'as_percentage'=>true );
		$chart[ 'legend_label' ] = array ( 'layout'=>"horizontal", 'bullet'=>"circle", 'font'=>"Times New Roman", 'bold'=>true, 'size'=>13, 'color'=>"000000", 'alpha'=>85 ); 
		$chart[ 'legend_rect' ] = array ( 'fill_color'=>"ffffff", 'fill_alpha'=>10, 'line_color'=>"000000", 'line_alpha'=>0, 'line_thickness'=>0, 'height'=>100 ); 
		$chart[ 'series_color' ] = array ( "ddaa41", "88dd11", "4e62dd", "ff8811", "4d4d4d"); 
		$chart[ 'series_explode' ] = array ( 20, 0, 50 );								
		return $chart;								
	}
	
	function swf_createColumnUserTypes($lesson_id){
		$user_types = ef_getUserTypesInfo($lesson_id);
		$axis_types = array();
		$data_general = array();
		$data_lesson = array();
		$axis_types[0] = "";
		$data_general[0] = "Overall";
		$data_lesson[0] = "Lesson";
		$i=1;
		
		foreach($user_types as $type){
			$axis_types[$i] = $type['user_type'];
			$data_general[$i] = $type['cnt_total'];
			$data_lesson[$i] = $type['cnt_lesson'];
			$i = $i + 1;
		}
		
	
		if ($lesson_id != "")
			$chart['chart_data'] = array(	$axis_types,
										$data_general,
										$data_lesson);
		else
			$chart['chart_data'] = array(	$axis_types,
										$data_general);
										
		$chart[ 'axis_category' ] = array ('bold'=>true, 'size'=>12, 'color'=>"000000", 'alpha'=>85, 'skip'=>0, 'orientation'=>"diagonal_up" ); 								
		$chart[ 'axis_value' ] = array ('bold'=>true, 'size'=>12, 'color'=>"000000", 'alpha'=>85, 'skip'=>0); 								
		$chart[ 'chart_grid_h' ] = array ( 'alpha'=>20, 'color'=>"000000", 'thickness'=>1, 'type'=>"dashed" );
		$chart[ 'chart_rect' ] = array ( 'x'=>75, 'y'=>50, 'width'=>300, 'height'=> 200, 'positive_color'=>"000066", 'negative_color'=>"000000", 'positive_alpha'=>10, 'negative_alpha'=>30 );
		$chart[ 'chart_transition' ] = array ( 'type'=>"scale", 'delay'=>.5, 'duration'=>.5, 'order'=>"series" );
		$chart[ 'chart_value' ] = array ( 'color'=>"ffffff", 'alpha'=>85, 'font'=>"arial", 'bold'=>true, 'size'=>10, 'position'=>"middle", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'as_percentage'=>false );
		
		$chart[ 'draw' ] = array ( array ( 'type'=>"text", 'color'=>"000000", 'alpha'=>10, 'font'=>"arial", 'rotation'=>-90, 'bold'=>true, 'size'=>45, 'x'=>-10, 'y'=>300, 'width'=>300, 'height'=>200, 'text'=>"user types", 'h_align'=>"left", 'v_align'=>"top" ));
		
		$chart[ 'legend_label' ] = array ( 'layout'=>"horizontal", 'font'=>"Times New Roman", 'bold'=>true, 'size'=>12, 'color'=>"333355", 'alpha'=>90 ); 
		$chart[ 'legend_rect' ] = array ( 'x'=>-50, 'y'=>-50, 'width'=>300, 'height'=>20, 'margin'=>5, 'fill_color'=>"000066", 'fill_alpha'=>8, 'line_color'=>"000000", 'line_alpha'=>0, 'line_thickness'=>0 ); 
		
		$chart[ 'series_color' ] = array ("666666","768bb3" ); 
		return $chart;										
	}
	
	
	function swf_createBarActiveUsers($lesson_id, $from, $to){
		$traffic = ef_getLessonTraffic($lesson_id, $from, $to);
		$user_logins = $traffic['users'];
		$user_totaltime = array();
		for ($i=0;$i<sizeof($traffic['users_time']);$i++){
			$user_totaltime[]=$traffic['users_time'][$i]['minutes'] + $traffic['users_time'][$i]['seconds']/60;						
		}
		
		array_multisort($user_totaltime,SORT_DESC,SORT_NUMERIC,$user_logins,SORT_DESC,SORT_STRING);
				
		$n = min(5,sizeof($user_logins));
		$user5=array();
		$time5=array();
		$user5[]="";
		$time5[]="sminutes";
		for ($i=0;$i<$n;$i++){
			if ($user_totaltime[$i] > 0){	//add only the users with totaltime > 0
				$user5[] = $user_logins[$i];
				$time5[] = $user_totaltime[$i];
			}
		}	
		
		$chart['chart_data'] = array($user5,$time5);
		$chart['chart_type'] = "bar";
		$chart['chart_rect'] = array ('width' => "400", 'height' => "250"); 
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart[ 'chart_value' ] = array ( 'color'=>"ffffff", 'alpha'=>90, 'font'=>"arial", 'bold'=>true, 'size'=>14, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>2, 'separator'=>"" );
		$chart['series_color'] = array ("ff6600");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		
		$chart[ 'draw' ] = array ( array ( 'type'=>"text", 'color'=>"ff0000", 'alpha'=>55, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>30, 'x'=>25, 'y'=>11, 'width'=>500, 'height'=>240, 'text'=>_5MOSTACTIVEUSERS, 'h_align'=>"left", 'v_align'=>"top" ),
                           array ( 'type'=>"text", 'color'=>"000000",  'alpha'=>40, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>15, 'x'=>100, 'y'=>75, 'width'=>400, 'height'=>290, 'text'=>_MINUTES, 'h_align'=>"center", 'v_align'=>"bottom" )
                           );
                           

		return $chart;										
	}
	
	function swf_createBar20ActiveUsers($logins, $seconds){
		for ($i=0;$i<sizeof($logins);$i++){
			$minutes[] = $seconds[$i]/60;						
		}
		array_unshift($logins,"");
		array_unshift($minutes,"minutes");
		$chart['chart_data'] = array($logins,$minutes);
		$chart['chart_type'] = "bar";
		$chart['chart_rect'] = array ('width' => "450", 'height' => "400", 'y' => 10); 
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart['chart_value' ] = array ( 'color'=>"000000", 'alpha'=>90, 'font'=>"arial", 'bold'=>true, 'size'=>10, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>2, 'separator'=>"" );
		$chart['series_color'] = array ("ff6600");
		$chart['legend_rect'] = array (	'x' =>	"-100",
						'y'	=>	"-100");
		
		$chart[ 'draw' ] = array ( array ( 'type'=>"text", 'color'=>"000000",  'alpha'=>40, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>15, 'x'=>420, 'y'=>430, 'width'=>100, 'height'=>20, 'text'=>_MINUTES, 'h_align'=>"center", 'v_align'=>"bottom" )
                           );
                        
        $chart[ 'axis_category' ] = array ( 'font'=>"Times New Roman", 'bold'=>true, 'size'=>10, 'color'=>"000000", 'alpha'=>85, 'skip'=>0 ); 
        $chart[ 'axis_value' ] = array ( 'font'=>"Times New Roman", 'bold'=>true, 'size'=>10, 'color'=>"000000", 'alpha'=>30, 'steps'=>6, 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"" );

		return $chart;							
	}
	
	function swf_createBar20ActiveLessons($lessons, $access){
		$lessons_u = array();
		for ($i=0;$i<sizeof($lessons);$i++){
			$lessons_u[]=utf8_encode($lessons[$i]);
			//$lessons_u[]="Οντοκεντρικός Προγραμματισμός";
		}
		array_unshift($lessons_u,"");
		array_unshift($access,"access");
		$chart['chart_data'] = array($lessons_u,$access);
		$chart['chart_type'] = "bar";
		$chart['chart_rect'] = array ('width' => "600", 'height' => "250"); 
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart[ 'chart_value' ] = array ( 'color'=>"ffffff", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>14, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>2, 'separator'=>"" );
		$chart['series_color'] = array ("ff6600");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		$chart['axis_category'] = array('font' => "Times New Roman");
		$chart['axis_value'] = array('font' => "Times New Roman");
		$chart[ 'draw' ] = array ( array ( 'type'=>"text", 'color'=>"ff0000", 'alpha'=>55, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>30, 'x'=>25, 'y'=>11, 'width'=>500, 'height'=>240, 'text'=>_20MOSTACTIVELESSONS, 'h_align'=>"left", 'v_align'=>"top" ),
                           array ( 'type'=>"text", 'color'=>"000000",  'alpha'=>40, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>15, 'x'=>100, 'y'=>75, 'width'=>400, 'height'=>290, 'text'=>_ACCESSNUMBER, 'h_align'=>"center", 'v_align'=>"bottom" )
                           );
                           

		return $chart;							
	}
	
	function swf_createLineAccessTime($lesson, $from, $to){
        $intervals = array();
        $intervals[] = "";
        $access = array();
        $access[] = "access";
        $valuetext = array();
        $valuetext[]="";
        $valuetext_tmp = array();
        $valuetext_tmp[]="";
        $l = floor(($to - $from)/21);
        $j=0;
        for ($i=$from+$l;$i<=$to;$i=$i+$l){
            if ($j%10 == 0){
                $d = date("d/m h:i", $i);
                $intervals[] = $d;
            }
            else
                $intervals[] = "";
            $traffic = ef_getLessonAccess($lesson, $i-$l,$i);
            $access[] = $traffic['total'];        
            $valuetext[] = $traffic['total']." - ".date("d/m h:i", $i); 
            $valuetext_tmp[]="";
            $j++;
        }    
        
        $chart['chart_type']="line";
        $chart[ 'chart_rect' ] = array ( 'x'=>40, 'y'=>35, 'width'=>610, 'height'=>300);
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart['series_color'] = array ("0000ff");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		$chart['axis_category'] = array ( 'size'=>14, 'color'=>"000000", 'alpha'=>0, 'font'=>"Times New Roman", 'bold'=>true, 'skip'=>0 ,'orientation'=>"horizontal" ); 
		$chart['axis_value' ] = array ('font'=>"Times New Roman", 'bold'=>true, 'size'=>14, 'color'=>"000000", 'alpha'=>50, 'steps'=>6, 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'show_min'=>true );
		$chart['chart_data'] = array($intervals, $access);
		$chart['draw'] = array ( array ( 'type'=>"text", 'color'=>"0000ff", 'alpha'=>55, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>25, 'x'=>95, 'y'=>6, 'width'=>250, 'height'=>140, 'text'=>_ACCESSNUMBER, 'h_align'=>"left", 'v_align'=>"top" )
                           );
        $chart['chart_value_text'] = array($valuetext_tmp,$valuetext);
        $chart['chart_value'] = array ( 'color'=>"ff0000", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>18, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"" );
		return $chart;
    }
    
    function swf_createLineLoginTime($from, $to){
        $intervals = array();
        $intervals[] = "";
        $access = array();
        $access[] = "access";
        $valuetext = array();
        $valuetext[]="";
        $valuetext_tmp = array();
        $valuetext_tmp[]="";
        $l = floor(($to - $from)/21);
        $j=0;
        for ($i=$from+$l;$i<=$to;$i=$i+$l){
            if ($j%10 == 0){
                $d = date("d/m h:i", $i);
                $intervals[] = $d;
            }
            else
                $intervals[] = "";
            $int['from'] = $i-$l;
            $int['to'] = $i;
            $traffic = ef_getSystemStatistics($int);
            $access[] = $traffic['total_logins'];     
            $valuetext[] = $traffic['total_logins']." - ".date("d/m h:i", $i); 
            $valuetext_tmp[]="";     
            $j++;
        }    
        
        $chart['chart_type']="line";
        $chart[ 'chart_rect' ] = array ( 'x'=>40, 'y'=>35, 'width'=>610, 'height'=>300);
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart['series_color'] = array ("0000ff");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		$chart['axis_category'] = array ( 'size'=>14, 'color'=>"000000", 'alpha'=>0, 'font'=>"Times New Roman", 'bold'=>true, 'skip'=>0 ,'orientation'=>"horizontal" ); 
		$chart['axis_value' ] = array ('font'=>"Times New Roman", 'bold'=>true, 'size'=>14, 'color'=>"000000", 'alpha'=>50, 'steps'=>6, 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'show_min'=>true );
		$chart['chart_data'] = array($intervals, $access);
		$chart['draw'] = array ( array ( 'type'=>"text", 'color'=>"0000ff", 'alpha'=>55, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>25, 'x'=>95, 'y'=>6, 'width'=>250, 'height'=>140, 'text'=>_SYSTEMLOGINS, 'h_align'=>"left", 'v_align'=>"top" )
                           );
        $chart['chart_value_text'] = array($valuetext_tmp,$valuetext);
        $chart['chart_value'] = array ( 'color'=>"ff0000", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>18, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"" );
		return $chart;
    }
    
    function swf_createLineAccessLesson($from, $to, $login, $lesson){
        $intervals = array();
        $intervals[] = "";
        $access = array();
        $access[] = "access";
        $valuetext = array();
        $valuetext[]="";
        $valuetext_tmp = array();
        $valuetext_tmp[]="";
        $l = floor(($to - $from)/21);
        $j=0;
        for ($i=$from+$l;$i<=$to;$i=$i+$l){
            if ($j%10 == 0){
                $d = date("d/m h:i", $i);
                $intervals[] = $d;
            }
            else
                $intervals[] = "";
            $int['from'] = $i-$l;
            $int['to'] = $i;
            $traffic = ef_getLessonAccessStatistics($int, $lesson, $login);
            $access[] = $traffic['total_access'];     
            $valuetext[] = $traffic['total_access']." - ".date("d/m h:i", $i); 
            $valuetext_tmp[]="";     
            $j++;
        }          
        $chart['chart_type']="line";
        $chart[ 'chart_rect' ] = array ( 'x'=>40, 'y'=>35, 'width'=>610, 'height'=>300);
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart['series_color'] = array ("0000ff");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		$chart['axis_category'] = array ( 'size'=>14, 'color'=>"000000", 'alpha'=>0, 'font'=>"Times New Roman", 'bold'=>true, 'skip'=>0 ,'orientation'=>"horizontal" ); 
		$chart['axis_value' ] = array ('font'=>"Times New Roman", 'bold'=>true, 'size'=>14, 'color'=>"000000", 'alpha'=>50, 'steps'=>6, 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'show_min'=>true );
		$chart['chart_data'] = array($intervals, $access);
		$chart['draw'] = array ( array ( 'type'=>"text", 'color'=>"0000ff", 'alpha'=>55, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>25, 'x'=>95, 'y'=>6, 'width'=>550, 'height'=>140, 'text'=>_LESSONACCESS, 'h_align'=>"left", 'v_align'=>"top" )
                           );
        $chart['chart_value_text'] = array($valuetext_tmp,$valuetext);
        $chart['chart_value'] = array ( 'color'=>"ff0000", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>18, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"" );
		return $chart;
    }
    
    function swf_createLineUserLogin($from, $to, $login){
        $intervals = array();
        $intervals[] = "";
        $access = array();
        $access[] = "access";
        $valuetext = array();
        $valuetext[]="";
        $valuetext_tmp = array();
        $valuetext_tmp[]="";
        $l = floor(($to - $from)/21);
        $j=0;
        for ($i=$from+$l;$i<=$to;$i=$i+$l){
            if ($j%10 == 0){
                $d = date("d/m h:i", $i);
                $intervals[] = $d;
            }
            else
                $intervals[] = "";
            $int['from'] = $i-$l;
            $int['to'] = $i;
            $traffic = ef_getUserLogins($int, $login);
            $access[] = $traffic['total_logins'];     
            $valuetext[] = $traffic['total_logins']." - ".date("d/m h:i", $i); 
            $valuetext_tmp[]="";     
            $j++;
        }          
        $chart['chart_type']="line";
        $chart['chart_rect' ] = array ( 'x'=>40, 'y'=>35, 'width'=>610, 'height'=>300);
		$chart['chart_transition'] = array ('type' => "scale"); 
		$chart['series_color'] = array ("0000ff");
		$chart['legend_rect'] = array (	'x' =>	"-100",
										'y'	=>	"-100");
		$chart['axis_category'] = array ( 'size'=>14, 'color'=>"000000", 'alpha'=>0, 'font'=>"Times New Roman", 'bold'=>true, 'skip'=>0 ,'orientation'=>"horizontal" ); 
		$chart['axis_value' ] = array ('font'=>"Times New Roman", 'bold'=>true, 'size'=>14, 'color'=>"000000", 'alpha'=>50, 'steps'=>6, 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"", 'show_min'=>true );
		$chart['chart_data'] = array($intervals, $access);
		$chart['draw'] = array ( array ( 'type'=>"text", 'color'=>"0000ff", 'alpha'=>55, 'font'=>"Times New Roman", 'rotation'=>0, 'bold'=>true, 'size'=>25, 'x'=>95, 'y'=>6, 'width'=>550, 'height'=>140, 'text'=>_LOGINS, 'h_align'=>"left", 'v_align'=>"top" )
                           );
        $chart['chart_value_text'] = array($valuetext_tmp,$valuetext);
        $chart['chart_value'] = array ( 'color'=>"ff0000", 'alpha'=>90, 'font'=>"Times New Roman", 'bold'=>true, 'size'=>18, 'position'=>"cursor", 'prefix'=>"", 'suffix'=>"", 'decimals'=>0, 'separator'=>"" );
		return $chart;
    }
	
	
?>
