<?php
/**
* Searches for a user
* 
* This page presents a simple user search form
*
* @todo    ,  ,   .
* @todo   ,    
* @package eFront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

eF_printHeader(); 
//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);

if (!eF_checkUser($_SESSION['s_login'], $_SESSION['s_password'])) {                           //Only a valid user may access this page
    header("location:index.php");
    exit;
}

if (isset($_GET['login']) && !($login = eF_checkParameter($_GET['login'], 'login'))) {                                   //Check designated login for validity
    eF_printMessage(_INVALIDLOGIN);
    exit;
}

if (isset($_GET['tests_content_ID']) && !($tests_content_ID = eF_checkParameter($_GET['tests_content_ID'], 'uint'))) {              //Check designated id for validity
    eF_printMessage(_INVALIDID);
    exit;
}

if (isset($_GET['test_content_ID']) && !($test_content_ID = eF_checkParameter($_GET['test_content_ID'], 'uint'))) {              //Check designated id for validity
    eF_printMessage(_INVALIDID);
    exit;
}

if (isset($_GET['id']) && !($id = eF_checkParameter($_GET['id'], 'uint'))) {              //Check designated id for validity
    eF_printMessage(_INVALIDID);
    exit;
}
    
if (isset($_GET['table']) && !($table = eF_checkParameter($_GET['table'], 'alnum_general'))) {              //Check designated id for validity
    eF_printMessage(_INVALIDTABLE);
    exit;
}    
    
if ($table == "news") {//deprecated
    $res = eF_execute("SELECT title, data FROM news WHERE id=".$id);
    list ($title, $data) = mysql_fetch_row($res);
    //$data = nl2br($data);    
    $data = html_entity_decode($data, ENT_QUOTES);  //changed with new editor.. for br and other tags 2/3/2207
}
elseif ($table == "comments") {
    $res = eF_getTableData("comments", "users_LOGIN, data", "id=".$id);
    $data = html_entity_decode($res[0]['data'], ENT_QUOTES);  //changed for new editor 2/3/2207
    $title = _COMMENTOFUSER."&nbsp;".$res[0]['users_LOGIN'];
}
elseif ($table == "tests") {
    if (isset($_GET['redo_tests_ID']) && eF_checkParameter($_GET['redo_tests_ID'], 'id') && isset($_GET['login']) && eF_checkParameter($_GET['login'], 'login') && $_SESSION['s_role_options']['content'] == 1) {
        $result      = eF_getTableData("users_to_done_tests","tests_ID,times","users_LOGIN='".$_GET['login']."' AND tests_ID=".$_GET['redo_tests_ID']);   //Get the times that the user has done this test
        $is_redoable = eF_getTableData("tests", "redoable", "id=".$_GET['redo_tests_ID']);                  //Get the times that this test can be redone

        $result = eF_getTableData("done_tests", "id", "tests_ID=".$_GET['redo_tests_ID']." AND users_LOGIN='".$_GET['login']."'");          //Get the database entry that corresponds to the previously done test by the user
        for ($i = 0; $i < sizeof($result); $i++) {                                                          //Normally, only 1 instance of done_tests exists per student/test, but in case of fault, may be more than one are registered. With this loop, we delete them all
            eF_deleteTableData("done_tests", "id=".$result[$i]['id']);
            eF_deleteTableData("done_questions", "done_tests_ID=".$result[$i]['id']);
            eF_deleteTableData("logs", "action='tests' AND comments=".$_GET['view_unit']." AND users_LOGIN='".$_GET['login']."'");
            eF_deleteTableData("logs", "action='test_begin' AND comments=".$_GET['redo_tests_ID']." AND users_LOGIN='".$_GET['login']."'");
            if (is_dir(G_UPLOADPATH.$_GET['login'].'/tests/'.$_GET['redo_tests_ID'])) {
                try {
                    EfrontFileSystem :: deleteDirectory(G_UPLOADPATH.$_GET['login'].'/tests/'.$_GET['redo_tests_ID'].'/');
                } catch (EfrontFileException $e) {
                    $message      = $e -> getMessage();
                    $message_type = 'failure';
                }
            }
            $fields_update = array('questions_order' => '',
                                   'answers_order'   => '');
            eF_updateTableData("users_to_done_tests", $fields_update, "tests_ID=".$test_data[0]['id']." and users_LOGIN='".$_GET['login']."'");
        }
        echo "<script>parent.location = parent.location+'&tab=tests'</script>";
        exit;
    } else {
        $ctg = "tests";
        $title .= "&nbsp;( "._STUDENTCORRECTEDTEST." ".$login." )";
        $res = eF_getTableData("tests", "id", "content_ID=".$tests_content_ID);
        $tests_ID = $res[0]['id'];
        $data = eF_printSolvedTest($login, $tests_ID);
    }
}
elseif ($table == "unsolved_tests") {
    $title = _TESTPREVIEW;
    $res = eF_getTableData("tests", "id", "content_ID=".$test_content_ID);
    $tests_ID = $res[0]['id'];
    if (!isset($time_start)) {
        $time_start = time();
    }
    $goback = false;
    $gonext = false;
    if(isset($_POST['submit_next_question'])){
      $gonext = true;
    }
    if(isset($_POST['submit_previous_question'])){
      $goback = true;
    }
    $data = eF_printUnsolvedTest($tests_ID, "show_data.php?table=unsolved_tests&test_content_ID=".$test_content_ID, $question_num, $time_start, $answer, $q,$goback,$must_submit,$gonext);
}

if ($_SESSION['s_type'] != 'student' || $_SESSION['s_type'] != 'professor') {
    print '
    <table style = "width:100%;">
        <tr><td style = "padding-top:10px;padding-bottom:15px;text-align:center">
            <input class = "flatButton" type = "submit" onClick = "window.print()" value = "'._PRINTIT.'"/>
        </td></tr>
    </table>';
}
print '
<center><br/>'.eF_printInnerTable($title, $data).'</center>';
?>
    