<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : cv_cs_CZ_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass CV in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/cv_cs_CZ_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='step1.firstName' and @before='step1.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="step3Before">
<xsl:choose>
  <xsl:when test="//field[@name='step3List' and @before='step4List']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
  <head>
    <title>CV - HTML</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
  </head>
<body>
<table width="700" border="0" cellspacing="0" cellpadding="0" class="CV">
  <tr>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="190"/></td>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="7"/></td>
	<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="8"/></td>
    <td colspan="11"><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="495"/></td>
  </tr>
  <tr>
    <td class="Logo" rowspan="2">&#160;</td>
	<td style="height:42px;">&#160;</td>
    <td colspan="12" rowspan="2">&#160;</td>
  </tr>
  <tr>
    <td class="Corner">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Title">
	  Europass - životopis<br/>
      
	 <br />
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">Osobní údaje</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Label">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
	      Příjmení&#160;Jméno
	    </xsl:when>
	    <xsl:otherwise>
		  Jméno&#160;Příjmení
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
          <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		</xsl:when>
	    <xsl:otherwise>
		  <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		</xsl:otherwise>
	  </xsl:choose>
	</td>
  </tr>
  <xsl:if test="//field[@name='step1.addressInfo' and @keep='true']">
  <tr>
    <td class="Label">Adresa</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/contactinfo/address/addressLine">
        <xsl:value-of select="current()" /><br/>
      </xsl:for-each>
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/postalCode) != 0">
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/postalCode" />, </xsl:if>
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/municipality" />
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/country/label) != 0"> (<xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/country/label" />)</xsl:if>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.mobile' and @keep='true']">
  <tr>
    <td class="Label">Telefon</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="5">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/telephone" />
	</td>
    <td class="Label" width="15%" colSpan="2">Mobilní telefon</td>
    <td class="Normal" colSpan="4">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/mobile" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.fax' and @keep='true']">
  <tr>
    <td class="Label">Fax</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/fax" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.email' and @keep='true']">
  <tr>
    <td class="Label">E-mail</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/email" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.nationality' and @keep='true']">
  <tr>
    <td class="Label">Státní příslušnost</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/demographics/nationality/label">
    		<xsl:if test="position() != 1">,&#160;</xsl:if>
        <xsl:value-of select="current()"/>
    	</xsl:for-each>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.birthDate' and @keep='true']">
  <tr>
    <td class="Label">Datum narození</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
    	<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.gender' and @keep='true']">
  <tr>
    <td class="Label">Pohlaví</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='M'"><xsl:text>Muž</xsl:text></xsl:if>
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='F'"><xsl:text>Žena</xsl:text></xsl:if>
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.application' and @keep='true']">
  <tr>
    <td class="Heading1">Požadované zaměstnání / 
profese</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <PRE><xsl:value-of select="europass:learnerinfo/application/label" /></PRE>
	</td>
  </tr>
  </xsl:if>
  
  
  <xsl:choose>
    <xsl:when test="$step3Before=1">
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Pracovní zkušenosti</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Období</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Povolání nebo vykonávaná funkce</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Hlavní pracovní náplň a oblasti odpovědnosti</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Název/jméno a adresa zaměstnavatele</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
          <PRE><xsl:value-of select="employer/name" /></PRE>
          <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
            <xsl:for-each select="employer/address/addressLine">
              <xsl:value-of select="current()" /><br/>
            </xsl:for-each>
            <xsl:if test="string-length(employer/address/postalCode) != 0"><xsl:value-of select="employer/address/postalCode" />, </xsl:if>
            <xsl:value-of select="employer/address/municipality" />
            <xsl:if test=" string-length(employer/address/country/label) != 0"> (<xsl:value-of select="employer/address/country/label" />)</xsl:if>
          </xsl:if>
		    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Obor činnosti či odvětví</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Vzdělání, odborná příprava a školení</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Období</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Dosažená kvalifikace</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Hlavní předměty / profesní dovednosti</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Název a typ organizace, která poskytla vzdělání, odbornou přípravu či kurz</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
        <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
        <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
          <xsl:for-each select="organisation/address/addressLine">
            <xsl:value-of select="current()" /><br/>
          </xsl:for-each>
          <xsl:if test="string-length(organisation/address/postalCode) != 0"><xsl:value-of select="organisation/address/postalCode" />, </xsl:if>
          <xsl:value-of select="organisation/address/municipality" />
          <xsl:if test="string-length(organisation/address/country/label) != 0"> (<xsl:value-of select="organisation/address/country/label" />)</xsl:if>
        </xsl:if>
      </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Úroveň vzdělání v národní nebo mezinárodní klasifikaci</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Vzdělání, odborná příprava a školení</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Období</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Dosažená kvalifikace</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Hlavní předměty / profesní dovednosti</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Název a typ organizace, která poskytla vzdělání, odbornou přípravu či kurz</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
                <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
            </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adresa</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="organisation/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="organisation/address/postalCode" /><br/>
                      <xsl:value-of select="organisation/address/municipality" /><br/>
                      <xsl:value-of select="organisation/address/country/label" /><br/>
                    </td>
		  </tr>
          </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Úroveň vzdělání v národní nebo mezinárodní klasifikaci</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Pracovní zkušenosti</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Období</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Povolání nebo vykonávaná funkce</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Hlavní pracovní náplň a oblasti odpovědnosti</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Název/jméno a adresa zaměstnavatele</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="employer/name" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adresa</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="employer/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="employer/address/postalCode" /><br/>
                      <xsl:value-of select="employer/address/municipality" /><br/>
                      <xsl:value-of select="employer/address/country/label" /><br/>
                    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Obor činnosti či odvětví</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	</xsl:otherwise>
  </xsl:choose>
  
  <tr>
    <td class="Heading1">Schopnosti, znalosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td colspan="11" class="Normal">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step5.motherLanguages' and @keep='true']">
  <tr>
    <td class="Label">Mateřský jazyk</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step5.foreignLanguageList' and @keep='true']">
  <tr>
    <td class="Label">Další jazykové znalosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td></tr>
  <tr>
    <td class="Label">Sebehodnocení</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2Center" colSpan="4">Porozumění</td>
    <td class="Heading2Center" colSpan="4">Mluvení</td>
    <td class="Heading2Center" colSpan="2">Psaní</td>
    <td width="1%">&#160;</td>
  </tr>
  <tr>
    <td class="Label">Evropská úroveň</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="NormalSmall" colSpan="2">Poslech</td>
    <td class="NormalSmall" colSpan="2">Čtení</td>
    <td class="NormalSmall" colSpan="2">Ústní interakce</td>
    <td class="NormalSmall" colSpan="2">Samostatný ústní projev</td>
    <td class="NormalSmall" colSpan="2">&#160;</td>
    <td width="1%">&#160;</td>
  </tr>
    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
	  <xsl:variable name="indexedLang">
        <xsl:value-of select="concat('step5.foreignLanguageList[', position()-1, ']')" />
      </xsl:variable>
      <xsl:if test="//field[@name=$indexedLang and @keep='true']">
      <tr>
	    <td class="Heading1Box"><xsl:value-of select="label" /></td>
	    <td class="VerticalLineBox">&#160;</td>
	    <td>&#160;</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/listening" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/listening='a1'">uživatel základů jazyka</xsl:if>
		    <xsl:if test="level/listening='b1'">samostatný uživatel</xsl:if>
			<xsl:if test="level/listening='c1'">zkušený uživatel</xsl:if>
			
			<xsl:if test="level/listening='a2'">uživatel základů jazyka</xsl:if>
		    <xsl:if test="level/listening='b2'">samostatný uživatel</xsl:if>
			<xsl:if test="level/listening='c2'">zkušený uživatel</xsl:if>
	    </td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/reading" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/reading='a1'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/reading='b1'">samostatný uživatel</xsl:if>
			<xsl:if test="level/reading='c1'">zkušený uživatel</xsl:if>
		
			<xsl:if test="level/reading='a2'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/reading='b2'">samostatný uživatel</xsl:if>
			<xsl:if test="level/reading='c2'">zkušený uživatel</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/spokeninteraction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokeninteraction='a1'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/spokeninteraction='b1'">samostatný uživatel</xsl:if>
			<xsl:if test="level/spokeninteraction='c1'">zkušený uživatel</xsl:if>
		
			<xsl:if test="level/spokeninteraction='a2'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/spokeninteraction='b2'">samostatný uživatel</xsl:if>
			<xsl:if test="level/spokeninteraction='c2'">zkušený uživatel</xsl:if>
		</td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/spokenproduction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokenproduction='a1'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/spokenproduction='b1'">samostatný uživatel</xsl:if>
			<xsl:if test="level/spokenproduction='c1'">zkušený uživatel</xsl:if>
		
			<xsl:if test="level/spokenproduction='a2'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/spokenproduction='b2'">samostatný uživatel</xsl:if>
			<xsl:if test="level/spokenproduction='c2'">zkušený uživatel</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/writing" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/writing='a1'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/writing='b1'">samostatný uživatel</xsl:if>
			<xsl:if test="level/writing='c1'">zkušený uživatel</xsl:if>
		
			<xsl:if test="level/writing='a2'">uživatel základů jazyka</xsl:if>
			<xsl:if test="level/writing='b2'">samostatný uživatel</xsl:if>
			<xsl:if test="level/writing='c2'">zkušený uživatel</xsl:if>
		</td>
	    <td width="1%">&#160;</td>
	  </tr>
	  </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <tr>
    <td class="Label">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step6.socialSkills' and @keep='true']">
  <tr>
    <td class="Label">Sociální schopnosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='social']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.organisationalSkills' and @keep='true']">
  <tr>
    <td class="Label">Organizační schopnosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='organisational']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.technicalSkills' and @keep='true']">
  <tr>
    <td class="Label">Technické znalosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='technical']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.computerSkills' and @keep='true']">
  <tr>
    <td class="Label">Počítačové znalosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='computer']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.artisticSkills' and @keep='true']">
  <tr>
    <td class="Label">Umělecké schopnosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='artistic']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.otherSkills' and @keep='true']">
  <tr>
    <td class="Label">Další schopnosti, znalosti a dovednosti</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='other']" /></PRE></td>
  </tr>	
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.drivingLicences' and @keep='true']">
  <tr>
    <td class="Label">Řidičský průkaz</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
        <xsl:for-each select="europass:learnerinfo/skilllist/structured-skill[@xsi:type='europass:driving']/drivinglicence">
            <xsl:if test="position() != 1">,&#160;</xsl:if>
            <xsl:value-of select="current()" />
        </xsl:for-each>
    </td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.additionalInfo' and @keep='true']">
  <tr>
    <td class="Heading1">Doplňující informace</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='additional']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.annexes' and @keep='true']">
  <tr>
    <td class="Heading1">Přílohy</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='annexes']" /></PRE></td>
  </tr>
  </xsl:if>
</table>
<br/>
<xsl:if test="//field[@name='grid' and @keep='true']">
<table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">EVROPSKÉ ÚROVNĚ – STUPNICE PRO SEBEHODNOCENÍ</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Rozumím známým slovům a zcela základním frázím týkajícím se mé osoby, mé rodiny a bezprostředního konkrétního okolí, pokud lidé hovoří pomalu a zřetelně.</td>
		<td>Rozumím známým jménům, slovům a velmi jednoduchým větám, například na vývěskách, plakátech nebo v katalozích.</td>
		<td>Umím se jednoduchým způsobem domluvit, je-li můj partner ochoten zopakovat  pomaleji svou výpověď nebo ji  přeformulovat a pomoci mi formulovat, co se snažím říci. Umím klást jednoduché otázky a na podobné otázky odpovídat, pokud se týkají mých   základních potřeb, nebo jde-li o věci, jež jsou mi důvěrně známé.</td>
		<td>Umím jednoduchými frázemi a větami popsat místo, kde žiji, a lidi, které znám.</td>
		<td>Umím napsat stručný jednoduchý text na pohlednici,  například pozdrav z dovolené. Umím vyplnit formuláře obsahující osobní údaje, například své jméno, státní příslušnost a adresu při přihlašování v hotelu.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Rozumím frázím a nejběžnější slovní zásobě vztahující se k oblastem, které se mě bezprostředně týkají (např. základní  informace o mně a mé rodině, o nakupování, místopisu, zaměstnání). Dokážu pochopit smysl krátkých jasných  jednoduchých zpráv a hlášení.</td>
		<td>Umím číst krátké jednoduché texty. Umím vyhledat konkrétní předvídatelné informace  v jednoduchých každodenních materiálech, např. v  inzerátech, prospektech, jídelních lístcích a jízdních řádech. Rozumím krátkým jednoduchým osobním dopisům.</td>
		<td>Umím komunikovat v jednoduchých běžných  situacích vyžadujících jednoduchou přímou výměnu  informací o známých tématech a činnostech. Zvládnu velmi  krátkou společenskou konverzaci, i když obvykle  nerozumím natolik, abych konverzaci sám/sama dokázal(a) udržet .</td>
		<td>Umím použít řadu frází a vět, abych jednoduchým způsobem popsal(a)  vlastní rodinu a další lidi, životní podmínky, dosažené vzdělání a své současné nebo předchozí  zaměstnání.</td>
		<td>Umím napsat krátké jednoduché poznámky a zprávy týkající se mých základních potřeb. Umím napsat velmi jednoduchý osobní dopis, například poděkování.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Rozumím  hlavním myšlenkám  vysloveným spisovným jazykem o běžných tématech, se kterými se setkávám v práci, ve škole, ve volném čase, atd. Rozumím smyslu mnoha  rozhlasových a televizních programů týkajících se současných událostí nebo témat souvisejících s oblastmi mého osobního či pracovního  zájmu, pokud jsou vysloveny  poměrně pomalu a zřetelně.</td>
		<td>Rozumím textům, které obsahují slovní zásobu často užívanou v každodenním životě nebo které  se vztahují k mé práci. Rozumím popisům událostí, pocitů a přáním  v osobních dopisech.</td>
		<td>Umím si poradit s většinou situací, které mohou nastat při cestování v oblasti, kde se tímto jazykem mluví. Dokážu se bez přípravy zapojit do hovoru o tématech, která jsou mi známá, o něž se zajímám nebo která se týkají každodenního života (např. rodiny, koníčků, práce, cestování a aktuálních událostí).</td>
		<td>Umím jednoduchým způsobem spojovat fráze, abych popsal(a) své zážitky a události, své sny, naděje a cíle. Umím stručně odůvodnit a vysvětlit své názory a plány. Umím vyprávět příběh nebo přiblížit obsah knihy nebo filmu a vylíčit  své reakce.</td>
		<td>Umím napsat  jednoduché souvislé texty na témata, která dobře znám nebo která mě osobně zajímají. Umím psát osobní dopisy popisující zážitky a dojmy.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Rozumím delším promluvám a přednáškám a dokážu sledovat i složitou výměnu  názorů, pokud téma dostatečně znám. Rozumím většině televizních zpráv a programů týkajících se aktuálních témat. Rozumím většině filmů ve spisovném jazyce.</td>
		<td>Rozumím článkům a zprávám zabývajícím se současnými  problémy, v nichž autoři zaujímají konkrétní  postoje či stanoviska. Rozumím textům současné prózy.</td>
		<td>Dokážu se účastnit rozhovoru natolik plynule a spontánně, že  mohu vést běžný  rozhovor  s rodilými mluvčími. Dokážu se  aktivně zapojit do diskuse o známých tématech, vysvětlovat a obhajovat své názory.</td>
		<td>Dokážu  se srozumitelně a podrobně vyjadřovat k široké škále  témat, která se vztahují k oblasti mého zájmu. Umím vysvětlit své  stanovisko k aktuálním otázkám a uvést výhody a nevýhody různých  řešení.</td>
		<td>Umím  napsat srozumitelné   podrobné texty na širokou škálu  témat souvisejících s mými zájmy. Umím napsat pojednání nebo zprávy, předávat informace, obhajovat nebo vyvracet určitý názor. V dopise dovedu  zdůraznit, čím jsou pro mě události a zážitky osobně důležité.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Rozumím delším promluvám, i když nemají jasnou stavbu a vztahy jsou vyjádřeny pouze v náznacích. Bez větší námahy rozumím televizním programům a filmům.</td>
		<td>Rozumím dlouhým složitým textům, a to jak faktografickým, tak  beletristickým a jsem schopen/ schopna ocenit rozdíly v jejich stylu. Rozumím odborným článkům a delším technickým instrukcím, a to i tehdy, když se nevztahují k mému oboru.</td>
		<td>Umím se vyjadřovat plynule a pohotově bez příliš zjevného hledání výrazů. Umím používat jazyk pružně a efektivně pro  společenské a pracovní  účely. Umím přesně formulovat své myšlenky a názory a vhodně navazovat na příspěvky ostatních  mluvčích.</td>
		<td>Umím jasně a podrobně popsat složitá témata, rozšiřovat je o témata vedlejší, rozvíjet konkrétní body a zakončit svou řeč vhodným  závěrem.</td>
		<td>Umím se jasně vyjádřit, dobře uspořádat text a podrobně vysvětlit svá stanoviska. Umím psát podrobné dopisy, pojednání nebo zprávy o složitých tématech a zdůraznit to, co považuji za nejdůležitější. Umím zvolit styl textu podle toho, jakému typu čtenáře je určen.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Bez potíží rozumím jakémukoli druhu mluveného projevu, živého či vysílaného. Pokud mám trochu času zvyknout si na specifické rysy výslovnosti rodilého mluvčího, nemám potíže porozumět mu ani tehdy, mluví-li rychle.</td>
		<td>Snadno čtu všechny formy písemného projevu, včetně abstraktních textů náročných svou stavbou i jazykem, jako jsou např. příručky, odborné články a krásná  literatura.</td>
		<td>Dokážu se zapojit do jakékoli konverzace nebo diskuse. Znám dobře idiomatické a hovorové výrazy. Umím se plynule vyjadřovat a přesně sdělovat  jemnější významové odstíny.  Narazím-li při vyjadřování na nějaký problém, dokážu svou výpověď přeformulovat tak hladce, že to ostatní ani nepostřehnou.</td>
		<td>Umím podat jasný plynulý popis nebo zdůvodnění stylem vhodným pro daný kontext a opírajícím se o efektivní logickou strukturu, která pomáhá posluchači všimnout si důležitých bodů a zapamatovat si je.</td>
		<td>Umím napsat jasný plynulý text vhodným stylem. Dokážu napsat složité dopisy, zprávy nebo články a vystavět text logicky tak, aby pomáhal čtenáři všimnout si důležitých bodů a zapamatovat si je. Umím psát resumé a recenze odborných nebo literárních  prací.</td>
	</tr>
</table>
</xsl:if>		
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logo_for_htmlpreview.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg" /> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
