<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : cv_sk_SK_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass CV in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/cv_sk_SK_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='step1.firstName' and @before='step1.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="step3Before">
<xsl:choose>
  <xsl:when test="//field[@name='step3List' and @before='step4List']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
  <head>
    <title>CV - HTML</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
  </head>
<body>
<table width="700" border="0" cellspacing="0" cellpadding="0" class="CV">
  <tr>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="190"/></td>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="7"/></td>
	<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="8"/></td>
    <td colspan="11"><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="495"/></td>
  </tr>
  <tr>
    <td class="Logo" rowspan="2">&#160;</td>
	<td style="height:42px;">&#160;</td>
    <td colspan="12" rowspan="2">&#160;</td>
  </tr>
  <tr>
    <td class="Corner">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Title">
	  Europass - životopis<br/>
      <p />
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">Osobné údaje</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Label">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
	      Priezvisko(á)&#160;Meno(á)
	    </xsl:when>
	    <xsl:otherwise>
		  Meno(á)&#160;Priezvisko(á)
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
          <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		</xsl:when>
	    <xsl:otherwise>
		  <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		</xsl:otherwise>
	  </xsl:choose>
	</td>
  </tr>
  <xsl:if test="//field[@name='step1.addressInfo' and @keep='true']">
  <tr>
    <td class="Label">Adresa(y)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/contactinfo/address/addressLine">
        <xsl:value-of select="current()" /><br/>
      </xsl:for-each>
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/postalCode) != 0">
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/postalCode" />, </xsl:if>
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/municipality" />
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/country/label) != 0"> (<xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/country/label" />)</xsl:if>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.mobile' and @keep='true']">
  <tr>
    <td class="Label">Telefón(y)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="5">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/telephone" />
	</td>
    <td class="Label" width="15%" colSpan="2">Mobil</td>
    <td class="Normal" colSpan="4">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/mobile" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.fax' and @keep='true']">
  <tr>
    <td class="Label">Fax(y)</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/fax" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.email' and @keep='true']">
  <tr>
    <td class="Label">E-mail(y)</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/email" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.nationality' and @keep='true']">
  <tr>
    <td class="Label">Štátna(e) príslušnosť(ti)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/demographics/nationality/label">
    		<xsl:if test="position() != 1">,&#160;</xsl:if>
        <xsl:value-of select="current()"/>
    	</xsl:for-each>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.birthDate' and @keep='true']">
  <tr>
    <td class="Label">Dátum narodenia</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
    	<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.gender' and @keep='true']">
  <tr>
    <td class="Label">Pohlavie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='M'"><xsl:text>Muž</xsl:text></xsl:if>
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='F'"><xsl:text>Žena</xsl:text></xsl:if>
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.application' and @keep='true']">
  <tr>
    <td class="Heading1"> Oblasť činnosti, o ktoré sa zaujímate / Zamestnanie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <PRE><xsl:value-of select="europass:learnerinfo/application/label" /></PRE>
	</td>
  </tr>
  </xsl:if>
  
  
  <xsl:choose>
    <xsl:when test="$step3Before=1">
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Prax</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Od - do</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Zamestnanie alebo pracovné zaradenie</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Hlavné činnosti a zodpovednosť</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Názov a adresa zamestnávateľa</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
          <PRE><xsl:value-of select="employer/name" /></PRE>
          <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
            <xsl:for-each select="employer/address/addressLine">
              <xsl:value-of select="current()" /><br/>
            </xsl:for-each>
            <xsl:if test="string-length(employer/address/postalCode) != 0"><xsl:value-of select="employer/address/postalCode" />, </xsl:if>
            <xsl:value-of select="employer/address/municipality" />
            <xsl:if test=" string-length(employer/address/country/label) != 0"> (<xsl:value-of select="employer/address/country/label" />)</xsl:if>
          </xsl:if>
		    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Druh práce alebo odvetvie hospodárstva</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Vzdelávanie a príprava</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Od - do</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Názov získanej kvalifikácie</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Hlavné predmety / profesijné zručnosti</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Názov a typ organizácie poskytujúcej vzdelávanie a prípravu</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
        <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
        <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
          <xsl:for-each select="organisation/address/addressLine">
            <xsl:value-of select="current()" /><br/>
          </xsl:for-each>
          <xsl:if test="string-length(organisation/address/postalCode) != 0"><xsl:value-of select="organisation/address/postalCode" />, </xsl:if>
          <xsl:value-of select="organisation/address/municipality" />
          <xsl:if test="string-length(organisation/address/country/label) != 0"> (<xsl:value-of select="organisation/address/country/label" />)</xsl:if>
        </xsl:if>
      </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Stupeň vzdelania v národnej alebo medzinárodnej klasifikácii</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Vzdelávanie a príprava</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Od - do</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Názov získanej kvalifikácie</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Hlavné predmety / profesijné zručnosti</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Názov a typ organizácie poskytujúcej vzdelávanie a prípravu</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
                <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
            </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adresa(y)</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="organisation/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="organisation/address/postalCode" /><br/>
                      <xsl:value-of select="organisation/address/municipality" /><br/>
                      <xsl:value-of select="organisation/address/country/label" /><br/>
                    </td>
		  </tr>
          </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Stupeň vzdelania v národnej alebo medzinárodnej klasifikácii</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Prax</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Od - do</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Zamestnanie alebo pracovné zaradenie</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Hlavné činnosti a zodpovednosť</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Názov a adresa zamestnávateľa</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="employer/name" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Adresa(y)</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="employer/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="employer/address/postalCode" /><br/>
                      <xsl:value-of select="employer/address/municipality" /><br/>
                      <xsl:value-of select="employer/address/country/label" /><br/>
                    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Druh práce alebo odvetvie hospodárstva</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	</xsl:otherwise>
  </xsl:choose>
  
  <tr>
    <td class="Heading1">Osobná spôsobilosť</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td colspan="11" class="Normal">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step5.motherLanguages' and @keep='true']">
  <tr>
    <td class="Label">Materinský(é) jazyk(y)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step5.foreignLanguageList' and @keep='true']">
  <tr>
    <td class="Label">Ďalší(ie) jazyk(y)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td></tr>
  <tr>
    <td class="Label">Sebahodnotenie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2Center" colSpan="4">Porozumenie</td>
    <td class="Heading2Center" colSpan="4">Hovorenie</td>
    <td class="Heading2Center" colSpan="2">Písanie</td>
    <td width="1%">&#160;</td>
  </tr>
  <tr>
    <td class="Label">Európska úroveň</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="NormalSmall" colSpan="2">Počúvanie</td>
    <td class="NormalSmall" colSpan="2">Čítanie</td>
    <td class="NormalSmall" colSpan="2">Ústna interakcia</td>
    <td class="NormalSmall" colSpan="2">Samostatný ústny prejav</td>
    <td class="NormalSmall" colSpan="2">&#160;</td>
    <td width="1%">&#160;</td>
  </tr>
    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
	  <xsl:variable name="indexedLang">
        <xsl:value-of select="concat('step5.foreignLanguageList[', position()-1, ']')" />
      </xsl:variable>
      <xsl:if test="//field[@name=$indexedLang and @keep='true']">
      <tr>
	    <td class="Heading1Box"><xsl:value-of select="label" /></td>
	    <td class="VerticalLineBox">&#160;</td>
	    <td>&#160;</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/listening" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/listening='a1'">Používateľ základného jazyka</xsl:if>
		    <xsl:if test="level/listening='b1'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/listening='c1'">Skúsený používateľ</xsl:if>
			
			<xsl:if test="level/listening='a2'">Používateľ základného jazyka</xsl:if>
		    <xsl:if test="level/listening='b2'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/listening='c2'">Skúsený používateľ</xsl:if>
	    </td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/reading" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/reading='a1'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/reading='b1'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/reading='c1'">Skúsený používateľ</xsl:if>
		
			<xsl:if test="level/reading='a2'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/reading='b2'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/reading='c2'">Skúsený používateľ</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/spokeninteraction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokeninteraction='a1'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/spokeninteraction='b1'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/spokeninteraction='c1'">Skúsený používateľ</xsl:if>
		
			<xsl:if test="level/spokeninteraction='a2'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/spokeninteraction='b2'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/spokeninteraction='c2'">Skúsený používateľ</xsl:if>
		</td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/spokenproduction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokenproduction='a1'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/spokenproduction='b1'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/spokenproduction='c1'">Skúsený používateľ</xsl:if>
		
			<xsl:if test="level/spokenproduction='a2'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/spokenproduction='b2'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/spokenproduction='c2'">Skúsený používateľ</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/writing" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/writing='a1'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/writing='b1'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/writing='c1'">Skúsený používateľ</xsl:if>
		
			<xsl:if test="level/writing='a2'">Používateľ základného jazyka</xsl:if>
			<xsl:if test="level/writing='b2'">Samostatný používateľ</xsl:if>
			<xsl:if test="level/writing='c2'">Skúsený používateľ</xsl:if>
		</td>
	    <td width="1%">&#160;</td>
	  </tr>
	  </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <tr>
    <td class="Label">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step6.socialSkills' and @keep='true']">
  <tr>
    <td class="Label">Sociálne zručnosti a kompetencie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='social']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.organisationalSkills' and @keep='true']">
  <tr>
    <td class="Label">Organizačné zručnosti a kompetencie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='organisational']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.technicalSkills' and @keep='true']">
  <tr>
    <td class="Label">Technické zručnosti a kompetencie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='technical']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.computerSkills' and @keep='true']">
  <tr>
    <td class="Label">Počítačové zručnosti a kompetencie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='computer']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.artisticSkills' and @keep='true']">
  <tr>
    <td class="Label">Umelecké zručnosti a kompetencie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='artistic']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.otherSkills' and @keep='true']">
  <tr>
    <td class="Label">Ďalšie zručnosti a kompetencie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='other']" /></PRE></td>
  </tr>	
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.drivingLicences' and @keep='true']">
  <tr>
    <td class="Label">Vodičský(é) preukaz(y)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
        <xsl:for-each select="europass:learnerinfo/skilllist/structured-skill[@xsi:type='europass:driving']/drivinglicence">
            <xsl:if test="position() != 1">,&#160;</xsl:if>
            <xsl:value-of select="current()" />
        </xsl:for-each>
    </td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.additionalInfo' and @keep='true']">
  <tr>
    <td class="Heading1">Doplňujúce informácie</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='additional']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.annexes' and @keep='true']">
  <tr>
    <td class="Heading1">Prílohy</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='annexes']" /></PRE></td>
  </tr>
  </xsl:if>
</table>
<br/>
<xsl:if test="//field[@name='grid' and @keep='true']">
<table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Európske úrovne – tabuľka sebahodnotenia</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Dokážem rozoznať známe slová a veľmi základné frázy týkajúce sa mňa a mojej rodiny a bezprostredného konkrétneho okolia, keď ľudia hovoria pomaly  a jasne.</td>
		<td>Rozumiem známym menám, slovám a veľmi jednoduchým vetám, napríklad na oznámeniach a plagátoch alebo v katalógoch.</td>
		<td>Dokážem komunikovať jednoduchým spôsobom za predpokladu, že môj partner v komunikácii je pripravený zopakovať alebo preformulovať svoju výpoveď pri pomalšej rýchlosti reči a že mi pomôže sformulovať, čo ja sa pokúšam povedať. Dokážem klásť a odpovedať na jednoduché otázky v oblasti mojich základných potrieb alebo na veľmi známe témy.</td>
		<td>Dokážem využívať jednoduché frázy a vetami opísať miesto, kde žijem a ľudí, ktorých poznám.</td>
		<td>Dokážem napísať krátku jednoduchú pohľadnicu, napríklad dokážem poslať pozdravy z dovolenky. Dokážem vyplniť formuláre s osobnými údajmi, napríklad uviesť svoje meno, štátnu príslušnosť a adresu na registračnom formulári v hoteli.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Dokážem porozumieť frázam a najbežnejšej slovnej zásobe vo vzťahu k oblastiam, ktoré sa ma  bezprostredne týkajú (napríklad základné informácie o mne a rodine, nakupovaní, miestnej oblasti, zamestnaní). Dokážem pochopiť zmysel  v krátkych, jasných a jednoduchých správach a oznámeniach.</td>
		<td>Dokážem čítať veľmi krátke jednoduché texty. Dokážem nájsť konkrétne predvídateľné  informácie v jednoduchom každodennom materiáli, ako sú napríklad inzeráty, prospekty, jedálne lístky a časové harmonogramy a dokážem porozumieť krátkymi jednoduchým osobným listom.</td>
		<td>Dokážem komunikovať v jednoduchých a bežných situáciách vyžadujúcich jednoduchú a priamu výmenu informácií o známych témach a činnostiach. Dokážem zvládnuť veľmi krátke spoločenské kontakty, dokonca aj keď zvyčajne nerozumiem dostatočne na to, aby som sám udržiaval konverzáciu.</td>
		<td>Dokážem použiť sériu fráz a viet na jednoduchý opis mojej rodiny a ostatných ľudí, životných podmienok, môjho vzdelania a mojej terajšej alebo nedávnej práce.</td>
		<td>Dokážem napísať krátke jednoduché oznámenia a správy vzťahujúce sa na moje bezprostredné potreby. Dokážem napísať veľmi jednoduchý osobný list, napríklad poďakovanie.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Dokážem pochopiť hlavné body jasnej štandardnej reči o známych veciach, s ktorými sa pravidelne stretávam v škole, práci, vo voľnom čase atď. Rozumiem zmyslu mnohých rozhlasových alebo televíznych programov o aktuálnych udalostiach a témach osobného či odborného záujmu, keď je prejav relatívne pomalý a jasný.</td>
		<td>Rozumiem textom, ktoré pozostávajú z každodennej slovnej zásoby často používanej v každodennom živote alebo ktoré sa vzťahujú sa na moju prácu. Dokážem porozumieť opisom udalostí, pocitov a prianí v osobných listoch.</td>
		<td>Dokážem zvládnuť väčšinu situácií, ktoré sa môžu vyskytnúť počas cestovania v oblasti, kde sa hovorí týmto jazykom. Môžem nepripravený vstúpiť do konverzácie na témy, ktoré sú známe, ktoré ma osobne zaujímajú, alebo ktoré sa týkajú osobného každodenného života (napríklad rodina, koníčky, práca, cestovanie, súčasné udalosti).</td>
		<td>Dokážem spájať frázy jednoduchým spôsobom, aby som opísal skúsenosti a udalosti, svoje sny, nádeje a ambície. Stručne dokážem uviesť dôvody a vysvetlenia názorov a plánov. Dokážem vyrozprávať príbeh alebo zápletku knihy či filmu a opísať svoje reakcie.</td>
		<td>Dokážem napísať jednoduchý súvislý text na témy, ktoré sú mi známe alebo ma osobne zaujímajú. Dokážem napísať osobné listy opisujúce skúsenosti a dojmy.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Dokážem porozumieť dlhšej reči a prednáškam a sledovať aj zložitú argumentačnú líniu za predpokladu, že téma mi je dostatočne známa. Dokážem pochopiť väčšinu televíznych správ a programov o aktuálnych udalostiach. Dokážem porozumieť väčšine filmov v spisovnom jazyku.</td>
		<td>Dokážem prečítať články a správy týkajúce sa aktuálnych problémov, v ktorých pisatelia alebo autori adoptujú konkrétne postoje alebo názory. Rozumiem súčasnej literárnej próze.</td>
		<td>Dokážem komunikovať na takej úrovni plynulosti a spontánnosti, ktorá mi celkom umožňuje viesť bežný rozhovor s rodenými hovoriacimi. Dokážem sa aktívne zúčastniť na diskusii na známe témy, pričom vyjadrujem a presadzujem svoje názory.</td>
		<td>Dokážem prezentovať jasné podrobné opisy celého radu predmetov vzťahujúcich sa na moju oblasť záujmu. Dokážem vysvetliť svoje stanovisko na aktuálne otázky s uvedením výhod a nevýhod rozličných možností.</td>
		<td>Dokážem napísať podrobný text o širokom rozsahu tém vzťahujúcich sa na moje záujmy. Dokážem napísať referát alebo správu, odovzdávať informácie alebo poskytnúť dôkazy na podporu konkrétneho názoru alebo proti nemu. Dokážem napísať listy, ktoré objasňujú, prečo sú niektoré  udalosti a skúsenosti pre mňa osobne dôležité.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Rozumiem dlhšej reči aj keď nie je jasne štruktúrovaná a keď vzťahy sú iba naznačené, nie explicitne signalizované. Dokážem bez väčšej námahy porozumieť televíznym programom a filmom.</td>
		<td>
	Rozumiem dlhým a zložitým faktickým a literárnym textom, pričom rozoznávam rozdiely v štýle. Rozumiem odborným článkom a dlhším návodom, dokonca aj keď sa nevzťahujú na moju oblasť.</td>
		<td>Dokážem sa vyjadrovať plynulo a spontánne bez zjavného hľadania výrazov. Dokážem využívať jazyk pružne a účinne pre spoločenské a  profesijné účely. Dokážem presne sformulovať svoje myšlienky a názory a dokážem vhodne nadviazať na príspevky ostatných hovoriacich.</td>
		<td>Dokážem jasne a podrobne opísať zložité témy, rozširovať ich o vedľajšie témy, rozvíjať konkrétne body a zakončiť reč vhodným záverom.</td>
		<td>Dokážem sa jasne vyjadriť, dobre usporiadať text a odborne vyjadriť svoje stanoviská. Dokážem písať o zložitých predmetoch v liste, referáte, či správe a zdôrazniť, čo pokladám za najdôležitejšie. Dokážem zvoliť štýl podľa čitateľa, ktorému je text určený.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Nemám žiadne ťažkosti pri pochopení akéhokoľvek druhu hovoreného jazyka, či už je to naživo alebo z vysielania, dokonca aj keď je prejav rodeného hovoriaceho veľmi rýchly za predpokladu, že mám dosť času na to, aby som sa si zvykol na jeho výslovnosť.</td>
		<td>Ľahko čítam v podstate všetky formy písaného jazyka vrátane abstraktných textov náročných svojou stavbou a jazykom, ako sú napríklad  príručky, odborné články a literárne diela.</td>
		<td>Bez námahy sa dokážem zúčastniť na akejkoľvek konverzácii alebo diskusii a  dobre ovládam idiomatické a hovorové výrazy. Dokážem sa vyjadrovať plynulo a  presne vyjadrovať jemné odtienky významu. Ak pri vyjadrovaní sa narazím na problém, dokážem sa vrátiť a preformulovať danú pasáž tak ľahko, že ostatní to ani nepostrehnú.</td>
		<td>Dokážem podať jasný a plynulý opis alebo zdôvodnenie v štýle, ktorý sa hodí pre daný kontext a s efektívnou logickou štruktúrou, ktorá pomôže príjemcovi všimnúť si dôležité body a zapamätať si ich.</td>
		<td>Dokážem napísať hladko plynúci text v príslušnom štýle. Dokážem napísať zložité listy, správy alebo články, ktoré prezentujú prípad s efektívnou logickou štruktúrou, ktorá pomôže príjemcovi všimnúť si dôležité body a zapamätať si ich. Dokážem napísať zhrnutia a recenzie o odborných prácach alebo literárnych dielach.</td>
	</tr>
</table>
</xsl:if>		
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logo_for_htmlpreview.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg" /> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
