<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]><xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : lp_no_NO_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass LP in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/lp_no_NO_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='personal.firstName' and @before='personal.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
  <title>LP - HTML</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
</head>
<body>
  <table class="LP" cellSpacing="0" cellPadding="10" width="740" border="0">
	  <tbody>
	  <tr align="middle">
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_europass_lp.gif" width="95"/></td>
	    <td style="text-align: center" width="60%">
		  <span class="LabelBold">Europass språkpass</span>
		  <br/>
		  <span class="Label">– et dokument i den europeiske språkpermen utarbeidet av Europarådet</span>
		</td>
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/otherlogo_lp.gif" width="95"/></td>
	  </tr>
	  </tbody>
  </table>
  <div class="VerLine_LP">
    <table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="173"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="516"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
	  <td class="LabelBold">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
	        Etternavn&#160;
	      </xsl:when>
	      <xsl:otherwise>
		    &#160;Etternavn
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
      <td class="Normal">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
            <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		  </xsl:when>
	      <xsl:otherwise>
		    <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		  </xsl:otherwise>
	    </xsl:choose>
      </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <xsl:if test="//field[@name='personal.birthDate' and @keep='true']">
    <tr>
      <td class="Label">Fødselsdato</td>
      <td class="Normal">
      <xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
      </td><td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
	</xsl:if>
    <tr>
      <td class="Label">Morsmål</td>
      <td class="Normal"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="Label">Andre språk</td>
	  <td class="Normal">
	    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
          <xsl:if test="position() != 1">,&#160;</xsl:if>
		  <xsl:value-of select="label" />
	    </xsl:for-each>
	   </td>
      <td>&#160;</td>
	 </tr>
	 </tbody>
     </table>
  </div>
  
  <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
    <xsl:variable name="indexedLang">
	  <xsl:value-of select="concat('foreignLanguageList[', position()-1, ']')" />
    </xsl:variable>
	
    <br/>
	<div class="VerLine_LP">
    
	<table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="19"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="8"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="17"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="108"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="86"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="23"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="31"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="79"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalHighlight" colSpan="13"><xsl:value-of select="label" /> </td>
      <td>&#160;</td>
	</tr>
    
	<xsl:if test="//field[@name=concat($indexedLang,'.ass') and @keep='true']">
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Egenvurdering av språkferdigheter </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeadingBold" colSpan="4">Forståelse</td>
      <td class="GridHeadingBold" colSpan="6">Tale</td>
      <td class="GridHeadingBold" colSpan="3">Skrift</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="2">Lytting</td>
      <td class="GridHeading" colspan="2">Lesing</td>
      <td class="GridHeading" colspan="3">Interaksjon</td>
      <td class="GridHeading" colspan="3">Muntlig produksjon</td>
      <td colSpan="3">&#160;</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalCenter"><xsl:value-of select="level/listening" /> </td>
      <td class="NormalCenter">
	    <xsl:if test="level/listening='a1'">Basisbruker</xsl:if>
        <xsl:if test="level/listening='b1'">Selvstendig bruker</xsl:if>
  	    <xsl:if test="level/listening='c1'">Dyktig bruker</xsl:if>
	    
		<xsl:if test="level/listening='a2'">Basisbruker</xsl:if>
	    <xsl:if test="level/listening='b2'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/listening='c2'">Dyktig bruker</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/reading" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/reading='a1'">Basisbruker</xsl:if>
		<xsl:if test="level/reading='b1'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/reading='c1'">Dyktig bruker</xsl:if>
		
		<xsl:if test="level/reading='a2'">Basisbruker</xsl:if>
		<xsl:if test="level/reading='b2'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/reading='c2'">Dyktig bruker</xsl:if>
	  </td>
      <td class="NormalCenter" colSpan="2"><xsl:value-of select="level/spokeninteraction" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/spokeninteraction='a1'">Basisbruker</xsl:if>
	    <xsl:if test="level/spokeninteraction='b1'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/spokeninteraction='c1'">Dyktig bruker</xsl:if>
		
		<xsl:if test="level/spokeninteraction='a2'">Basisbruker</xsl:if>
	    <xsl:if test="level/spokeninteraction='b2'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/spokeninteraction='c2'">Dyktig bruker</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/spokenproduction" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/spokenproduction='a1'">Basisbruker</xsl:if>
	    <xsl:if test="level/spokenproduction='b1'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/spokenproduction='c1'">Dyktig bruker</xsl:if>
		
		<xsl:if test="level/spokenproduction='a2'">Basisbruker</xsl:if>
	    <xsl:if test="level/spokenproduction='b2'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/spokenproduction='c2'">Dyktig bruker</xsl:if>
	  </td>
	  <td class="NormalCenter"><xsl:value-of select="level/writing" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/writing='a1'">Basisbruker</xsl:if>
	    <xsl:if test="level/writing='b1'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/writing='c1'">Dyktig bruker</xsl:if>
		
		<xsl:if test="level/writing='a2'">Basisbruker</xsl:if>
	    <xsl:if test="level/writing='b2'">Selvstendig bruker</xsl:if>
		<xsl:if test="level/writing='c2'">Dyktig bruker</xsl:if>
	  </td>
      <td>&#160;</td>
	</tr>
    </xsl:if>
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Eksamensbevis / vitnemål </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="5">Tittel på vitnemål / bevis</td>
	  <td class="GridHeading" colspan="4">Utstedt av</td>
	  <td class="GridHeading" colspan="3">Dato</td>
	  <td class="GridHeading">Europeisk nivå</td>
      <td>&#160;</td>
	</tr>
    
	<xsl:for-each select="diplomalist/diploma">
	  <xsl:variable name="indexedDiploma">
	    <xsl:value-of select="concat('.diplomaList[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:variable name="indexedBoth">
	    <xsl:value-of select="concat('', $indexedLang, $indexedDiploma)" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
        <tr>
          <td>&#160;</td>
          <td class="Normal" colSpan="5"><xsl:value-of select="title" /></td>
          <td class="Normal" colSpan="4"><xsl:value-of select="awardingBody" /></td>
          <td class="NormalCenter" colSpan="3">
            <xsl:value-of select="translate(date/day,'-','')" />
            <xsl:if test="string-length(date/day) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/month,'-','')" />
            <xsl:if test="string-length(date/month) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/year,'-','')" />
          </td>
          <td class="NormalCenter"><xsl:value-of select="level" /> </td>
          <td>&#160;</td>
	    </tr>
        <tr>
          <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	    </tr>
	  </xsl:if>
    </xsl:for-each>
  
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Erfaring med språket </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="9">Beskrivelse</td>
	  <td class="GridHeading" colspan="3">Fra</td>
	  <td class="GridHeading">Til</td>
      <td>&#160;</td>
	</tr>
	
    <xsl:for-each select="experiencelist/experience">
	<xsl:variable name="indexedExperience">
	  <xsl:value-of select="concat('.experienceList[', position()-1, ']')" />
	</xsl:variable>
	<xsl:variable name="indexedBoth">
	  <xsl:value-of select="concat('', $indexedLang, $indexedExperience)" />
	</xsl:variable>
    <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
      <tr>
        <td>&#160;</td>
        <td class="Normal" colSpan="9"><xsl:value-of select="description" /></td>
        <td class="NormalCenter" colSpan="3">
          <xsl:value-of select="translate(period/from/day,'-','')" />
		    	<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/month,'-','')" />
          <xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/year,'-','')" />
	    </td>
        <td class="NormalCenter">
          <xsl:value-of select="translate(period/to/day,'-','')" />
          <xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/month,'-','')" />
          <xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/year,'-','')" />
	    </td>
        <td>&#160;</td>
	  </tr>
      <tr>
        <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
      </tr>
	</xsl:if>
	</xsl:for-each>
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
  
  </tbody>
  </table>
  
  </div>
  </xsl:for-each>
    
  <div class="Asterix">
    (*)Titler merket med en stjerne er valgfrie
	(**)Se egenvurderings-skjema
	(***)Europeiske rammeverket (CEF)-nivå hvis spesifisert på originalen av vitnemålet eller beviset.<br/>
  </div>
  <br/>
  <div class="Footnote">
	<b>Forklarende note</b><br/>
	Europass språkpass er en del av europeiske språkpermen som er utviklet av Europarådet. De seks europeiske CEF-nivåene (CEF = Common European Framework of Reference for Languages) i egenvurderingsskjemaet angir brukerens språklige ferdighetsnivå på en standardisert måte.<br/>
	Flere opplysninger om Europass språkpass: http://europass.cedefop.europa.eu - Flere opplysninger om europeiske språkpermen: www.coe.int/portfolio<br/>
	Oppsett og mal for Europass språkpass kan lastes ned gratis fra nettsidene over.<br/>
	© Europarådet og De Europeiske Fellesskap, 2004   20060628<br/>
  </div>
  <br/>
  
  <xsl:if test="//field[@name='grid' and @keep='true']">
  <table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Europeiske nivåer – Egenvurderingsmatrise</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Jeg kan kjenne igjen vanlige ord og svært enkle uttrykk som angår meg selv, min familie og mine nære omgivelser når man snakker langsomt og tydelig.</td>
		<td>Jeg kan forstå kjente navn, ord og svært enkle setninger, for eksempel i annonser, på plakater eller i kataloger.</td>
		<td>Jeg kan delta i en samtale på en enkel måte hvis samtalepartneren er villig til å gjenta, omformulere, snakke langsomt og hjelpe meg å formulere meg. Jeg kan stille og svare på enkle spørsmål knyttet til umiddelbare behov eller til svært kjente emner.</td>
		<td>Jeg kan bruke enkle uttrykk og setninger for å beskrive stedet der jeg bor og mennesker jeg kjenner.</td>
		<td>Jeg kan skrive et enkelt postkort, f.eks. et julekort. Jeg kan fylle ut skjemaer med personlige opplysninger, som navn, nasjonalitet og adresse.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Jeg kan forstå vanlige ord og ytringer knyttet til områder av umiddelbar personlig betydning (f.eks. svært enkel informasjon som gjelder meg selv, min familie, mitt nærmiljø, innkjøp og arbeidsliv). Jeg kan oppfatte hovedinnholdet i enkle, korte og tydelige beskjeder og meldinger.</td>
		<td>Jeg kan lese svært korte, enkle tekster. Jeg kan finne spesifikke, forutsigbare opplysninger i enkel, dagligdags informasjon som reklame, brosjyrer, menyer og rutetabeller. Jeg kan forstå korte, enkle, personlige brev.</td>
		<td>Jeg kan delta i enkle og rutinepregede samtalesituasjoner som innebærer enkel og direkte utveksling av informasjon om kjente emner og aktiviteter. Jeg kan bruke og forstå vanlige høflighetsfraser, men forstår som regel ikke nok til å holde samtalen gående.</td>
		<td>Jeg kan bruke en rekke uttrykk og setninger for på en enkel måte å beskrive familie og andre mennesker, boforhold, min utdanningsbakgrunn og min nåværende eller tidligere jobb.</td>
		<td>Jeg kan skrive korte, enkle notater og beskjeder. Jeg kan skrive et svært enkelt personlig brev, f.eks. et takkebrev.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Jeg kan forstå hovedinnholdet i klar, standard tale om kjente emner knyttet til bl.a. arbeid, skole og fritid. Jeg kan forstå hovedinnholdet i mange radio- og TV-programmer om aktuelle saker eller om emner som er av personlig eller faglig interesse for meg, når det snakkes relativt langsomt og tydelig.</td>
		<td>Jeg kan forstå tekster der språket i stor grad er preget av vanlige, dagligdagse ord og uttrykk eller vanlige ord knyttet til arbeidet mitt. Jeg kan forstå personlige brev med beskrivelser av hendelser, følelser og ønsker.</td>
		<td>Jeg kan klare meg språklig i de fleste situasjoner som kan oppstå når jeg reiser i et område der språket snakkes. Jeg kan uforberedt delta i samtaler om kjente emner, emner av personlig interesse eller som er viktige i dagliglivet (f.eks. familie, hobby, arbeid, reise, aktuelle hendelser).</td>
		<td>Jeg kan gi en enkel, sammenhengende framstilling av hendelser, erfaringer, drømmer, håp og planer. Jeg kan kort forklare og begrunne mine meninger og planer. Jeg kan fortelle en historie eller gjenfortelle handlingen i en bok eller film og beskrive reaksjonene mine.</td>
		<td>Jeg kan skrive en enkel og sammenhengende tekst om dagligdagse emner eller om emner som berører meg personlig. Jeg kan skrive personlige brev og beskrive opplevelser og inntrykk.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Jeg kan forstå lengre sammenhengende tale og foredrag og følge komplekse argumentasjonsrekker når emnet er forholdsvis kjent. Jeg kan forstå de fleste nyhets- og aktualitetsprogrammer på TV. Jeg kan forstå de aller fleste filmer der det brukes standard tale.</td>
		<td>Jeg kan lese artikler og rapporter om aktuelle problemstillinger, der forfatteren gir uttrykk for bestemte holdninger eller synspunkter. Jeg kan forstå prosalitteratur fra vår egen tid.</td>
		<td>Jeg kan bruke språket så flytende og spontant at samtaler med morsmålsbrukere ikke byr på særlige problemer. Jeg kan delta aktivt i diskusjoner i kjente sammenhenger, og jeg kan uttrykke og begrunne synspunktene mine.</td>
		<td>Jeg kan gi klare og detaljerte beskrivelser innenfor et vidt spekter av emner knyttet til mitt interessefelt. Jeg kan forklare et synspunkt på en gitt problemstilling og gjøre rede for fordeler og ulemper ved ulike alternativer.</td>
		<td>Jeg kan skrive klare, detaljerte tekster om et vidt spekter av emner knyttet til mine interesser. Jeg kan skrive en sammenhengende framstilling eller rapport for å formidle informasjon eller argumentere for eller imot et bestemt synspunkt. Jeg kan skrive brev som tydelig viser hvilken betydning visse hendelser og erfaringer har for meg.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Jeg kan forstå sammenhengende tale også når den ikke er tydelig strukturert, og når sammenhenger er underforståtte og ikke kommer tydelig fram. Jeg kan forstå TV-programmer og filmer uten altfor store anstrengelser.</td>
		<td>Jeg kan forstå lange, komplekse faktatekster og skjønnlitterære tekster, og legge merke til trekk som er typiske for ulike stilnivåer. Jeg kan forstå fagartikler og lengre, tekniske instruksjoner selv når de ligger utenfor mitt felt.</td>
		<td>Jeg kan uttrykke meg flytende og spontant uten at det i særlig grad merkes at jeg leter etter uttrykksmåter. Jeg kan bruke språket fleksibelt og effektivt både i sosiale og faglige sammenhenger. Jeg kan formulere idéer og meninger presist og forholde meg til samtalepartnere på en hensiktsmessig måte.</td>
		<td>Jeg kan gi klare og detaljerte beskrivelser av komplekse emner der jeg trekker inn delmomenter, utdyper enkelte punkter og runder av med en passende konklusjon.</td>
		<td>Jeg kan skrive klare og strukturerte tekster og gi uttrykk for mine synspunkter på en utfyllende måte. Jeg kan skrive om komplekse emner (i brev, rapporter, artikler eller essays) og understreke hva jeg mener er de viktigste punktene. Jeg kan velge en stil som passer til den som skal lese teksten.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Jeg forstår uten problemer alle former for muntlig språk både i det virkelige liv og i media, også når morsmålsbrukeren snakker i et naturlig og hurtig tempo, dersom jeg får litt tid til å gjøre meg kjent med dialekten.</td>
		<td>Jeg leser uten problemer praktisk talt alle former for tekst, inkludert tekster om abstrakte emner og tekster som er komplekse når det gjelder språk eller struktur, som instruksjoner, fagartikler og litterære verk.</td>
		<td>Jeg kan uten anstrengelse delta i alle former for samtale og diskusjon og har god kjennskap til faste uttrykk og alminnelige talemåter. Jeg kan uttrykke meg flytende og formidle finere meningsnyanser på en presis måte. Hvis jeg får et språklig problem, kan jeg omformulere meg slik at det nesten ikke merkes.</td>
		<td>Jeg kan beskrive, drøfte og argumentere på en klar og flytende måte, bruke et språk og en stil som passer i sammenhengen, og strukturere det jeg sier på en hensiktsmessig og logisk måte slik at den som lytter, kan legge merke til og huske viktige poenger.</td>
		<td>Jeg kan skrive klare tekster med god flyt i en passende stil. Jeg kan skrive komplekse brev, rapporter og artikler der jeg legger fram en sak med en hensiktsmessig og logisk struktur som hjelper mottakeren å legge merke til og huske viktige poenger. Jeg kan skrive sammendrag og anmeldelser både av faglige og litterære arbeider.</td>
	</tr>
  </table>
  </xsl:if>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif"/> <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_for_htmlpreview.gif"/>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg"/> 
</body>
</html>
  </xsl:template>
</xsl:stylesheet>
